/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import edu.cmu.cs.radar.rhai.spacetime.Services;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeSession;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class STMBackendController {
    public static final String ST_MODULE_PATH_KEY = "radar.stp.st-module.path";
    public static final String IIOP_HOSTNAME_KEY = "radar.stp.iiop.hostname";
    public static final String IIOP_PORT_KEY = "radar.stp.iiop.port";

    protected static SpaceTimeSession startSTMBackend(Properties radarProperties) {
        return STMBackendController.startSTMBackend(radarProperties, false);
    }

    protected static SpaceTimeSession startSTMBackend(Properties radarProperties, boolean teeOutput) {
        String stModulePath;
        block7: {
            stModulePath = radarProperties.getProperty(ST_MODULE_PATH_KEY);
            if (stModulePath == null) {
                Services.logger.error("property 'radar.stp.st-module.path' is undefined");
                return null;
            }
            String stModuleCommand = String.valueOf(stModulePath) + " IIOP_PORT=" + radarProperties.getProperty(IIOP_PORT_KEY);
            Services.logger.info("stm backend starting: " + stModuleCommand);
            Process stModuleProcess = Runtime.getRuntime().exec(stModuleCommand);
            Services.logger.info("stm backend started");
            InputStream stdOut = stModuleProcess.getInputStream();
            InputStream stdErr = stModuleProcess.getErrorStream();
            Logger stLogger = Logger.getLogger("STM:ST-MODULE");
            STMBackendReadyLineListener readyListener = new STMBackendReadyLineListener();
            OutputLogger stdOutLogger = new OutputLogger(stdOut, stLogger, Level.INFO);
            stdOutLogger.addLineListener(readyListener);
            OutputLogger stdErrLogger = new OutputLogger(stdErr, stLogger, Level.ERROR);
            if (teeOutput) {
                stdOutLogger.addLineListener(new PrintStreamLineListener(System.out));
                stdErrLogger.addLineListener(new PrintStreamLineListener(System.err));
            }
            new Thread(stdOutLogger).start();
            new Thread(stdErrLogger).start();
            if (readyListener.waitForSTMBackendToStart()) break block7;
            return null;
        }
        try {
            int cumulativeSleepDuration = 0;
            Exception stmConnectException = null;
            int tri = 1;
            while (tri <= 10) {
                SpaceTimeSession stmSession = SpaceTimeSession.createInstance(radarProperties);
                if (stmSession.isConnected()) {
                    Services.logger.info("connected to stm backend");
                    return stmSession;
                }
                stmConnectException = stmSession._connectException;
                int sleepDuration = tri * 1000;
                cumulativeSleepDuration += sleepDuration;
                STMBackendController.sleep(sleepDuration);
                ++tri;
            }
            Services.logger.error("unable to connect to stm backend after " + cumulativeSleepDuration / 1000 + " second(s)", stmConnectException);
        }
        catch (IOException ex) {
            Services.logger.error("unable to start stm backend: " + stModulePath, ex);
        }
        return null;
    }

    private static void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static class OutputLogger
    implements Runnable {
        private BufferedReader _reader;
        private Logger _log;
        private Level _level;
        private List _lineListeners;

        public OutputLogger(InputStream in, Logger log, Level level) {
            this._reader = new BufferedReader(new InputStreamReader(in));
            this._log = log;
            this._level = level;
            this._lineListeners = new ArrayList();
        }

        public void run() {
            try {
                String line;
                while ((line = this._reader.readLine()) != null) {
                    this._log.log(this._level, line);
                    this.fireLineRead(line);
                }
            }
            catch (Exception ex) {
                this._log.error("caught exception reading stm backend stream (" + this._level.toString() + ")", ex);
            }
            this.fireEOF();
        }

        public void addLineListener(LineListener listener) {
            this._lineListeners.add(listener);
        }

        private void fireLineRead(String line) {
            Iterator lineListenerIterator = this._lineListeners.iterator();
            while (lineListenerIterator.hasNext()) {
                ((LineListener)lineListenerIterator.next()).lineRead(line);
            }
        }

        private void fireEOF() {
            Iterator lineListenerIterator = this._lineListeners.iterator();
            while (lineListenerIterator.hasNext()) {
                ((LineListener)lineListenerIterator.next()).eof();
            }
        }
    }

    private static interface LineListener {
        public void lineRead(String var1);

        public void eof();
    }

    private static class PrintStreamLineListener
    implements LineListener {
        private PrintStream _stream;

        public PrintStreamLineListener(PrintStream stream) {
            this._stream = stream;
        }

        public void lineRead(String line) {
            this._stream.println(line);
        }

        public void eof() {
        }
    }

    private static class STMBackendReadyLineListener
    implements LineListener {
        private boolean _stmBackendStarted = false;
        private boolean _eof = false;

        private STMBackendReadyLineListener() {
        }

        public synchronized void lineRead(String line) {
            Services.logger.trace("enter: lineRead(): " + line);
            if (line.equals("STM Backend started")) {
                this._stmBackendStarted = true;
                Services.logger.trace("received notification that the stm backend has started, releasing all waiting threads");
                this.notifyAll();
            }
            Services.logger.trace("leave: lineRead()");
        }

        public synchronized void eof() {
            Services.logger.trace("enter: eof()");
            this._eof = true;
            this.notifyAll();
            Services.logger.trace("leave: eof()");
        }

        public synchronized boolean waitForSTMBackendToStart() {
            Services.logger.trace("enter: waitForSTMBackendToStart()");
            while (!this._stmBackendStarted && !this._eof) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    Services.logger.error("waiting for STM Backend to start", ex);
                    ex.printStackTrace();
                }
            }
            Services.logger.trace("leave: waitForSTMBackendToStart()");
            return this._stmBackendStarted;
        }
    }
}

