/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import java.util.Hashtable;
import java.util.Vector;

public class RangedItemList {
    private Vector _cells = new Vector();
    private Hashtable _itemTable = new Hashtable();

    public void debug_PrintList() {
        int i = 0;
        while (i < this._cells.size()) {
            Cell cell = (Cell)this._cells.get(i);
            System.out.println("Cell: " + i + "[" + ((Cell)cell)._range.begin + "-" + ((Cell)cell)._range.end + "]");
            int j = 0;
            while (j < cell._columnList.size()) {
                System.out.println(" Column: " + j);
                Vector column = (Vector)cell._columnList.get(j);
                int k = 0;
                while (k < column.size()) {
                    Item item = (Item)column.get(k);
                    System.out.println("  Item: [" + item.range.begin + "-" + item.range.end + "]");
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public void clear() {
        this._cells.clear();
        this._itemTable.clear();
    }

    public int size() {
        int size = 0;
        int i = 0;
        while (i < this._cells.size()) {
            Cell cell = (Cell)this._cells.get(i);
            int j = 0;
            while (j < cell._columnList.size()) {
                Vector column = (Vector)cell._columnList.get(j);
                size += column.size();
                ++j;
            }
            ++i;
        }
        return size;
    }

    public ItemInformation[] getAllItemInformation() {
        Vector<ItemInformation> itemList = new Vector<ItemInformation>();
        int i = 0;
        while (i < this._cells.size()) {
            Cell cell = (Cell)this._cells.get(i);
            int j = 0;
            while (j < cell._columnList.size()) {
                Vector column = (Vector)cell._columnList.get(j);
                int k = 0;
                while (k < column.size()) {
                    Item item = (Item)column.get(k);
                    itemList.add(new ItemInformation(item.key, j, cell._columnList.size()));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        ItemInformation[] itemArray = new ItemInformation[itemList.size()];
        itemList.toArray(itemArray);
        return itemArray;
    }

    public ItemInformation getItemInformation(Object key) {
        int i = 0;
        while (i < this._cells.size()) {
            Cell cell = (Cell)this._cells.get(i);
            int j = 0;
            while (j < cell._columnList.size()) {
                Vector column = (Vector)cell._columnList.get(j);
                int k = 0;
                while (k < column.size()) {
                    Item item = (Item)column.get(k);
                    if (item.key == key) {
                        return new ItemInformation(item.key, j, cell._columnList.size());
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public ItemInformation getItemInformation(int index) {
        int count = 0;
        int i = 0;
        while (i < this._cells.size()) {
            Cell cell = (Cell)this._cells.get(i);
            int j = 0;
            while (j < cell._columnList.size()) {
                Vector column = (Vector)cell._columnList.get(j);
                if (index >= count && index < count + column.size()) {
                    Item item = (Item)column.get(index - count);
                    return new ItemInformation(item.key, j, cell._columnList.size());
                }
                count += column.size();
                ++j;
            }
            ++i;
        }
        return null;
    }

    public void addItem(Object key, long begin, long end) {
        Item item = new Item(key, new Range(begin, end));
        this._itemTable.put(key, item);
        Cell prevCell = null;
        Cell currentCell = null;
        boolean itemAdded = false;
        Vector<Integer> removedItems = new Vector<Integer>();
        int i = 0;
        while (i < this._cells.size()) {
            currentCell = (Cell)this._cells.get(i);
            if (((Cell)currentCell)._range.begin <= begin && ((Cell)currentCell)._range.end > begin || ((Cell)currentCell)._range.end >= end && ((Cell)currentCell)._range.begin < end || ((Cell)currentCell)._range.begin >= begin && ((Cell)currentCell)._range.end <= end) {
                if (!itemAdded) {
                    currentCell.add(item);
                    itemAdded = true;
                    prevCell = currentCell;
                } else {
                    prevCell.append(currentCell);
                    removedItems.add(new Integer(i));
                }
            } else {
                if (!itemAdded && end <= ((Cell)currentCell)._range.begin) {
                    Cell newCell = new Cell();
                    newCell.add(item);
                    itemAdded = true;
                    this._cells.insertElementAt(newCell, i);
                    break;
                }
                prevCell = currentCell;
            }
            ++i;
        }
        if (!itemAdded) {
            Cell newCell = new Cell();
            newCell.add(item);
            this._cells.add(newCell);
        }
        i = removedItems.size() - 1;
        while (i >= 0) {
            int index = (Integer)removedItems.get(i);
            this._cells.remove(index);
            --i;
        }
    }

    public void moveItem(Object key, long begin, long end) {
        this.removeItem(key);
        this.addItem(key, begin, end);
    }

    public void removeItem(Object key) {
        this._itemTable.remove(key);
        int i = 0;
        while (i < this._cells.size()) {
            Cell cell = (Cell)this._cells.get(i);
            int j = 0;
            while (j < cell._columnList.size()) {
                Vector column = (Vector)cell._columnList.get(j);
                int k = 0;
                while (k < column.size()) {
                    Item item = (Item)column.get(k);
                    if (item.key == key) {
                        cell.remove(item);
                        return;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static class ItemInformation {
        private Object _key;
        private int _column;
        private int _totalColumns;

        private ItemInformation(Object key, int column, int totalColumns) {
            this._key = key;
            this._column = column;
            this._totalColumns = totalColumns;
        }

        public Object getKey() {
            return this._key;
        }

        public int getColumn() {
            return this._column;
        }

        public int getTotalColumns() {
            return this._totalColumns;
        }
    }

    public static class Range {
        public long begin;
        public long end;

        public Range(long begin, long end) {
            this.begin = begin;
            this.end = end;
        }
    }

    private static class Cell {
        private Range _range;
        private Vector _columnList = new Vector();

        public Cell() {
            this._range = new Range(0L, 0L);
        }

        public Range getRange() {
            return this._range;
        }

        public int add(Item item) {
            if (this._columnList.size() == 0) {
                this._range.begin = item.range.begin;
                this._range.end = item.range.end;
            } else {
                this._range.begin = Math.min(this._range.begin, item.range.begin);
                this._range.end = Math.max(this._range.end, item.range.end);
            }
            int i = 0;
            while (i < this._columnList.size()) {
                Vector column = (Vector)this._columnList.get(i);
                int insertionPoint = this.findInsertionPoint(column, item);
                if (insertionPoint >= 0) {
                    column.insertElementAt(item, insertionPoint);
                    return i;
                }
                ++i;
            }
            Vector<Item> newColumn = new Vector<Item>();
            newColumn.add(item);
            this._columnList.add(newColumn);
            return this._columnList.size() - 1;
        }

        public void remove(Item item) {
            int i = 0;
            while (i < this._columnList.size()) {
                Vector column = (Vector)this._columnList.get(i);
                int j = 0;
                while (j < column.size()) {
                    Item currentItem = (Item)column.get(j);
                    if (currentItem == item) {
                        column.remove(j);
                        this.pack();
                        return;
                    }
                    ++j;
                }
                ++i;
            }
        }

        public void move(Item item, long begin, long end) {
            if (begin < this._range.begin || end > this._range.end) {
                throw new IllegalArgumentException("Cannot move item outside cell range");
            }
            int i = 0;
            while (i < this._columnList.size()) {
                Vector column = (Vector)this._columnList.get(i);
                int j = 0;
                while (j < column.size()) {
                    Item currentItem = (Item)column.get(j);
                    if (currentItem == item) {
                        boolean fit = true;
                        if (i > 0 && ((Item)column.get((int)(i - 1))).range.end > begin) {
                            fit = false;
                        }
                        if (fit && i < column.size() - 2 && ((Item)column.get((int)(i + 1))).range.begin < end) {
                            fit = false;
                        }
                        if (!fit) {
                            column.remove(j);
                            this.add(item);
                            this.pack();
                        }
                        return;
                    }
                    ++j;
                }
                ++i;
            }
        }

        public void append(Cell cell) {
            int i = 0;
            while (i < cell._columnList.size()) {
                Vector column = (Vector)cell._columnList.get(i);
                int j = 0;
                while (j < column.size()) {
                    this.add((Item)column.get(j));
                    ++j;
                }
                ++i;
            }
        }

        private void pack() {
            int i = this._columnList.size() - 1;
            while (i >= 0) {
                Vector localColumn = (Vector)this._columnList.get(i);
                if (localColumn.size() == 0) {
                    this._columnList.remove(i);
                }
                --i;
            }
        }

        private int findInsertionPoint(Vector column, Item item) {
            int columnSize = column.size();
            if (columnSize == 0) {
                return 0;
            }
            Item prevItem = null;
            Item currentItem = null;
            int i = 0;
            while (i < columnSize) {
                currentItem = (Item)column.get(i);
                if (currentItem.range.begin >= item.range.end) {
                    if (prevItem != null && prevItem.range.end > item.range.begin) {
                        return -1;
                    }
                    if (i < columnSize - 1) {
                        Item nextItem = (Item)column.get(i + 1);
                        if (item.range.end > nextItem.range.begin) {
                            return -1;
                        }
                    }
                    return i;
                }
                prevItem = currentItem;
                ++i;
            }
            if (currentItem != null && item.range.begin >= currentItem.range.end) {
                return columnSize;
            }
            return -1;
        }
    }

    private static class Item {
        public Range range;
        public Object key;

        public Item(Object key, Range range) {
            this.key = key;
            this.range = range;
        }
    }
}

