/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import edu.cmu.cs.radar.rhai.calendar.DateTime;
import edu.cmu.cs.radar.rhai.spacetime.ComponentDragContainer;
import edu.cmu.cs.radar.rhai.spacetime.ComponentDragListener;
import edu.cmu.cs.radar.rhai.spacetime.DateSelectionListener;
import edu.cmu.cs.radar.rhai.spacetime.GenericRequestDragComponent;
import edu.cmu.cs.radar.rhai.spacetime.RequestListModel;
import edu.cmu.cs.radar.rhai.spacetime.SelectionListener;
import edu.cmu.cs.radar.rhai.spacetime.Services;
import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeDate;
import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeRequestNode;
import edu.cmu.cs.radar.rhai.spacetime.WorkJournal;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class DatePicker
extends JPanel
implements ComponentDragListener,
SelectionListener {
    private static final long serialVersionUID = 0L;
    private Date _selectedDate;
    private Date _previouslySelectedDate;
    private int _selectedDay;
    private int _selectedMonth;
    private int _selectedYear;
    private Date _currentDate;
    private int _currentMonth;
    private int _currentYear;
    private int _firstDayInMonth;
    private int _daysInMonth;
    private int _daysInPrevMonth;
    private Point _targetCell;
    private boolean _usingValidRange;
    private int _startDay;
    private int _startMonth;
    private int _startYear;
    private int _stopDay;
    private int _stopMonth;
    private int _stopYear;
    private RequestListModel _listModel;
    private GregorianCalendar _calendar;
    private ArrayList _listeners;
    private ComponentDragContainer _dragContainer;
    private static final String[] monthLabels = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final String[] dayLabels = new String[]{"S", "M", "T", "W", "Th", "F", "S"};
    private static int CELL_WIDTH = 16;
    private static int CELL_HEIGHT = 16;

    public DatePicker(RequestListModel listModel) {
        this.setSize(this.getMinimumSize());
        this.setBackground(Color.white);
        this._currentDate = this._selectedDate = new Date(0L);
        this._listeners = new ArrayList();
        this._usingValidRange = false;
        this._calendar = new GregorianCalendar();
        this.calculateMonth();
        this._listModel = listModel;
        listModel.addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent e) {
                DatePicker.this.repaint();
            }

            public void intervalAdded(ListDataEvent e) {
            }

            public void intervalRemoved(ListDataEvent e) {
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                Point p = e.getPoint();
                int xoffset = (DatePicker.this.getWidth() - 9 * CELL_WIDTH) / 2;
                Rectangle2D.Float leftRect = new Rectangle2D.Float(0.0f, 0.0f, CELL_WIDTH, CELL_HEIGHT);
                Rectangle2D.Float rightRect = new Rectangle2D.Float(DatePicker.this.getWidth() - CELL_WIDTH, 0.0f, CELL_WIDTH, CELL_HEIGHT);
                int monthRoll = 0;
                if (leftRect.contains(p.x, p.y)) {
                    monthRoll = -1;
                } else if (rightRect.contains(p.x, p.y)) {
                    monthRoll = 1;
                }
                if (monthRoll != 0) {
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.setTime(DatePicker.this._currentDate);
                    DatePicker.this.rollCalendarMonth(calendar, monthRoll);
                    DatePicker.this._currentDate = calendar.getTime();
                    DatePicker.this.calculateMonth();
                    DatePicker.this.repaint();
                    return;
                }
                if (p.y <= 2 * CELL_HEIGHT || p.x - xoffset <= CELL_WIDTH || p.x - xoffset >= 8 * CELL_WIDTH) {
                    return;
                }
                int x = (p.x - xoffset) / CELL_WIDTH - 1;
                int y = p.y / CELL_HEIGHT - 2;
                DayInfo dayInfo = DatePicker.this.getDayInfo(x, y);
                if (!dayInfo.valid) {
                    return;
                }
                DatePicker.this._calendar.setTime(DatePicker.this._currentDate);
                if (dayInfo.prevMonth) {
                    DatePicker.this.rollCalendarMonth(DatePicker.this._calendar, -1);
                    DatePicker.this._currentDate = DatePicker.this._calendar.getTime();
                } else if (dayInfo.nextMonth) {
                    DatePicker.this.rollCalendarMonth(DatePicker.this._calendar, 1);
                    DatePicker.this._currentDate = DatePicker.this._calendar.getTime();
                }
                DatePicker.this._calendar.set(5, dayInfo.day);
                DatePicker.this._previouslySelectedDate = DatePicker.this._selectedDate;
                DatePicker.this._selectedDate = DatePicker.this._calendar.getTime();
                DatePicker.this.calculateMonth();
                DatePicker.this.repaint();
                Services.logger.info("The user selected date '" + DatePicker.this._selectedDate.toString() + "' in the calendar");
                DatePicker.this.notifyDateSelected();
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        this.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent e) {
                DatePicker.this.repaint();
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentHidden(ComponentEvent e) {
            }

            public void componentShown(ComponentEvent e) {
            }
        });
    }

    public void setValidDateRange(Date startDate, Date stopDate) {
        this._usingValidRange = true;
        this._calendar.setTime(startDate);
        this._startDay = this._calendar.get(5);
        this._startMonth = this._calendar.get(2);
        this._startYear = this._calendar.get(1);
        this._calendar.setTime(stopDate);
        this._stopDay = this._calendar.get(5);
        this._stopMonth = this._calendar.get(2);
        this._stopYear = this._calendar.get(1);
        if (this._selectedDay < this._startDay || this._selectedDay > this._stopDay || this._selectedMonth < this._startMonth || this._selectedMonth > this._stopMonth || this._selectedYear < this._startYear || this._selectedYear > this._stopYear) {
            this._currentDate = startDate;
            this._selectedDate = startDate;
            this.calculateMonth();
            this.repaint();
            this.notifyDateSelected();
        }
    }

    public void setSelectedDate(Date date) {
        this._previouslySelectedDate = this._selectedDate;
        this._selectedDate = date;
        this.calculateMonth();
        this.notifyDateSelected();
        this.repaint();
    }

    public void clearValidDateRange() {
        this._usingValidRange = false;
    }

    private void notifyDateSelected() {
        if (this._previouslySelectedDate != null) {
            this._calendar.setTime(this._previouslySelectedDate);
            int previousYear = this._calendar.get(1);
            int previousDay = this._calendar.get(6);
            this._calendar.setTime(this._selectedDate);
            int year = this._calendar.get(1);
            int day = this._calendar.get(6);
            if (previousYear == year && previousDay == day) {
                return;
            }
        }
        int i = 0;
        while (i < this._listeners.size()) {
            DateSelectionListener listener = (DateSelectionListener)this._listeners.get(i);
            listener.selectDate(this._selectedDate);
            ++i;
        }
    }

    private void rollCalendarMonth(GregorianCalendar calendar, int interval) {
        if (interval == 0) {
            return;
        }
        int monthRoll = 0;
        if (interval < 0) {
            monthRoll = interval;
        } else if (interval > 0) {
            monthRoll = 1;
        }
        if (monthRoll != 0) {
            calendar.add(2, monthRoll);
        }
    }

    private void calculateMonth() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(this._selectedDate);
        this._selectedDay = calendar.get(5);
        this._selectedMonth = calendar.get(2);
        this._selectedYear = calendar.get(1);
        calendar.setTime(this._currentDate);
        calendar.set(5, 1);
        this._currentMonth = calendar.get(2);
        this._currentYear = calendar.get(1);
        this._firstDayInMonth = calendar.get(7);
        this._daysInMonth = calendar.getActualMaximum(5);
        calendar.add(2, -1);
        this._daysInPrevMonth = calendar.getActualMaximum(5);
    }

    private DayInfo getDayInfo(int x, int y) {
        int value = 7 * y + x;
        int day = 1;
        int month = this._currentMonth;
        int year = this._currentYear;
        boolean prevMonth = false;
        boolean nextMonth = false;
        if (value < this._firstDayInMonth - 1) {
            day = 2 + this._daysInPrevMonth - this._firstDayInMonth + value;
            if (this._currentMonth == 0) {
                month = 11;
                year = this._currentYear - 1;
            } else {
                month = this._currentMonth - 1;
            }
            prevMonth = true;
        } else if (value > this._firstDayInMonth + this._daysInMonth - 2) {
            day = value - this._daysInMonth - this._firstDayInMonth + 2;
            if (this._currentMonth == 11) {
                month = 0;
                year = this._currentYear + 1;
            } else {
                month = this._currentMonth + 1;
            }
            nextMonth = true;
        } else {
            day = 2 + value - this._firstDayInMonth;
        }
        if (!this._usingValidRange) {
            return new DayInfo(day, month, prevMonth, nextMonth, true, false, false);
        }
        if (year < this._startYear || year > this._stopYear) {
            return new DayInfo(day, month, prevMonth, nextMonth, false, false, false);
        }
        if (month < this._startMonth || month > this._stopMonth) {
            return new DayInfo(day, month, prevMonth, nextMonth, false, false, false);
        }
        if (day < this._startDay || day > this._stopDay) {
            return new DayInfo(day, month, prevMonth, nextMonth, false, false, false);
        }
        if (this._startDay == day && this._startMonth == month && this._startYear == year) {
            return new DayInfo(day, month, prevMonth, nextMonth, true, true, false);
        }
        if (this._stopDay == day && this._stopMonth == month && this._stopYear == year) {
            return new DayInfo(day, month, prevMonth, nextMonth, true, false, true);
        }
        return new DayInfo(day, month, prevMonth, nextMonth, true, false, false);
    }

    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int width = this.getWidth();
        int height = this.getHeight();
        g.setColor(Color.lightGray);
        g.fillRect(0, 0, width, CELL_HEIGHT);
        String monthString = String.valueOf(monthLabels[this._currentMonth]) + " " + Integer.toString(this._currentYear);
        g.setColor(Color.black);
        Font titleFont = new Font("Sans Serif", 1, 11);
        Font normalFont = new Font("Sans Serif", 0, 10);
        g.setFont(titleFont);
        FontMetrics titleFontMetrics = g.getFontMetrics(titleFont);
        g.drawString(monthString, width / 2 - titleFontMetrics.stringWidth(monthString) / 2, CELL_HEIGHT - 4);
        g.setFont(normalFont);
        FontMetrics fontMetrics = g.getFontMetrics(normalFont);
        int xoffset = (width - 9 * CELL_WIDTH) / 2;
        g.setColor(Color.black);
        int i = 0;
        while (i < 7) {
            g.drawString(dayLabels[i], xoffset + (i + 2) * CELL_WIDTH - CELL_WIDTH / 2 - fontMetrics.stringWidth(dayLabels[i]) / 2, 2 * CELL_HEIGHT - 4);
            ++i;
        }
        g.setColor(Color.lightGray);
        g.drawLine(xoffset + CELL_WIDTH, 2 * CELL_HEIGHT, xoffset + 8 * CELL_WIDTH, 2 * CELL_HEIGHT);
        g.setColor(Color.black);
        g.fillPolygon(new int[]{5, CELL_WIDTH - 5, CELL_WIDTH - 5}, new int[]{CELL_WIDTH / 2, 4, CELL_HEIGHT - 4}, 3);
        g.fillPolygon(new int[]{width - 5, width - CELL_WIDTH + 5, width - CELL_WIDTH + 5}, new int[]{CELL_WIDTH / 2, 4, CELL_HEIGHT - 4}, 3);
        i = 0;
        while (i < 6) {
            int j = 0;
            while (j < 7) {
                int x = xoffset + j * CELL_WIDTH;
                int y = i * CELL_HEIGHT;
                DayInfo dayInfo = this.getDayInfo(j, i);
                if (this._usingValidRange && dayInfo.valid) {
                    g.setColor(Color.lightGray);
                    g.fillRect(x + CELL_WIDTH, y + 2 * CELL_HEIGHT, CELL_WIDTH, CELL_HEIGHT);
                }
                String dayString = Integer.toString(dayInfo.day);
                if (this._selectedDay == dayInfo.day && this._selectedMonth == dayInfo.month && this._selectedYear == this._currentYear) {
                    g.setColor(Color.black);
                    g.fillRect(x + CELL_WIDTH, y + 2 * CELL_HEIGHT, CELL_WIDTH, CELL_HEIGHT);
                    g.setColor(Color.white);
                    g.drawString(dayString, x + 2 * CELL_WIDTH - CELL_WIDTH / 2 - fontMetrics.stringWidth(dayString) / 2, y + 3 * CELL_HEIGHT - 4);
                } else {
                    if (dayInfo.nextMonth || dayInfo.prevMonth) {
                        g.setColor(Color.lightGray);
                    } else {
                        g.setColor(Color.black);
                    }
                    g.drawString(dayString, x + 2 * CELL_WIDTH - CELL_WIDTH / 2 - fontMetrics.stringWidth(dayString) / 2, y + 3 * CELL_HEIGHT - 4);
                }
                ++j;
            }
            ++i;
        }
        g.setColor(Color.gray);
        g.drawLine(this.getWidth() - 1, 0, width - 1, height - 1);
        if (this._targetCell != null) {
            g.setColor(new Color(0, 0, 200));
            g.drawRect(xoffset + CELL_WIDTH + CELL_WIDTH * this._targetCell.x, 2 * CELL_HEIGHT + CELL_HEIGHT * this._targetCell.y, CELL_WIDTH, CELL_HEIGHT);
            g.drawRect(xoffset + CELL_WIDTH + CELL_WIDTH * this._targetCell.x + 1, 2 * CELL_HEIGHT + CELL_HEIGHT * this._targetCell.y + 1, CELL_WIDTH - 2, CELL_HEIGHT - 2);
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(9 * CELL_WIDTH, 8 * CELL_HEIGHT);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void addDateListener(DateSelectionListener listener) {
        this._listeners.add(listener);
    }

    public void componentDragEnter(ComponentDragContainer dragContainer, Component component, Point p) {
        this._dragContainer = dragContainer;
    }

    public void componentDragLeave(ComponentDragContainer dragContainer, Component component, Point p) {
        this._targetCell = null;
    }

    public void componentDragAbort(ComponentDragContainer dragContainer, Component component) {
        this._targetCell = null;
        this.repaint();
    }

    public void componentDragged(Point p) {
        SpaceTimeRequestNode requestNode = ((GenericRequestDragComponent)this._dragContainer.getDragComponent()).getRequestNode();
        if (!requestNode.isAssigned()) {
            return;
        }
        int xoffset = (this.getWidth() - 9 * CELL_WIDTH) / 2;
        int x = (p.x - xoffset) / CELL_WIDTH - 1;
        int y = p.y / CELL_HEIGHT - 2;
        Point newTarget = null;
        if (x >= 0 && x <= 6 && y >= 0 && y <= 5) {
            DayInfo dayInfo = this.getDayInfo(x, y);
            if (dayInfo.valid) {
                newTarget = new Point(x, y);
            }
        }
        if (newTarget != null) {
            if (!newTarget.equals(this._targetCell)) {
                this._targetCell = newTarget;
                this.repaint();
            }
        } else if (this._targetCell != null && !this._targetCell.equals(newTarget)) {
            this._targetCell = newTarget;
            this.repaint();
        }
    }

    public boolean componentDropped(Point p) {
        if (this._targetCell == null) {
            return false;
        }
        DayInfo dayInfo = this.getDayInfo(this._targetCell.x, this._targetCell.y);
        this._calendar.set(5, dayInfo.day);
        this._calendar.set(2, dayInfo.month);
        this._targetCell = null;
        return this.componentDropped(this._dragContainer.getDragComponent(), this._calendar.getTime());
    }

    public void componentDropComplete(ComponentDragContainer dragContainer, Component component) {
    }

    protected boolean componentDropped(Component dragComponent, Date date) {
        if (!(dragComponent instanceof GenericRequestDragComponent)) {
            return false;
        }
        SpaceTimeRequestNode requestNode = ((GenericRequestDragComponent)dragComponent).getRequestNode();
        this._calendar.setTime(requestNode.getStart());
        int hour = this._calendar.get(11);
        int minute = this._calendar.get(12);
        this._calendar.setTime(date);
        this._calendar.set(11, hour);
        this._calendar.set(12, minute);
        WorkJournal.NodeStateCaptureItem changeEventDayAction = new WorkJournal.NodeStateCaptureItem(this._listModel, requestNode.getNode(), "change day");
        SpaceTimeDate spaceTimeDate = new SpaceTimeDate(this._calendar.getTime());
        requestNode.setStart(spaceTimeDate);
        changeEventDayAction.captureState();
        Services.journal.addItem(changeEventDayAction);
        String dateString = DateFormat.getDateInstance(2).format(new DateTime(date).getAsDate());
        changeEventDayAction.setLogDescription("dragged event '" + requestNode.getNode().getName() + "' to date '" + dateString + "' in the calendar");
        Services.logger.info(changeEventDayAction.log());
        return true;
    }

    public void setSelection(Object sender, Object selection, int type, boolean selected, boolean doubleClick) {
        if (type == 1 && selection != null && doubleClick) {
            SpaceTimeNode selectionNode = this._listModel.getDataAdapter().getNodeById((String)selection);
            SpaceTimeRequestNode selectionRequestNode = new SpaceTimeRequestNode(selectionNode);
            if (selectionRequestNode.isAssigned()) {
                this.setSelectedDate(selectionRequestNode.getStart());
            }
            selectionRequestNode.dispose();
        }
    }

    public void setViewState(Object sender, Object selection, boolean show) {
    }

    private static class DayInfo {
        public int day;
        public int month;
        public boolean prevMonth;
        public boolean nextMonth;
        public boolean valid;
        public boolean startDay;
        public boolean stopDay;

        public DayInfo(int day, int month, boolean prevMonth, boolean nextMonth, boolean valid, boolean startDay, boolean stopDay) {
            this.day = day;
            this.month = month;
            this.prevMonth = prevMonth;
            this.nextMonth = nextMonth;
            this.valid = valid;
            this.startDay = startDay;
            this.stopDay = stopDay;
        }
    }
}

