/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.calendar;

import edu.cmu.cs.radar.rhai.calendar.CalendarObjectView;
import edu.cmu.cs.radar.rhai.calendar.Event;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;

public class EventView
extends CalendarObjectView {
    private static final long serialVersionUID = 1L;

    public EventView(Event event) {
        super(event);
    }

    public Event getEvent() {
        return (Event)this.getCalendarObject();
    }

    public Insets getInsets() {
        return new Insets(2, 5, 5, 5);
    }

    public Color getBackgroundColor() {
        return this.getEvent().isTimeSlot() ? Color.LIGHT_GRAY : super.getBackgroundColor();
    }

    protected Shape createOutline(int width, int height) {
        if (this.getEvent() != null && !this.getEvent().isTimeSlot()) {
            return super.createOutline(width, height);
        }
        int notch = 4;
        GeneralPath path = new GeneralPath(1);
        int left = 0;
        int y = 0;
        int x = notch;
        boolean in = false;
        path.moveTo(left + x, y);
        while (y + notch <= height) {
            in = !in;
            path.lineTo(x += in ? -notch : notch, y += notch);
        }
        in = !in;
        int yleft = height - y;
        path.lineTo(x += in ? -yleft : yleft, height);
        in = !in;
        y += notch;
        x = in ? width - yleft : width - notch + yleft;
        path.lineTo(x, height);
        x = in ? width - notch : width;
        while (y > 0) {
            in = !in;
            path.lineTo(x += in ? -notch : notch, y -= notch);
        }
        path.closePath();
        return path;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        String text = this.getEvent().getSummary();
        if (text == null) {
            return;
        }
        String location = this.getEvent().getLocation();
        if (location != null) {
            text = String.valueOf(text) + " (" + location + ")";
        }
        g2.setPaint(Color.BLACK);
        Insets insets = this.getInsets();
        int width = Math.max(this.getWidth() - insets.right - insets.left, 10);
        int x = insets.left;
        int y = insets.top;
        String[] paragraphs = text.split("\n");
        int p = 0;
        while (p < paragraphs.length) {
            String paragraph = paragraphs[p];
            if (paragraph == null || paragraph.length() == 0) {
                y += g2.getFontMetrics().getHeight();
            } else {
                AttributedString attributedString = new AttributedString(paragraph);
                attributedString.addAttribute(TextAttribute.FONT, g2.getFont());
                AttributedCharacterIterator characterIterator = attributedString.getIterator();
                FontRenderContext fontRenderContext = g2.getFontRenderContext();
                LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(characterIterator, fontRenderContext);
                while (lineBreakMeasurer.getPosition() < characterIterator.getEndIndex()) {
                    TextLayout textLayout = lineBreakMeasurer.nextLayout(width);
                    y = (int)((float)y + textLayout.getAscent());
                    textLayout.draw(g2, x, y);
                    y = (int)((float)y + (textLayout.getDescent() + textLayout.getLeading()));
                }
            }
            ++p;
        }
    }
}

