/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.calendar;

import edu.cmu.cs.radar.rhai.calendar.CalendarObject;
import edu.cmu.cs.radar.rhai.calendar.CalendarObjectCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AbstractCalendarObjectCollection
implements CalendarObjectCollection,
CalendarObjectCollection.Listener {
    protected Set mCalendarObjects = new HashSet();
    protected List mCalendarObjectCollectionListeners = new ArrayList();
    protected CalendarObjectCollection mSource = null;

    protected AbstractCalendarObjectCollection() {
    }

    public void connectToSource(CalendarObjectCollection source) {
        if (this.mSource != null) {
            throw new IllegalStateException("already connected to a source");
        }
        if (source == null) {
            throw new NullPointerException("argument 'source'");
        }
        this.mSource = source;
        this.mSource.addCalendarObjectCollectionListener(this);
    }

    protected void addCalendarObject(CalendarObject calObj) {
        if (calObj == null) {
            throw new NullPointerException("argument 'calObj'");
        }
        if (this.mCalendarObjects.contains(calObj)) {
            throw new IllegalArgumentException("CalendarObject (" + calObj.getID() + ") already contained");
        }
        this.mCalendarObjects.add(calObj);
        this.fireCalendarObjectAdded(calObj);
    }

    protected synchronized void checkCalendarObject(CalendarObject calObj) {
        if (calObj == null) {
            throw new NullPointerException("argument 'calObj'");
        }
        this.fireCalendarObjectChanged(calObj);
    }

    protected synchronized void removeCalendarObject(CalendarObject calObj) {
        if (calObj == null) {
            throw new NullPointerException("argument 'calObj'");
        }
        if (!this.mCalendarObjects.contains(calObj)) {
            throw new IllegalArgumentException("CalendarObject (" + calObj.getID() + ") not contained");
        }
        this.mCalendarObjects.remove(calObj);
        this.fireCalendarObjectRemoved(calObj);
    }

    public void calendarObjectAdded(AbstractCalendarObjectCollection source, CalendarObject calObj) {
        if (source == null) {
            throw new NullPointerException("argument 'source'");
        }
        if (calObj == null) {
            throw new NullPointerException("argument 'calObj'");
        }
        if (this.mSource != source) {
            throw new IllegalArgumentException("not connected to 'source' (" + source + ")");
        }
        this.addCalendarObject(calObj);
    }

    public void calendarObjectChanged(AbstractCalendarObjectCollection source, CalendarObject calObj) {
        if (source == null) {
            throw new NullPointerException("argument 'source'");
        }
        if (calObj == null) {
            throw new NullPointerException("argument 'calObj'");
        }
        if (this.mSource != source) {
            throw new IllegalArgumentException("not connected to 'source' (" + source + ")");
        }
        this.checkCalendarObject(calObj);
    }

    public void calendarObjectRemoved(AbstractCalendarObjectCollection source, CalendarObject calObj) {
        if (source == null) {
            throw new NullPointerException("argument 'source'");
        }
        if (calObj == null) {
            throw new NullPointerException("argument 'calObj'");
        }
        if (this.mSource != source) {
            throw new IllegalArgumentException("not connected to 'source' (" + source + ")");
        }
        this.removeCalendarObject(calObj);
    }

    public synchronized void addCalendarObjectCollectionListener(CalendarObjectCollection.Listener listener) {
        this.mCalendarObjectCollectionListeners.add(listener);
        Iterator iter = this.mCalendarObjects.iterator();
        while (iter.hasNext()) {
            CalendarObject calObj = (CalendarObject)iter.next();
            listener.calendarObjectAdded(this, calObj);
        }
    }

    public synchronized void removeCalendarObjectCollectionListener(CalendarObjectCollection.Listener listener) {
        Iterator iter = this.mCalendarObjects.iterator();
        while (iter.hasNext()) {
            CalendarObject calObj = (CalendarObject)iter.next();
            listener.calendarObjectRemoved(this, calObj);
        }
        this.mCalendarObjectCollectionListeners.remove(listener);
    }

    protected synchronized void fireCalendarObjectAdded(CalendarObject calObj) {
        Object[] listeners = this.mCalendarObjectCollectionListeners.toArray();
        int i = 0;
        while (i < listeners.length) {
            ((CalendarObjectCollection.Listener)listeners[i]).calendarObjectAdded(this, calObj);
            ++i;
        }
    }

    protected synchronized void fireCalendarObjectChanged(CalendarObject calObj) {
        Object[] listeners = this.mCalendarObjectCollectionListeners.toArray();
        int i = 0;
        while (i < listeners.length) {
            ((CalendarObjectCollection.Listener)listeners[i]).calendarObjectChanged(this, calObj);
            ++i;
        }
    }

    protected synchronized void fireCalendarObjectRemoved(CalendarObject calObj) {
        Object[] listeners = this.mCalendarObjectCollectionListeners.toArray();
        int i = 0;
        while (i < listeners.length) {
            ((CalendarObjectCollection.Listener)listeners[i]).calendarObjectRemoved(this, calObj);
            ++i;
        }
    }
}

