/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.stp.cachingdatamodel;

import SpaceTime.DataModel.CertainPlf;
import SpaceTime.DataModel.CertainPlfImpl;
import SpaceTime.DataModel.LinearFunctionIntervals;
import java.util.ArrayList;

public class LinearFunctionData {
    private static final int NOVALUE = -100;
    private CertainPlf _functionData;
    private ArrayList _xValues;
    private ArrayList _yValues;
    private double _maxY;
    private int _size;

    public LinearFunctionData(CertainPlf functionData) {
        this._functionData = functionData;
        this._maxY = -100.0;
        this._size = -100;
        this._xValues = new ArrayList();
        this._yValues = new ArrayList();
        this.cacheDataPoints();
    }

    private void cacheDataPoints() {
        this._xValues.clear();
        this._yValues.clear();
        int size = this.size();
        int i = 0;
        while (i < size) {
            this._xValues.add(new Double(this._functionData.GetX(i)));
            this._yValues.add(new Double(this._functionData.GetY(i)));
            ++i;
        }
    }

    public int size() {
        if (this._size == -100) {
            this._size = this._functionData.Size();
        }
        return this._size;
    }

    public double getMaxY() {
        if (this._maxY == -100.0) {
            this._maxY = this._functionData.GetMaxY();
        }
        return this._maxY;
    }

    public double getX(int index) {
        Double doubleVal = (Double)this._xValues.get(index);
        return doubleVal;
    }

    public double getY(int index) {
        Double doubleVal = (Double)this._yValues.get(index);
        return doubleVal;
    }

    public LinearFunctionIntervals GetThresholdedIntervals(double threshold) {
        return ((CertainPlfImpl)this._functionData).GetThresholdedIntervals(threshold);
    }
}

