/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import SpaceTime.DataModel.NodeChangeSummary;
import edu.cmu.cs.radar.rhai.spacetime.EditRoomAction;
import edu.cmu.cs.radar.rhai.spacetime.JTree142;
import edu.cmu.cs.radar.rhai.spacetime.NoHorizontalScrollViewport;
import edu.cmu.cs.radar.rhai.spacetime.RequestListModel;
import edu.cmu.cs.radar.rhai.spacetime.RoomNode;
import edu.cmu.cs.radar.rhai.spacetime.ScheduleInfo;
import edu.cmu.cs.radar.rhai.spacetime.ScheduleList;
import edu.cmu.cs.radar.rhai.spacetime.ScheduleListListener;
import edu.cmu.cs.radar.rhai.spacetime.SelectionListener;
import edu.cmu.cs.radar.rhai.spacetime.SelectionManager;
import edu.cmu.cs.radar.rhai.spacetime.Services;
import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeDate;
import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeRequestNode;
import edu.cmu.cs.radar.stp.cachingdatamodel.GlobalChangeListener;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeNode;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeProperty;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class RoomPicker
extends JPanel
implements SelectionListener {
    private static final long serialVersionUID = 1L;
    private static final String UNKNOWN_BUILDING = "Unknown";
    private RequestListModel _reqListModel;
    private SelectionManager _selectionManager;
    private Room _selectedRoom;
    private boolean _ignoreTreeSelectionChanges;
    private ScheduleList _schedules;
    private HashMap _buildings;
    private HashMap _rooms;
    private ArrayList _scheduleListListeners;
    private JTree _tree;
    static /* synthetic */ Class class$0;

    public RoomPicker(RequestListModel reqListModel, SelectionManager selectionManager) {
        this._reqListModel = reqListModel;
        this._selectionManager = selectionManager;
        this._selectionManager.addListener(this);
        this._selectedRoom = null;
        this._ignoreTreeSelectionChanges = false;
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this._schedules = new ScheduleList();
        this._buildings = new HashMap();
        this._rooms = new HashMap();
        this._scheduleListListeners = new ArrayList();
        this._tree = new JTree142(new DefaultTreeModel(null)){
            private static final long serialVersionUID = 1L;

            public Point getToolTipLocation(MouseEvent event) {
                int row = RoomPicker.this._tree.getRowForLocation(event.getX(), event.getY());
                if (row < 0) {
                    return super.getToolTipLocation(event);
                }
                Rectangle bounds = RoomPicker.this._tree.getRowBounds(row);
                Point location = bounds.getLocation();
                Object value = RoomPicker.this._tree.getPathForRow(row).getLastPathComponent();
                boolean isLeaf = RoomPicker.this._tree.getModel().isLeaf(value);
                CellPanel renderer = (CellPanel)RoomPicker.this._tree.getCellRenderer().getTreeCellRendererComponent(RoomPicker.this._tree, value, false, true, isLeaf, row, false);
                renderer.setBounds(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
                renderer.doLayout();
                location.x = (int)((double)location.x + ((double)renderer._checkBox.getX() + renderer._checkBox._textRect.getX() - 1.0));
                location.y = (int)((double)location.y + ((double)renderer._checkBox.getY() + renderer._checkBox._textRect.getY()));
                return location;
            }
        };
        this._tree.setRootVisible(false);
        this._tree.setEditable(true);
        this._tree.setToggleClickCount(1);
        this._tree.setRowHeight(-1);
        this._tree.setExpandsSelectedPaths(true);
        this._tree.setScrollsOnExpand(true);
        ToolTipManager.sharedInstance().registerComponent(this._tree);
        this._tree.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                MouseEvent eRoot = SwingUtilities.convertMouseEvent(RoomPicker.this._tree, e, null);
                RoomPicker.this._tree.getParent().dispatchEvent(e);
                ToolTipManager.sharedInstance().mouseMoved(SwingUtilities.convertMouseEvent(null, eRoot, RoomPicker.this._tree));
            }
        });
        this._tree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                Object object = path.getLastPathComponent();
                if (object instanceof Building) {
                    Building building = (Building)object;
                    building._isExpanded = true;
                    if (!RoomPicker.this._ignoreTreeSelectionChanges) {
                        Services.logger.info("The user expanded building '" + building._name + "' in the room picker");
                    }
                }
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                Object object = path.getLastPathComponent();
                if (object instanceof Building) {
                    Building building = (Building)object;
                    building._isExpanded = false;
                    if (!RoomPicker.this._ignoreTreeSelectionChanges) {
                        Services.logger.info("The user collapsed building '" + building._name + "' in the room picker");
                    }
                }
            }
        });
        this._tree.addMouseListener(new MouseAdapter(){
            private Room _currentRoom;

            public void mouseClicked(MouseEvent evt) {
                Room room;
                if (evt.getButton() == 1 && evt.getClickCount() == 2 && (room = this.getRoomAt(evt)) != null) {
                    room.setThreeStateValue(2);
                    RoomPicker.this._selectionManager.notifySelection(RoomPicker.this, room._roomNode.getName(), 2, true, true, true);
                    Services.logger.info("The user double clicked on room '" + room._roomNode.getName() + "' in the room picker");
                }
            }

            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    this.handleContextMenu(evt);
                }
            }

            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    this.handleContextMenu(evt);
                }
            }

            private Room getRoomAt(MouseEvent evt) {
                Object obj;
                TreePath path = RoomPicker.this._tree.getPathForLocation(evt.getX(), evt.getY());
                if (path != null && (obj = path.getLastPathComponent()) instanceof Room) {
                    return (Room)obj;
                }
                return null;
            }

            private void handleContextMenu(MouseEvent evt) {
                Room room;
                this._currentRoom = room = this.getRoomAt(evt);
                if (room != null) {
                    JMenuItem showHideRoomMenuItem = new JMenuItem(room._isShowing ? "Hide Room" : "Show Room");
                    showHideRoomMenuItem.addActionListener(new ActionListener(this, showHideRoomMenuItem, room){
                        final /* synthetic */ 4 this$1;
                        private final /* synthetic */ JMenuItem val$showHideRoomMenuItem;
                        private final /* synthetic */ Room val$room;
                        {
                            this.this$1 = var1_1;
                            this.val$showHideRoomMenuItem = jMenuItem;
                            this.val$room = room;
                        }

                        public void actionPerformed(ActionEvent arg0) {
                            int newState = 4.access$0(this.this$1).isShowing() ? 0 : 2;
                            4.access$0(this.this$1).setThreeStateValue(newState);
                            Services.logger.info("The user chose '" + this.val$showHideRoomMenuItem.getText() + "' for: " + Room.access$0(this.val$room).getName());
                        }
                    });
                    JMenuItem editRoomPropertiesMenuItem = new JMenuItem(new EditRoomAction(this._currentRoom._roomNode));
                    JPopupMenu roomContextMenu = new JPopupMenu();
                    roomContextMenu.add(showHideRoomMenuItem);
                    roomContextMenu.add(editRoomPropertiesMenuItem);
                    roomContextMenu.show(RoomPicker.this._tree, evt.getX(), evt.getY());
                }
            }

            static /* synthetic */ Room access$0(4 var0) {
                return var0._currentRoom;
            }
        });
        this._tree.setCellRenderer(new LocationTreeNodeCellRenderer());
        this._tree.setCellEditor(new LocationTreeNodeCellEditor());
        RootNotSelectableSelectionModel selectionModel = new RootNotSelectableSelectionModel();
        selectionModel.setSelectionMode(1);
        this._tree.setSelectionModel(selectionModel);
        selectionModel.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                if (RoomPicker.this._ignoreTreeSelectionChanges) {
                    return;
                }
                Object obj = evt.getPath().getLastPathComponent();
                if (obj instanceof Room) {
                    Room room = (Room)obj;
                    boolean selected = evt.isAddedPath();
                    RoomPicker.this._selectionManager.notifySelection(RoomPicker.this, room._roomNode.getName(), 2, selected, true, false);
                    Services.logger.info("The user selected room '" + room._roomNode.getName() + "' in the room picker");
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewport(new NoHorizontalScrollViewport());
        scrollPane.setViewportView(this._tree);
        scrollPane.setBorder(null);
        scrollPane.setBackground(this.getBackground());
        scrollPane.setViewportBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        scrollPane.setHorizontalScrollBarPolicy(31);
        this.add((Component)scrollPane, "Center");
        this._reqListModel.addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent e) {
                RoomPicker.this.listModelChanged();
            }

            public void intervalAdded(ListDataEvent e) {
                RoomPicker.this.listModelChanged();
            }

            public void intervalRemoved(ListDataEvent e) {
                RoomPicker.this.listModelChanged();
            }
        });
        ActionMap am = this._tree.getActionMap();
        am.put("selectPrevious", new ChangeSelectionAction(0));
        am.put("selectNext", new ChangeSelectionAction(1));
        am.put("selectParent", new ChangeSelectionAction(-1));
        am.put("selectChild", new ChangeSelectionAction(-1));
        am.put("scrollUpChangeSelection", new ChangeSelectionAction(3));
        am.put("scrollDownChangeSelection", new ChangeSelectionAction(2));
    }

    public void setSelection(Object sender, Object selection, int type, boolean selected, boolean doubleClick) {
        this._ignoreTreeSelectionChanges = true;
        if (type == 1) {
            Room room;
            SpaceTimeNode eventNode;
            SpaceTimeRequestNode requestNode;
            String roomName;
            if (this._selectedRoom != null) {
                this._selectedRoom._backgroundSelected = true;
            }
            if (doubleClick && selected && (roomName = (requestNode = new SpaceTimeRequestNode(eventNode = this._reqListModel.getDataAdapter().getNodeById(selection.toString()))).getRoom()) != null && (room = (Room)this._rooms.get(roomName)) != null) {
                room.setThreeStateValue(2);
            }
            this._tree.clearSelection();
        }
        if (type == 2) {
            if (this._selectedRoom != null) {
                this._selectedRoom._backgroundSelected = false;
            }
            if (selection == null) {
                this._tree.clearSelection();
                this._ignoreTreeSelectionChanges = false;
                return;
            }
            Room room = (Room)this._rooms.get(selection.toString());
            if (room == null) {
                return;
            }
            if (selected) {
                TreePath path = new TreePath(room.getPath());
                this._tree.setSelectionPath(path);
                this._tree.scrollPathToVisible(path);
                this._selectedRoom = room;
            } else {
                this._selectedRoom = room;
                this._selectedRoom._backgroundSelected = true;
                this._tree.clearSelection();
            }
        }
        this._ignoreTreeSelectionChanges = false;
        this.repaint();
    }

    public void setViewState(Object sender, Object selection, boolean show) {
        SpaceTimeNode roomNode = (SpaceTimeNode)selection;
        Room room = (Room)this._rooms.get(roomNode.getName());
        if (room == null) {
            return;
        }
        int newState = show ? 2 : 0;
        room.setThreeStateValue(newState);
    }

    public void addScheduleListListener(ScheduleListListener listener) {
        this._scheduleListListeners.add(listener);
    }

    private void notifyScheduleListListeners() {
        Iterator iterator = this._scheduleListListeners.iterator();
        while (iterator.hasNext()) {
            ((ScheduleListListener)iterator.next()).showSchedule(this._schedules);
        }
    }

    private synchronized void countAllocations() {
        Hashtable<String, Integer> roomHash = new Hashtable<String, Integer>();
        List requestList = this._reqListModel.getDataAdapter().getRequests();
        int i = 0;
        while (i < requestList.size()) {
            SpaceTimeNode node = (SpaceTimeNode)requestList.get(i);
            SpaceTimeRequestNode requestNode = new SpaceTimeRequestNode(node);
            if (requestNode.isAssigned()) {
                String roomId = requestNode.getRoom();
                if (roomHash.containsKey(roomId)) {
                    Integer intCount = (Integer)roomHash.get(roomId);
                    roomHash.put(roomId, new Integer(intCount + 1));
                } else {
                    roomHash.put(roomId, new Integer(1));
                }
            }
            requestNode.dispose();
            ++i;
        }
        boolean countChanged = false;
        Iterator roomIterator = this._rooms.values().iterator();
        while (roomIterator.hasNext()) {
            Room room = (Room)roomIterator.next();
            Integer intCount = (Integer)roomHash.get(room._roomNode.getName());
            if (intCount != null) {
                if (room._allocationCount == intCount) continue;
                room._allocationCount = intCount;
                countChanged = true;
                continue;
            }
            room._allocationCount = 0;
        }
        if (countChanged) {
            this.repaint();
        }
    }

    public void listModelChanged() {
        this._ignoreTreeSelectionChanges = true;
        this._schedules.clear();
        this._selectedRoom = null;
        HashMap oldBuildings = this._buildings;
        HashMap oldRooms = this._rooms;
        this._buildings = new HashMap();
        this._rooms = new HashMap();
        DefaultMutableTreeNode rootTreeNode = new DefaultMutableTreeNode("Ardra");
        this._tree.setModel(new DefaultTreeModel(rootTreeNode));
        int orderIndex = 0;
        List rooms = this._reqListModel.getDataAdapter().getRooms();
        int i = 0;
        while (i < rooms.size()) {
            String buildingName;
            Building building;
            SpaceTimeNode roomNode = (SpaceTimeNode)rooms.get(i);
            Room room = new Room(roomNode, ++orderIndex);
            Room oldRoom = (Room)oldRooms.get(roomNode.getName());
            if (oldRoom != null) {
                room.setIsShowing(oldRoom.isShowing());
            }
            this._rooms.put(roomNode.getName(), room);
            if (room.isShowing()) {
                this._schedules.add(room._scheduleInfo);
            }
            if ((building = (Building)this._buildings.get(buildingName = room._buildingName)) == null) {
                building = new Building(buildingName);
                Building oldBuilding = (Building)oldBuildings.get(buildingName);
                if (oldBuilding != null) {
                    building.setIsExpanded(oldBuilding.isExpanded());
                }
                rootTreeNode.add(building);
                this._buildings.put(buildingName, building);
            }
            building.addRoom(room);
            ++i;
        }
        GlobalChangeListener changeListener = new GlobalChangeListener(){

            public void worldStateNodeChanged(String nodeId, NodeChangeSummary changes) {
                boolean show;
                RoomPicker.this.countAllocations();
                Room room = (Room)RoomPicker.this._rooms.get(nodeId);
                if (room != null && (show = RoomNode.isShownInGUI(room._roomNode)) != room.isShowing()) {
                    if (show) {
                        RoomPicker.this._schedules.add(room._scheduleInfo);
                    } else {
                        RoomPicker.this._schedules.remove(room._scheduleInfo);
                    }
                    room._isShowing = show;
                    RoomPicker.this.notifyScheduleListListeners();
                    RoomPicker.this._tree.repaint();
                }
            }

            public void worldStateNodeAdded(String nodeId) {
            }

            public void worldStateGlobalScoreChanged(double score) {
            }

            public void worldStateNodeScoreChanged(String nodeId, double score) {
            }
        };
        this._reqListModel.getDataAdapter().addGlobalChangeListener(changeListener);
        this.notifyScheduleListListeners();
        this.countAllocations();
        Iterator buildingIterator = this._buildings.values().iterator();
        while (buildingIterator.hasNext()) {
            Building building = (Building)buildingIterator.next();
            TreePath path = new TreePath(building.getPath());
            if (building.isExpanded()) {
                this._tree.expandPath(path);
                continue;
            }
            this._tree.collapsePath(path);
        }
        this._ignoreTreeSelectionChanges = false;
    }

    private class RootNotSelectableSelectionModel
    extends DefaultTreeSelectionModel {
        private static final long serialVersionUID = 1L;

        private RootNotSelectableSelectionModel() {
        }

        public void setSelectionPaths(TreePath[] pPaths) {
            if (pPaths != null) {
                TreePath path = pPaths[0];
                if (path.getPathCount() >= 3) {
                    pPaths = new TreePath[]{path};
                } else {
                    return;
                }
            }
            super.setSelectionPaths(pPaths);
        }
    }

    private class ChangeSelectionAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        public static final int NOTHING = -1;
        public static final int ONE_UP = 0;
        public static final int ONE_DOWN = 1;
        public static final int PAGE_DOWN = 2;
        public static final int PAGE_UP = 3;
        private int _type;

        public ChangeSelectionAction(int type) {
            this._type = type;
        }

        public void actionPerformed(ActionEvent e) {
            JTree tree = (JTree)e.getSource();
            TreePath selectionPath = tree.getSelectionPath();
            if (selectionPath == null) {
                return;
            }
            int step = 0;
            int selectedRow = tree.getRowForPath(selectionPath);
            switch (this._type) {
                case -1: {
                    return;
                }
                case 0: {
                    step = -1;
                    break;
                }
                case 1: {
                    step = 1;
                    break;
                }
                case 3: {
                    step = 1;
                    selectedRow = -1;
                    break;
                }
                case 2: {
                    step = -1;
                    selectedRow = tree.getRowCount();
                }
            }
            selectedRow += step;
            while (selectedRow >= 0 && selectedRow < tree.getRowCount()) {
                TreePath path = tree.getPathForRow(selectedRow);
                if (path.getPathCount() >= 3) {
                    tree.setSelectionPath(path);
                    break;
                }
                selectedRow += step;
            }
        }
    }

    private static interface ThreeStateValue {
        public static final int DESELECTED = 0;
        public static final int INDETERMINATE = 1;
        public static final int SELECTED = 2;
    }

    private abstract class LocationTreeNode
    extends DefaultMutableTreeNode
    implements ThreeStateValue {
        protected boolean _backgroundSelected = false;

        private LocationTreeNode() {
        }

        public abstract String getLabel();

        public abstract String getTypeAndName();

        public abstract int getThreeStateValue();

        public abstract void setThreeStateValue(int var1);
    }

    private class Building
    extends LocationTreeNode {
        private static final long serialVersionUID = 1L;
        private String _name;
        private boolean _isExpanded;
        private ArrayList _rooms;

        public Building(String name) {
            this._name = name;
            this._isExpanded = true;
            this._rooms = new ArrayList();
        }

        public String getLabel() {
            return "<html><b>" + this._name + "</b></html>";
        }

        public String getTypeAndName() {
            return "building '" + this._name + "'";
        }

        public int getThreeStateValue() {
            boolean roomShowing = false;
            boolean roomNotShowing = false;
            Iterator roomIterator = this._rooms.iterator();
            while (roomIterator.hasNext()) {
                if (((Room)roomIterator.next()).isShowing()) {
                    roomShowing = true;
                } else {
                    roomNotShowing = true;
                }
                if (!roomShowing || !roomNotShowing) continue;
                return 1;
            }
            if (roomShowing) {
                return 2;
            }
            return 0;
        }

        public void setThreeStateValue(int newThreeStateValue) {
            int oldThreeStateValue = this.getThreeStateValue();
            if (oldThreeStateValue == newThreeStateValue) {
                return;
            }
            Iterator roomIterator = this._rooms.iterator();
            while (roomIterator.hasNext()) {
                Room room = (Room)roomIterator.next();
                room.setThreeStateValue(newThreeStateValue);
            }
        }

        public void addRoom(Room room) {
            this.add(room);
            this._rooms.add(room);
        }

        public boolean isExpanded() {
            return this._isExpanded;
        }

        public void setIsExpanded(boolean isExpanded) {
            this._isExpanded = isExpanded;
        }

        public String toString() {
            return this._name;
        }
    }

    private class Room
    extends LocationTreeNode {
        private static final long serialVersionUID = 1L;
        private SpaceTimeNode _roomNode;
        private String _displayName;
        private boolean _isAvailable;
        private boolean _isShowing;
        private String _buildingName;
        private int _allocationCount;
        private ScheduleInfo _scheduleInfo;

        public Room(SpaceTimeNode roomNode, int orderIndex) {
            this._roomNode = roomNode;
            this._displayName = this._roomNode.getDisplayName();
            this._isShowing = this._isAvailable = this.isInitiallyAvailable();
            SpaceTimeProperty buildingProperty = roomNode.getProperty("building");
            this._buildingName = buildingProperty != null ? buildingProperty.getStringValue() : RoomPicker.UNKNOWN_BUILDING;
            this._allocationCount = 0;
            this._scheduleInfo = new ScheduleInfo(this._roomNode.getDisplayName(), this._buildingName, this._roomNode.getName(), orderIndex, new SpaceTimeDate(this._roomNode.getAdapter().getScenarioStart()), new SpaceTimeDate(this._roomNode.getAdapter().getScenarioStop()));
        }

        public String getLabel() {
            return "<html><b>" + this._displayName + "</b>" + " \u2013 " + this._allocationCount + " " + (this._allocationCount == 1 ? "event" : "events") + "</html>";
        }

        public String getTypeAndName() {
            return "room '" + this._displayName + "'";
        }

        public boolean isShowing() {
            return this._isShowing;
        }

        public void setIsShowing(boolean isShowing) {
            this._isShowing = isShowing;
        }

        public int getThreeStateValue() {
            return this._isShowing ? 2 : 0;
        }

        public void setThreeStateValue(int newThreeStateValue) {
            boolean oldIsShowing = this._isShowing;
            switch (newThreeStateValue) {
                case 0: {
                    this._isShowing = false;
                    break;
                }
                case 2: {
                    this._isShowing = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid 'newThreeStateValue': " + newThreeStateValue);
                }
            }
            if (oldIsShowing == this._isShowing) {
                return;
            }
            if (this._isShowing) {
                RoomPicker.this._schedules.add(this._scheduleInfo);
            } else {
                RoomPicker.this._schedules.remove(this._scheduleInfo);
            }
            RoomNode.setShownInGUI(this._roomNode, this._isShowing);
            RoomPicker.this.notifyScheduleListListeners();
            RoomPicker.this._tree.repaint();
        }

        public boolean markedUsable() {
            return RoomNode.markedUsable(this._roomNode);
        }

        public boolean isInitiallyAvailable() {
            return RoomNode.isShownInGUI(this._roomNode);
        }

        public String toString() {
            return this._displayName;
        }
    }

    private static class LocationTreeNodeCellRenderer
    implements TreeCellRenderer {
        private static final long serialVersionUID = 1L;
        private CellPanel _renderPanel = new CellPanel();

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (!(value instanceof LocationTreeNode)) {
                return new JLabel();
            }
            LocationTreeNode treeNode = (LocationTreeNode)value;
            this._renderPanel.setup(tree, treeNode, selected, expanded, leaf);
            return this._renderPanel;
        }
    }

    private static class LocationTreeNodeCellEditor
    extends AbstractCellEditor
    implements TreeCellEditor,
    ItemListener,
    MouseListener {
        private static final long serialVersionUID = 1L;
        private CellPanel _editorPanel = new CellPanel();
        private JTree _tree;
        private LocationTreeNode _value;

        public LocationTreeNodeCellEditor() {
            this._editorPanel._checkBox.addItemListener(this);
            this._tree = null;
            this._value = null;
        }

        public Object getCellEditorValue() {
            return this._value;
        }

        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
            if (!(value instanceof LocationTreeNode)) {
                this._value = null;
                return new JLabel();
            }
            this._tree = tree;
            this._value = (LocationTreeNode)value;
            this._editorPanel.setup(tree, this._value, true, expanded, leaf);
            this._editorPanel._checkBox.addMouseListener(this);
            return this._editorPanel;
        }

        public void itemStateChanged(ItemEvent evt) {
            boolean show = evt.getStateChange() == 1;
            this._value.setThreeStateValue(show ? 2 : 0);
            Services.logger.info("The user has " + (show ? "shown" : "hidden") + " " + this._value.getTypeAndName() + " in the room picker");
        }

        public boolean isCellEditable(EventObject evt) {
            MouseEvent mevt = (MouseEvent)evt;
            JTree tree = (JTree)mevt.getSource();
            TreePath path = tree.getPathForLocation(mevt.getX(), mevt.getY());
            if (path != null) {
                TreeNode value = (TreeNode)path.getLastPathComponent();
                TreeCellRenderer renderer = tree.getCellRenderer();
                CellPanel panel = (CellPanel)renderer.getTreeCellRendererComponent(tree, value, tree.isPathSelected(path), tree.isExpanded(path), value.isLeaf(), tree.getRowForPath(path), false);
                panel.setSize(Integer.MAX_VALUE, Integer.MAX_VALUE);
                panel.doLayout();
                Rectangle cellBounds = tree.getPathBounds(path);
                Rectangle cboxBounds = panel._checkBox.getBounds();
                Rectangle iconBounds = panel._checkBox._iconRect;
                iconBounds.x += cellBounds.x + cboxBounds.x;
                iconBounds.y += cellBounds.y + cboxBounds.y;
                boolean result = iconBounds.contains(mevt.getX(), mevt.getY());
                return result;
            }
            return false;
        }

        public void mouseClicked(MouseEvent arg0) {
        }

        public void mousePressed(MouseEvent arg0) {
        }

        public void mouseReleased(MouseEvent arg0) {
            this.fireEditingStopped();
            this._editorPanel._checkBox.removeMouseListener(this);
            TreePath path = new TreePath(this._value.getPath());
            this._tree.clearSelection();
            this._tree.setSelectionPath(path);
        }

        public void mouseEntered(MouseEvent arg0) {
        }

        public void mouseExited(MouseEvent arg0) {
        }
    }

    private static class CellPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private static final Color __selectedColor = new Color(55, 104, 197);
        private static final Border __backgroundSelectedBorder = new DashedBorder();
        private static Icon __minusIcon;
        private static Icon __plusIcon;
        private JLabel _icon;
        private ThreeStateCheckBox _checkBox;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.cmu.cs.radar.rhai.spacetime.RoomPicker$LocationTreeNodeCellRenderer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ClassLoader classLoader = clazz.getClassLoader();
            __minusIcon = new ImageIcon(classLoader.getResource("edu/cmu/cs/radar/rhai/media/minus.png"));
            __plusIcon = new ImageIcon(classLoader.getResource("edu/cmu/cs/radar/rhai/media/plus.png"));
        }

        public CellPanel() {
            this.setLayout(new FlowLayout(0, 2, 0));
            this.setBorder(BorderFactory.createEmptyBorder());
            this._icon = new JLabel();
            this._checkBox = new ThreeStateCheckBox();
            this._checkBox.setBorder(BorderFactory.createEmptyBorder());
            this.add(this._checkBox);
        }

        public void setup(JTree tree, LocationTreeNode locationTreeNode, boolean selected, boolean expanded, boolean leaf) {
            this.setBackground(selected ? __selectedColor : tree.getBackground());
            if (leaf) {
                this.remove(this._icon);
            } else {
                this.add((Component)this._icon, 0);
                this._icon.setIcon(expanded ? __minusIcon : __plusIcon);
            }
            this._checkBox.setText(locationTreeNode.getLabel());
            this._checkBox.setBackground(this.getBackground());
            this._checkBox.setForeground(selected ? Color.white : this.getForeground());
            this.setToolTipText(locationTreeNode.getLabel());
            if (locationTreeNode._backgroundSelected) {
                this.setBorder(__backgroundSelectedBorder);
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }
            this._checkBox.setThreeStateValue(locationTreeNode.getThreeStateValue());
            this.invalidate();
        }
    }

    private static class DashedBorder
    implements Border {
        private final Insets INSETS = new Insets(1, 1, 1, 1);
        private static Stroke __dashedStroke = new BasicStroke(1.0f, 1, 0, 1.0f, new float[]{2.0f}, 0.0f);

        private DashedBorder() {
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(Color.darkGray);
            g2.setStroke(__dashedStroke);
            g2.drawRect(x, y, width - 1, height - 1);
        }

        public Insets getBorderInsets(Component c) {
            return this.INSETS;
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }

    private static class ThreeStateCheckBox
    extends JCheckBox {
        private static final long serialVersionUID = 1L;
        private static final Color __boxColor = new Color(33, 161, 33);
        private boolean _indeterminate = false;
        private Dimension _size = new Dimension();
        private Rectangle _viewRect = new Rectangle();
        private Rectangle _iconRect = new Rectangle();
        private Rectangle _textRect = new Rectangle();

        public void setThreeStateValue(int val) {
            switch (val) {
                case 2: {
                    this.setSelected(true);
                    this._indeterminate = false;
                    break;
                }
                case 0: {
                    this.setSelected(false);
                    this._indeterminate = false;
                    break;
                }
                case 1: {
                    this.setSelected(true);
                    this._indeterminate = true;
                }
            }
        }

        public void paint(Graphics g) {
            Insets insets = this.getInsets();
            if (insets == null) {
                return;
            }
            this._size = this.getSize(this._size);
            this._viewRect.x = insets.left;
            this._viewRect.y = insets.top;
            this._viewRect.width = this._size.width - (insets.right + this._viewRect.x);
            this._viewRect.height = this._size.height - (insets.bottom + this._viewRect.y);
            this._iconRect.x = 0;
            this._iconRect.y = 0;
            this._iconRect.width = 0;
            this._iconRect.height = 0;
            this._textRect.x = 0;
            this._textRect.y = 0;
            this._textRect.width = 0;
            this._textRect.height = 0;
            BasicRadioButtonUI btnUI = (BasicRadioButtonUI)this.getUI();
            Icon icon = btnUI.getDefaultIcon();
            SwingUtilities.layoutCompoundLabel(this, g.getFontMetrics(), this.getText(), icon, this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), this._viewRect, this._iconRect, this._textRect, this.getText() == null ? 0 : this.getIconTextGap());
            super.paint(g);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this._indeterminate) {
                BasicRadioButtonUI btnUI = (BasicRadioButtonUI)this.getUI();
                Icon icon = btnUI.getDefaultIcon();
                g.setColor(__boxColor);
                g.fillRect(this._iconRect.x + 3, this._iconRect.y + 3, icon.getIconWidth() - 6, icon.getIconHeight() - 6);
            }
        }
    }
}

