/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeRequestNode;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import javax.swing.JComponent;

public class GenericRequestDragComponent
extends JComponent {
    private static final long serialVersionUID = 0L;
    private DrawListener _drawListener;
    private SpaceTimeRequestNode _requestNode;
    private Object _source;
    private Image _image;

    public GenericRequestDragComponent(SpaceTimeRequestNode requestNode, Object source) {
        this._requestNode = requestNode;
        this._source = source;
    }

    public SpaceTimeRequestNode getRequestNode() {
        return this._requestNode;
    }

    public Object getSource() {
        return this._source;
    }

    public void setDrawListener(DrawListener drawListener) {
        this._drawListener = drawListener;
    }

    public void setImage(Image image) {
        FilteredImageSource filterSource = new FilteredImageSource(image.getSource(), new AlphaFilter());
        this._image = this.createImage(filterSource);
    }

    public boolean isOpaque() {
        return false;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this._drawListener != null) {
            this._drawListener.draw(g, this.getSize());
            return;
        }
        if (this._image != null) {
            g.drawImage(this._image, 0, 0, this);
        }
    }

    public static interface DrawListener {
        public void draw(Graphics var1, Dimension var2);
    }

    private static class AlphaFilter
    extends RGBImageFilter {
        private AlphaFilter() {
        }

        public int filterRGB(int x, int y, int rgb) {
            return 0xC0000000 | rgb & 0xFFFFFF;
        }
    }
}

