/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import edu.cmu.cs.radar.rhai.spacetime.DetailsPanel;
import edu.cmu.cs.radar.rhai.spacetime.SpringUtilities;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeNode;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeProperty;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.NumberFormatter;

public class EditNodePropertiesDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private SpaceTimeNode _node;
    private boolean _localPropertiesOnly;
    private ArrayList _propertyAndTextFieldList;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public EditNodePropertiesDialog(Frame owner, String title, SpaceTimeNode node, boolean localPropertiesOnly) {
        super(owner, title, true);
        this._node = node;
        this._localPropertiesOnly = localPropertiesOnly;
        this._propertyAndTextFieldList = new ArrayList();
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        JPanel propertyEditors = this.buildPropertyEditors();
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(new JButton(new CancelAction()));
        buttonPanel.add(Box.createHorizontalStrut(5));
        JButton saveButton = new JButton(new SaveAction());
        buttonPanel.add(saveButton);
        this.getRootPane().setDefaultButton(saveButton);
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BoxLayout(contentPanel, 3));
        contentPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        contentPanel.add(propertyEditors);
        contentPanel.add(Box.createVerticalStrut(5));
        contentPanel.add(buttonPanel);
        this.setContentPane(contentPanel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                new CancelAction().actionPerformed(null);
            }
        });
    }

    private JPanel buildPropertyEditors() {
        JPanel editors = new JPanel();
        editors.setLayout(new BoxLayout(editors, 3));
        HashMap categories = DetailsPanel.collectCategories(this._node);
        Set localPropertyTypes = this._node.getLocalPropertyTypes();
        ArrayList categoryLabels = new ArrayList(categories.keySet());
        Collections.sort(categoryLabels);
        int i = 0;
        while (i < categoryLabels.size()) {
            String categoryLabel = (String)categoryLabels.get(i);
            ArrayList propertyGroup = (ArrayList)categories.get(categoryLabel);
            propertyGroup = this.filterPropertyList(propertyGroup, localPropertyTypes);
            if ((propertyGroup = this.sortCategory(categoryLabel, propertyGroup)).size() > 0) {
                JPanel group = new JPanel(new SpringLayout());
                group.setBorder(BorderFactory.createTitledBorder(categoryLabel));
                Iterator propertyIterator = propertyGroup.iterator();
                while (propertyIterator.hasNext()) {
                    SpaceTimeProperty property = (SpaceTimeProperty)propertyIterator.next();
                    Object value = null;
                    DefaultFormatter formatter = null;
                    int horizontalAlignment = 10;
                    switch (property.getDataType()) {
                        case 0: {
                            value = new Integer(property.getIntValue());
                            NumberFormatter nonNegativeIntegerFormatter = new NumberFormatter();
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("java.lang.Integer");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            nonNegativeIntegerFormatter.setValueClass(clazz);
                            nonNegativeIntegerFormatter.setMinimum(new Integer(0));
                            nonNegativeIntegerFormatter.setMaximum(new Integer(Integer.MAX_VALUE));
                            formatter = nonNegativeIntegerFormatter;
                            horizontalAlignment = 11;
                            break;
                        }
                        case 2: {
                            value = property.getStringValue();
                            formatter = new DefaultFormatter();
                            break;
                        }
                        case 6: {
                            value = new Double(property.getMoneyValue());
                            NumberFormatter nonNegativeCurrencyFormatter = new NumberFormatter(NumberFormat.getCurrencyInstance());
                            Class<?> clazz = class$1;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("java.lang.Double");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            nonNegativeCurrencyFormatter.setValueClass(clazz);
                            nonNegativeCurrencyFormatter.setMinimum(new Double(0.0));
                            nonNegativeCurrencyFormatter.setMaximum(new Double(1.6777215E7));
                            formatter = nonNegativeCurrencyFormatter;
                            horizontalAlignment = 11;
                        }
                    }
                    if (value == null) continue;
                    formatter.setAllowsInvalid(false);
                    formatter.setOverwriteMode(false);
                    JLabel label = new JLabel(String.valueOf(property.getDisplayLabel()) + ":", 11);
                    JFormattedTextField textField = new JFormattedTextField(formatter);
                    textField.setValue(value);
                    textField.setColumns(10);
                    textField.setHorizontalAlignment(horizontalAlignment);
                    textField.setEditable(property.isEditable());
                    label.setLabelFor(textField);
                    group.add(label);
                    group.add(textField);
                    this._propertyAndTextFieldList.add(new Object[]{property, textField});
                }
                SpringUtilities.makeCompactGrid(group, propertyGroup.size(), 2, 5, 5, 5, 5);
                editors.add(group);
            }
            ++i;
        }
        return editors;
    }

    private ArrayList filterPropertyList(ArrayList propertyGroup, Set localPropertyTypes) {
        ArrayList<SpaceTimeProperty> filteredPropertyList = new ArrayList<SpaceTimeProperty>();
        Iterator propertyGroupIterator = propertyGroup.iterator();
        while (propertyGroupIterator.hasNext()) {
            int dataType;
            SpaceTimeProperty property = (SpaceTimeProperty)propertyGroupIterator.next();
            if (this._localPropertiesOnly && !localPropertyTypes.contains(property.getPropertyType()) || (dataType = property.getDataType()) != 0 && dataType != 2 && dataType != 6) continue;
            filteredPropertyList.add(property);
        }
        return filteredPropertyList;
    }

    protected ArrayList sortCategory(String categoryLabel, ArrayList properties) {
        Collections.sort(properties, SpaceTimeProperty.sLabelAndDisplayStringComparator);
        return properties;
    }

    private class SaveAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public SaveAction() {
            super("Save");
            this.putValue("MnemonicKey", new Integer(83));
        }

        public void actionPerformed(ActionEvent e) {
            Iterator editingPropertiesIterator = EditNodePropertiesDialog.this._propertyAndTextFieldList.iterator();
            while (editingPropertiesIterator.hasNext()) {
                Object[] objs = (Object[])editingPropertiesIterator.next();
                SpaceTimeProperty property = (SpaceTimeProperty)objs[0];
                if (!property.isEditable()) continue;
                JFormattedTextField textField = (JFormattedTextField)objs[1];
                switch (property.getDataType()) {
                    case 0: {
                        property.setIntValue((Integer)textField.getValue());
                        break;
                    }
                    case 2: {
                        property.setStringValue((String)textField.getValue());
                        break;
                    }
                    case 6: {
                        property.setMoneyValue((Double)textField.getValue());
                    }
                }
            }
            EditNodePropertiesDialog.this.hide();
        }
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CancelAction() {
            super("Cancel");
            this.putValue("MnemonicKey", new Integer(67));
        }

        public void actionPerformed(ActionEvent e) {
            EditNodePropertiesDialog.this.hide();
        }
    }
}

