/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.calendar;

import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;

public class Time
implements Comparable {
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int HOURS_PER_DAY = 24;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_DAY = 86400;
    public static final Time START_OF_DAY = new Time(0, 0, 0);
    public static final Time END_OF_DAY = new Time(24, 0, 0);
    private int mSeconds;
    private static final DecimalFormat sTwoPaddedZerosFormatter = new DecimalFormat("00");

    public Time() {
        this.mSeconds = 0;
    }

    private Time(int seconds) {
        if (seconds < 0 || 86400 < seconds) {
            throw new IllegalArgumentException("'seconds' (" + seconds + ") out of bounds: 0 - " + 86400);
        }
        this.mSeconds = seconds;
    }

    public Time(int hour, int minute, int second) {
        this.init(hour, minute, second);
    }

    public Time(String strTime) {
        try {
            String[] parts = strTime.split(":");
            int hour = Integer.parseInt(parts[0]);
            int minute = parts.length >= 2 ? Integer.parseInt(parts[1]) : 0;
            int second = parts.length >= 3 ? Integer.parseInt(parts[2]) : 0;
            this.init(hour, minute, second);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("'strTime' has invalid number: " + nfe.getMessage());
        }
    }

    public Time(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        this.init(cal.get(11), cal.get(12), cal.get(13));
    }

    private void init(int hour, int minute, int second) {
        if (hour < 0) {
            throw new IllegalArgumentException("'hour' < 0");
        }
        if (hour > 24) {
            throw new IllegalArgumentException("'hour' > 24");
        }
        if (minute < 0) {
            throw new IllegalArgumentException("'minute' < 0");
        }
        if (minute > 60) {
            throw new IllegalArgumentException("'minute' > 60");
        }
        if (second < 0) {
            throw new IllegalArgumentException("'second' < 0");
        }
        if (second > 60) {
            throw new IllegalArgumentException("'second' > 60");
        }
        this.mSeconds = 3600 * hour + 60 * minute + second;
    }

    public int getSecond() {
        return this.mSeconds % 60;
    }

    public int getMinute() {
        return this.mSeconds / 60 % 60;
    }

    public int getHour() {
        return this.mSeconds / 3600;
    }

    public boolean equals(Object o) {
        return this.equals((Time)o);
    }

    public boolean equals(Time otherTime) {
        return this.mSeconds == otherTime.mSeconds;
    }

    public int compareTo(Object o) {
        return this.compareTo((Time)o);
    }

    public int compareTo(Time otherTime) {
        return this.mSeconds - otherTime.mSeconds;
    }

    public boolean before(Time otherTime) {
        return this.compareTo(otherTime) < 0;
    }

    public boolean beforeOrEqual(Time otherTime) {
        return this.compareTo(otherTime) <= 0;
    }

    public boolean after(Time otherTime) {
        return this.compareTo(otherTime) > 0;
    }

    public boolean afterOrEqual(Time otherTime) {
        return this.compareTo(otherTime) >= 0;
    }

    public Time roundToSeconds(int seconds) {
        int roundedSeconds = this.mSeconds + seconds / 2;
        roundedSeconds /= seconds;
        return new Time(roundedSeconds *= seconds);
    }

    public Time roundToMinutes(int minutes) {
        return this.roundToSeconds(60 * minutes);
    }

    public Time roundToHours(int hours) {
        return this.roundToSeconds(3600 * hours);
    }

    public Time roundDownToHour() {
        if (this.isHour()) {
            return new Time(this.mSeconds);
        }
        int secondsInHour = this.mSeconds % 3600;
        return new Time(this.mSeconds - secondsInHour);
    }

    public Time roundUpToHour() {
        if (this.isHour()) {
            return new Time(this.mSeconds);
        }
        int secondsInHour = this.mSeconds % 3600;
        return new Time(this.mSeconds + 3600 - secondsInHour);
    }

    public boolean isHour() {
        return this.mSeconds % 3600 == 0;
    }

    public Time addMinutes(int count) {
        return new Time(this.mSeconds + 60 * count);
    }

    public Time addHours(int count) {
        return new Time(this.mSeconds + 3600 * count);
    }

    public Time shiftBy(Duration amount) {
        return new Time(this.mSeconds + amount.mSeconds);
    }

    public static double interpolate(Time start, Time end, Time value) {
        double duration = end.mSeconds - start.mSeconds;
        if (duration <= 0.0) {
            throw new IllegalArgumentException("'end' <= 'start'");
        }
        double offset = value.mSeconds - start.mSeconds;
        return offset / duration;
    }

    public static Time interpolate(Time start, Time end, double ratio) {
        try {
            return new Time((int)((double)(end.mSeconds - start.mSeconds) * ratio + (double)start.mSeconds));
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    public String toString() {
        return String.valueOf(sTwoPaddedZerosFormatter.format(this.getHour())) + ":" + sTwoPaddedZerosFormatter.format(this.getMinute()) + ":" + sTwoPaddedZerosFormatter.format(this.getSecond());
    }

    public String toStringHourMinute() {
        int hour = (this.getHour() - 1) % 12 + 1;
        return String.valueOf(hour) + ":" + sTwoPaddedZerosFormatter.format(this.getMinute());
    }

    public static class Range {
        private Time mStart;
        private Time mEnd;

        public Range(Range range) {
            if (range == null) {
                throw new NullPointerException("argument 'range'");
            }
            this.mStart = range.getStart();
            this.mEnd = range.getEnd();
        }

        public Range(Time start, Time end) {
            if (start == null) {
                throw new NullPointerException("argument 'start'");
            }
            if (end == null) {
                throw new NullPointerException("argument 'end'");
            }
            if (start.after(end)) {
                throw new IllegalArgumentException("'end' (" + end.toString() + ") < 'start' (" + start.toString() + ")");
            }
            this.mStart = start;
            this.mEnd = end;
        }

        public Time getStart() {
            return this.mStart;
        }

        public Time getEnd() {
            return this.mEnd;
        }

        public boolean overlaps(Range otherRange) {
            return !(!this.mStart.before(otherRange.mEnd) && !this.mStart.equals(otherRange.mEnd) || !this.mEnd.after(otherRange.mStart) && !this.mEnd.equals(otherRange.mStart));
        }

        public static Range create(String strRange) {
            String[] parts = strRange.split("--");
            Time start = new Time(parts[0].trim());
            Time end = new Time(parts[1].trim());
            return new Range(start, end);
        }

        public boolean contains(Range otherRange) {
            return !(!this.mStart.before(otherRange.mStart) && !this.mStart.equals(otherRange.mStart) || !this.mEnd.after(otherRange.mEnd) && !this.mEnd.equals(otherRange.mEnd));
        }

        public Duration getDuration() {
            return new Duration(this);
        }

        public double ratio(Duration duration) {
            return duration.getSeconds() / this.getDuration().getSeconds();
        }

        public Split split(Time timeToSplit) {
            if (timeToSplit.before(this.mStart) || timeToSplit.after(this.mEnd)) {
                throw new IllegalArgumentException("'timeToSplit' (" + timeToSplit + ") is outside of range (" + this + ")");
            }
            Range before = !this.mStart.equals(timeToSplit) ? new Range(this.mStart, timeToSplit) : null;
            Range after = !this.mEnd.equals(timeToSplit) ? new Range(timeToSplit, this.mEnd) : null;
            return new Split(before, after);
        }

        public String toString() {
            return String.valueOf(this.mStart.toString()) + "-" + this.mEnd.toString();
        }

        public static class Split {
            private Range mBefore;
            private Range mAfter;

            public Range getBefore() {
                return this.mBefore;
            }

            public Range getAfter() {
                return this.mAfter;
            }

            public Split(Range before, Range after) {
                this.mBefore = before;
                this.mAfter = after;
            }
        }
    }

    public static class Duration
    implements Comparable {
        private int mSeconds;

        public double getSeconds() {
            return this.mSeconds;
        }

        public double getMinutes() {
            return (double)this.mSeconds / 60.0;
        }

        public Duration(Time start, Time end) {
            if (start == null) {
                throw new NullPointerException("argument 'start'");
            }
            if (end == null) {
                throw new NullPointerException("argument 'end'");
            }
            this.mSeconds = end.mSeconds - start.mSeconds;
        }

        public Duration(Range range) {
            if (range == null) {
                throw new NullPointerException("argument 'range'");
            }
            this.mSeconds = range.getEnd().mSeconds - range.getStart().mSeconds;
        }

        protected Duration(int seconds) {
            this.mSeconds = seconds;
        }

        public static Duration createForMinutes(int minutes) {
            return new Duration(minutes * 60);
        }

        public static Duration createForMinutes(double minutes) {
            return new Duration((int)Math.rint(minutes * 60.0));
        }

        public int compareTo(Object o) {
            return this.compareTo((Duration)o);
        }

        public int compareTo(Duration otherDuration) {
            return this.mSeconds - otherDuration.mSeconds;
        }
    }
}

