/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.stp.cachingdatamodel;

import Ch.Elca.Iiop.GenericUserException;
import SpaceTime.DataModel.Change;
import SpaceTime.DataModel.DMArrayList;
import SpaceTime.DataModel.NodeChangeSummary;
import edu.cmu.cs.radar.rhai.spacetime.Services;
import edu.cmu.cs.radar.stp.cachingdatamodel.NodeChangeListener;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeDataAdapter;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeEdge;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SpaceTimeNode {
    private static final int NOVALUE = -100;
    private SpaceTime.DataModel.SpaceTimeNode _node;
    private SpaceTimeDataAdapter _dataAdapter;
    private Map<String, SpaceTimeProperty> _propertyCache;
    private Set<String> _propertyNames;
    private Set<String> _unassociatedPropertyNames;
    private Map<String, SpaceTimeEdge> _edgeCache;
    private String _name;
    private String _displayName;
    private int _edgeCount;
    private boolean _edgeCacheComplete;
    private double _score;

    public SpaceTimeNode(SpaceTime.DataModel.SpaceTimeNode node, SpaceTimeDataAdapter dataAdapter) {
        this._node = node;
        this._dataAdapter = dataAdapter;
        this._propertyCache = new HashMap<String, SpaceTimeProperty>();
        this._propertyNames = new HashSet<String>();
        this._unassociatedPropertyNames = new HashSet<String>();
        this._edgeCache = new HashMap<String, SpaceTimeEdge>();
        this._edgeCount = -100;
        this._edgeCacheComplete = false;
        this._score = -100.0;
    }

    public SpaceTime.DataModel.SpaceTimeNode getHostedNode() {
        return this._node;
    }

    public void flushCache() {
        Services.logger.trace("flushing node cache: no change summary: " + this.getDisplayName());
        this._propertyCache.clear();
        this._propertyNames.clear();
        this._unassociatedPropertyNames.clear();
        this._edgeCache.clear();
        this._edgeCount = -100;
        this._edgeCacheComplete = false;
        this._displayName = null;
    }

    public void flushCache(NodeChangeSummary changes) {
        Change change;
        int n;
        int n2;
        Change[] changeArray;
        Services.logger.trace("flushing node cache: with change summary: " + this.getDisplayName());
        if (changes._propertiesChanged != null) {
            Services.logger.trace("  properties changed");
            changeArray = changes._propertiesChanged;
            n2 = changes._propertiesChanged.length;
            n = 0;
            while (n < n2) {
                change = changeArray[n];
                Services.logger.trace("    flushing property: " + change._sourceId + " [" + this.changeTypeToString(change._changeType) + "]");
                this._propertyCache.remove(change._sourceId);
                if (change._changeType == 0 || change._changeType == 1) {
                    if (this._propertyNames.contains(change._sourceId)) {
                        this._propertyNames.clear();
                    }
                    if (this._unassociatedPropertyNames.contains(change._sourceId)) {
                        this._unassociatedPropertyNames.clear();
                    }
                }
                ++n;
            }
        }
        if (changes._edgesChanged != null) {
            Services.logger.trace("  edges changed");
            changeArray = changes._edgesChanged;
            n2 = changes._edgesChanged.length;
            n = 0;
            while (n < n2) {
                change = changeArray[n];
                Services.logger.trace("    flushing edge: " + change._sourceId + " [" + this.changeTypeToString(change._changeType) + "]");
                this.flushEdge(change._sourceId);
                ++n;
            }
        }
    }

    private String changeTypeToString(int changeType) {
        switch (changeType) {
            case 0: {
                return "added";
            }
            case 1: {
                return "removed";
            }
            case 2: {
                return "modified";
            }
        }
        return "unknown";
    }

    private void flushEdge(String edgeType) {
        this._edgeCache.remove(edgeType);
    }

    public SpaceTimeDataAdapter getAdapter() {
        return this._dataAdapter;
    }

    public void addChangeListener(NodeChangeListener listener) {
        this._dataAdapter.addNodeChangeListener(listener, this.getName());
    }

    public void removeChangeListener(NodeChangeListener listener) {
        this._dataAdapter.removeNodeChangeListener(listener);
    }

    public String getName() {
        if (this._name == null) {
            this._name = this._node.Name();
        }
        return this._name;
    }

    public double getScore() {
        if (this._score != -100.0) {
            return this._score;
        }
        this._score = this._node.Score();
        return this._score;
    }

    public void setScore(double newScore) {
        this._score = newScore;
        this._node.Score(newScore);
        if (newScore == -101.0) {
            this.getAdapter().notifyGlobalScorePending();
        }
    }

    public void updateCachedScore(double score) {
        this._score = score;
    }

    public String getDisplayName() {
        if (this._displayName == null) {
            try {
                this._displayName = this._node.GetDisplayName();
            }
            catch (GenericUserException genericUserException) {
                // empty catch block
            }
        }
        return this._displayName;
    }

    public int getEdgeCount() {
        if (this._edgeCount == -100) {
            try {
                this._edgeCount = this._node.GetEdgeCount();
            }
            catch (GenericUserException genericUserException) {
                // empty catch block
            }
        }
        return this._edgeCount;
    }

    public SpaceTimeEdge getEdge(String edgeType) {
        SpaceTimeEdge cachedEdge = this._edgeCache.get(edgeType);
        if (cachedEdge == null && this._edgeCache.containsKey(edgeType)) {
            return null;
        }
        if (cachedEdge == null) {
            try {
                SpaceTime.DataModel.SpaceTimeEdge edge = this._node.GetEdge(edgeType);
                if (edge != null) {
                    cachedEdge = new SpaceTimeEdge(edge);
                }
                this._edgeCache.put(edgeType, cachedEdge);
            }
            catch (GenericUserException genericUserException) {
                // empty catch block
            }
        }
        return cachedEdge;
    }

    private void cacheAllEdges() {
        if (this._edgeCacheComplete) {
            return;
        }
        try {
            int edgeIndex = 0;
            while (edgeIndex < this.getEdgeCount()) {
                SpaceTime.DataModel.SpaceTimeEdge edge = this._node.GetEdgeAt(edgeIndex);
                String edgeType = edge.Type();
                if (!this._edgeCache.containsKey(edgeType)) {
                    this._edgeCache.put(edgeType, new SpaceTimeEdge(edge));
                }
                ++edgeIndex;
            }
            this._edgeCacheComplete = true;
        }
        catch (GenericUserException genericUserException) {
            // empty catch block
        }
    }

    public List<SpaceTimeEdge> getEdges() {
        this.cacheAllEdges();
        ArrayList<SpaceTimeEdge> edges = new ArrayList<SpaceTimeEdge>();
        for (SpaceTimeEdge edge : this._edgeCache.values()) {
            if (edge == null) continue;
            edges.add(edge);
        }
        return edges;
    }

    private SpaceTimeProperty getPropertyFromCache(String name) {
        return this._propertyCache.get(name);
    }

    public SpaceTimeProperty getProperty(String name) {
        SpaceTimeProperty cachedProperty = this.getPropertyFromCache(name);
        if (cachedProperty == null) {
            if (this._propertyCache.containsKey(name)) {
                return null;
            }
            try {
                SpaceTime.DataModel.SpaceTimeProperty property = this._node.GetProperty(name);
                if (property != null) {
                    cachedProperty = new SpaceTimeProperty(property, this);
                }
                this._propertyCache.put(name, cachedProperty);
            }
            catch (GenericUserException genericUserException) {
                // empty catch block
            }
        }
        return cachedProperty;
    }

    public List<String> getPropertyNames() {
        if (this._propertyNames.size() == 0) {
            try {
                DMArrayList dmList = this._node.GetPropertyNames();
                int i = 0;
                while (i < dmList.Count()) {
                    this._propertyNames.add(dmList.GetAt(i).extract_Value().toString());
                    ++i;
                }
            }
            catch (GenericUserException genericUserException) {
                // empty catch block
            }
        }
        return new ArrayList<String>(this._propertyNames);
    }

    public List<String> getUnassociatedPropertyNames() {
        if (this._unassociatedPropertyNames.size() == 0) {
            try {
                DMArrayList dmList = this._node.GetUnassociatedPropertyNames();
                int i = 0;
                while (i < dmList.Count()) {
                    this._unassociatedPropertyNames.add(dmList.GetAt(i).extract_Value().toString());
                    ++i;
                }
            }
            catch (GenericUserException genericUserException) {
                // empty catch block
            }
        }
        return new ArrayList<String>(this._unassociatedPropertyNames);
    }

    public void addProperty(SpaceTimeProperty property) {
        try {
            property.setOwnerNode(this);
            this._node.AddProperty(property.getHostedProperty());
        }
        catch (GenericUserException genericUserException) {
            // empty catch block
        }
    }

    public void addEdge(SpaceTimeEdge edge) {
        try {
            this._edgeCount = -100;
            this._edgeCacheComplete = false;
            this._node.AddEdge(edge.getHostedEdge());
        }
        catch (GenericUserException genericUserException) {
            // empty catch block
        }
    }

    public void removeEdge(String edgeType) {
        try {
            this._edgeCount = -100;
            this._edgeCacheComplete = false;
            this._node.RemoveEdge(edgeType);
            this.flushEdge(edgeType);
        }
        catch (GenericUserException genericUserException) {
            // empty catch block
        }
    }

    public Set<String> getLocalPropertyTypes() {
        HashSet<String> localPropertyTypes = new HashSet<String>();
        try {
            int localPropertyCount = this._node.GetLocalPropertyCount();
            int localPropertyIndex = 0;
            while (localPropertyIndex < localPropertyCount) {
                SpaceTime.DataModel.SpaceTimeProperty property = this._node.GetLocalProperty(localPropertyIndex);
                localPropertyTypes.add(property.PropertyType());
                ++localPropertyIndex;
            }
        }
        catch (GenericUserException e) {
            e.printStackTrace();
        }
        return localPropertyTypes;
    }

    public String toString() {
        return this._displayName;
    }
}

