/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import edu.cmu.cs.radar.stp.cachingdatamodel.LinearFunctionData;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeNode;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeProperty;

public class RoomNode {
    protected static final String SHOWN_IN_GUI = "shownInGui";

    public static boolean markedUsable(SpaceTimeNode roomNode) {
        SpaceTimeProperty markedUseable = roomNode.getProperty("markedUsable");
        return markedUseable == null || !"False".equalsIgnoreCase(markedUseable.getStringValue());
    }

    public static boolean isAvailable(SpaceTimeNode roomNode) {
        if (!RoomNode.markedUsable(roomNode)) {
            return false;
        }
        SpaceTimeProperty availability = roomNode.getProperty("resourceLimit");
        if (availability == null) {
            return false;
        }
        LinearFunctionData functionData = availability.getFunctionData();
        if (functionData == null) {
            return false;
        }
        int i = 0;
        while (i < functionData.size()) {
            if (functionData.getY(i) > 0.0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isShownInGUI(SpaceTimeNode roomNode) {
        SpaceTimeProperty isShownInGUI = roomNode.getProperty(SHOWN_IN_GUI);
        if (isShownInGUI != null) {
            String value = isShownInGUI.getStringValue();
            if (value.equalsIgnoreCase("true")) {
                return true;
            }
            if (value.equalsIgnoreCase("false")) {
                return false;
            }
            if (value.equalsIgnoreCase("default")) {
                return RoomNode.isAvailable(roomNode);
            }
        }
        return true;
    }

    public static void setShownInGUI(SpaceTimeNode roomNode, boolean show) {
        SpaceTimeProperty isShownInGUI = roomNode.getProperty(SHOWN_IN_GUI);
        if (isShownInGUI == null) {
            isShownInGUI = roomNode.getAdapter().createProperty(SHOWN_IN_GUI);
            roomNode.addProperty(isShownInGUI);
        }
        isShownInGUI.setStringValue(Boolean.toString(show));
    }
}

