/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import SpaceTime.DataModel.Change;
import SpaceTime.DataModel.NodeChangeSummary;
import edu.cmu.cs.radar.rhai.spacetime.DetailsPanel;
import edu.cmu.cs.radar.rhai.spacetime.EditEventAction;
import edu.cmu.cs.radar.rhai.spacetime.SelectionManager;
import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeRequestNode;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeDataAdapter;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeNode;
import javax.swing.tree.DefaultMutableTreeNode;

public class RequestDetailsPanel
extends DetailsPanel {
    private static final long serialVersionUID = 1L;
    private static final String CATEGORY_ASSIGNMENT = "Assignment";
    private SpaceTimeRequestNode _requestNode;
    private DefaultMutableTreeNode _assignmentTreeNode = new DefaultMutableTreeNode("Assignment");

    public RequestDetailsPanel(SpaceTimeDataAdapter dataAdapter, SelectionManager selectionManager) {
        super(dataAdapter, selectionManager, new EditEventAction());
    }

    @Override
    protected void augmentDetailsTree(DefaultMutableTreeNode rootTreeNode) {
        this.updateAssignmentTreeNode();
        rootTreeNode.insert(this._assignmentTreeNode, 0);
    }

    @Override
    public void setNode(SpaceTimeNode node) {
        if (this._requestNode != null) {
            this._requestNode.dispose();
        }
        this._requestNode = node != null ? new SpaceTimeRequestNode(node) : null;
        super.setNode(node);
    }

    @Override
    public void setSelection(Object sender, Object selection, int type, boolean selected, boolean doubleClick) {
        if (type == 1 && selected) {
            String nodeName;
            String string = nodeName = this._node != null ? this._node.getName() : "";
            if (!nodeName.equals(selection)) {
                SpaceTimeNode requestNode = this._dataAdapter.getNodeById(selection.toString());
                this.setNode(requestNode);
            }
        }
    }

    private void updateAssignmentTreeNode() {
        this._assignmentTreeNode.removeAllChildren();
        if (this._requestNode != null && this._requestNode.isAssigned() && !this._requestNode.isRejected()) {
            this._assignmentTreeNode.add(new DefaultMutableTreeNode("Room: " + this._requestNode.getRoomDisplayName()));
            this._assignmentTreeNode.add(new DefaultMutableTreeNode("Building: " + this._requestNode.getBuildingDisplayName()));
            this._assignmentTreeNode.add(new DefaultMutableTreeNode("Time: " + this._requestNode.getStart().toString("h:mm a") + "\u2013" + this._requestNode.getStop().toString("h:mm a")));
            this._assignmentTreeNode.add(new DefaultMutableTreeNode("Day: " + this._requestNode.getStart().toString("EEEE, MMMM d, yyyy")));
        } else {
            this._assignmentTreeNode.add(new DefaultMutableTreeNode("Unscheduled"));
        }
    }

    @Override
    public void nodeChanged(String nodeName, NodeChangeSummary changes) {
        super.nodeChanged(nodeName, changes);
        if (this._node == null || !this._node.getName().equals(nodeName)) {
            return;
        }
        if (changes != null && changes._edgesChanged != null) {
            Change[] changeArray = changes._edgesChanged;
            int n = changes._edgesChanged.length;
            int n2 = 0;
            while (n2 < n) {
                Change change = changeArray[n2];
                if (change._sourceId.equals("assignTo") || change._sourceId.equals("fixTo")) {
                    this.updateAssignmentTreeNode();
                    this._treeModel.nodeStructureChanged(this._assignmentTreeNode);
                }
                ++n2;
            }
        }
    }
}

