/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import edu.cmu.cs.radar.rhai.spacetime.SwingHelper;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class ItemDistanceChart
extends JComponent {
    private static final long serialVersionUID = 0L;
    private static final int BORDER = 10;
    private String _sourceName;
    private List<Item> _items = new ArrayList<Item>();
    private float _maxDistance = 0.0f;

    public ItemDistanceChart(String sourceName) {
        this._sourceName = sourceName;
    }

    public void addItem(String name, float distance, String distanceString) {
        this._items.add(new Item(name, distance, distanceString));
        if (distance > this._maxDistance) {
            this._maxDistance = distance;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = SwingHelper.prepareGraphics(g);
        int width = this.getWidth();
        int height = this.getHeight();
        g2.clearRect(0, 0, width, height);
        g2.setColor(Color.darkGray);
        g2.drawLine(10, 10, 10, height - 10);
        Graphics2D subGraphics = (Graphics2D)g2.create();
        this.drawItem(subGraphics, this._sourceName, 0.0f, null);
        subGraphics.dispose();
        for (Item item : this._items) {
            subGraphics = (Graphics2D)g2.create();
            this.drawItem(subGraphics, item.name, item.distance, item.distanceString);
            subGraphics.dispose();
        }
    }

    private void drawItem(Graphics2D g2, String label, float distance, String distanceString) {
        int height = this.getHeight();
        int adjustedDistance = (int)(distance * (float)(height - 20) / this._maxDistance);
        g2.translate(10, 10 + adjustedDistance);
        g2.setColor(new Color(200, 200, 255, 200));
        g2.fillOval(-4, -4, 8, 8);
        g2.setColor(Color.gray);
        g2.drawOval(-4, -4, 8, 8);
        g2.setFont(this.getFont().deriveFont(0, 10.0f));
        g2.setColor(Color.black);
        if (distance > 0.0f) {
            String distanceLabel = distanceString == null ? Float.toString(distance) : distanceString;
            g2.drawString("(" + distanceLabel + ") " + label, 6, 4);
        } else {
            g2.drawString(label, 6, 4);
        }
    }

    private static class Item {
        public String name;
        public float distance;
        public String distanceString;

        public Item(String name, float distance) {
            this.name = name;
            this.distance = distance;
        }

        public Item(String name, float distance, String distanceString) {
            this.name = name;
            this.distance = distance;
            this.distanceString = distanceString;
        }
    }
}

