/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.neg;

import cmradar.manager.neg.NegotiationLog;
import cmradar.manager.neg.RoomNegotiationLogEntry;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Iterator;

public class SimpleBayesLearner {
    NegotiationLog log;
    HashMap yesCount;
    HashMap noCount;

    public SimpleBayesLearner(NegotiationLog negotiationLog) {
        this.log = negotiationLog;
        this.yesCount = new HashMap();
        this.noCount = new HashMap();
    }

    public SimpleBayesLearner(NegotiationLog negotiationLog, HashMap hashMap, HashMap hashMap2) {
        this.log = negotiationLog;
        this.yesCount = hashMap;
        this.noCount = hashMap2;
    }

    protected void learn() {
        HashMap hashMap = this.log.getEntryList();
        Iterator iterator = hashMap.keySet().iterator();
        String string = (String)iterator.next();
        while (string != null) {
            int n;
            RoomNegotiationLogEntry roomNegotiationLogEntry = (RoomNegotiationLogEntry)hashMap.get(string);
            if (!this.yesCount.containsKey(roomNegotiationLogEntry.getOwnerId())) {
                this.yesCount.put(roomNegotiationLogEntry.getOwnerId(), new Integer(0));
                this.noCount.put(roomNegotiationLogEntry.getOwnerId(), new Integer(0));
            }
            if (roomNegotiationLogEntry.getResponse()) {
                n = (Integer)this.yesCount.get(roomNegotiationLogEntry.getOwnerId());
                this.yesCount.put(roomNegotiationLogEntry.getOwnerId(), new Integer(n + 1));
            } else {
                n = (Integer)this.noCount.get(roomNegotiationLogEntry.getOwnerId());
                this.noCount.put(roomNegotiationLogEntry.getOwnerId(), new Integer(n + 1));
            }
            string = (String)iterator.next();
        }
    }

    public HashMap doLearning() {
        this.learn();
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        Iterator iterator = this.yesCount.keySet().iterator();
        String string = (String)iterator.next();
        while (string != null) {
            int n = (Integer)this.yesCount.get(string);
            int n2 = (Integer)this.noCount.get(string);
            double d = ((double)n + 0.5) / ((double)n + (double)n2 + 1.0);
            hashMap.put(string, new Double(d));
            string = (String)iterator.next();
        }
        return hashMap;
    }

    public String toString() {
        HashMap hashMap = this.doLearning();
        String string = "";
        Iterator iterator = hashMap.keySet().iterator();
        String string2 = (String)iterator.next();
        while (string2 != null) {
            string = string + string2 + "\t" + hashMap.get(string2) + "\n";
            string2 = (String)iterator.next();
        }
        return string;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("Usage: log-filename");
        }
        try {
            NegotiationLog negotiationLog = new NegotiationLog(new BufferedReader(new FileReader(stringArray[0])));
            SimpleBayesLearner simpleBayesLearner = new SimpleBayesLearner(negotiationLog);
            System.out.println(simpleBayesLearner.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

