/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.neg;

import cmradar.manager.data.Calendar;
import cmradar.manager.data.Meeting;
import cmradar.manager.data.Template;
import cmradar.manager.data.TimeSlot;
import cmradar.manager.neg.AbstractNegotiator;
import cmradar.manager.neg.MutableNegotiationLog;
import cmradar.manager.sched.Scheduler;
import cmradar.manager.sim.MessageCommunicator;
import cmradar.manager.sim.Utility;
import cmradar.manager.sys.RManagerIO;
import cmradar.manager.sys.RManagerIOSystem;
import java.util.HashMap;
import java.util.Random;
import java.util.Vector;
import javax.swing.JOptionPane;

public class InteractiveNegotiator
extends AbstractNegotiator {
    public int opt_bumpMode = ALWAYS;
    public static int NEVER = 0;
    public static int ALWAYS = 1;
    public static int MIXED = 2;
    public static int NUM_ATTENDEES = 3;
    public static int MTG_ID = 4;
    public static int PREDEFINED_KIND = 5;
    public static int WEIGHTED_NUM_ATTENDEES = 6;
    public static int PROBABILITY_RULE = 7;
    public static int LASTRESORT = 10;
    public int opt_bumpRound = -1;
    public int opt_pslots = 1;
    public int opt_bumpTaboo = 0;
    Random RAND = new Random(666L);
    public HashMap rejectedSlots = new HashMap();
    public HashMap acceptedSlots = new HashMap();

    private void TRACE(String string) {
    }

    public InteractiveNegotiator(RManagerIO rManagerIO, String string, String string2, Scheduler scheduler, MessageCommunicator messageCommunicator) {
        super(rManagerIO, string, string2, scheduler, messageCommunicator);
        this.negLogger = new MutableNegotiationLog();
    }

    public void receive_message(Template template, String string) {
        System.out.println("receive_message: " + string);
        String string2 = template.getInitiator();
        if (string2.equals(this.myUserId)) {
            this.handleMessage_initiator(template, string);
        } else {
            this.handleMessage_attendee(template);
        }
        this.calendar.updated();
    }

    public void handleMessage_initiator(Template template, String string) {
        System.out.println("handling message from " + string);
        String string2 = template.getMeetingId();
        Meeting meeting = this.calendar.getMeeting(string2);
        if (meeting == null) {
            System.out.println("new meeting");
            this.newState_initiator(template);
        } else if (meeting.isPending()) {
            System.out.println("old meeting");
            this.pendingState_initiator(template, string);
        } else if (meeting.isConfirmed() || meeting.isBumped()) {
            System.out.println("isConfirmed or isBumped");
            this.confirmedState_initiator(template, string);
        } else {
            System.out.println(this.myUserId + " Initiator: Meeting " + string2 + " is not in new, pending, confirmed or bumped state! ");
            System.out.println(this.myUserId + " Probably failed.");
        }
    }

    public void newState_initiator(Meeting meeting) {
        this.TRACE("newState_initiator: meeting");
        Meeting meeting2 = new Meeting(meeting);
        meeting2.bumpedBy = meeting.bumpedBy;
        TimeSlot timeSlot = meeting.getBumpedTimeSlot();
        meeting2.tabooTimes.add(timeSlot);
        this.logTaboo(meeting2, timeSlot);
        this.calendar.addMeeting(meeting2);
        ++this.numBumps;
        this.newState_initiator(meeting2.toTemplate());
    }

    public void newState_initiator(Template template) {
        this.TRACE("newState_initiator: request");
        Meeting meeting = this.calendar.getMeeting(template.getMeetingId());
        if (meeting == null) {
            meeting = new Meeting(this.myUserId, template);
            this.calendar.addMeeting(meeting);
            this.negLogger.addEntry(meeting.getMeetingId());
            this.negLogger.setStartTime(meeting.getMeetingId(), Utility.TimeMS());
            this.negLogger.setResult(meeting.getMeetingId(), false);
        }
        this.logStatusChange(meeting, null);
        this.openMeetings.add(meeting.getMeetingId());
        boolean bl = this.handleMeetingRequest_initiator(meeting, null);
        if (!bl) {
            this.printStatus(this.myUserId + ": Scheduling done for " + meeting.getMeetingId() + "(fail, no slots)", 0);
            System.out.println(this.myUserId + ": Scheduling done for " + meeting.getMeetingId() + "(fail, no slots)");
            this.negLogger.setResult(meeting.getMeetingId(), false);
            this.negLogger.setEndTime(meeting.getMeetingId(), Utility.TimeMS());
            this.logFailure(meeting);
            this.openMeetings.remove(meeting.getMeetingId());
            return;
        }
        if (meeting.getAttendantIds().size() == 1) {
            TimeSlot timeSlot = this.checkForAgreement(meeting);
            this.confirmMeeting(meeting, timeSlot, false);
            this.handleBumpedMeetings(meeting);
            this.negLogger.setResult(meeting.getMeetingId(), true);
            this.negLogger.setEndTime(meeting.getMeetingId(), Utility.TimeMS());
            this.openMeetings.remove(meeting.getMeetingId());
        } else {
            System.out.println(this.myUserId + ": Initiating meeting " + meeting.getMeetingId());
            this.printStatus("Initiating meeting " + meeting.getMeetingId(), 0);
            meeting.clearResponseBits();
            Vector vector = meeting.getAttendantIds();
            Vector vector2 = meeting.getPendingTimeSlots();
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.get(i);
                if (string.equals(this.myUserId)) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    TimeSlot timeSlot = (TimeSlot)vector2.get(j);
                    meeting.addResponseBit(string, timeSlot);
                }
            }
            this.sendMeetingRequest(meeting);
        }
    }

    public void sendMeetingRequest(Meeting meeting) {
        this.TRACE("sendMeetingRequests");
        Template template = new Template(meeting.toTemplate());
        template.clearTimeSlots();
        Vector vector = meeting.getPendingTimeSlots();
        for (int i = 0; i < vector.size(); ++i) {
            template.addTimeSlot((TimeSlot)vector.get(i), "pending");
        }
        Vector vector2 = meeting.getAttendantIds();
        for (int i = 0; i < vector2.size(); ++i) {
            String string = (String)vector2.get(i);
            if (string.equals(this.myUserId)) continue;
            this.negLogger.incMessageCount(meeting.getMeetingId());
            this.mComm.sendMessage(template.toLispList(), this.myUserId, string);
        }
        this.TRACE("end sendMeetingRequests");
    }

    public void pendingState_initiator(Template template, String string) {
        System.out.println("pendingState_initiator");
        Meeting meeting = this.calendar.getMeeting(template.getMeetingId());
        System.out.println(" Response for meeting " + meeting.getMeetingId() + " from " + string);
        Vector vector = template.getTimeSlots();
        for (int i = 0; i < vector.size(); ++i) {
            TimeSlot timeSlot = (TimeSlot)vector.elementAt(i);
            System.out.println("setting status to: " + template.getStatus(timeSlot));
            meeting.setTimeSlotStatus(string, timeSlot, template.getStatus(timeSlot));
            meeting.setResponseBit(string, timeSlot);
        }
        if (!meeting.allResponseBitsSet()) {
            return;
        }
        this.negLogger.incRoundCount(meeting.getMeetingId());
        TimeSlot timeSlot = this.checkForAgreement(meeting);
        if (timeSlot != null) {
            System.out.println(this.myUserId + ": Scheduling done for " + meeting.getMeetingId() + "(success)");
            this.confirmMeeting(meeting, timeSlot, true);
            this.handleBumpedMeetings(meeting);
            this.negLogger.setResult(meeting.getMeetingId(), true);
            this.negLogger.setEndTime(meeting.getMeetingId(), Utility.TimeMS());
            this.openMeetings.remove(meeting.getMeetingId());
            return;
        }
        System.out.println(this.myUserId + ": No intersection found.");
        boolean bl = this.handleMeetingRequest_initiator(meeting, null);
        if (bl) {
            this.printStatus(" Starting next iteration for meeting " + meeting.getMeetingId() + " with " + meeting.getPendingTimeSlots().size() + " pending slots", 0);
            System.out.println(this.myUserId + ": Starting next iteration for meeting " + meeting.getMeetingId() + " with " + meeting.getPendingTimeSlots().size() + " pending slots");
            meeting.clearResponseBits();
            Vector vector2 = meeting.getAttendantIds();
            Vector vector3 = meeting.getPendingTimeSlots();
            for (int i = 0; i < vector2.size(); ++i) {
                String string2 = (String)vector2.get(i);
                if (string2.equals(this.myUserId)) continue;
                for (int j = 0; j < vector3.size(); ++j) {
                    TimeSlot timeSlot2 = (TimeSlot)vector3.get(j);
                    meeting.addResponseBit(string2, timeSlot2);
                }
            }
            this.sendMeetingRequest(meeting);
        } else {
            if (this.opt_bumpMode == LASTRESORT) {
                System.out.println(this.myUserId + ": Unable to find any more slots.");
                System.out.println(this.myUserId + ": Trying bumping.");
                timeSlot = this.checkForAgreementWithBumping(meeting);
                if (timeSlot != null) {
                    System.out.println(this.myUserId + ": Scheduling done for " + meeting.getMeetingId() + "(success)");
                    this.confirmMeeting(meeting, timeSlot, true);
                    this.handleBumpedMeetings(meeting);
                    this.negLogger.setResult(meeting.getMeetingId(), true);
                    this.negLogger.setEndTime(meeting.getMeetingId(), Utility.TimeMS());
                    this.openMeetings.remove(meeting.getMeetingId());
                    return;
                }
            }
            this.printStatus("Unable to find an agreed upon time for " + meeting.getMeetingId() + "!", 0);
            System.out.println(this.myUserId + ": Scheduling done for " + meeting.getMeetingId() + "(fail, no intersection and no more slots)");
            this.negLogger.setResult(meeting.getMeetingId(), false);
            this.negLogger.setEndTime(meeting.getMeetingId(), Utility.TimeMS());
            this.logFailure(meeting);
            this.freeReservedSlots(meeting);
            Template template2 = new Template(meeting.toTemplate());
            template2.clearTimeSlots();
            InteractiveNegotiator interactiveNegotiator = this;
            template2.addTimeSlot(interactiveNegotiator.calendar.getFullRange(), "impossible");
            Vector vector4 = meeting.getAttendantIds();
            for (int i = 0; i < vector4.size(); ++i) {
                String string3 = (String)vector4.elementAt(i);
                if (string3.equals(this.myUserId)) continue;
                this.negLogger.incMessageCount(template2.getMeetingId());
                this.mComm.sendMessage(template2.toLispList(), this.myUserId, string3);
            }
            this.handleBumpedMeetings(meeting);
            this.openMeetings.remove(meeting.getMeetingId());
        }
    }

    public void confirmedState_initiator(Template template, String string) {
        this.TRACE("confirmedState_initiator");
        Vector vector = template.getImpossibleTimeSlots();
        if (vector.size() == 0) {
            return;
        }
        TimeSlot timeSlot = (TimeSlot)vector.elementAt(0);
        Meeting meeting = this.calendar.getMeeting(template.getMeetingId());
        TimeSlot timeSlot2 = meeting.getConfirmedTimeSlot();
        if (timeSlot2 == null && (timeSlot2 = meeting.getBumpedTimeSlot()) == null) {
            System.out.println("error line 229");
            Utility.waitForKey(true);
        }
        if (timeSlot2.equals(timeSlot)) {
            System.out.println(this.myUserId + ": De-confirming meeting " + meeting.getMeetingId());
            this.printStatus(" De-confirming meeting " + meeting.getMeetingId(), 0);
            this.freeReservedSlots(meeting);
            this.calendar.deleteMeeting(meeting.getMeetingId());
            Meeting meeting2 = new Meeting(meeting);
            meeting2.setTimeSlotStatus(string, timeSlot, "impossible");
            meeting2.tabooTimes.add(timeSlot);
            this.logTaboo(meeting2, timeSlot);
            this.calendar.addMeeting(meeting2);
            this.negLogger.addEntry(meeting.getMeetingId());
            this.negLogger.setStartTime(meeting.getMeetingId(), Utility.TimeMS());
            this.negLogger.setResult(meeting.getMeetingId(), false);
            Template template2 = new Template(meeting.toTemplate());
            template2.clearTimeSlots();
            template2.addTimeSlot(timeSlot, "impossible");
            Vector vector2 = meeting2.getAttendantIds();
            if (vector2.size() > 2) {
                for (int i = 0; i < vector2.size(); ++i) {
                    String string2 = (String)vector2.elementAt(i);
                    if (string2.equals(this.myUserId)) continue;
                    this.negLogger.incMessageCount(template2.getMeetingId());
                    this.mComm.sendMessage(template2.toLispList(), this.myUserId, string2);
                }
            }
            ++this.numBumps;
            this.newState_initiator(meeting2.toTemplate());
        }
    }

    public boolean handleMeetingRequest_initiator2(Meeting meeting, TimeSlot timeSlot) {
        Object object;
        TimeSlot timeSlot2;
        this.TRACE("handleMeetingRequest_initiator2");
        if (timeSlot == null) {
            timeSlot2 = this.calendar.getFullRange2();
        } else {
            object = timeSlot;
            InteractiveNegotiator interactiveNegotiator = this;
            TimeSlot timeSlot3 = interactiveNegotiator.calendar.getFullRange();
            timeSlot2 = new TimeSlot();
            timeSlot2.earliestStartTime = timeSlot3.earliestStartTime;
            timeSlot2.latestFinishTime = timeSlot3.latestFinishTime;
            timeSlot2.startTime = ((TimeSlot)object).startTime;
            timeSlot2.finishTime = ((TimeSlot)object).finishTime;
        }
        object = meeting.getAllImpossibleUnion();
        if (this.opt_bumpTaboo == 1) {
            for (int i = 0; i < meeting.tabooTimes.size(); ++i) {
                TimeSlot timeSlot4 = (TimeSlot)meeting.tabooTimes.get(i);
                if (((Vector)object).contains(timeSlot4)) continue;
                ((Vector)object).add(timeSlot4);
            }
        }
        int n = meeting.getPendingTimeSlots().size();
        this.reserveOneSlot(meeting, timeSlot2, (Vector)object);
        return n != meeting.getPendingTimeSlots().size();
    }

    public boolean handleMeetingRequest_initiator(Meeting meeting, TimeSlot timeSlot) {
        TimeSlot timeSlot2;
        int n;
        this.TRACE("handleMeetingRequest_initiator");
        Vector vector = meeting.getAllImpossibleUnion();
        if (this.opt_bumpTaboo == 1) {
            for (n = 0; n < meeting.tabooTimes.size(); ++n) {
                timeSlot2 = (TimeSlot)meeting.tabooTimes.get(n);
                if (vector.contains(timeSlot2)) continue;
                vector.add(timeSlot2);
            }
        }
        n = 0;
        timeSlot2 = Calendar.getRandomFreeSlot(this.calendar, vector, this.RAND);
        if (n != 0) {
            return this.handleMeetingRequest_initiator2(meeting, timeSlot);
        }
        if (timeSlot2 == null && this.opt_bumpMode != NEVER) {
            return this.handleMeetingRequest_initiator2(meeting, timeSlot);
        }
        if (timeSlot2 == null) {
            return false;
        }
        int n2 = meeting.getPendingTimeSlots().size();
        boolean bl = this.reserveOneSlot(meeting, timeSlot2, vector);
        if (!bl) {
            System.out.println("Requested free slot " + timeSlot2.toPrettyString() + " not reserved by scheduler.");
            System.out.println(meeting.toTemplate().toString());
            this.calendar.printCalendar(new RManagerIOSystem(""));
            Utility.waitForKey(true);
        }
        return n2 != meeting.getPendingTimeSlots().size();
    }

    private String confirmStringFromTemplate(Template template, int n) {
        Vector vector = template.getTimeSlots();
        System.out.println("size: " + vector.size());
        String string = "Accept this meeting?\n\n";
        string = string + "Initiator: " + template.getInitiator() + "\n";
        string = string + "Start time: " + ((TimeSlot)vector.get((int)n)).startTime + "\n";
        string = string + "Finish time: " + ((TimeSlot)vector.get((int)n)).finishTime;
        return string;
    }

    private void rejectMeetingRequest(Meeting meeting, Template template, TimeSlot timeSlot) {
        template.addTimeSlot(timeSlot, "impossible");
        System.out.println("template after reject: \n" + template);
        this.mComm.sendMessage(template.toLispList(), this.myUserId, template.getInitiator());
        System.out.println("status after reject: " + template.getStatus(timeSlot));
    }

    private void confirmMeetingRequest(Meeting meeting, Template template) {
        System.out.println("confirmMeetingRequest");
        Vector vector = template.getPendingTimeSlots();
        for (int i = 0; i < vector.size(); ++i) {
            System.out.println("CONFIRM SIZE: " + vector.size());
            TimeSlot timeSlot = (TimeSlot)vector.get(i);
            String string = this.confirmStringFromTemplate(template, i);
            int n = 1;
            if (this.rejectedSlots.containsKey(timeSlot.toString())) {
                System.out.println("already asked about this one");
                template.addTimeSlot(timeSlot, "impossible");
                continue;
            }
            if (this.acceptedSlots.containsKey(timeSlot.toString())) continue;
            n = JOptionPane.showConfirmDialog(null, string, this.myUserId + ": Confirm Meeting", 0);
            if (n == 0 && !this.calendar.isTimeSlotEmpty(timeSlot)) {
                n = JOptionPane.showConfirmDialog(null, "Time slot is full.  Bump current meeting?", "Confirm Meeting", 0);
            }
            if (n == 1) {
                System.out.println("rejecting: " + timeSlot.toPrettyString());
                template.addTimeSlot(timeSlot, "impossible");
                this.rejectedSlots.put(timeSlot.toString(), null);
                continue;
            }
            this.handleMeetingRequest_attendee(meeting, template);
            this.acceptedSlots.put(timeSlot.toString(), null);
            return;
        }
        this.mComm.sendMessage(template.toLispList(), this.myUserId, template.getInitiator());
    }

    public void handleMessage_attendee(Template template) {
        this.printStatus("Received message about meeting " + template.getMeetingId(), 0);
        this.TRACE("handleMessage_attendee");
        Meeting meeting = this.calendar.getMeeting(template.getMeetingId());
        if (meeting == null) {
            this.newState_attendee(template);
        } else if (meeting.isPossible()) {
            this.possibleState_attendee(template);
        } else if (meeting.isPending()) {
            this.pendingState_attendee(template);
        } else if (meeting.isConfirmed() || meeting.isBumped()) {
            this.confirmedState_attendee(template);
        } else {
            this.printStatus("Don't know what I did! ", 0);
            System.out.println(this.myUserId + " Attendee: Don't know what I did! ");
        }
    }

    public void newState_attendee(Template template) {
        this.TRACE(this.myUserId + ": newState_attendee");
        System.out.println("newState_attendee");
        Meeting meeting = this.calendar.getMeeting(template.getMeetingId());
        if (meeting == null) {
            System.out.println("adding meeting to calendar");
            meeting = new Meeting(this.myUserId, template);
            this.calendar.addMeeting(meeting);
        }
        this.confirmMeetingRequest(meeting, template);
    }

    public void possibleState_attendee(Template template) {
        System.out.println("possibleState_attendee");
        Meeting meeting = this.calendar.getMeeting(template.getMeetingId());
        Vector vector = template.getImpossibleTimeSlots();
        if (vector.size() > 0) {
            this.freeReservedSlots(meeting);
            this.calendar.deleteMeeting(meeting.getMeetingId());
            return;
        }
        Vector vector2 = template.getPendingTimeSlots();
        if (vector2.size() == 0) {
            this.printStatus("   No slots requested. ", 0);
            return;
        }
        this.confirmMeetingRequest(meeting, template);
        System.out.println("we never do this");
    }

    public void pendingState_attendee(Template template) {
        this.TRACE("pendingState_attendee");
        System.out.println("pendingState_attendee");
        Meeting meeting = this.calendar.getMeeting(template.getMeetingId());
        this.printStatus(" In case Pen: " + meeting.getMeetingId(), 0);
        TimeSlot timeSlot = template.getConfirmedTimeSlot();
        if (timeSlot != null) {
            String string = this.calendar.getMeetingIdFromTimeSlot(timeSlot);
            if (string == null) {
                System.out.println("Error 248");
                Utility.waitForKey(true);
            } else if (!string.equals(meeting.getMeetingId())) {
                System.out.println("Error 252");
                Utility.waitForKey(true);
            } else {
                this.printStatus(" Confirming meeting " + meeting.getMeetingId(), 0);
                this.confirmMeeting(meeting, timeSlot, true);
                this.handleBumpedMeetings(meeting);
            }
            return;
        }
        Vector vector = template.getImpossibleTimeSlots();
        if (vector.size() > 0) {
            this.printStatus(" Deleting pending meeting " + meeting.getMeetingId(), 0);
            this.freeReservedSlots(meeting);
            this.calendar.deleteMeeting(meeting.getMeetingId());
            this.handleBumpedMeetings(meeting);
            return;
        }
        Vector vector2 = template.getPendingTimeSlots();
        if (vector2.size() > 0) {
            this.confirmMeetingRequest(meeting, template);
        }
    }

    public void confirmedState_attendee(Template template) {
        System.out.println("confirmedState_attendee");
        Meeting meeting = this.calendar.getMeeting(template.getMeetingId());
        Vector vector = template.getImpossibleTimeSlots();
        TimeSlot timeSlot = meeting.getConfirmedTimeSlot();
        if (timeSlot == null && (timeSlot = meeting.getBumpedTimeSlot()) == null) {
            System.out.println("error line 275");
            Utility.waitForKey(true);
        }
        for (int i = 0; i < vector.size(); ++i) {
            this.printStatus(" In case ConCan: " + meeting.getMeetingId(), 0);
            this.printStatus(" reservedslot: " + timeSlot.toPrettyString(), 0);
            TimeSlot timeSlot2 = (TimeSlot)vector.elementAt(i);
            this.printStatus(" impossible: " + timeSlot2.toPrettyString(), 0);
            if (!timeSlot.equals(timeSlot2)) continue;
            this.printStatus(" Deleting confirmed meeting " + meeting.getMeetingId(), 0);
            this.freeReservedSlots(meeting);
            this.calendar.deleteMeeting(meeting.getMeetingId());
        }
    }

    public boolean handleMeetingRequest_attendee(Meeting meeting, Template template) {
        System.out.println("handleMeetingRequest_attendee");
        Vector vector = template.getPendingTimeSlots();
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            TimeSlot timeSlot = (TimeSlot)vector.get(i);
            this.ioManager.writeLine("Received request for time " + timeSlot.toPrettyString());
            boolean bl2 = this.reserveOneSlot(meeting, timeSlot, null);
            if (!bl2) continue;
            bl = true;
        }
        String string = template.getInitiator();
        this.printStatus("Responding to " + string + " with " + meeting.getPendingTimeSlots().size() + " pending slots(" + bl + ")", 0);
        this.mComm.sendMessage(meeting.toLispList(), this.myUserId, string);
        return bl;
    }

    public boolean setBumpingStrategy(Meeting meeting) {
        int n;
        this.TRACE("setBumpingStrategy");
        boolean bl = false;
        if (this.opt_bumpMode == MIXED && meeting.getInitiator().equals(this.myUserId) && (n = this.negLogger.getRoundCount(meeting.getMeetingId())) >= this.opt_bumpRound) {
            this.ozone.setBumping(true);
            System.out.println(this.myUserId + ": Enabling bumping for " + meeting.getMeetingId() + " (" + n + ")");
            bl = true;
        }
        return bl;
    }

    public TimeSlot checkForAgreementWithBumping(Meeting meeting) {
        this.TRACE("checkForAgreementWithBumping");
        Vector vector = meeting.getAllPendingIntersection();
        if (vector.size() == 0) {
            return null;
        }
        for (int i = 0; i < vector.size(); ++i) {
            TimeSlot timeSlot = (TimeSlot)vector.get(i);
            String string = this.calendar.getMeetingIdFromTimeSlot(timeSlot);
            if (meeting.getTimeSlotStatus(this.myUserId, timeSlot).equals("pending")) {
                return timeSlot;
            }
            if (string != null && string.equals(meeting.getMeetingId())) continue;
            this.ozone.setBumping(true);
            this.reserveOneSlot(meeting, timeSlot, null);
            if (this.opt_bumpMode == NEVER) {
                this.ozone.setBumping(false);
            }
            if (!meeting.getTimeSlotStatus(this.myUserId, timeSlot).equals("pending")) continue;
            return timeSlot;
        }
        return null;
    }

    public TimeSlot checkForAgreement(Meeting meeting) {
        this.TRACE("checkForAgreement");
        Vector vector = meeting.getAllPendingIntersection();
        if (vector.size() == 0) {
            return null;
        }
        for (int i = 0; i < vector.size(); ++i) {
            TimeSlot timeSlot = (TimeSlot)vector.get(i);
            String string = this.calendar.getMeetingIdFromTimeSlot(timeSlot);
            if (meeting.getTimeSlotStatus(this.myUserId, timeSlot).equals("pending")) {
                return timeSlot;
            }
            if (string != null && string.equals(meeting.getMeetingId())) continue;
            System.out.println(" unproposed interesction found " + timeSlot.toPrettyString());
            this.reserveOneSlot(meeting, timeSlot, null);
            if (!meeting.getTimeSlotStatus(this.myUserId, timeSlot).equals("pending")) continue;
            return timeSlot;
        }
        return null;
    }

    public void confirmMeeting(Meeting meeting, TimeSlot timeSlot, boolean bl) {
        System.out.println("confirmMeeting");
        System.out.println("status: " + meeting.getTimeSlotStatus(this.myUserId, timeSlot));
        System.out.println("slot: " + timeSlot.toString());
        meeting.setTimeSlotStatus(this.myUserId, timeSlot, "confirmed");
        this.logStatusChange(meeting, timeSlot);
        this.logEvent(meeting, "confirmed", timeSlot);
        meeting.setConfirmed();
        Vector vector = meeting.getPendingTimeSlots();
        for (int i = 0; i < vector.size(); ++i) {
            meeting.setTimeSlotStatus(this.myUserId, (TimeSlot)vector.get(i), "possible");
            this.logStatusChange(meeting, (TimeSlot)vector.get(i));
            this.logEvent(meeting, "unreserved", (TimeSlot)vector.get(i));
        }
        Template template = new Template(meeting.toTemplate());
        template.clearTimeSlots();
        template.addTimeSlot(timeSlot, "confirmed");
        this.ozone.processRequest(template, this.opt_pslots);
        this.calendar.checkConsistency(this.ioManager);
        this.printStatus("Meeting " + meeting.getMeetingId() + " successfully scheduled.\n", 0);
        if (meeting.getInitiator().equals(this.myUserId) && bl) {
            Vector vector2 = meeting.getAttendantIds();
            for (int i = 0; i < vector2.size(); ++i) {
                String string = (String)vector2.elementAt(i);
                if (string.equals(this.myUserId)) continue;
                this.negLogger.incMessageCount(meeting.getMeetingId());
                this.mComm.sendMessage(meeting.toLispList(), this.myUserId, string);
            }
        }
    }

    public void freeReservedSlots(Meeting meeting) {
        this.TRACE("freeReservedSlots");
        TimeSlot timeSlot = meeting.getConfirmedTimeSlot();
        if (timeSlot != null) {
            meeting.setTimeSlotStatus(this.myUserId, timeSlot, "possible");
        }
        Vector vector = meeting.getPendingTimeSlots();
        for (int i = 0; i < vector.size(); ++i) {
            meeting.setTimeSlotStatus(this.myUserId, (TimeSlot)vector.get(i), "possible");
            this.logStatusChange(meeting, (TimeSlot)vector.get(i));
            this.logEvent(meeting, "unreserved", (TimeSlot)vector.get(i));
        }
        meeting.setStatus("possible");
        Template template = new Template(meeting.toTemplate());
        template.clearTimeSlots();
        InteractiveNegotiator interactiveNegotiator = this;
        template.addTimeSlot(interactiveNegotiator.calendar.getFullRange(), "impossible");
        this.ozone.processRequest(template, this.opt_pslots);
    }

    public boolean reserveSlots(Meeting meeting, Vector vector, Vector vector2) {
        Object object;
        TimeSlot timeSlot;
        int n;
        Object object2;
        Object object3;
        TimeSlot timeSlot2;
        int n2;
        this.TRACE("reserveSlots");
        Template template = new Template(meeting.toTemplate());
        template.clearTimeSlots();
        for (int i = 0; i < vector.size(); ++i) {
            TimeSlot timeSlot3 = (TimeSlot)vector.get(i);
            template.addTimeSlot(timeSlot3, "possible");
        }
        Vector vector3 = meeting.getPendingTimeSlots();
        for (n2 = 0; n2 < vector3.size(); ++n2) {
            timeSlot2 = (TimeSlot)vector3.elementAt(n2);
            if (Template.indexOf(vector, timeSlot2) >= 0) continue;
            template.addTimeSlot(timeSlot2, "pending");
        }
        if (vector2 != null) {
            for (n2 = 0; n2 < vector2.size(); ++n2) {
                timeSlot2 = (TimeSlot)vector2.get(n2);
                if (Template.indexOf(vector3, timeSlot2) >= 0) continue;
                template.addTimeSlot(timeSlot2, "impossible");
            }
        }
        n2 = this.setBumpingStrategy(meeting) ? 1 : 0;
        Vector vector4 = this.ozone.processRequest(template, this.opt_pslots);
        if (n2 != 0) {
            this.ozone.setBumping(false);
        }
        Template template2 = (Template)vector4.elementAt(0);
        if (vector4.size() > 1) {
            for (int i = 1; i < vector4.size(); ++i) {
                object3 = this.calendar.getMeeting(((Template)vector4.elementAt(i)).getMeetingId());
                if (object3 == null) {
                    System.out.println(this.myUserId + ": Scheduler returned bumped meeting that is not in my calendar.");
                    System.out.println("\t Meeting: " + ((Template)vector4.elementAt(i)).getMeetingId());
                    this.calendar.printCalendar(new RManagerIOSystem(""));
                    System.out.println(this.myUserId + ": ErrorScheduler ");
                    Utility.waitForKey(true);
                    continue;
                }
                if (!((Meeting)object3).isConfirmed()) {
                    System.out.println(this.myUserId + ": Scheduler returned bumped meeting that is not confirmed.");
                    System.out.println(this.myUserId + ": ErrorScheduler ");
                    for (int j = 0; j < vector4.size(); ++j) {
                        object2 = (Template)vector4.elementAt(j);
                        System.out.println(this.myUserId + " " + ((Template)object2).toLispList());
                    }
                    Utility.waitForKey(true);
                    continue;
                }
                if (this.opt_bumpMode == NEVER) {
                    System.out.println(this.myUserId + ": Scheduler returned bumped meeting but bumping is supposed to be off!.");
                    System.out.println(this.myUserId + ": ErrorScheduler ");
                    Utility.waitForKey(true);
                    continue;
                }
                TimeSlot timeSlot4 = ((Meeting)object3).getConfirmedTimeSlot();
                ((Meeting)object3).setTimeSlotStatus(this.myUserId, timeSlot4, "bumped");
                ((Meeting)object3).setStatus("bumped");
                ((Meeting)object3).bumpedBy = meeting.getMeetingId();
                meeting.bumped.add(((Meeting)object3).getMeetingId());
                this.logStatusChange((Meeting)object3, timeSlot4);
                this.logEvent((Meeting)object3, "bumped  ", timeSlot4);
            }
        }
        boolean bl = false;
        object3 = template2.getPendingTimeSlots();
        Vector vector5 = template2.getImpossibleTimeSlots();
        object2 = meeting.getPendingTimeSlots();
        for (n = 0; n < vector.size(); ++n) {
            timeSlot = (TimeSlot)vector.get(n);
            if (Template.indexOf(vector5, timeSlot) >= 0) {
                meeting.setTimeSlotStatus(this.myUserId, timeSlot, "impossible");
                this.logStatusChange(meeting, timeSlot);
                this.logEvent(meeting, "rejected", timeSlot);
                continue;
            }
            if (Template.indexOf((Vector)object3, timeSlot) < 0 || Template.indexOf((Vector)object2, timeSlot) >= 0) continue;
            bl = true;
            object = new TimeSlot(timeSlot);
            ((TimeSlot)object).earliestStartTime = ((TimeSlot)object).startTime;
            ((TimeSlot)object).latestFinishTime = ((TimeSlot)object).finishTime;
            meeting.setTimeSlotStatus(this.myUserId, (TimeSlot)object, "pending");
            meeting.setStatus("pending");
            this.logStatusChange(meeting, (TimeSlot)object);
            this.logEvent(meeting, "reserved", (TimeSlot)object);
        }
        object2 = meeting.getPendingTimeSlots();
        for (n = 0; n < ((Vector)object3).size(); ++n) {
            Template template3;
            int n3;
            timeSlot = (TimeSlot)((Vector)object3).elementAt(n);
            object = this.calendar.getMeetingIdFromTimeSlot(timeSlot);
            if (object != null && !((String)object).equals(meeting.getMeetingId())) {
                System.out.println(this.myUserId + ": Pending slot received from scheduler but slot already has a meeting in it!");
                System.out.println(meeting.getMeetingId() + " " + timeSlot.toPrettyString());
                this.calendar.printCalendar(new RManagerIOSystem(""));
                for (n3 = 0; n3 < vector4.size(); ++n3) {
                    template3 = (Template)vector4.elementAt(n3);
                    System.out.println(template3.toString());
                }
                Utility.waitForKey(true);
                continue;
            }
            if (timeSlot.st() < Calendar.DAY_START_HOUR || timeSlot.ft() > Calendar.DAY_END_HOUR || timeSlot.st() > Calendar.DAY_END_HOUR || timeSlot.ft() < Calendar.DAY_START_HOUR || timeSlot.day() > Calendar.NUM_DAYS) {
                System.out.println(this.myUserId + ": Slot received from scheduler but slot is outside of calendar range!");
                System.out.println(meeting.getMeetingId() + " " + timeSlot.toPrettyString());
                System.out.println("request: " + template.toLispList());
                for (n3 = 0; n3 < vector4.size(); ++n3) {
                    template3 = (Template)vector4.elementAt(n3);
                    System.out.println(template3.toString());
                }
                Utility.waitForKey(true);
                continue;
            }
            if (Template.indexOf((Vector)object2, timeSlot) >= 0) continue;
            bl = true;
            timeSlot.earliestStartTime = timeSlot.startTime;
            timeSlot.latestFinishTime = timeSlot.finishTime;
            meeting.setTimeSlotStatus(this.myUserId, timeSlot, "pending");
            meeting.setStatus("pending");
            this.logStatusChange(meeting, timeSlot);
            this.logEvent(meeting, "reserved", timeSlot);
        }
        return bl;
    }

    public boolean reserveOneSlot(Meeting meeting, TimeSlot timeSlot, Vector vector) {
        this.TRACE("reserveOneSlot");
        if (meeting.getTimeSlotStatus(this.myUserId, timeSlot).equals("pending")) {
            return false;
        }
        Vector<TimeSlot> vector2 = new Vector<TimeSlot>();
        vector2.add(timeSlot);
        boolean bl = this.reserveSlots(meeting, vector2, vector);
        return bl;
    }

    public void handleBumpedMeetings(Meeting meeting) {
        this.TRACE("handleBumpedMeetings");
        Vector vector = (Vector)meeting.bumped.clone();
        for (int i = 0; i < vector.size(); ++i) {
            String string;
            Meeting meeting2 = this.calendar.getMeeting((String)vector.elementAt(i));
            if (meeting2 == null || !meeting2.isBumped()) continue;
            TimeSlot timeSlot = meeting2.getBumpedTimeSlot();
            if (timeSlot == null) {
                System.out.println(this.myUserId + ": No bumped time slot in bumped meeting");
                System.out.println(meeting2.toTemplate());
                Utility.waitForKey(true);
            }
            if ((string = this.calendar.getMeetingIdFromTimeSlot(timeSlot)) == null) {
                this.confirmMeeting(meeting2, timeSlot, false);
                meeting2.bumpedBy = "";
                meeting.bumped.remove(meeting2.getMeetingId());
                continue;
            }
            this.rescheduleBumpedMeeting(meeting2);
        }
    }

    public void rescheduleBumpedMeeting(Meeting meeting) {
        this.TRACE("rescheduleBumpedMeeting");
        this.freeReservedSlots(meeting);
        this.calendar.deleteMeeting(meeting.getMeetingId());
        TimeSlot timeSlot = meeting.getBumpedTimeSlot();
        Template template = new Template(meeting.toTemplate());
        template.clearTimeSlots();
        template.addTimeSlot(timeSlot, "impossible");
        this.logReschedule(meeting);
        this.logEvent(meeting, "un-confirmed", timeSlot);
        if (template.getInitiator().equals(this.myUserId)) {
            this.printStatus("De-confirming meeting " + meeting.getMeetingId(), 0);
            System.out.println(this.myUserId + ": De-confirming meeting " + meeting.getMeetingId());
            this.negLogger.addEntry(meeting.getMeetingId());
            this.negLogger.setBumpId(meeting.getMeetingId(), meeting.bumpedBy);
            this.negLogger.setStartTime(meeting.getMeetingId(), Utility.TimeMS());
            this.negLogger.setResult(meeting.getMeetingId(), false);
            Vector vector = template.getAttendantIds();
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.elementAt(i);
                if (string.equals(this.myUserId)) continue;
                this.negLogger.incMessageCount(template.getMeetingId());
                this.mComm.sendMessage(template.toLispList(), this.myUserId, string);
            }
            this.newState_initiator(meeting);
        } else {
            this.mComm.sendMessage(template.toLispList(), this.myUserId, template.getInitiator());
        }
    }

    public void setOptions(String string) {
        this.TRACE("setOptions");
        this.opt_bumpMode = ALWAYS;
        this.opt_bumpRound = -1;
        this.ozone.setBumping(false);
        if (string.equals("")) {
            return;
        }
        String[] stringArray = string.split(":");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("=");
            if (stringArray2.length != 2) {
                this.printOptionsErrorandExit(string);
            }
            if (stringArray2[0].equals("bumpmode")) {
                if (stringArray2[1].equals("0")) {
                    this.opt_bumpMode = NEVER;
                    this.ozone.setBumping(false);
                    this.ozone.setBumpingStrategy(0);
                    continue;
                }
                if (stringArray2[1].equals("1")) {
                    this.opt_bumpMode = ALWAYS;
                    this.ozone.setBumping(true);
                    this.ozone.setBumpingStrategy(2);
                    continue;
                }
                if (stringArray2[1].equals("2")) {
                    this.opt_bumpMode = MIXED;
                    continue;
                }
                if (stringArray2[1].equals("3")) {
                    this.opt_bumpMode = NUM_ATTENDEES;
                    this.ozone.setBumping(true);
                    this.ozone.setBumpingStrategy(1);
                    continue;
                }
                if (stringArray2[1].equals("4")) {
                    this.opt_bumpMode = MTG_ID;
                    this.ozone.setBumping(true);
                    this.ozone.setBumpingStrategy(4);
                    continue;
                }
                if (stringArray2[1].equals("5")) {
                    this.opt_bumpMode = PREDEFINED_KIND;
                    this.ozone.setBumping(true);
                    this.ozone.setBumpingStrategy(3);
                    continue;
                }
                if (stringArray2[1].equals("6")) {
                    this.opt_bumpMode = WEIGHTED_NUM_ATTENDEES;
                    this.ozone.setBumping(true);
                    this.ozone.setBumpingStrategy(3);
                    continue;
                }
                if (stringArray2[1].equals("7")) {
                    this.opt_bumpMode = PROBABILITY_RULE;
                    this.ozone.setBumping(true);
                    this.ozone.setBumpingStrategy(3);
                    continue;
                }
                this.printOptionsErrorandExit(string);
                continue;
            }
            if (stringArray2[0].equals("round")) {
                this.opt_bumpRound = new Integer(stringArray2[1]);
                continue;
            }
            if (stringArray2[0].equals("taboo")) {
                this.opt_bumpTaboo = new Integer(stringArray2[1]);
                continue;
            }
            if (stringArray2[0].equals("pslots")) {
                this.opt_pslots = new Integer(stringArray2[1]);
                continue;
            }
            this.printOptionsErrorandExit(string);
        }
        if (this.opt_bumpMode == MIXED && this.opt_bumpRound < 0) {
            this.printOptionsErrorandExit(string);
        }
    }

    public void printOptionsErrorandExit(String string) {
        System.out.println("Unknown options to InteractiveNegotiator!");
        System.out.println("Given option string: " + string);
        System.out.println("\n\nOptions: bumpmode -- 0 means NEVER, 1 means ALWAYS, 2 means MIXED\n");
        System.out.println("round -- number of rounds after which to enable bumping when bumpmode==MIXED\n");
        System.out.println("Exiting...");
        System.exit(0);
    }
}

