/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.data;

import cmradar.manager.data.TimeSlot;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Template {
    public static final String PENDING = "pending";
    public static final String CONFIRMED = "confirmed";
    public static final String POSSIBLE = "possible";
    public static final String IMPOSSIBLE = "impossible";
    public static final String UNKNOWN = "unknown";
    public static final String BUMPED = "bumped";
    public static final String NEW = "NEW";
    protected static Logger logger = Logger.getLogger((String)(class$cmradar$manager$data$Template == null ? (class$cmradar$manager$data$Template = Template.class$("cmradar.manager.data.Template")) : class$cmradar$manager$data$Template).getName());
    public String meetingId;
    public String msgId = "NEW";
    public String timeStamp;
    public String initiator;
    public double duration;
    public Vector attendants;
    public Vector purposes;
    public Vector timeSlots = new Vector();
    protected String templateString = null;
    static /* synthetic */ Class class$cmradar$manager$data$Template;

    public Template() {
        this.meetingId = "nil";
        this.msgId = NEW;
        this.timeStamp = "nil";
        this.initiator = "nil";
        this.duration = 0.0;
        this.attendants = new Vector();
        this.purposes = new Vector();
    }

    public Template(Template template) {
        this.meetingId = template.meetingId;
        this.msgId = template.msgId;
        this.timeStamp = template.timeStamp;
        this.initiator = template.initiator;
        this.duration = template.duration;
        this.timeSlots = (Vector)template.timeSlots.clone();
        this.attendants = (Vector)template.attendants.clone();
        this.purposes = (Vector)template.purposes.clone();
    }

    public String getInitiator() {
        return this.initiator;
    }

    public void setInitiator(String string) {
        this.initiator = string;
    }

    public int getDurationHr() {
        return (int)(this.duration / 3600.0);
    }

    public double getDuration() {
        return this.duration;
    }

    public void setDuration(double d) {
        this.duration = d;
    }

    public String getMeetingId() {
        return this.meetingId;
    }

    public void setMeetingId(String string) {
        this.meetingId = string;
    }

    public Vector getTimeSlots() {
        return this.timeSlots;
    }

    public void setTimeSlots(Vector vector) {
        this.timeSlots = vector;
    }

    public String getPredefinedKind() {
        if (this.purposes.size() > 0) {
            return ((purpose)this.purposes.elementAt((int)0)).predefinedKind;
        }
        return "nil";
    }

    public String getExpectedGain() {
        if (this.purposes.size() > 0) {
            return ((purpose)this.purposes.elementAt((int)0)).expectedGain;
        }
        return null;
    }

    public void setPredefinedKind(String string) {
        this.addPurpose(string, "nil", "nil");
    }

    public void clearTimeSlots() {
        this.timeSlots = new Vector();
    }

    public static int indexOf(Vector vector, TimeSlot timeSlot) {
        for (int i = 0; i < vector.size(); ++i) {
            TimeSlot timeSlot2 = (TimeSlot)vector.elementAt(i);
            if (!timeSlot2.equals(timeSlot)) continue;
            return i;
        }
        return -1;
    }

    protected int indexOf(TimeSlot timeSlot) {
        return Template.indexOf(this.timeSlots, timeSlot);
    }

    public String getStatus() {
        if (this.timeSlots.size() == 0) {
            return null;
        }
        if (this.timeSlots.size() > 1) {
            logger.log((Priority)Level.WARN, (Object)("more than one timeslots: sz=" + this.timeSlots.size()));
        }
        TimeSlot timeSlot = (TimeSlot)this.timeSlots.elementAt(0);
        return timeSlot.getStatus();
    }

    public String getStatus(TimeSlot timeSlot) {
        return timeSlot.getStatus();
    }

    public void setStatus(TimeSlot timeSlot, String string) {
        TimeSlot timeSlot2 = null;
        Enumeration enumeration = this.timeSlots.elements();
        while (enumeration.hasMoreElements()) {
            TimeSlot timeSlot3 = (TimeSlot)enumeration.nextElement();
            if (!timeSlot3.startTime.equals(timeSlot.startTime) || !timeSlot3.finishTime.equals(timeSlot.finishTime) || !timeSlot3.location.equals(timeSlot.location)) continue;
            timeSlot2 = timeSlot3;
        }
        if (timeSlot2 == null) {
            logger.log((Priority)Level.ERROR, (Object)("Template:" + this.meetingId + " doesn't have timeslot " + timeSlot));
        } else {
            timeSlot2.setStatus(string);
        }
    }

    public String getDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.purposes.size(); ++i) {
            purpose purpose2 = (purpose)this.purposes.elementAt(i);
            stringBuffer.append(purpose2.description);
            if (i + 1 >= this.purposes.size()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public String getSubject() {
        return this.getDescription();
    }

    public void addPurpose(String string, String string2, String string3) {
        purpose purpose2 = new purpose();
        purpose2.predefinedKind = string;
        purpose2.description = string2;
        purpose2.specialNote = string3;
        this.purposes.add(purpose2);
    }

    public void addPurpose(String string, String string2, String string3, String string4) {
        purpose purpose2 = new purpose();
        purpose2.predefinedKind = string;
        purpose2.description = string2;
        purpose2.specialNote = string3;
        purpose2.expectedGain = string4;
        this.purposes.add(purpose2);
    }

    public void removeTimeSlot(TimeSlot timeSlot) {
        int n = this.indexOf(timeSlot);
        if (n >= 0) {
            this.timeSlots.remove(n);
        }
    }

    public void addTimeSlot(TimeSlot timeSlot) {
        this.addTimeSlot(timeSlot, timeSlot.getStatus());
    }

    public void addTimeSlot(TimeSlot timeSlot, String string) {
        timeSlot.setStatus(string);
        int n = this.indexOf(timeSlot);
        if (n < 0) {
            this.timeSlots.add(new TimeSlot(timeSlot));
        } else {
            this.timeSlots.set(n, timeSlot);
        }
    }

    public void addAttendant(String string, double d) {
        this.attendants.add(new attendant(string, d));
    }

    public TimeSlot getHighestPriorityTimeSlot(String string, double d) {
        Vector vector = this.getTimeSlotsFromStatus(string);
        double d2 = d;
        TimeSlot timeSlot = null;
        for (int i = 0; i < vector.size(); ++i) {
            TimeSlot timeSlot2 = (TimeSlot)vector.get(i);
            if (!(timeSlot2.priority > d2)) continue;
            timeSlot = timeSlot2;
            d2 = timeSlot2.priority;
        }
        return timeSlot;
    }

    public TimeSlot getHighestPriorityTimeSlot(String string) {
        Vector vector = this.getTimeSlotsFromStatus(string);
        double d = -1.0;
        TimeSlot timeSlot = null;
        for (int i = 0; i < vector.size(); ++i) {
            TimeSlot timeSlot2 = (TimeSlot)vector.get(i);
            if (!(timeSlot2.priority > d)) continue;
            timeSlot = timeSlot2;
            d = timeSlot2.priority;
        }
        return timeSlot;
    }

    public Vector getTimeSlotsFromStatus(String string) {
        Vector<TimeSlot> vector = new Vector<TimeSlot>();
        for (int i = 0; i < this.timeSlots.size(); ++i) {
            TimeSlot timeSlot = (TimeSlot)this.timeSlots.elementAt(i);
            String string2 = timeSlot.getStatus();
            if (!string.equalsIgnoreCase(string2)) continue;
            vector.add(timeSlot);
        }
        return vector;
    }

    public Vector getPossibleTimeSlots() {
        return this.getTimeSlotsFromStatus(POSSIBLE);
    }

    public Vector getImpossibleTimeSlots() {
        return this.getTimeSlotsFromStatus(IMPOSSIBLE);
    }

    public Vector getPendingTimeSlots() {
        return this.getTimeSlotsFromStatus(PENDING);
    }

    public TimeSlot getConfirmedTimeSlot() {
        Vector vector = this.getTimeSlotsFromStatus(CONFIRMED);
        if (vector.size() > 1) {
            System.out.println("Meeting.java: More than one confirmed timeslot!");
            System.out.println(" Seems like an error...exiting...");
            System.exit(0);
        }
        if (vector.size() == 1) {
            return (TimeSlot)vector.elementAt(0);
        }
        return null;
    }

    public Vector getAttendantIds() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.attendants.size(); ++i) {
            vector.add(((attendant)this.attendants.elementAt((int)i)).id);
        }
        return vector;
    }

    public String toXMLString() {
        Object object;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<meeting id=\"" + this.meetingId + "\">\n");
        stringBuffer.append("\t<message-id>" + this.msgId + "</message-id>\n");
        stringBuffer.append("\t<timestamp>" + this.timeStamp + "</timestamp>\n");
        stringBuffer.append("\t<subject>" + this.getSubject() + "</subject>\n");
        stringBuffer.append("\t<initiator>" + this.initiator + "</initiator>\n");
        stringBuffer.append("\t<duration>" + this.duration + "</duration>\n");
        if (this.attendants.size() > 0) {
            stringBuffer.append("\t<attendants>\n");
        }
        for (n = 0; n < this.attendants.size(); ++n) {
            object = (attendant)this.attendants.get(n);
            stringBuffer.append("\t\t<attendant>");
            stringBuffer.append(((attendant)object).id);
            stringBuffer.append("</attendant>\n");
        }
        if (this.attendants.size() > 0) {
            stringBuffer.append("\t</attendants>\n");
        }
        if (this.timeSlots.size() > 0) {
            stringBuffer.append("\t<timeslots>\n");
        }
        for (n = 0; n < this.timeSlots.size(); ++n) {
            object = (TimeSlot)this.timeSlots.get(n);
            stringBuffer.append(((TimeSlot)object).toXMLString(this.getStatus((TimeSlot)object)));
        }
        if (this.attendants.size() > 0) {
            stringBuffer.append("\t</timeslots>\n");
        }
        stringBuffer.append("</meeting>\n");
        return stringBuffer.toString();
    }

    public String toString() {
        Object object;
        int n;
        StringBuffer stringBuffer = new StringBuffer("Template: ");
        stringBuffer.append("\n  meetingId=" + this.meetingId);
        stringBuffer.append(",msgId=" + this.msgId);
        stringBuffer.append(",timeStamp=" + this.timeStamp);
        stringBuffer.append(",initiator=" + this.initiator);
        stringBuffer.append(",duration=" + this.duration);
        stringBuffer.append("\n  timeSlots:");
        for (n = 0; n < this.timeSlots.size(); ++n) {
            object = (TimeSlot)this.timeSlots.elementAt(n);
            stringBuffer.append("\n   timeSlot: ");
            stringBuffer.append(",st=" + ((TimeSlot)object).startTime);
            stringBuffer.append(",ft=" + ((TimeSlot)object).finishTime);
            stringBuffer.append(",status=" + this.getStatus((TimeSlot)object));
        }
        stringBuffer.append("\n  attendants: ");
        for (n = 0; n < this.attendants.size(); ++n) {
            object = (attendant)this.attendants.elementAt(n);
            stringBuffer.append("\n    attendant: ");
            stringBuffer.append("id=" + ((attendant)object).id);
            stringBuffer.append(",level=" + ((attendant)object).level);
        }
        stringBuffer.append("\n  purposes: ");
        for (n = 0; n < this.purposes.size(); ++n) {
            object = (purpose)this.purposes.elementAt(n);
            stringBuffer.append("\n    purpose: ");
            stringBuffer.append("predefinedKind=" + ((purpose)object).predefinedKind);
            stringBuffer.append("expectedGain=" + ((purpose)object).expectedGain);
            stringBuffer.append(",description=\"" + ((purpose)object).description + "\"");
            stringBuffer.append(",specialNote=\"" + ((purpose)object).specialNote + "\"");
        }
        return stringBuffer.toString();
    }

    protected static String valueFromKeyword(String string, String string2) {
        String string3 = "nil";
        int n = string.indexOf(string2);
        int n2 = string.indexOf(41, n);
        if (n > 0 && n < n2) {
            string3 = string.substring((n += string2.length() + 1) + 1, n2 - 1);
        }
        return string3;
    }

    protected static double valueFromKeyword2(String string, String string2) {
        double d = -1.0;
        int n = string.indexOf(string2);
        int n2 = string.indexOf(41, n);
        if (n > 0 && n < n2) {
            String string3 = string.substring(n += string2.length() + 1, n2);
            try {
                d = new Double(string3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return d;
    }

    protected static String getMeetingIdFromString(String string) {
        return Template.valueFromKeyword(string, "meeting-id");
    }

    protected static String getMsgIdFromString(String string) {
        return Template.valueFromKeyword(string, "msg-id");
    }

    protected static String getTimeStampFromString(String string) {
        return Template.valueFromKeyword(string, "timestamp");
    }

    protected static String getInitiatorFromString(String string) {
        return Template.valueFromKeyword(string, "initiator");
    }

    protected static double getDurationFromString(String string) {
        return Template.valueFromKeyword2(string, "duration");
    }

    public static String getEarliestStartTimeFromString(String string) {
        return Template.valueFromKeyword(string, "earliest-start-time");
    }

    public static String getLatestFinishTimeFromString(String string) {
        return Template.valueFromKeyword(string, "latest-finish-time");
    }

    public static String getStartTimeFromString(String string) {
        return Template.valueFromKeyword(string, "(start-time");
    }

    public static String getFinishTimeFromString(String string) {
        return Template.valueFromKeyword(string, "(finish-time");
    }

    public static double getPriorityFromString(String string) {
        return Template.valueFromKeyword2(string, "priority");
    }

    public static String getStatusFromString(String string) {
        return Template.valueFromKeyword(string, "status");
    }

    public static String getIdFromString(String string) {
        return Template.valueFromKeyword(string, "id");
    }

    public static double getLevelFromString(String string) {
        return Template.valueFromKeyword2(string, "level");
    }

    public static String getPredefinedKindFromString(String string) {
        return Template.valueFromKeyword(string, "predefined-kind");
    }

    public static String getExpectedGainFromString(String string) {
        double d = Template.valueFromKeyword2(string, "expected-gain");
        if (d < 0.0) {
            return null;
        }
        return String.valueOf(d);
    }

    public static String getDescriptionFromString(String string) {
        return Template.valueFromKeyword(string, "description");
    }

    public static String getSpecialNoteFromString(String string) {
        return Template.valueFromKeyword(string, "special-note");
    }

    public static TimeSlot getTimeSlotFromString(String string) {
        TimeSlot timeSlot = new TimeSlot();
        timeSlot.earliestStartTime = Template.getEarliestStartTimeFromString(string);
        timeSlot.latestFinishTime = Template.getLatestFinishTimeFromString(string);
        timeSlot.startTime = Template.getStartTimeFromString(string);
        timeSlot.finishTime = Template.getFinishTimeFromString(string);
        timeSlot.priority = Template.getPriorityFromString(string);
        return timeSlot;
    }

    public static Vector getTimeSlotsFromString(String string) {
        Vector<TimeSlot> vector = new Vector<TimeSlot>();
        int n = string.indexOf("time-slots");
        if (n > 0) {
            int n2 = string.indexOf("time-slot", n += 9);
            int n3 = string.indexOf("time-slot", n2 + 1);
            if (n3 < 0) {
                n3 = string.length();
            }
            while (n2 > 0 && n2 < n3) {
                String string2 = string.substring(n2 += 9, n3);
                TimeSlot timeSlot = Template.getTimeSlotFromString(string2);
                vector.add(timeSlot);
                n3 = string.indexOf("time-slot", (n2 = string.indexOf("time-slot", n2 + 1)) + 1);
                if (n3 >= 0) continue;
                n3 = string.length();
            }
        }
        if (vector.size() == 0) {
            // empty if block
        }
        return vector;
    }

    public static Vector getTimeSlotStatusFromString(String string) {
        Vector<String> vector = new Vector<String>();
        int n = string.indexOf("time-slots");
        if (n > 0) {
            int n2 = string.indexOf("time-slot", n += 9);
            int n3 = string.indexOf("time-slot", n2 + 1);
            if (n3 < 0) {
                n3 = string.length();
            }
            while (n2 > 0 && n2 < n3) {
                String string2 = string.substring(n2 += 9, n3);
                String string3 = Template.getStatusFromString(string2);
                vector.add(string3);
                n3 = string.indexOf("time-slot", (n2 = string.indexOf("time-slot", n2 + 1)) + 1);
                if (n3 >= 0) continue;
                n3 = string.length();
            }
        }
        return vector;
    }

    public static attendant getAttendantFromString(String string) {
        Template template = new Template();
        attendant attendant2 = template.new attendant();
        attendant2.id = Template.getIdFromString(string);
        attendant2.level = Template.getLevelFromString(string);
        return attendant2;
    }

    public static Vector getAttendantsFromString(String string) {
        Vector<attendant> vector = new Vector<attendant>();
        int n = string.indexOf("attendants");
        if (n > 0) {
            int n2 = string.indexOf("attendant", n += 10);
            int n3 = string.indexOf("attendant", n2 + 1);
            if (n3 < 0) {
                n3 = string.length();
            }
            while (n2 > 0 && n2 < n3) {
                String string2 = string.substring(n2 += 9, n3);
                attendant attendant2 = Template.getAttendantFromString(string2);
                vector.add(attendant2);
                n3 = string.indexOf("attendant", (n2 = string.indexOf("attendant", n2 + 1)) + 1);
                if (n3 >= 0) continue;
                n3 = string.length();
            }
        }
        return vector;
    }

    protected static purpose getPurposeFromString(String string) {
        Template template = new Template();
        purpose purpose2 = template.new purpose();
        purpose2.predefinedKind = Template.getPredefinedKindFromString(string);
        purpose2.expectedGain = Template.getExpectedGainFromString(string);
        purpose2.description = Template.getDescriptionFromString(string);
        purpose2.specialNote = Template.getSpecialNoteFromString(string);
        return purpose2;
    }

    protected static Vector getPurposesFromString(String string) {
        Vector<purpose> vector = new Vector<purpose>();
        int n = string.indexOf("purposes");
        if (n > 0) {
            int n2 = string.indexOf("purpose", n += 8);
            int n3 = string.indexOf("purpose", n2 + 1);
            if (n3 < 0) {
                n3 = string.length();
            }
            while (n2 > 0 && n2 < n3) {
                String string2 = string.substring(n2 += 7, n3);
                purpose purpose2 = Template.getPurposeFromString(string2);
                vector.add(purpose2);
                n3 = string.indexOf("purpose", (n2 = string.indexOf("purpose", n2 + 1)) + 1);
                if (n3 >= 0) continue;
                n3 = string.length();
            }
        }
        return vector;
    }

    public void prepareBumpedRequest() {
        this.timeSlots.clear();
    }

    public static Template getTemplateFromString(String string) {
        Template template = new Template();
        template.meetingId = Template.getMeetingIdFromString(string);
        template.msgId = Template.getMsgIdFromString(string);
        template.timeStamp = Template.getTimeStampFromString(string);
        template.initiator = Template.getInitiatorFromString(string);
        template.duration = Template.getDurationFromString(string);
        template.timeSlots = Template.getTimeSlotsFromString(string);
        Vector vector = Template.getTimeSlotStatusFromString(string);
        for (int i = 0; i < template.timeSlots.size(); ++i) {
            TimeSlot timeSlot = (TimeSlot)template.timeSlots.elementAt(i);
            String string2 = (String)vector.elementAt(i);
            timeSlot.setStatus(string2);
        }
        template.attendants = Template.getAttendantsFromString(string);
        template.purposes = Template.getPurposesFromString(string);
        return template;
    }

    public static Vector getTemplatesFromString(String string) {
        Vector<Template> vector = new Vector<Template>();
        int n = string.indexOf("templates");
        if (n > 0) {
            int n2 = string.indexOf("template", n += 9);
            int n3 = string.indexOf("template", n2 + 1);
            if (n3 < 0) {
                n3 = string.length();
            }
            while (n2 > 0 && n2 < n3) {
                String string2 = string.substring(n2 += 8, n3);
                Template template = Template.getTemplateFromString(string2);
                vector.add(template);
                n3 = string.indexOf("template", (n2 = string.indexOf("template", n2 + 1)) + 1);
                if (n3 >= 0) continue;
                n3 = string.length();
            }
        }
        if (vector.size() == 0) {
            // empty if block
        }
        return vector;
    }

    public static String FiletoString(String string) {
        String string2 = new String("");
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            int n = fileInputStream.read();
            while (n != -1) {
                string2 = string2 + (char)n;
                n = fileInputStream.read();
            }
            fileInputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("unable to read from file: " + string);
        }
        return string2;
    }

    public String toLispList() {
        Object object;
        int n;
        StringBuffer stringBuffer = new StringBuffer("(template ");
        stringBuffer.append("(meeting-id \"" + this.meetingId + "\") ");
        stringBuffer.append("(msg-id \"" + this.msgId + "\") ");
        stringBuffer.append("(timestamp \"" + this.timeStamp + "\") ");
        stringBuffer.append("(initiator \"" + this.initiator + "\") ");
        stringBuffer.append("(duration " + (int)this.duration + ") ");
        stringBuffer.append("(time-slots ");
        for (n = 0; n < this.timeSlots.size(); ++n) {
            object = (TimeSlot)this.timeSlots.elementAt(n);
            stringBuffer.append("(time-slot  ");
            stringBuffer.append("(earliest-start-time \"" + ((TimeSlot)object).earliestStartTime + "\") ");
            stringBuffer.append("(latest-finish-time \"" + ((TimeSlot)object).latestFinishTime + "\") ");
            stringBuffer.append("(start-time \"" + ((TimeSlot)object).startTime + "\") ");
            stringBuffer.append("(finish-time \"" + ((TimeSlot)object).finishTime + "\") ");
            stringBuffer.append("(priority " + ((TimeSlot)object).priority + ") ");
            stringBuffer.append("(status \"" + this.getStatus((TimeSlot)object) + "\")) ");
        }
        stringBuffer.append(")");
        stringBuffer.append("(attendants ");
        for (n = 0; n < this.attendants.size(); ++n) {
            object = (attendant)this.attendants.elementAt(n);
            stringBuffer.append("(attendant ");
            stringBuffer.append("(id \"" + ((attendant)object).id + "\") ");
            stringBuffer.append("(level " + ((attendant)object).level + ")) ");
        }
        stringBuffer.append(")");
        stringBuffer.append("(purposes ");
        for (n = 0; n < this.purposes.size(); ++n) {
            object = (purpose)this.purposes.elementAt(n);
            stringBuffer.append("(purpose ");
            stringBuffer.append("(predefined-kind \"" + ((purpose)object).predefinedKind + "\") ");
            stringBuffer.append("(expected-gain " + ((purpose)object).expectedGain + ") ");
            stringBuffer.append("(description \"" + ((purpose)object).description + "\") ");
            stringBuffer.append("(special-note \"" + ((purpose)object).specialNote + "\"))");
        }
        stringBuffer.append(")");
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void fillInTestData1() {
        this.meetingId = "MT4623";
        this.msgId = "MGS1002";
        this.timeStamp = "2003-06-23 [14:08 -0500]";
        this.initiator = "mmv@cs.cmu.edu";
        this.duration = 3600.0;
        TimeSlot timeSlot = new TimeSlot();
        timeSlot.earliestStartTime = "2003-06-25 [9:00 -0500]";
        timeSlot.latestFinishTime = "2003-06-25 [17:00 -0500]";
        timeSlot.startTime = "2003-06-25 [15:00 -0500]";
        timeSlot.finishTime = "2003-06-25 [16:00 -0500]";
        timeSlot.priority = 1.0;
        this.addTimeSlot(timeSlot, POSSIBLE);
        attendant attendant2 = new attendant();
        attendant2.id = "sfs@cs.cmu.edu";
        attendant2.level = 1.0;
        this.attendants.addElement(attendant2);
        attendant attendant3 = new attendant();
        attendant3.id = "mmv@cs.cmu.edu";
        attendant3.level = 1.0;
        this.attendants.addElement(attendant3);
        purpose purpose2 = new purpose();
        purpose2.predefinedKind = "radar-working-meeting";
        purpose2.description = "working meeting for the Radar project";
        purpose2.specialNote = "nil";
        this.purposes.addElement(purpose2);
    }

    public void fillInTestData2() {
        this.meetingId = "MT4624";
        this.msgId = "MGS1003";
        this.timeStamp = "2003-06-24 [14:08 -0500]";
        this.initiator = "mmv@cs.cmu.edu";
        this.duration = 3600.0;
        TimeSlot timeSlot = new TimeSlot();
        timeSlot.earliestStartTime = "2003-06-25 [10:00 -0500]";
        timeSlot.latestFinishTime = "2003-06-25 [11:00 -0500]";
        timeSlot.startTime = "2003-06-25 [10:00 -0500]";
        timeSlot.finishTime = "2003-06-25 [11:00 -0500]";
        timeSlot.priority = 1.0;
        this.addTimeSlot(timeSlot, PENDING);
        TimeSlot timeSlot2 = new TimeSlot();
        timeSlot2.earliestStartTime = "2003-06-25 [13:00 -0500]";
        timeSlot2.latestFinishTime = "2003-06-25 [14:00 -0500]";
        timeSlot2.startTime = "2003-06-25 [13:00 -0500]";
        timeSlot2.finishTime = "2003-06-25 [14:00 -0500]";
        timeSlot2.priority = 0.5;
        this.addTimeSlot(timeSlot2, PENDING);
        attendant attendant2 = new attendant();
        attendant2.id = "sfs@cs.cmu.edu";
        attendant2.level = 1.0;
        this.attendants.addElement(attendant2);
        attendant attendant3 = new attendant();
        attendant3.id = "mmv@cs.cmu.edu";
        attendant3.level = 1.0;
        this.attendants.addElement(attendant3);
        purpose purpose2 = new purpose();
        purpose2.predefinedKind = "radar-working-meeting";
        purpose2.description = "We need to have working meeting for the Radar project";
        purpose2.specialNote = "nil";
        this.purposes.addElement(purpose2);
    }

    public void fillInTestData3_mmv_sfs() {
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
        calendar.add(5, 1);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd [HH:mm Z]");
        String string = simpleDateFormat.format(calendar.getTime());
        this.meetingId = "M2";
        this.msgId = "MGS1004";
        this.timeStamp = string;
        this.initiator = "mmv@cs.cmu.edu";
        this.duration = 3600.0;
        TimeSlot timeSlot = new TimeSlot();
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
        String string2 = simpleDateFormat2.format(calendar.getTime());
        timeSlot.earliestStartTime = string2 + " [10:00 -0500]";
        timeSlot.latestFinishTime = string2 + " [15:00 -0500]";
        timeSlot.startTime = string2 + " [10:00 -0500]";
        timeSlot.finishTime = string2 + " [11:00 -0500]";
        timeSlot.priority = 0.2;
        timeSlot.priority = 1.0;
        this.addTimeSlot(timeSlot, POSSIBLE);
        attendant attendant2 = new attendant();
        attendant2.id = "sfs@cs.cmu.edu";
        attendant2.level = 1.0;
        this.attendants.addElement(attendant2);
        attendant attendant3 = new attendant();
        attendant3.id = "mmv@cs.cmu.edu";
        attendant3.level = 1.0;
        this.attendants.addElement(attendant3);
        purpose purpose2 = new purpose();
        purpose2.predefinedKind = ":faculty-meeting";
        purpose2.description = "Urgent meeting for the Radar project";
        purpose2.specialNote = "nil";
        this.purposes.addElement(purpose2);
    }

    public void fillInTestData3_sfs_pmodi() {
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
        calendar.add(5, 1);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd [HH:mm Z]");
        String string = simpleDateFormat.format(calendar.getTime());
        this.meetingId = "MT1";
        this.msgId = "MGS1005";
        this.timeStamp = string;
        this.initiator = "sfs@cs.cmu.edu";
        this.duration = 3600.0;
        TimeSlot timeSlot = new TimeSlot();
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
        String string2 = simpleDateFormat2.format(calendar.getTime());
        timeSlot.earliestStartTime = string2 + " [10:00 -0500]";
        timeSlot.latestFinishTime = string2 + " [15:00 -0500]";
        timeSlot.startTime = string2 + " [10:00 -0500]";
        timeSlot.finishTime = string2 + " [11:00 -0500]";
        timeSlot.priority = 0.2;
        this.addTimeSlot(timeSlot, CONFIRMED);
        attendant attendant2 = new attendant();
        attendant2.id = "sfs@cs.cmu.edu";
        attendant2.level = 1.0;
        this.attendants.addElement(attendant2);
        attendant attendant3 = new attendant();
        attendant3.id = "pmodi@cs.cmu.edu";
        attendant3.level = 1.0;
        this.attendants.addElement(attendant3);
        purpose purpose2 = new purpose();
        purpose2.predefinedKind = ":project-meeting";
        purpose2.description = "Discuss Radar Goals [Jay, Steve] NSH 1305";
        purpose2.specialNote = "nil";
        this.purposes.addElement(purpose2);
    }

    public void fillerMeeting_4() {
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
        calendar.add(5, 1);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd [HH:mm Z]");
        String string = simpleDateFormat.format(calendar.getTime());
        this.meetingId = "MT4";
        this.msgId = "MGS3432";
        this.timeStamp = string;
        this.initiator = "sfs@cs.cmu.edu";
        this.duration = 3600.0;
        TimeSlot timeSlot = new TimeSlot();
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
        String string2 = simpleDateFormat2.format(calendar.getTime());
        timeSlot.earliestStartTime = string2 + " [14:00 -0500]";
        timeSlot.latestFinishTime = string2 + " [15:00 -0500]";
        timeSlot.startTime = string2 + " [14:00 -0500]";
        timeSlot.finishTime = string2 + " [15:00 -0500]";
        timeSlot.priority = 0.9;
        this.addTimeSlot(timeSlot, CONFIRMED);
        attendant attendant2 = new attendant();
        attendant2.id = "sfs@cs.cmu.edu";
        attendant2.level = 1.0;
        this.attendants.addElement(attendant2);
        purpose purpose2 = new purpose();
        purpose2.predefinedKind = "meeting";
        purpose2.description = "Project Meeting, Wean 8220";
        purpose2.specialNote = "nil";
        this.purposes.addElement(purpose2);
    }

    public void fillerMeeting_5() {
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
        calendar.add(5, 1);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd [HH:mm Z]");
        String string = simpleDateFormat.format(calendar.getTime());
        this.meetingId = "MT5";
        this.msgId = "MGS1205";
        this.timeStamp = string;
        this.initiator = "sfs@cs.cmu.edu";
        this.duration = 3600.0;
        TimeSlot timeSlot = new TimeSlot();
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
        String string2 = simpleDateFormat2.format(calendar.getTime());
        timeSlot.earliestStartTime = string2 + " [15:00 -0500]";
        timeSlot.latestFinishTime = string2 + " [16:00 -0500]";
        timeSlot.startTime = string2 + " [15:00 -0500]";
        timeSlot.finishTime = string2 + " [16:00 -0500]";
        timeSlot.priority = 0.2;
        this.addTimeSlot(timeSlot, CONFIRMED);
        attendant attendant2 = new attendant();
        attendant2.id = "sfs@cs.cmu.edu";
        attendant2.level = 1.0;
        this.attendants.addElement(attendant2);
        purpose purpose2 = new purpose();
        purpose2.predefinedKind = "special-meeting";
        purpose2.description = "Work on paper, NSH 1502";
        purpose2.specialNote = "nil";
        this.purposes.addElement(purpose2);
    }

    public void fillerMeeting_6() {
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
        calendar.add(5, 1);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd [HH:mm Z]");
        String string = simpleDateFormat.format(calendar.getTime());
        this.meetingId = "MT6";
        this.msgId = "MGS1205";
        this.timeStamp = string;
        this.initiator = "sfs@cs.cmu.edu";
        this.duration = 3600.0;
        TimeSlot timeSlot = new TimeSlot();
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
        String string2 = simpleDateFormat2.format(calendar.getTime());
        timeSlot.earliestStartTime = string2 + " [15:00 -0500]";
        timeSlot.latestFinishTime = string2 + " [16:00 -0500]";
        timeSlot.startTime = string2 + " [15:00 -0500]";
        timeSlot.finishTime = string2 + " [16:00 -0500]";
        timeSlot.priority = 0.2;
        this.addTimeSlot(timeSlot, CONFIRMED);
        attendant attendant2 = new attendant();
        attendant2.id = "pmodi@cs.cmu.edu";
        attendant2.level = 1.0;
        this.attendants.addElement(attendant2);
        attendant attendant3 = new attendant();
        attendant3.id = "mmv@cs.cmu.edu";
        attendant3.level = 1.0;
        this.attendants.addElement(attendant3);
        purpose purpose2 = new purpose();
        purpose2.predefinedKind = "special-meeting";
        purpose2.description = "Meeting [Jay, Manuela] Wean 7123";
        purpose2.specialNote = "nil";
        this.purposes.addElement(purpose2);
    }

    public void fillerMeeting_7() {
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
        calendar.add(5, 1);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd [HH:mm Z]");
        String string = simpleDateFormat.format(calendar.getTime());
        this.meetingId = "MT7";
        this.msgId = "MGS1244";
        this.timeStamp = string;
        this.initiator = "sfs@cs.cmu.edu";
        this.duration = 3600.0;
        TimeSlot timeSlot = new TimeSlot();
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
        String string2 = simpleDateFormat2.format(calendar.getTime());
        timeSlot.earliestStartTime = string2 + " [15:00 -0500]";
        timeSlot.latestFinishTime = string2 + " [16:00 -0500]";
        timeSlot.startTime = string2 + " [15:00 -0500]";
        timeSlot.finishTime = string2 + " [16:00 -0500]";
        timeSlot.priority = 0.2;
        this.addTimeSlot(timeSlot, CONFIRMED);
        attendant attendant2 = new attendant();
        attendant2.id = "pmodi@cs.cmu.edu";
        attendant2.level = 1.0;
        this.attendants.addElement(attendant2);
        attendant attendant3 = new attendant();
        attendant3.id = "mmv@cs.cmu.edu";
        attendant3.level = 1.0;
        this.attendants.addElement(attendant3);
        purpose purpose2 = new purpose();
        purpose2.predefinedKind = "special-meeting";
        purpose2.description = "Meeting [Jay, Manuela] Wean 7123";
        purpose2.specialNote = "nil";
        this.purposes.addElement(purpose2);
    }

    public void fillerMeeting_8() {
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
        calendar.add(5, 1);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd [HH:mm Z]");
        String string = simpleDateFormat.format(calendar.getTime());
        this.meetingId = "MT8";
        this.msgId = "MGS1233";
        this.timeStamp = string;
        this.initiator = "mmv@cs.cmu.edu";
        this.duration = 3600.0;
        TimeSlot timeSlot = new TimeSlot();
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
        String string2 = simpleDateFormat2.format(calendar.getTime());
        timeSlot.earliestStartTime = string2 + " [8:00 -0500]";
        timeSlot.latestFinishTime = string2 + " [9:00 -0500]";
        timeSlot.startTime = string2 + " [8:00 -0500]";
        timeSlot.finishTime = string2 + " [9:00 -0500]";
        timeSlot.priority = 0.2;
        this.addTimeSlot(timeSlot, PENDING);
        attendant attendant2 = new attendant();
        attendant2.id = "mmv@cs.cmu.edu";
        attendant2.level = 1.0;
        this.attendants.addElement(attendant2);
        purpose purpose2 = new purpose();
        purpose2.predefinedKind = "special-meeting";
        purpose2.description = "Work on proposal [Manuela] Wean 7123 ";
        purpose2.specialNote = "nil";
        this.purposes.addElement(purpose2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class purpose {
        String predefinedKind;
        String description;
        String specialNote;
        String expectedGain = null;

        protected purpose() {
        }
    }

    protected class attendant {
        String id;
        double level;

        public attendant() {
        }

        public attendant(String string, double d) {
            this.id = string;
            this.level = d;
        }
    }
}

