/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.data;

import cmradar.manager.data.EnumRequirement;
import cmradar.manager.data.MemberRequirement;
import cmradar.manager.data.NumericRequirement;
import cmradar.manager.data.Requirement;
import cmradar.manager.data.Room;
import cmradar.manager.data.Template;
import cmradar.manager.data.TimeSlot;
import edu.cmu.cs.radar.integ.ICMRadarProvides;
import edu.cmu.cs.radar.integ.ICMRadarRequires;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public class RoomTemplate
extends Template {
    public ArrayList requirements;
    private HashMap numOwnersToWait = null;
    private Vector failedRooms = null;

    public RoomTemplate() {
        this.requirements = new ArrayList();
    }

    public RoomTemplate(RoomTemplate roomTemplate) {
        super(roomTemplate);
        this.requirements = (ArrayList)roomTemplate.requirements.clone();
    }

    public RoomTemplate(ICMRadarProvides.EventInformation eventInformation) {
        this();
        this.meetingId = eventInformation.getEventId();
        this.initiator = eventInformation.getUserId();
        this.duration = eventInformation.getDurationPref();
        if (this.duration < 3600.0) {
            this.duration = 3600.0;
        }
        ICMRadarProvides.EventInformation.Preference preference = eventInformation.getStartPref();
        for (int i = 0; i < preference.getIntervalCount(); ++i) {
            double d = preference.getIntervalStart(i);
            double d2 = Math.max(preference.getIntervalStop(i), d + this.duration);
            this.addTimeSlot(new TimeSlot((long)d, (long)d2), "possible");
        }
        Iterator iterator = eventInformation.getAdditionalPrefs().iterator();
        while (iterator.hasNext()) {
            ICMRadarProvides.EventInformation.Preference preference2 = (ICMRadarProvides.EventInformation.Preference)iterator.next();
            if (preference2.getIntervalCount() != 1) {
                logger.log((Priority)Level.ERROR, (Object)("preference must have 1 interval " + preference2.getName()));
                continue;
            }
            double d = preference2.getIntervalStart(0);
            double d3 = preference2.getIntervalStop(0);
            this.requirements.add(new NumericRequirement(preference2.getName(), 1.0, 1.0, d, d3, d3));
        }
        this.addAttendant(this.initiator, 1.0);
        this.addPurpose("conference", "conference", "", String.valueOf(eventInformation.getExpectedGain()));
    }

    public ICMRadarProvides.EventInformation toEventInformation() {
        Object object;
        Calendar calendar = Calendar.getInstance();
        ICMRadarProvides.EventInformation.Preference preference = new ICMRadarProvides.EventInformation.Preference("start");
        Enumeration enumeration = this.timeSlots.elements();
        while (enumeration.hasMoreElements()) {
            object = (TimeSlot)enumeration.nextElement();
            preference.AddInterval(((TimeSlot)object).getStartTime(), ((TimeSlot)object).getFinishTime());
        }
        float f = 9999.0f;
        object = this.getExpectedGain();
        if (object != null) {
            try {
                f = Float.parseFloat(((String)object).trim());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        ICMRadarProvides.EventInformation eventInformation = new ICMRadarProvides.EventInformation(this.initiator, this.meetingId, preference, (long)this.duration, f);
        Iterator iterator = this.requirements.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof NumericRequirement)) continue;
            NumericRequirement numericRequirement = (NumericRequirement)e;
            ICMRadarProvides.EventInformation.Preference preference2 = new ICMRadarProvides.EventInformation.Preference(numericRequirement.getName());
            preference2.AddInterval(numericRequirement.getMin(), numericRequirement.getMax());
            eventInformation.addAdditionalPref(preference2);
        }
        return eventInformation;
    }

    public ICMRadarRequires.Reservation makeReservation(int n, Room room) {
        TimeSlot timeSlot = this.getConfirmedTimeSlot();
        if (timeSlot == null) {
            return null;
        }
        ICMRadarRequires.Reservation reservation = new ICMRadarRequires.Reservation(this.meetingId, timeSlot.location, room.getBuilding(), timeSlot.getStartTime(), timeSlot.getFinishTime(), room.getFeatures(), n);
        return reservation;
    }

    public ArrayList getRequirements() {
        return this.requirements;
    }

    public void setRoomRequirements(Map map) {
        this.requirements = new ArrayList();
        logger.log((Priority)Level.ERROR, (Object)"setRequirements needs to be implemented! don't know what objects Map got");
    }

    public static boolean isRoomTemplate(String string) {
        return string.indexOf("rtemplate") != -1;
    }

    public void setOwnersToWait(HashMap hashMap) {
        this.numOwnersToWait = hashMap;
    }

    public HashMap getOwnersToWait() {
        return this.numOwnersToWait;
    }

    public int getNumOwnersToWait(String string) {
        return (Integer)this.numOwnersToWait.get(string);
    }

    public void setNumOwnersToWait(String string, int n) {
        this.numOwnersToWait.put(string, new Integer(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrOwnerResponse(String string) {
        Integer n = (Integer)this.numOwnersToWait.get(string);
        if (n == null) {
            return;
        }
        int n2 = n;
        --n2;
        HashMap hashMap = this.numOwnersToWait;
        synchronized (hashMap) {
            this.numOwnersToWait.put(string, new Integer(n2));
        }
    }

    public void addFailedRoom(String string) {
        this.failedRooms.add(string);
    }

    public boolean isFailedRoom(String string) {
        return this.failedRooms.contains(string);
    }

    public Vector getFailedRooms() {
        return this.failedRooms;
    }

    public void setFailedRooms(Vector vector) {
        this.failedRooms = vector;
    }

    public void resetRoomOwners() {
        this.numOwnersToWait = new HashMap();
        this.failedRooms = new Vector();
    }

    public String toXMLString() {
        Object object;
        int n;
        StringBuffer stringBuffer = new StringBuffer("<rTemplate>\n");
        stringBuffer.append("<meeting id=\"" + this.meetingId + "\">\n");
        stringBuffer.append("\t<message-id>" + this.msgId + "</message-id>\n");
        stringBuffer.append("\t<timestamp>" + this.timeStamp + "</timestamp>\n");
        stringBuffer.append("\t<subject>" + this.getSubject() + "</subject>\n");
        stringBuffer.append("\t<initiator>" + this.initiator + "</initiator>\n");
        stringBuffer.append("\t<duration>" + this.duration + "</duration>\n");
        if (this.attendants.size() > 0) {
            stringBuffer.append("\t<attendants>\n");
        }
        for (n = 0; n < this.attendants.size(); ++n) {
            object = (Template.attendant)this.attendants.get(n);
            stringBuffer.append("\t\t<attendant>");
            stringBuffer.append(((Template.attendant)object).id);
            stringBuffer.append("</attendant>\n");
        }
        if (this.attendants.size() > 0) {
            stringBuffer.append("\t</attendants>\n");
        }
        if (this.requirements.size() > 0) {
            stringBuffer.append("\t<room-requirements>\n");
        }
        for (n = 0; n < this.requirements.size(); ++n) {
            stringBuffer.append(((Requirement)this.requirements.get(n)).xmlString("\t\t"));
        }
        stringBuffer.append("\n\t</room-requirements>\n");
        if (this.timeSlots.size() > 0) {
            stringBuffer.append("\t<timeslots>\n");
        }
        for (n = 0; n < this.timeSlots.size(); ++n) {
            object = (TimeSlot)this.timeSlots.get(n);
            stringBuffer.append(((TimeSlot)object).toXMLString(this.getStatus((TimeSlot)object)));
        }
        if (this.attendants.size() > 0) {
            stringBuffer.append("\t</timeslots>\n");
        }
        stringBuffer.append("</meeting>\n</rTemplate>\n");
        return stringBuffer.toString();
    }

    public String toString() {
        Object object;
        int n;
        StringBuffer stringBuffer = new StringBuffer("RoomTemplate: ");
        stringBuffer.append("\n  meetingId=" + this.meetingId);
        stringBuffer.append(",msgId=" + this.msgId);
        stringBuffer.append(",timeStamp=" + this.timeStamp);
        stringBuffer.append(",initiator=" + this.initiator);
        stringBuffer.append(",duration=" + this.duration);
        stringBuffer.append("\n  timeSlots:");
        for (n = 0; n < this.timeSlots.size(); ++n) {
            object = (TimeSlot)this.timeSlots.elementAt(n);
            stringBuffer.append("\n   timeSlot: ");
            if (((TimeSlot)object).location != null) {
                stringBuffer.append("room-id=" + ((TimeSlot)object).location);
            }
            stringBuffer.append(",st=" + ((TimeSlot)object).startTime);
            stringBuffer.append(",ft=" + ((TimeSlot)object).finishTime);
            stringBuffer.append(",status=" + this.getStatus((TimeSlot)object));
        }
        stringBuffer.append("\n  attendants: ");
        for (n = 0; n < this.attendants.size(); ++n) {
            object = (Template.attendant)this.attendants.elementAt(n);
            stringBuffer.append("\n    attendant: ");
            stringBuffer.append("id=" + ((Template.attendant)object).id);
            stringBuffer.append(",level=" + ((Template.attendant)object).level);
        }
        stringBuffer.append("\n  room-requirements ");
        for (n = 0; n < this.requirements.size(); ++n) {
            stringBuffer.append(this.requirements.get(n).toString());
        }
        stringBuffer.append("\n  purposes: ");
        for (n = 0; n < this.purposes.size(); ++n) {
            object = (Template.purpose)this.purposes.elementAt(n);
            stringBuffer.append("\n    purpose: ");
            stringBuffer.append("predefinedKind=" + ((Template.purpose)object).predefinedKind);
            stringBuffer.append("expectedGain=" + ((Template.purpose)object).expectedGain);
            stringBuffer.append(",description=\"" + ((Template.purpose)object).description + "\"");
        }
        return stringBuffer.toString();
    }

    public static String getLocationFromString(String string) {
        return RoomTemplate.valueFromKeyword(string, "(room-id");
    }

    public static TimeSlot getTimeSlotFromString(String string) {
        TimeSlot timeSlot = new TimeSlot();
        timeSlot.location = RoomTemplate.getLocationFromString(string);
        timeSlot.earliestStartTime = RoomTemplate.getEarliestStartTimeFromString(string);
        timeSlot.latestFinishTime = RoomTemplate.getLatestFinishTimeFromString(string);
        timeSlot.startTime = RoomTemplate.getStartTimeFromString(string);
        timeSlot.finishTime = RoomTemplate.getFinishTimeFromString(string);
        timeSlot.priority = RoomTemplate.getPriorityFromString(string);
        timeSlot.status = RoomTemplate.getStatusFromString(string);
        return timeSlot;
    }

    public static Vector getTimeSlotsFromString(String string) {
        Vector<TimeSlot> vector = new Vector<TimeSlot>();
        int n = string.indexOf("time-slots");
        if (n > 0) {
            int n2 = string.indexOf("time-slot", n += 9);
            int n3 = string.indexOf("time-slot", n2 + 1);
            if (n3 < 0) {
                n3 = string.length();
            }
            while (n2 > 0 && n2 < n3) {
                String string2 = string.substring(n2 += 9, n3);
                TimeSlot timeSlot = RoomTemplate.getTimeSlotFromString(string2);
                vector.add(timeSlot);
                n3 = string.indexOf("time-slot", (n2 = string.indexOf("time-slot", n2 + 1)) + 1);
                if (n3 >= 0) continue;
                n3 = string.length();
            }
        }
        if (vector.size() == 0) {
            // empty if block
        }
        return vector;
    }

    public static ArrayList getRequirementsFromString_Obsolete(String string) {
        ArrayList<Requirement> arrayList = new ArrayList<Requirement>();
        int n = string.indexOf("room-requirements");
        if (n > 0) {
            int n2 = string.indexOf("requirement", n += 17);
            int n3 = string.indexOf("requirement", n2 + 1);
            if (n3 < 0) {
                n3 = string.length();
            }
            while (n2 > 0 && n2 < n3) {
                String string2 = string.substring(n2 += 11, n3);
                Requirement requirement = RoomTemplate.getRequirementFromString(string2);
                arrayList.add(requirement);
                n3 = string.indexOf("requirement", (n2 = string.indexOf("requirement", n2 + 1)) + 1);
                if (n3 >= 0) continue;
                n3 = string.length();
            }
        }
        if (arrayList.size() == 0) {
            // empty if block
        }
        return arrayList;
    }

    public static ArrayList getRequirementsFromString(String string) {
        ArrayList<Requirement> arrayList = new ArrayList<Requirement>();
        int n = string.indexOf("room-requirements");
        int n2 = RoomTemplate.getCloseParenIndex(string, n + 1);
        while (n >= 0 && (n = string.indexOf(40, n)) <= n2 && n >= 0) {
            int n3 = RoomTemplate.getCloseParenIndex(string, n + 1);
            if (n3 < 0) {
                System.out.println("ERROR: check syntax for room-requirements");
                return arrayList;
            }
            String string2 = string.substring(n, n3 + 1);
            n = n3 + 1;
            Requirement requirement = RoomTemplate.getRequirementFromString(string2);
            arrayList.add(requirement);
        }
        if (arrayList.size() == 0) {
            // empty if block
        }
        return arrayList;
    }

    public static int getCloseParenIndex(String string, int n) {
        int n2 = 1;
        while (n < string.length()) {
            switch (string.charAt(n)) {
                case '(': {
                    ++n2;
                    break;
                }
                case ')': {
                    --n2;
                }
            }
            if (n2 == 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private static Requirement getRequirementFromString(String string) {
        try {
            int n;
            double d = 0.5;
            double d2 = 1.0;
            Requirement requirement = null;
            int n2 = string.indexOf(40, 1);
            while (n2 + 1 < string.length() && (n = RoomTemplate.getCloseParenIndex(string, n2 + 1)) >= 0) {
                String string2 = string.substring(n2 + 1, n);
                n2 = string.indexOf(40, n + 1);
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                String string3 = stringTokenizer.nextToken();
                if (string3.equals("importance")) {
                    d = Double.parseDouble(stringTokenizer.nextToken());
                    continue;
                }
                if (string3.equals("hardness")) {
                    d2 = Double.parseDouble(stringTokenizer.nextToken());
                    continue;
                }
                String string4 = stringTokenizer.nextToken();
                if (string4.equals(":numeric")) {
                    double[] dArray = new double[]{Double.parseDouble(stringTokenizer.nextToken()), Double.parseDouble(stringTokenizer.nextToken()), Double.parseDouble(stringTokenizer.nextToken())};
                    Arrays.sort(dArray);
                    double d3 = dArray[0];
                    double d4 = dArray[1];
                    double d5 = dArray[2];
                    requirement = new NumericRequirement(string3, d2, d, d3, d5, d4);
                    continue;
                }
                if (string4.equals(":member")) {
                    int n3 = string2.indexOf(40);
                    int n4 = RoomTemplate.getCloseParenIndex(string2, n3 + 1);
                    String string5 = string2.substring(n3, n4 + 1);
                    requirement = new MemberRequirement(string3, d2, d, string5);
                    continue;
                }
                System.out.println("UNKNOWN room requirement[" + string3 + "] ignored...");
            }
            requirement.setImportance(d);
            requirement.setHardness(d2);
            return requirement;
        }
        catch (Exception exception) {
            System.out.println(string);
            exception.printStackTrace();
            return null;
        }
    }

    public TimeSlot getHighestPriorityTimeSlot(String string, double d) {
        Vector vector = this.getTimeSlotsFromStatus(string);
        double d2 = d;
        TimeSlot timeSlot = null;
        for (int i = 0; i < vector.size(); ++i) {
            TimeSlot timeSlot2 = (TimeSlot)vector.get(i);
            String string2 = timeSlot2.location + "-" + String.valueOf(timeSlot2.st());
            if (this.isFailedRoom(string2) || !(timeSlot2.priority > d2)) continue;
            timeSlot = timeSlot2;
            d2 = timeSlot2.priority;
        }
        return timeSlot;
    }

    private static Requirement getRequirementFromString_Obsolete(String string) {
        String string2 = string.trim();
        String[] stringArray = string.split("[()]");
        String string3 = stringArray[0];
        int n = 0;
        while (string3.matches("[ \t\n]*")) {
            string3 = stringArray[++n];
        }
        string3 = string3.trim();
        String string4 = stringArray[++n];
        while (string4.matches("[ \t\n]*")) {
            string4 = stringArray[++n];
        }
        string4 = string4.trim();
        String string5 = stringArray[++n];
        while (string5.matches("[ \t\n]*")) {
            string5 = stringArray[++n];
        }
        string5 = string5.trim();
        String[] stringArray2 = string3.split(" ");
        String string6 = stringArray2[0];
        String string7 = stringArray2[1];
        float f = new Float(string4.split(" ")[1]).floatValue();
        float f2 = new Float(string5.split(" ")[1]).floatValue();
        if (string7.equals(":numeric")) {
            double[] dArray = new double[]{new Double(stringArray2[2]), new Double(stringArray2[3]), new Double(stringArray2[4])};
            Arrays.sort(dArray);
            double d = dArray[0];
            double d2 = dArray[1];
            double d3 = dArray[2];
            return new NumericRequirement(string6, f2, f, d, d3, d2);
        }
        if (string7.equals(":enum")) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 2; i < stringArray2.length; ++i) {
                String string8 = stringArray2[i];
                if (string8.startsWith("\"")) {
                    string8 = string8.substring(1, string8.length() - 1);
                }
                arrayList.add(string8);
            }
            return new EnumRequirement(string6, f2, f, arrayList);
        }
        if (string7.equals(":numeric-k")) {
            System.out.println("ERROR: type [" + string7 + "] NOT IMPLEMENTED!!!!");
            return null;
        }
        if (string7.equals(":member")) {
            System.out.println("type [" + string7 + "] s=" + string);
            String string9 = "";
            return new MemberRequirement(string6, f2, f, string9);
        }
        System.out.println("Unrecognized type");
        return null;
    }

    public static Template getTemplateFromString(String string) {
        RoomTemplate roomTemplate = new RoomTemplate();
        roomTemplate.meetingId = RoomTemplate.getMeetingIdFromString(string);
        roomTemplate.msgId = RoomTemplate.getMsgIdFromString(string);
        roomTemplate.timeStamp = RoomTemplate.getTimeStampFromString(string);
        roomTemplate.initiator = RoomTemplate.getInitiatorFromString(string);
        roomTemplate.duration = RoomTemplate.getDurationFromString(string);
        roomTemplate.timeSlots = RoomTemplate.getTimeSlotsFromString(string);
        roomTemplate.attendants = RoomTemplate.getAttendantsFromString(string);
        roomTemplate.purposes = RoomTemplate.getPurposesFromString(string);
        roomTemplate.requirements = RoomTemplate.getRequirementsFromString(string);
        return roomTemplate;
    }

    public static Vector getTemplatesFromString(String string) {
        Vector<RoomTemplate> vector = new Vector<RoomTemplate>();
        int n = string.indexOf("templates");
        if (n > 0) {
            int n2 = string.indexOf("rtemplate", n += 9);
            int n3 = string.indexOf("rtemplate", n2 + 1);
            if (n3 < 0) {
                n3 = string.length();
            }
            while (n2 > 0 && n2 < n3) {
                String string2 = string.substring(n2 += 8, n3);
                RoomTemplate roomTemplate = (RoomTemplate)RoomTemplate.getTemplateFromString(string2);
                vector.add(roomTemplate);
                n3 = string.indexOf("rtemplate", (n2 = string.indexOf("rtemplate", n2 + 1)) + 1);
                if (n3 >= 0) continue;
                n3 = string.length();
            }
        }
        if (vector.size() == 0) {
            // empty if block
        }
        return vector;
    }

    public String toLispList() {
        Object object;
        int n;
        StringBuffer stringBuffer = new StringBuffer("(rtemplate ");
        stringBuffer.append("(meeting-id \"" + this.meetingId + "\") ");
        stringBuffer.append("(msg-id \"" + this.msgId + "\") ");
        stringBuffer.append("(timestamp \"" + this.timeStamp + "\") ");
        stringBuffer.append("(initiator \"" + this.initiator + "\") ");
        stringBuffer.append("(duration " + (int)this.duration + ") ");
        stringBuffer.append("(time-slots ");
        for (n = 0; n < this.timeSlots.size(); ++n) {
            object = (TimeSlot)this.timeSlots.elementAt(n);
            stringBuffer.append("(time-slot  ");
            if (((TimeSlot)object).location != null) {
                stringBuffer.append("(room-id \"" + ((TimeSlot)object).location + "\") ");
            }
            stringBuffer.append("(earliest-start-time \"" + ((TimeSlot)object).earliestStartTime + "\") ");
            stringBuffer.append("(latest-finish-time \"" + ((TimeSlot)object).latestFinishTime + "\") ");
            stringBuffer.append("(start-time \"" + ((TimeSlot)object).startTime + "\") ");
            stringBuffer.append("(finish-time \"" + ((TimeSlot)object).finishTime + "\") ");
            stringBuffer.append("(priority " + ((TimeSlot)object).priority + ") ");
            stringBuffer.append("(status \"" + this.getStatus((TimeSlot)object) + "\")) ");
        }
        stringBuffer.append(")");
        stringBuffer.append("(attendants ");
        for (n = 0; n < this.attendants.size(); ++n) {
            object = (Template.attendant)this.attendants.elementAt(n);
            stringBuffer.append("(attendant ");
            stringBuffer.append("(id \"" + ((Template.attendant)object).id + "\") ");
            stringBuffer.append("(level " + ((Template.attendant)object).level + ")) ");
        }
        stringBuffer.append(")");
        stringBuffer.append("(room-requirements");
        for (n = 0; n < this.requirements.size(); ++n) {
            stringBuffer.append(this.requirements.get(n).toString());
        }
        stringBuffer.append(")");
        stringBuffer.append("(purposes ");
        for (n = 0; n < this.purposes.size(); ++n) {
            object = (Template.purpose)this.purposes.elementAt(n);
            stringBuffer.append("(purpose ");
            stringBuffer.append("(predefined-kind \"" + ((Template.purpose)object).predefinedKind + "\") ");
            if (((Template.purpose)object).expectedGain != null) {
                stringBuffer.append("(expected-gain " + ((Template.purpose)object).expectedGain + ") ");
            }
            stringBuffer.append("(description \"" + ((Template.purpose)object).description + "\") ");
            stringBuffer.append(")");
        }
        stringBuffer.append(")");
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void fillInTestData1() {
        this.meetingId = "MT4623";
        this.msgId = "MGS1002";
        this.timeStamp = "2003-06-23 [14:08 -0500]";
        this.initiator = "mmv@cs.cmu.edu";
        this.duration = 3600.0;
        TimeSlot timeSlot = new TimeSlot();
        timeSlot.location = "NSH123";
        timeSlot.earliestStartTime = "2003-06-25 [9:00 -0500]";
        timeSlot.latestFinishTime = "2003-06-25 [17:00 -0500]";
        timeSlot.startTime = "2003-06-25 [15:00 -0500]";
        timeSlot.finishTime = "2003-06-25 [16:00 -0500]";
        timeSlot.priority = 1.0;
        this.addTimeSlot(timeSlot, "possible");
        Template.attendant attendant2 = new Template.attendant(this);
        attendant2.id = "sfs@cs.cmu.edu";
        attendant2.level = 1.0;
        this.attendants.addElement(attendant2);
        Template.attendant attendant3 = new Template.attendant(this);
        attendant3.id = "mmv@cs.cmu.edu";
        attendant3.level = 1.0;
        this.attendants.addElement(attendant3);
        Template.purpose purpose2 = new Template.purpose(this);
        purpose2.predefinedKind = "radar-working-meeting";
        purpose2.description = "working meeting for the Radar project";
        this.purposes.addElement(purpose2);
        NumericRequirement numericRequirement = new NumericRequirement("capacity", 0.9f, 0.9f, 10.0, 20.0, 15.0);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("computer");
        arrayList.add("overhead");
        EnumRequirement enumRequirement = new EnumRequirement("projector", 0.9f, 0.9f, arrayList);
        this.requirements.add(numericRequirement);
        this.requirements.add(enumRequirement);
    }

    public static void main(String[] stringArray) {
        String string = Template.FiletoString(stringArray[0]);
        RoomTemplate roomTemplate = (RoomTemplate)RoomTemplate.getTemplateFromString(string);
        String string2 = roomTemplate.toLispList();
        RoomTemplate roomTemplate2 = (RoomTemplate)RoomTemplate.getTemplateFromString(string2);
        System.out.println(roomTemplate2.toLispList());
    }
}

