//package edu.cmu.cs.radar.integ;
package cmradar;

import java.io.*;
import java.util.*;
import java.awt.Frame;
import org.apache.log4j.*;
import cmradar.manager.data.*;
import cmradar.manager.sim.Simulator;
import edu.cmu.cs.radar.integ.*;
import edu.cmu.cs.radar.integ.ICMRadarProvides.EventInformation;
import edu.cmu.cs.radar.integ.ICMRadarProvides.EventInformation.Preference;

public class CMRadarTest implements IRadarServices {

    Properties prop;
    public CMRadarTest () {
	prop = new Properties();
	try {
	    FileInputStream in = new FileInputStream("radar.properties");
	    prop.load(in);
	    in.close();
	}catch(Exception ex) {
	    ex.printStackTrace();
	    System.exit(0);
	}
    }

    public void foundRoom(ICMRadarRequires.Reservation rsrv) {
	System.out.println("\n CMRADAR found a room " + rsrv);
	//cmradar.manager.sim.Utility.waitForKey(true);
	// <<<< process returned reservation here
    }

    public Map sessionRequirements(String sessionID) {
	HashMap map = new HashMap();
	return map;
    }

    public Properties getProps(){ return prop; }
    public String getUser() { return null; }
    public String getRoot() { return null; }
    public void iconify(Frame x) {}
    public void deiconify(Frame x) {}
    public void radarScriptCall(String s, String arg) {}

    public static void main(String[] args) {
	
	String filePrefix = "";
	int nReqs = 2;
	int maxHrs = 4;
	if(args.length == 0) {
	    System.out.println("java cmradar.CMRadarTest filePrefix test_count [scheduleLogLevel]\n");
	    System.exit(0);
	}
	if (args.length > 0) filePrefix = args[0]; 
	if (args.length > 1) nReqs = Integer.parseInt(args[1]);
	if (args.length > 2) Simulator.schedulerLogLevel = Integer.parseInt(args[2]); // default:0

	// Log4J
	PropertyConfigurator.configure("radar.properties");

	CMRadarTest radar = new CMRadarTest(); // <<< radar handle

	for(int i=0; i<nReqs; ++i) {
	
	    String file = filePrefix + i;
	    CMRadarShim myCmradar = new CMRadarShim();
	
	    // initialize with the radar handle 
	    // switch property file for each test set
	    myCmradar.initialize(radar);//, file + ".properties");

	    Vector requests = RoomTemplate.getTemplatesFromString(Template.FiletoString(file + ".requests"));	
	    for(int j=0; j<requests.size(); ++j) {
		RoomTemplate rt = (RoomTemplate) requests.elementAt(j);
		EventInformation ei = rt.toEventInformation();
		//System.out.println("\n***CMRADAR RCV rt=" + rt + "\nei=" + ei);
		myCmradar.requestRoom(ei);
	    }	
	    
	    // wait until there's no more active requests
	    while(true) {
		if (myCmradar.done()) break; // done if there's no active requests
		try { Thread.sleep(1000); } catch (Exception ex) {}	    
	    }
	    
	    // print result statistics
	    myCmradar.printStat();
	    
	    cmradar.manager.sim.Utility.waitForKey(true);

	    // finish up the testing
	    myCmradar.shutdown();	
	}
    }
}