/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import edu.cmu.cs.radar.rhai.spacetime.STMBackendController;
import edu.cmu.cs.radar.rhai.spacetime.Services;
import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeWindowFrame;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeSession;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.apache.log4j.varia.NullAppender;

public class Entry {
    public static SpaceTimeWindowFrame _frame;

    public static void main(String[] args) {
        Entry.start(args);
    }

    public static void start(String[] args) {
        SpaceTimeSession stmSession;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String stmPath = null;
        boolean debugModeOn = true;
        if (args != null) {
            String[] stringArray = args;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String arg = stringArray[n];
                if (arg.startsWith("-debug=")) {
                    debugModeOn = Boolean.valueOf(arg.substring(arg.indexOf(61) + 1));
                }
                if (arg.startsWith("-stmPath=")) {
                    stmPath = arg.substring(arg.indexOf(61) + 1);
                }
                ++n;
            }
        }
        Services.initLogger(debugModeOn);
        if (!debugModeOn) {
            Logger.getRootLogger().removeAllAppenders();
            Logger.getRootLogger().addAppender(new NullAppender());
        }
        Properties radarProperties = new Properties();
        radarProperties.put("radar.stp.iiop.hostname", "localhost");
        radarProperties.put("radar.stp.iiop.port", "8087");
        if (stmPath != null) {
            radarProperties.put("radar.stp.st-module.path", stmPath);
            stmSession = STMBackendController.startSTMBackend(radarProperties, Services.logger, true);
        } else {
            stmSession = SpaceTimeSession.createInstance(radarProperties);
        }
        if (stmSession == null || stmSession.getDataAdapter() == null) {
            JOptionPane.showMessageDialog(null, "Unable to connect to STM backend", "Fatal error", 0);
            System.exit(0);
        }
        Runtime.getRuntime().addShutdownHook(new ShutdownThread());
        _frame = new SpaceTimeWindowFrame(stmSession, null);
        _frame.setVisible(true);
    }

    public static void vendorEmailArrived(String extraction) {
        if (_frame != null) {
            _frame.getStmSession().processVOP(extraction);
        }
    }

    private static class ShutdownThread
    extends Thread {
        private ShutdownThread() {
        }

        @Override
        public void run() {
            System.out.println("Shutting down STM Backend");
            _frame.getStmSession().shutdown();
            System.out.println("STM Backend shut down");
        }
    }
}

