/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import edu.cmu.cs.radar.rhai.spacetime.DetailsPanel;
import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeWindowFrame;
import edu.cmu.cs.radar.rhai.spacetime.SpringUtilities;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeNode;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeProperty;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.NumberFormatter;

public class EditNodePropertiesDialog
extends JDialog
implements FocusListener {
    private static final long serialVersionUID = 1L;
    private SpaceTimeNode _node;
    private boolean _localPropertiesOnly;
    private String _nullValueString;
    private List<Object[]> _propertyAndTextFieldList;
    private JPanel _propertyEditors;

    public EditNodePropertiesDialog(String title, SpaceTimeNode node, boolean localPropertiesOnly, String nullValueString) {
        super(SpaceTimeWindowFrame.s_singleton, title, true);
        this._node = node;
        this._localPropertiesOnly = localPropertiesOnly;
        this._nullValueString = nullValueString;
        this._propertyAndTextFieldList = new ArrayList<Object[]>();
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this._propertyEditors = this.buildPropertyEditors();
        JScrollPane propertyEditorsScroll = new JScrollPane(this._propertyEditors);
        propertyEditorsScroll.setVerticalScrollBarPolicy(22);
        propertyEditorsScroll.setHorizontalScrollBarPolicy(30);
        propertyEditorsScroll.getVerticalScrollBar().setUnitIncrement(40);
        propertyEditorsScroll.setBorder(null);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(new JButton(new CancelAction()));
        buttonPanel.add(Box.createHorizontalStrut(5));
        JButton saveButton = new JButton(new SaveAction());
        buttonPanel.add(saveButton);
        this.getRootPane().setDefaultButton(saveButton);
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BoxLayout(contentPanel, 3));
        contentPanel.add(propertyEditorsScroll);
        contentPanel.add(Box.createVerticalStrut(5));
        contentPanel.add(buttonPanel);
        this.setContentPane(contentPanel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        propertyEditorsScroll.setVerticalScrollBarPolicy(20);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                new CancelAction().actionPerformed(null);
            }
        });
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getParent().getSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension parentSize = this.getParent().getSize();
        Dimension preferredSize = super.getPreferredSize();
        int width = Math.min(parentSize.width, preferredSize.width);
        int height = Math.min(parentSize.height, preferredSize.height);
        return new Dimension(width, height);
    }

    private JPanel buildPropertyEditors() {
        JPanel editors = new JPanel();
        editors.setLayout(new BoxLayout(editors, 3));
        Map<String, List<SpaceTimeProperty>> categories = DetailsPanel.collectCategories(this._node, false);
        Set<String> localPropertyTypes = this._node.getLocalPropertyTypes();
        ArrayList categoryLabels = new ArrayList(categories.keySet());
        Collections.sort(categoryLabels);
        ArrayList<JLabel> labels = new ArrayList<JLabel>();
        for (String categoryLabel : categoryLabels) {
            List<SpaceTimeProperty> propertyGroup = categories.get(categoryLabel);
            propertyGroup = this.filterPropertyList(propertyGroup, localPropertyTypes);
            if ((propertyGroup = this.sortCategory(categoryLabel, propertyGroup)).size() <= 0) continue;
            JPanel group = new JPanel(new SpringLayout());
            group.setBorder(BorderFactory.createTitledBorder(categoryLabel));
            for (SpaceTimeProperty property : propertyGroup) {
                Object value;
                JComponent editor = null;
                String[] allowedValues = property.getAllowedValues();
                if (allowedValues == null) {
                    DefaultFormatter formatter = null;
                    switch (property.getDataType()) {
                        case 0: {
                            PropertyNumberFormatter nonNegativeIntegerFormatter = new PropertyNumberFormatter(NumberFormat.getIntegerInstance());
                            nonNegativeIntegerFormatter.setValueClass(Integer.class);
                            nonNegativeIntegerFormatter.setMinimum(new Integer(0));
                            nonNegativeIntegerFormatter.setMaximum(new Integer(Integer.MAX_VALUE));
                            formatter = nonNegativeIntegerFormatter;
                            break;
                        }
                        case 6: {
                            PropertyNumberFormatter nonNegativeCurrencyFormatter = new PropertyNumberFormatter(NumberFormat.getCurrencyInstance(), true);
                            nonNegativeCurrencyFormatter.setValueClass(Double.class);
                            nonNegativeCurrencyFormatter.setMinimum(new Double(0.0));
                            nonNegativeCurrencyFormatter.setMaximum(new Double(1.6777215E7));
                            formatter = nonNegativeCurrencyFormatter;
                            break;
                        }
                        case 2: {
                            formatter = new DefaultFormatter();
                        }
                    }
                    value = null;
                    String displayWhenValueNull = null;
                    switch (property.getStoredDataType()) {
                        case 0: {
                            value = new Integer(property.getIntValue());
                            break;
                        }
                        case 7: {
                            value = new Double(property.getMoneyValue());
                            break;
                        }
                        case 2: {
                            value = property.getStringValue();
                            if (this._nullValueString == null || !this._nullValueString.equals(value)) break;
                            displayWhenValueNull = this._nullValueString;
                            value = null;
                            break;
                        }
                        case 4: {
                            displayWhenValueNull = property.getDisplayValueString();
                        }
                    }
                    formatter.setAllowsInvalid(false);
                    formatter.setOverwriteMode(false);
                    JFormattedTextField ftf = new JFormattedTextField(formatter);
                    ftf.putClientProperty("display-when-value-null", displayWhenValueNull);
                    ftf.putClientProperty("label", property.getDisplayLabel());
                    ftf.setColumns(10);
                    ftf.setEditable(property.isEditable());
                    ftf.setFocusable(property.isEditable());
                    ftf.setValue(value);
                    ftf.addFocusListener(this);
                    editor = ftf;
                } else {
                    JComboBox<String> cbox = new JComboBox<String>(allowedValues);
                    cbox.insertItemAt("", 0);
                    cbox.setEditable(false);
                    value = property.getStringValue();
                    if (this._nullValueString != null && this._nullValueString.equals(value)) {
                        cbox.setSelectedIndex(0);
                    } else {
                        cbox.setSelectedItem(value);
                    }
                    editor = cbox;
                }
                JLabel label = new JLabel(String.valueOf(property.getDisplayLabel()) + ":", 11);
                group.add(label);
                label.setLabelFor(editor);
                group.add(editor);
                editor.setFont(label.getFont());
                this._propertyAndTextFieldList.add(new Object[]{property, editor});
                labels.add(label);
            }
            group.putClientProperty("rows", new Integer(propertyGroup.size()));
            editors.add(group);
        }
        int maxLabelWidth = 0;
        for (JLabel label : labels) {
            maxLabelWidth = Math.max(maxLabelWidth, label.getPreferredSize().width);
        }
        for (JLabel label : labels) {
            Dimension preferredSize = label.getPreferredSize();
            preferredSize.width = maxLabelWidth;
            label.setPreferredSize(preferredSize);
        }
        Component[] components = editors.getComponents();
        Component[] componentArray = components;
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            Component element = componentArray[n];
            JComponent group = (JComponent)element;
            Integer rows = (Integer)group.getClientProperty("rows");
            SpringUtilities.makeCompactGrid(group, rows, 2, 5, 5, 5, 5);
            ++n;
        }
        return editors;
    }

    private List<SpaceTimeProperty> filterPropertyList(List<SpaceTimeProperty> propertyGroup, Set<String> localPropertyTypes) {
        ArrayList<SpaceTimeProperty> filteredPropertyList = new ArrayList<SpaceTimeProperty>();
        for (SpaceTimeProperty property : propertyGroup) {
            int dataType;
            if (this._localPropertiesOnly && !localPropertyTypes.contains(property.getPropertyType()) || (dataType = property.getDataType()) != 0 && dataType != 2 && dataType != 6) continue;
            filteredPropertyList.add(property);
        }
        return filteredPropertyList;
    }

    protected List<SpaceTimeProperty> sortCategory(String categoryLabel, List<SpaceTimeProperty> properties) {
        Collections.sort(properties, SpaceTimeProperty.sLabelAndDisplayStringComparator);
        return properties;
    }

    @Override
    public void focusGained(FocusEvent e) {
        Rectangle rect = SwingUtilities.convertRectangle(e.getComponent().getParent(), e.getComponent().getBounds(), this._propertyEditors);
        this._propertyEditors.scrollRectToVisible(rect);
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    private class PropertyNumberFormatter
    extends NumberFormatter {
        private static final long serialVersionUID = 381360960661771996L;
        boolean _enableCurrencyTweaks;

        public PropertyNumberFormatter(NumberFormat format) {
            this(format, false);
        }

        public PropertyNumberFormatter(NumberFormat format, boolean enableCurrencyTweaks) {
            super(format);
            this._enableCurrencyTweaks = enableCurrencyTweaks;
        }

        @Override
        public Object stringToValue(String text) throws ParseException {
            if ((text == null || text.length() == 0) && EditNodePropertiesDialog.this._nullValueString != null) {
                return null;
            }
            if (this._enableCurrencyTweaks) {
                if (text.equals("$")) {
                    text = "$0";
                }
                if (!text.startsWith("$")) {
                    text = "$" + text;
                }
            }
            return super.stringToValue(text);
        }

        @Override
        public String valueToString(Object value) throws ParseException {
            JFormattedTextField tft = this.getFormattedTextField();
            tft.setForeground(Color.black);
            if (value == null) {
                Object displayWhenValueNull = tft.getClientProperty("display-when-value-null");
                if (!tft.hasFocus() && displayWhenValueNull != null) {
                    if (tft.isEditable()) {
                        tft.setForeground(Color.gray);
                    }
                    return displayWhenValueNull.toString();
                }
                return "";
            }
            return super.valueToString(value);
        }
    }

    private class SaveAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public SaveAction() {
            super("Save");
            this.putValue("MnemonicKey", new Integer(83));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block5: for (Object[] objs : EditNodePropertiesDialog.this._propertyAndTextFieldList) {
                SpaceTimeProperty property = (SpaceTimeProperty)objs[0];
                if (!property.isEditable()) continue;
                JComponent editor = (JComponent)objs[1];
                Object value = null;
                if (editor instanceof JFormattedTextField) {
                    JFormattedTextField textField = (JFormattedTextField)editor;
                    value = textField.getValue();
                } else if (editor instanceof JComboBox) {
                    JComboBox comboBox = (JComboBox)editor;
                    String selectedItem = (String)comboBox.getSelectedItem();
                    Object object = value = selectedItem.length() > 0 ? selectedItem : null;
                }
                if (value != null) {
                    switch (property.getDataType()) {
                        case 0: {
                            int newIntValue = (Integer)value;
                            if (property.getStoredDataType() == 0 && property.getIntValue() == newIntValue) continue block5;
                            property.setIntValue(newIntValue);
                            break;
                        }
                        case 2: {
                            String newStringValue = (String)value;
                            if (property.getStoredDataType() == 2 && property.getStringValue().equals(newStringValue)) continue block5;
                            property.setStringValue(newStringValue);
                            break;
                        }
                        case 6: {
                            double newMoneyValue = (Double)value;
                            if (property.getStoredDataType() == 7 && property.getMoneyValue() == newMoneyValue) continue block5;
                            property.setMoneyValue(newMoneyValue);
                        }
                    }
                    continue;
                }
                if (property.getStoredDataType() == 4 || EditNodePropertiesDialog.this._nullValueString == null || property.getStoredDataType() == 2 && property.getStringValue().equals(EditNodePropertiesDialog.this._nullValueString)) continue;
                property.setStringValue(EditNodePropertiesDialog.this._nullValueString);
            }
            EditNodePropertiesDialog.this.setVisible(false);
        }
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CancelAction() {
            super("Cancel");
            this.putValue("MnemonicKey", new Integer(67));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EditNodePropertiesDialog.this.setVisible(false);
        }
    }
}

