/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.calendar;

import edu.cmu.cs.radar.rhai.calendar.AbstractCalendarObjectCollection;
import edu.cmu.cs.radar.rhai.calendar.CalendarObject;
import edu.cmu.cs.radar.rhai.calendar.CalendarObjectCollection;
import edu.cmu.cs.radar.rhai.calendar.CalendarObjectView;
import edu.cmu.cs.radar.rhai.calendar.Time;
import edu.cmu.cs.radar.rhai.calendar.TimeView;
import edu.cmu.cs.radar.rhai.spacetime.SwingHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class TimeGrid
extends TimeView
implements CalendarObjectCollection.Listener {
    private static final long serialVersionUID = 1L;
    protected CalendarObjectCollection mCalendarObjectCollection;
    protected Map<CalendarObject, CalendarObjectView> mCalendarObjectViewMap;

    public TimeGrid(CalendarObjectCollection calObjCol, Time.Range range) {
        super(range);
        this.setLayout(new TimeGridLayoutManager());
        this.mCalendarObjectViewMap = new HashMap<CalendarObject, CalendarObjectView>();
        if (calObjCol != null) {
            this.mCalendarObjectCollection = calObjCol;
            this.mCalendarObjectCollection.addCalendarObjectCollectionListener(this);
        }
    }

    @Override
    public void calendarObjectAdded(AbstractCalendarObjectCollection source, CalendarObject calObj) {
        if (source == this.mCalendarObjectCollection) {
            this.add(calObj);
        }
    }

    @Override
    public void calendarObjectRemoved(AbstractCalendarObjectCollection source, CalendarObject calObj) {
        if (source == this.mCalendarObjectCollection) {
            this.remove(calObj);
        }
    }

    @Override
    public void calendarObjectChanged(AbstractCalendarObjectCollection source, CalendarObject calObj) {
    }

    protected void add(CalendarObject calObj) {
        if (this.mCalendarObjectViewMap.containsKey(calObj)) {
            throw new IllegalArgumentException(String.valueOf(calObj.toString()) + " is alread showing in this TimeGrid");
        }
        CalendarObjectView cov = new CalendarObjectView(calObj);
        this.mCalendarObjectViewMap.put(calObj, cov);
        this.add((Component)cov, new Integer(cov.getLayer()));
        this.revalidate();
    }

    protected void remove(CalendarObject calObj) {
        CalendarObjectView cov = this.mCalendarObjectViewMap.remove(calObj);
        if (cov == null) {
            throw new IllegalArgumentException(String.valueOf(calObj.toString()) + " is not showing in this TimeGrid");
        }
        this.remove(cov);
        this.revalidate();
    }

    public void add(CalendarObjectView cov) {
        this.add((Component)cov, new Integer(cov.getLayer()));
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = SwingHelper.prepareGraphics(g);
        Time currentTime = this.getStart().roundDownToHour();
        Time lastHour = this.getEnd().roundUpToHour();
        while (true) {
            int y = this.getValueForTimeAsInteger(currentTime);
            g2.setColor(currentTime.isHour() ? HOUR_GRAY : QUARTER_HOUR_GRAY);
            g2.drawLine(0, y, this.getWidth(), y);
            if (currentTime.afterOrEqual(lastHour)) break;
            currentTime = currentTime.addMinutes(15);
        }
        g2.setColor(Color.GRAY);
        g2.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dim = super.getMinimumSize();
        dim.width = 150;
        return dim;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.width = 150;
        return dim;
    }

    public CalendarObjectView getCalendarObject(String id) {
        Component[] children;
        if (id == null) {
            throw new NullPointerException("argument 'id'");
        }
        Component[] componentArray = children = this.getComponents();
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            Component element = componentArray[n];
            CalendarObjectView cov = (CalendarObjectView)element;
            String covID = cov.getID();
            if (covID != null && id.equals(covID)) {
                return cov;
            }
            ++n;
        }
        return null;
    }

    private static class TimeGridLayoutManager
    implements LayoutManager {
        private TimeGridLayoutManager() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            if (!(comp instanceof CalendarObjectView)) {
                throw new IllegalArgumentException("'comp' is not of type 'CalendarObjectView'");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            if (!(parent instanceof TimeGrid)) {
                throw new IllegalArgumentException("'parent' is not of type 'TimeGrid'");
            }
            TimeGrid timeGrid = (TimeGrid)parent;
            Object object = parent.getTreeLock();
            synchronized (object) {
                Component[] preferenceLayer = timeGrid.getComponentsInLayer(1);
                Component[] existingLayer = timeGrid.getComponentsInLayer(2);
                Component[] proposalLayer = timeGrid.getComponentsInLayer(3);
                Component[] layer = new Component[existingLayer.length + proposalLayer.length];
                System.arraycopy(existingLayer, 0, layer, 0, existingLayer.length);
                System.arraycopy(proposalLayer, 0, layer, existingLayer.length, proposalLayer.length);
                this.doLayout(timeGrid, preferenceLayer);
                this.doLayout(timeGrid, layer);
            }
            parent.repaint();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return parent.getMinimumSize();
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return parent.getPreferredSize();
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        public void doLayout(TimeGrid timeGrid, Component[] children) {
            LinkedList<RangeLayout> rangeLayouts = new LinkedList<RangeLayout>();
            ArrayList<COVLayout> covLayouts = new ArrayList<COVLayout>();
            rangeLayouts.add(new RangeLayout(new Time.Range(new Time(0, 0, 0), new Time(24, 0, 0))));
            Component[] componentArray = children;
            int n = 0;
            int n2 = componentArray.length;
            while (n < n2) {
                Component element = componentArray[n];
                CalendarObjectView cov = (CalendarObjectView)element;
                COVLayout covLayout = this.addCOVToRanges(cov, rangeLayouts);
                covLayouts.add(covLayout);
                ++n;
            }
            for (RangeLayout rangeLayout : rangeLayouts) {
                rangeLayout.backlinkCOVs();
                rangeLayout.computeConflicts();
            }
            Collections.sort(covLayouts);
            for (COVLayout covLayout : covLayouts) {
                covLayout.pickColumn();
            }
            for (COVLayout covLayout : covLayouts) {
                covLayout.propagateColumnCount(covLayout.mColumn);
            }
            for (COVLayout covLayout : covLayouts) {
                covLayout.setBounds(timeGrid);
            }
        }

        private COVLayout addCOVToRanges(CalendarObjectView newCOV, List<RangeLayout> rangeLayouts) {
            RangeLayout before;
            Time.Range.Split<RangeLayout> split;
            RangeLayout cur;
            COVLayout covLayout = new COVLayout(newCOV);
            ListIterator<RangeLayout> iter = rangeLayouts.listIterator();
            while (iter.hasNext()) {
                cur = iter.next();
                if (!cur.getStart().beforeOrEqual(newCOV.getStart()) || !newCOV.getStart().before(cur.getEnd())) continue;
                iter.remove();
                split = cur.splitRangeLayout(newCOV.getStart());
                before = split.getBefore();
                if (before != null) {
                    iter.add(before);
                }
                iter.add(split.getAfter());
                iter.previous();
                break;
            }
            while (iter.hasNext()) {
                cur = iter.next();
                if (cur.getEnd().before(newCOV.getEnd())) {
                    cur.addCOVLayout(covLayout);
                    continue;
                }
                split = cur.splitRangeLayout(newCOV.getEnd());
                before = split.getBefore();
                RangeLayout after = split.getAfter();
                before.addCOVLayout(covLayout);
                iter.set(before);
                if (after == null) break;
                iter.add(after);
                break;
            }
            return covLayout;
        }

        private static class RangeLayout
        extends Time.Range {
            private List<COVLayout> mCOVLayouts;
            private int mColumnCount;
            private BitSet mColumns;

            public RangeLayout(Time.Range range) {
                this(range, null);
            }

            public RangeLayout(Time.Range range, List<COVLayout> covLayout) {
                super(range);
                this.mCOVLayouts = covLayout != null ? covLayout : new ArrayList();
                this.mColumnCount = 0;
                this.mColumns = new BitSet();
                this.mColumns.set(0);
            }

            public void addCOVLayout(COVLayout covLayout) {
                this.mCOVLayouts.add(covLayout);
            }

            public Time.Range.Split<RangeLayout> splitRangeLayout(Time timeToSplit) {
                Time.Range.Split<Time.Range> split = super.split(timeToSplit);
                Time.Range before = split.getBefore();
                Time.Range after = split.getAfter();
                RangeLayout beforeLayoutInfo = before != null ? new RangeLayout(before, new ArrayList<COVLayout>(this.mCOVLayouts)) : null;
                RangeLayout afterLayoutInfo = after != null ? new RangeLayout(after, new ArrayList<COVLayout>(this.mCOVLayouts)) : null;
                return new Time.Range.Split<RangeLayout>(beforeLayoutInfo, afterLayoutInfo);
            }

            public void backlinkCOVs() {
                for (COVLayout covLayout : this.mCOVLayouts) {
                    covLayout.addRangeLayout(this);
                }
            }

            public void computeConflicts() {
                int startsHere = 0;
                for (COVLayout covLayout : this.mCOVLayouts) {
                    if (!covLayout.mCOV.getStart().equals(this.getStart())) continue;
                    ++startsHere;
                }
                int size = this.mCOVLayouts.size();
                for (COVLayout covLayout : this.mCOVLayouts) {
                    if (covLayout.mCOV.getStart().equals(this.getStart())) {
                        covLayout.mTotalConflicts = size - 1;
                    } else {
                        COVLayout cOVLayout = covLayout;
                        cOVLayout.mTotalConflicts = cOVLayout.mTotalConflicts + startsHere;
                    }
                    covLayout.mConcurrentConflicts = Math.max(covLayout.mConcurrentConflicts, size - 1);
                }
            }

            public void propagateColumnCount(int columnCount) {
                if (columnCount <= this.mColumnCount) {
                    return;
                }
                this.mColumnCount = columnCount;
                for (COVLayout covLayout : this.mCOVLayouts) {
                    covLayout.propagateColumnCount(this.mColumnCount);
                }
            }

            @Override
            public String toString() {
                return String.valueOf(super.toString()) + ": " + this.mCOVLayouts.size() + ", " + this.mColumnCount;
            }
        }

        private static class COVLayout
        implements Comparable<COVLayout> {
            private CalendarObjectView mCOV;
            private List<RangeLayout> mRangeLayouts;
            private int mColumn;
            private int mColumnCount;
            private int mConcurrentConflicts;
            private int mTotalConflicts;

            public COVLayout(CalendarObjectView calendarObjectView) {
                this.mCOV = calendarObjectView;
                this.mRangeLayouts = new ArrayList<RangeLayout>();
            }

            @Override
            public int compareTo(COVLayout covLayout) {
                int result = this.mTotalConflicts - covLayout.mTotalConflicts;
                if (result == 0) {
                    Time.Duration duration = this.mCOV.getDuration();
                    Time.Duration otherDuration = covLayout.mCOV.getDuration();
                    result = duration.compareTo(otherDuration);
                }
                if (result == 0) {
                    result = -this.mCOV.getStart().compareTo(covLayout.mCOV.getStart());
                }
                return -result;
            }

            public void addRangeLayout(RangeLayout rangeLayout) {
                this.mRangeLayouts.add(rangeLayout);
            }

            public void pickColumn() {
                BitSet availColumns = new BitSet();
                for (RangeLayout rangeLayout : this.mRangeLayouts) {
                    availColumns.or(rangeLayout.mColumns);
                }
                this.mColumn = availColumns.nextClearBit(0);
                for (RangeLayout rangeLayout : this.mRangeLayouts) {
                    rangeLayout.mColumns.set(this.mColumn);
                }
            }

            public void propagateColumnCount(int columnCount) {
                if (columnCount <= this.mColumnCount) {
                    return;
                }
                this.mColumnCount = columnCount;
                for (RangeLayout rangeLayout : this.mRangeLayouts) {
                    rangeLayout.propagateColumnCount(this.mColumnCount);
                }
            }

            public void setBounds(TimeGrid timeGrid) {
                int width = timeGrid.getWidth();
                int left = (int)Math.round((double)(this.mColumn - 1) / (double)this.mColumnCount * (double)width);
                int right = (int)Math.round((double)this.mColumn / (double)this.mColumnCount * (double)width);
                this.mCOV.setHorizontalBounds(left, right - left);
            }

            public String toString() {
                return String.valueOf(this.mCOV.toString()) + ": " + this.mConcurrentConflicts + ", " + this.mTotalConflicts + ", " + this.mRangeLayouts.size() + ", " + this.mColumn + ", " + this.mColumnCount;
            }
        }
    }
}

