/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.sys.calendar;

import cmradar.manager.data.Meeting;
import cmradar.manager.data.TimeSlot;
import cmradar.manager.sys.calendar.CalendarObjects.MeetingDataLink;
import cmradar.manager.sys.calendar.Table;
import cmradar.manager.sys.calendar.View;
import java.awt.Color;
import java.util.Iterator;

public class Model {
    private String localhost = "localhost";
    private String port = "1234";
    private View view;

    public void addView(View view) {
        this.view = view;
    }

    public void initialize() {
        for (int i = 0; i < this.view.getTable().getTable().getRowCount(); ++i) {
            for (int j = 1; j < Table.numCols; ++j) {
                this.view.getTable().getTable().setValueAt(new MeetingDataLink(null, Color.white), i, j);
            }
        }
    }

    public void updateAll(Iterator iterator) {
        while (iterator.hasNext()) {
            Meeting meeting = (Meeting)iterator.next();
            this.addMeeting(meeting);
        }
    }

    public void addMeeting(Meeting meeting) {
        boolean bl = false;
        TimeSlot timeSlot = meeting.getConfirmedTimeSlot();
        if (timeSlot != null) {
            String string = this.parseTimeSlot(timeSlot.startTime);
            String string2 = this.parseDay(timeSlot.startTime);
            for (int i = 0; i < this.view.getTable().TIMES.length; ++i) {
                if (!string.equals(this.view.getTable().TIMES[i])) continue;
                this.view.getTable().getTable().setValueAt(new MeetingDataLink(meeting, meeting.getColor()), i, Integer.parseInt("" + string2.charAt(9)));
                bl = true;
            }
        }
        if (!bl) {
            System.out.println("Sorry, failed to add meeting " + meeting.getMeetingId() + " into display.");
            System.out.println("Could be caused a misformatted time string (e.g., 9:00 instead of 09:00).");
            System.out.println("See cmradar.manager.sys.calendar.Model.addMeeting() for the brain-dead code that caused this warning. ");
        }
    }

    private String parseTimeSlot(String string) {
        String string2 = "";
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == ' ' || string.charAt(i) == '-') {
                bl = false;
            }
            if (bl) {
                string2 = string2 + string.charAt(i);
            }
            if (string.charAt(i) != '[') continue;
            bl = true;
        }
        return string2;
    }

    private String parseDay(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == ' ') {
                return string2;
            }
            string2 = string2 + string.charAt(i);
        }
        return string2;
    }
}

