/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.sim;

import cmradar.manager.data.Calendar;
import cmradar.manager.data.Meeting;
import cmradar.manager.data.Template;
import cmradar.manager.demo.DemoController;
import cmradar.manager.demo.DemoDisplay;
import cmradar.manager.sim.AgentInfo;
import cmradar.manager.sim.AgentThread;
import cmradar.manager.sim.MeetingInfo;
import cmradar.manager.sim.Message;
import cmradar.manager.sim.MessageCommunicator;
import cmradar.manager.sim.Mode;
import cmradar.manager.sim.QueueEvent;
import cmradar.manager.sim.QueueListener;
import cmradar.manager.sim.RadarLogger;
import cmradar.manager.sim.SimParameters;
import cmradar.manager.sim.Utility;
import cmradar.manager.sys.RManagerIO;
import cmradar.manager.sys.RManagerIOSystem;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Simulator
implements MessageCommunicator {
    SimParameters params;
    AgentThread[] threads;
    DemoController controller;
    Mode mode = Mode.SYNC;
    int cycleCnt = 0;
    Hashtable msgQs = null;
    int msgCnt = 0;
    boolean mutex = false;
    long timeStart;
    long timeEnd;
    int pollTime = 500;
    int timeMax = 3600;
    boolean timeoutCondition = false;
    static int port = 9998;
    static int x = 50;
    static int y = 50;
    RadarLogger simLog = null;
    static Logger logger = Logger.getLogger((String)(class$cmradar$manager$sim$Simulator == null ? (class$cmradar$manager$sim$Simulator = Simulator.class$("cmradar.manager.sim.Simulator")) : class$cmradar$manager$sim$Simulator).getName());
    public static int schedulerLogLevel = 0;
    private Vector listeners = new Vector();
    boolean demo = false;
    public static boolean newMeetingsFileExists = false;
    public static String defaultNewMeetingsFilename = "newmeetings";
    double elapsed = 0.0;
    StringBuffer timeSeries = new StringBuffer();
    static /* synthetic */ Class class$cmradar$manager$sim$Simulator;

    public Simulator() {
    }

    public Simulator(SimParameters simParameters, boolean bl, String[] stringArray) {
        int n;
        this.params = simParameters;
        this.demo = bl;
        this.setUpLogFile();
        PrintWriter printWriter = null;
        String string = SimParameters.outCalendarsFile + ".events";
        try {
            FileWriter fileWriter = new FileWriter(string);
            printWriter = new PrintWriter(fileWriter);
        }
        catch (IOException iOException) {
            System.out.println("Error in opening " + string + " for logging");
            System.out.println("Exiting.");
            System.exit(1);
        }
        if (this.demo) {
            this.controller = new DemoController(bl);
        }
        this.msgQs = new Hashtable(Collections.synchronizedMap(new Hashtable()));
        System.out.println("Begin Simulator run...");
        System.out.print(" Initializing agents and calendars...");
        long l = Utility.TimeMS();
        Vector vector = this.params.getAgents();
        Vector vector2 = this.params.getCalendars();
        this.threads = new AgentThread[vector.size()];
        System.out.println(vector.size());
        for (n = 0; n < vector.size(); ++n) {
            Object object;
            AgentInfo agentInfo = (AgentInfo)vector.elementAt(n);
            if (this.demo) {
                object = new Rectangle(400 + 30 * n, 20 + 30 * n, 350, 550);
                DemoDisplay demoDisplay = new DemoDisplay(agentInfo.getUserName(), agentInfo.getUserId(), (Rectangle)object, this, (Calendar)vector2.get(n));
                this.threads[n] = new AgentThread((MessageCommunicator)this, agentInfo, demoDisplay);
            } else {
                object = new RManagerIOSystem(agentInfo.getUserId());
                this.threads[n] = new AgentThread((MessageCommunicator)this, agentInfo, (RManagerIO)object);
            }
            if (n == 0) {
                port = agentInfo.getPortNumber();
            }
            this.addMsgReceiver(agentInfo.getUserId());
        }
        this.init_calendars(this.params);
        if (!newMeetingsFileExists) {
            while (!newMeetingsFileExists) {
            }
            try {
                this.params.parseNewMeetingsFile(defaultNewMeetingsFilename);
            }
            catch (Exception exception) {
                System.out.println("Could not read file " + defaultNewMeetingsFilename);
                System.exit(0);
            }
        }
        System.out.println("Begin Scheduling...");
        this.timeStart = Utility.TimeMS();
        if (this.mode.isSync()) {
            this.runSynchronousMode();
        } else if (this.mode.isAsync()) {
            this.runAsynchronousMode();
        }
        for (n = 0; n < this.threads.length; ++n) {
            this.threads[n].finish();
        }
        this.timeEnd = Utility.TimeMS();
        this.elapsed = ((double)this.timeEnd - (double)this.timeStart) / 1000.0;
        this.printExecutionStatus();
        System.out.println("Done.");
        this.logFinalStats();
        this.printSummary();
        System.exit(0);
    }

    private void init_calendars(SimParameters simParameters) {
        int n;
        int n2;
        Vector vector = simParameters.getCalendars();
        long l = Utility.TimeMS();
        for (n2 = 0; n2 < this.threads.length; ++n2) {
            this.threads[n2].init();
            this.threads[n2].set_logger(this.simLog);
            for (n = 0; n < vector.size(); ++n) {
                Calendar calendar = (Calendar)vector.get(n);
                if (!calendar.myUserId.equals(this.threads[n2].getUserId())) continue;
                this.threads[n2].set_calendar_and_return(calendar);
                calendar.updated();
            }
        }
        n2 = 0;
        while (n2 == 0) {
            n = 1;
            for (int i = 0; i < this.threads.length; ++i) {
                if (this.threads[i].negotiator.calendarIsSet) continue;
                n = 0;
                break;
            }
            if (n != 0) {
                n2 = 1;
                continue;
            }
            try {
                Thread.sleep(this.pollTime);
            }
            catch (Exception exception) {}
        }
        long l2 = Utility.TimeMS();
        System.out.println("Done. Time(sec) elapsed: " + (l2 - l) / 1000L);
    }

    private static boolean isFileEmpty(String string) {
        File file = new File(string);
        return file.length() == 0L;
    }

    public void runSynchronousMode() {
        int n = -1;
        this.elapsed = ((double)Utility.TimeMS() - (double)this.timeStart) / 1000.0;
        this.logCurrentStats("00000");
        Vector vector = this.params.getNewMeetings();
        for (int i = 0; i < vector.size(); ++i) {
            int n2;
            MeetingInfo meetingInfo = (MeetingInfo)vector.elementAt(i);
            Vector vector2 = new Vector(meetingInfo.getAttendants().keySet());
            String string = "null";
            Meeting meeting = new Meeting(string, meetingInfo.getMeetingId(), meetingInfo.getInitiator(), Meeting.typeStringToInt(meetingInfo.getType()), new Vector(vector2));
            Template template = meeting.toTemplate();
            System.out.println("Sim: Initiate meeting " + template.getMeetingId() + " to " + template.getInitiator());
            for (n2 = 0; n2 < this.threads.length; ++n2) {
                if (!this.threads[n2].getUserId().equals(template.getInitiator())) continue;
                this.sendMessage(template.toLispList(), this.threads[n2].getUserId(), this.threads[n2].getUserId(), false);
            }
            while (!this.QuiDetected() && !this.timeout()) {
                ++this.cycleCnt;
                for (n2 = 0; n2 < this.threads.length; ++n2) {
                    if (this.demo) {
                        this.controller.tryWait();
                    }
                    this.threads[n2].runOneCycle();
                }
                if (this.cycleCnt % 10 != 0) continue;
                this.printExecutionStatus();
                if (this.msgCnt == n) {
                    System.out.println("Deadlock detected!");
                    Utility.waitForKey(true);
                }
                n = this.msgCnt;
            }
        }
    }

    public void runAsynchronousMode() {
        int n = -1;
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i].start();
        }
        Vector vector = this.params.getNewMeetings();
        for (int i = 0; i < vector.size(); ++i) {
            int n2;
            MeetingInfo meetingInfo = (MeetingInfo)vector.elementAt(i);
            Template template = meetingInfo.toTemplate();
            System.out.println("Sim: Initiate meeting " + template.getMeetingId() + " to " + template.getInitiator());
            for (n2 = 0; n2 < this.threads.length; ++n2) {
                if (!this.threads[n2].getUserId().equals(template.getInitiator())) continue;
                this.sendMessage(template.toLispList(), this.threads[n2].getUserId(), this.threads[n2].getUserId(), false);
            }
            n2 = 0;
            while (!this.QuiDetected() && !this.timeout()) {
                try {
                    Thread.sleep(this.pollTime);
                    if ((n2 = (n2 + 1) % 10) != 0) continue;
                    this.printExecutionStatus();
                    if (this.msgCnt == n) {
                        System.out.println("Deadlock detected!");
                    }
                    n = this.msgCnt;
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean QuiDetected() {
        for (int i = 0; i < this.threads.length; ++i) {
            if (!this.threads[i].Qui()) {
                return false;
            }
            String string = this.threads[i].getUserId();
            LinkedList linkedList = (LinkedList)this.msgQs.get(string);
            if (linkedList.size() <= 0) continue;
            return false;
        }
        return true;
    }

    public void printExecutionStatus() {
        String string;
        Object object;
        if (this.mode.isSync()) {
            object = "  cycles elapsed";
            System.out.println((String)object + Utility.fillerString((String)object) + this.cycleCnt);
            String string2 = "  total msgs communicated";
            System.out.println(string2 + Utility.fillerString(string2) + this.msgCnt);
            for (int i = 0; i < this.threads.length; ++i) {
                string = this.threads[i].getUserId();
                LinkedList linkedList = (LinkedList)this.msgQs.get(string);
            }
        } else if (this.mode.isAsync()) {
            double d = ((double)Utility.TimeMS() - (double)this.timeStart) / 1000.0;
            String string3 = "  time elapsed(sec)";
            System.out.println(string3 + Utility.fillerString(string3) + d);
            string = "  total msgs communicated";
            System.out.println(string + Utility.fillerString(string) + this.msgCnt);
        }
        try {
            object = new PrintWriter(new FileWriter(this.params.getOutCalendarsFile()));
            ((PrintWriter)object).println("#Final Calendars \n#-----------------------------------------");
            for (int i = 0; i < this.threads.length; ++i) {
                ((PrintWriter)object).println(this.threads[i].printCalendar());
            }
            ((PrintWriter)object).close();
        }
        catch (IOException iOException) {
            System.err.println("Unable to open the output calendars file for writing.");
            iOException.printStackTrace();
        }
    }

    public void printSummary() {
        if (this.mode.isAsync()) {
            System.out.println("********* TotalTime (secs) " + this.elapsed + " *********");
        } else if (this.mode.isSync()) {
            System.out.println("********* TotalCycles " + this.cycleCnt + " *********");
        }
        System.out.println("********* TotalMsgsSent " + this.msgCnt + " *********");
        System.out.println("********* Thanks for playing ************");
    }

    public boolean timeout() {
        double d = ((double)Utility.TimeMS() - (double)this.timeStart) / 1000.0;
        if (d > (double)this.timeMax) {
            String string = "  Max Time Elapsed";
            System.out.println(string + Utility.fillerString(string) + d);
            this.timeoutCondition = true;
            return true;
        }
        return false;
    }

    public void setUpLogFile() {
        PrintWriter printWriter = null;
        String string = SimParameters.outCalendarsFile + ".log";
        try {
            FileWriter fileWriter = new FileWriter(string);
            printWriter = new PrintWriter(fileWriter);
        }
        catch (IOException iOException) {
            System.out.println("Error in opening " + string + " for logging");
            System.out.println("Exiting.");
            System.exit(1);
        }
        this.simLog = new RadarLogger(printWriter);
        this.simLog.printToLogln("#time\tmtg_id\tagent_id\tslot\tstatus\tquality\n#-----------------------------------------");
    }

    public void logCurrentStats(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < this.threads.length) {
            int n7 = n6++;
            n += this.threads[n7].negotiator.numBumps;
            n2 += this.threads[n7].negotiator.numSuccess();
            n3 += this.threads[n7].negotiator.numFailure();
            n4 += this.threads[n7].negotiator.numRounds();
            n5 += this.threads[n7].negotiator.numMeetings();
        }
        this.timeSeries.append("\n" + this.cycleCnt + "\t" + this.msgCnt + "\t" + n4 + "\t" + this.elapsed + "   " + "\t" + n + "\t" + n2 + "\t" + n3 + "\t" + string + "\t" + n5);
    }

    public void logFinalStats() {
        int n;
        this.simLog.printToLogln("\n\nTime Series Stats: \n===================\n");
        this.simLog.printToLogln("#cyc\tmsgs\trounds\ttime(sec)\tbumps\tsuccess\tfailure\tmid\n#-----------------------------------------------------------------------");
        this.simLog.printToLogln(this.timeSeries.toString());
        this.simLog.printToLogln("\n\nFinal Stats: \n===================\n");
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < this.threads.length) {
            n = n6++;
            n2 += this.threads[n].negotiator.numBumps;
            n3 += this.threads[n].negotiator.numSuccess();
            n4 += this.threads[n].negotiator.numFailure();
            n5 += this.threads[n].negotiator.numRounds();
        }
        this.simLog.printToLogln("\n#cyc\tmsgs\trounds\ttime(sec)\tbumps\tsuccess\tfailure\ttimeout\trun\n#-----------------------------------------------------------------------\n#" + this.cycleCnt + "\t" + this.msgCnt + "\t" + n5 + "\t" + this.elapsed + "    " + "\t" + n2 + "\t" + n3 + "\t" + n4 + "\t" + this.timeoutCondition + "\t" + SimParameters.outCalendarFilePrefix);
        n6 = 0;
        while (n6 < this.threads.length) {
            n = n6++;
            double d = this.threads[n].evaluateSchedule();
            double d2 = this.threads[n].initialQuality();
        }
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(this.params.getOutCalendarsFile()));
            printWriter.println("#Final Calendars \n#-----------------------------------------");
            for (n = 0; n < this.threads.length; ++n) {
                printWriter.println(this.threads[n].printCalendar());
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            System.err.println("Unable to open the output calendars file for writing.");
            iOException.printStackTrace();
        }
    }

    public void logSimLogLine(SimLogLine simLogLine) {
        if (this.simLog != null) {
            String string = simLogLine.mtgid;
            long l = simLogLine.time;
            int n = simLogLine.msgs;
            int n2 = simLogLine.success;
            this.simLog.printToLogln(string + "\t" + l + "\t" + n + "\t" + n2);
        }
    }

    public void addQueueListener(QueueListener queueListener) {
        this.listeners.add(queueListener);
    }

    public void addMsgReceiver(String string) {
        LinkedList linkedList = new LinkedList(Collections.synchronizedList(new LinkedList()));
        this.msgQs.put(string, linkedList);
    }

    public void sendMessage(String string, String string2, String string3) {
        this.sendMessage(string, string2, string3, true);
    }

    public void sendMessage(String string, String string2, String string3, boolean bl) {
        while (this.mutex) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {}
        }
        this.mutex = true;
        LinkedList linkedList = (LinkedList)this.msgQs.get(string3);
        if (linkedList != null) {
            linkedList.addLast(new Message(string, string2, string3, !bl));
            if (bl) {
                ++this.msgCnt;
            }
        } else {
            logger.log((Priority)Level.INFO, (Object)("Simulator.sendMessage(): Unknown agent name: " + string3 + " m=" + string + " from " + string2));
            this.sendMessageToEnvironmentManager(string, string2, string3);
        }
        this.mutex = false;
    }

    public void sendMessageToEnvironmentManager(String string, String string2, String string3) {
        System.out.println("!!!!sendMessageToEnvironmentManager to " + string3);
    }

    public int getNumMessages(String string) {
        LinkedList linkedList = (LinkedList)this.msgQs.get(string);
        return linkedList.size();
    }

    public Message getMessage(String string) {
        while (this.mutex) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {}
        }
        this.mutex = true;
        LinkedList linkedList = (LinkedList)this.msgQs.get(string);
        if (linkedList != null) {
            Message message;
            try {
                message = (Message)linkedList.removeFirst();
            }
            catch (NoSuchElementException noSuchElementException) {
                message = null;
            }
            if (message != null) {
                if (!message.isHidden()) {
                    QueueListener queueListener;
                    QueueEvent queueEvent = new QueueEvent(string, message, 0);
                    Iterator iterator = this.listeners.iterator();
                    while (iterator.hasNext()) {
                        queueListener = (QueueListener)iterator.next();
                        queueListener.queueChanged(queueEvent);
                    }
                    queueEvent = new QueueEvent(string, message, 1);
                    iterator = this.listeners.iterator();
                    while (iterator.hasNext()) {
                        queueListener = (QueueListener)iterator.next();
                        queueListener.queueChanged(queueEvent);
                    }
                }
                this.mutex = false;
                return message;
            }
        } else {
            System.out.println("Simulator.getMessage(): Unknown agent name: " + string);
        }
        this.mutex = false;
        return null;
    }

    private static void printCLIParams() {
        System.out.println("Usage:\n");
        System.out.println("Simulator\n\t\t  -gen agents newmeetings newcalendars\n\t\t| -sched agents oldmeetings calendar newmeetings newcalendars\n\t\t| -rgen agents newcalendars newmeetings\n");
    }

    private static void printUFParams() {
        System.out.println("Usage:\n");
        System.out.println("Simulator\n\t\t| -ufmsched \n\t-agent [.agents file]\n\t-oldmtgs [old meetings file]\n\t-newmtgs [new meetings file]\n\t-oldcal [old calendar file]\n\t-newcal [new calendar file]\n\n\n");
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        if (stringArray.length == 0) {
            Simulator.printCLIParams();
            System.exit(1);
        }
        SimParameters simParameters = new SimParameters();
        try {
            if (stringArray[0].equals("-gen")) {
                if (stringArray.length != 4) {
                    Simulator.printCLIParams();
                    System.exit(1);
                }
                simParameters.parseSimFiles(stringArray[1], stringArray[2], stringArray[3]);
                new Simulator(simParameters, bl, stringArray);
            } else if (stringArray[0].equals("-sched")) {
                if (stringArray.length != 6 && stringArray.length != 7) {
                    Simulator.printCLIParams();
                    System.exit(1);
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equals("-demo")) continue;
                    bl = true;
                }
                if (bl && stringArray.length == 6) {
                    simParameters.parseSimFiles(stringArray[1], stringArray[2], stringArray[3], null, stringArray[4]);
                    newMeetingsFileExists = false;
                } else {
                    simParameters.parseSimFiles(stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5]);
                    newMeetingsFileExists = true;
                }
                new Simulator(simParameters, bl, stringArray);
            } else {
                if (stringArray[0].equals("-rgen")) {
                    System.out.println("-rgen no longer supported");
                    return;
                }
                if (stringArray[0].equals("-rgen2")) {
                    return;
                }
                if (stringArray[0].equals("-rgen3")) {
                    System.out.println("-rgen3 no longer supported");
                    return;
                }
                if (stringArray[0].equals("-ufmsched")) {
                    String string = null;
                    String string2 = null;
                    String string3 = null;
                    String string4 = null;
                    String string5 = null;
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i].equals("-agent")) {
                            if (stringArray.length > ++i) {
                                string = stringArray[i];
                            }
                        } else if (stringArray[i].equals("-oldmtgs")) {
                            if (stringArray.length > ++i) {
                                string2 = stringArray[i];
                            }
                        } else if (stringArray[i].equals("-newmtgs")) {
                            if (stringArray.length > ++i) {
                                string3 = stringArray[i];
                            }
                        } else if (stringArray[i].equals("-oldcal")) {
                            if (stringArray.length > ++i) {
                                string4 = stringArray[i];
                            }
                        } else if (stringArray[i].equals("-newcal")) {
                            if (stringArray.length > ++i) {
                                string5 = stringArray[i];
                            }
                        } else {
                            Simulator.printUFParams();
                        }
                        simParameters.parseSimFiles(string, string2, string4, string3, string5);
                        newMeetingsFileExists = true;
                    }
                    new Simulator(simParameters, bl, stringArray);
                } else {
                    Simulator.printCLIParams();
                    System.exit(1);
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("Error starting simulator. Quitting.");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SimLogLine {
        String mtgid = "0";
        String initiator;
        long time = 0L;
        int msgs = 0;
        int success = 0;
    }
}

