/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.neg;

import cmradar.manager.data.Meeting;
import cmradar.manager.data.Room;
import cmradar.manager.data.RoomTemplate;
import cmradar.manager.data.SharedRoomCalendar;
import cmradar.manager.data.Template;
import cmradar.manager.data.TimeSlot;
import cmradar.manager.neg.AbstractRoomNegotiator;
import cmradar.manager.sched.Scheduler;
import cmradar.manager.sim.MessageCommunicator;
import cmradar.manager.sys.RManagerIO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

public class RoomOwnerSimpleTwoProb
extends AbstractRoomNegotiator {
    HashMap probTable;
    public static int MAX_SMALL_CAPACITY = 15;
    public static int MAX_MED_CAPACITY = 40;
    public static String SMALL = "small";
    public static String MEDIUM = "medium";
    public static String LARGE = "large";

    public RoomOwnerSimpleTwoProb(RManagerIO rManagerIO, String string, String string2, Scheduler scheduler, MessageCommunicator messageCommunicator, HashMap hashMap) {
        super(rManagerIO, string, string2, scheduler, messageCommunicator);
        this.probTable = hashMap;
    }

    public RoomOwnerSimpleTwoProb(RManagerIO rManagerIO, String string, String string2, Scheduler scheduler, MessageCommunicator messageCommunicator, SharedRoomCalendar sharedRoomCalendar, HashMap hashMap) {
        super(rManagerIO, string, string2, scheduler, messageCommunicator, sharedRoomCalendar);
        this.probTable = hashMap;
    }

    public void receive_message(Template template, String string) {
        RoomTemplate roomTemplate = (RoomTemplate)template;
        TimeSlot timeSlot = (TimeSlot)template.getTimeSlotsFromStatus("possible").get(0);
        Room room = this.sharedRCal.getRoomFromId(timeSlot.location);
        this.ioManager.writeLine("\n -> Received request...");
        this.ioManager.writeLine("   * room " + room.getRoomId() + " for " + timeSlot.toParseString());
        this.ioManager.writeLine("\n");
        ArrayList arrayList = this.myMeetingsForTime(timeSlot, room);
        if (arrayList.size() > 0) {
            Meeting meeting = (Meeting)arrayList.get(0);
            this.ioManager.writeLine("\n -> Request conflicts with existing reservation...");
            this.ioManager.writeLine("   * meeting " + meeting.getMeetingId() + " is in room " + room.getRoomId() + " at " + timeSlot.toParseString());
            if (this.decide(arrayList, room)) {
                template.setStatus(timeSlot, "possible");
                this.ioManager.writeLine("   * decided to accept request and bump.");
                this.ioManager.writeLine("\n");
            } else {
                template.setStatus(timeSlot, "impossible");
                this.ioManager.writeLine("   * decided to reject request.");
                this.ioManager.writeLine("\n");
            }
            this.mComm.sendMessage(template.toLispList(), this.myUserId, string);
        }
    }

    protected boolean decide(ArrayList arrayList, Room room) {
        try {
            Random random = new Random();
            for (int i = 0; i < arrayList.size(); ++i) {
                Number number;
                Object object;
                int n = ((Meeting)arrayList.get((int)i)).type;
                Integer n2 = new Integer(((Meeting)arrayList.get((int)i)).type);
                HashMap hashMap = (HashMap)this.probTable.get(n2);
                if (hashMap == null) {
                    System.out.println("RoomOwnerSimpMTypeProb: Got a meeting type I don't know about.");
                    System.out.println("type i got: " + n);
                    System.out.println("types i know about: ");
                    object = this.probTable.keySet().iterator();
                    while (object.hasNext()) {
                        number = (Integer)object.next();
                        System.out.println((Integer)number + ", ");
                    }
                    return false;
                }
                object = SMALL;
                if (room.getMaxCapacity() > MAX_SMALL_CAPACITY) {
                    object = MEDIUM;
                }
                if (room.getMaxCapacity() > MAX_MED_CAPACITY) {
                    object = LARGE;
                }
                number = (Double)hashMap.get(object);
                double d = 0.5;
                if (number != null) {
                    d = (Double)number;
                } else {
                    System.out.println("no prob for type=" + n + " sz=" + (String)object);
                }
                double d2 = random.nextDouble();
                this.ioManager.writeLine("   * [" + d2 + " >? " + d + "]");
                if (!(d2 > d)) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Error in RoomOwnerSimpleTwoProb.decide()... request denied and continue...");
            return false;
        }
    }
}

