/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.ext;

import cmradar.manager.ext.Learner;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Vector;

public class Matrix2 {
    Vector rows;
    int nRows;
    int nCols;

    public Matrix2() {
        this(0);
    }

    public Matrix2(int n) {
        this.nCols = n;
        this.nRows = 0;
        this.rows = new Vector();
    }

    public Matrix2(int n, int n2) {
        this(n, n2, Learner.UNSET);
    }

    public Matrix2(int n, int n2, Double d) {
        this.nRows = n;
        this.nCols = n2;
        this.rows = new Vector(n);
        for (int i = 0; i < n; ++i) {
            Vector<Double> vector = new Vector<Double>(n2);
            for (int j = 0; j < n2; ++j) {
                vector.add(new Double(d));
            }
            this.rows.add(vector);
        }
    }

    public Matrix2(Vector vector) {
        this.nRows = vector.size();
        if (this.nRows == 0) {
            this.nCols = 0;
            this.rows = new Vector();
            return;
        }
        this.nCols = ((Vector)vector.elementAt(0)).size();
        this.rows = new Vector(vector);
    }

    public Matrix2(Matrix2 matrix2) {
        this.nRows = matrix2.nRows;
        this.nCols = matrix2.nCols;
        this.rows = new Vector(this.nRows);
        for (int i = 0; i < this.nRows; ++i) {
            this.rows.add(new Vector((Vector)matrix2.rows.elementAt(i)));
        }
    }

    public Matrix2(String string) {
        this.rows = new Vector();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                Vector<Double> vector = new Vector<Double>();
                string2 = string2.substring(1, string2.length() - 1);
                String[] stringArray = string2.split(",");
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = stringArray[i].trim();
                    if (string3.equals("null") || string3.equals("")) {
                        vector.add(null);
                        continue;
                    }
                    vector.add(new Double(string3));
                }
                this.rows.add(vector);
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
            this.nRows = this.rows.size();
            if (this.nRows > 0) {
                this.nCols = ((Vector)this.rows.elementAt(0)).size();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
    }

    public String sizeString() {
        return String.valueOf(this.nRows) + "x" + String.valueOf(this.nCols);
    }

    public int size() {
        return this.nRows * this.nCols;
    }

    public int getNumColumns() {
        return this.nCols;
    }

    public int getNumRows() {
        return this.nRows;
    }

    public void setData(int n, int n2, Object object) {
        Vector vector = (Vector)this.rows.elementAt(n);
        vector.setElementAt(object, n2);
    }

    public Object elementAt(int n, int n2) {
        Vector vector = (Vector)this.rows.elementAt(n);
        return vector.elementAt(n2);
    }

    public void addRow(Vector vector) {
        this.rows.add(vector);
        ++this.nRows;
    }

    public Vector getRow(int n) {
        return (Vector)this.rows.elementAt(n);
    }

    public Vector getRows() {
        return this.rows;
    }

    public void setRowAt(Vector vector, int n) {
        this.rows.setElementAt(vector, n);
    }

    public static Vector find(Vector vector, Object object) {
        Vector<Integer> vector2 = new Vector<Integer>();
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (e == null || !e.equals(object)) continue;
            vector2.add(new Integer(i));
        }
        return vector2;
    }

    public void save(String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (int i = 0; i < this.rows.size(); ++i) {
                Vector vector = (Vector)this.rows.elementAt(i);
                bufferedWriter.write(vector + "\n");
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.rows.size(); ++i) {
            Vector vector = (Vector)this.rows.elementAt(i);
            stringBuffer.append(i + ": " + vector.toString() + "\n");
        }
        return stringBuffer.toString();
    }

    public String toTableString() {
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.rows.size(); ++i) {
            int n3;
            Vector vector = (Vector)this.rows.elementAt(i);
            for (n3 = 0; n3 <= i; ++n3) {
                stringBuffer.append("    ");
            }
            while (n3 < vector.size()) {
                Object e = vector.elementAt(n3);
                if (e instanceof Double) {
                    double d = (Double)e;
                    if (d == 1.0) {
                        stringBuffer.append("    ");
                    } else if (d == 0.0) {
                        stringBuffer.append("    ");
                    } else if (d > 0.9) {
                        stringBuffer.append("+   ");
                    } else if (d < 0.1) {
                        stringBuffer.append("-   ");
                    } else if (0.4 < d && d < 0.6) {
                        stringBuffer.append("~   ");
                        ++n2;
                    } else {
                        stringBuffer.append(String.valueOf(d));
                        ++n;
                    }
                } else {
                    stringBuffer.append((e == null ? "null" : e.toString()) + " ");
                }
                ++n3;
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("sz=" + this.size() + ", count=" + n + ", fuzzy=" + n2 + ", nRows=" + this.nRows + ", nCols=" + this.nCols + "\n");
        return stringBuffer.toString();
    }
}

