/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.ext;

import cmradar.manager.ext.DataSimulator;
import cmradar.manager.ext.RUser;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Random;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

class BetaUser
extends RUser {
    static Logger logger = Logger.getLogger((String)(class$cmradar$manager$ext$BetaUser == null ? (class$cmradar$manager$ext$BetaUser = BetaUser.class$("cmradar.manager.ext.BetaUser")) : class$cmradar$manager$ext$BetaUser).getName());
    double alpha;
    double beta;
    HashMap pdf = new HashMap();
    public static final double[] gamma = new double[]{0.5, 1.0, 2.0, 3.0, 4.0, 5.0};
    public static final String[] gammaS = new String[]{"0.5", "1.0", "2.0", "3.0", "4.0", "5.0"};
    static /* synthetic */ Class class$cmradar$manager$ext$BetaUser;

    public BetaUser(int n, HashMap hashMap, Random random) {
        super(n, hashMap, random);
        this.type = -1;
        this.initBeta(random);
    }

    public BetaUser(int n, int n2, Random random) {
        super(n, n2, random);
        this.type = -1;
        this.initBeta(random);
    }

    private void initBeta(Random random) {
        int n = random.nextInt(gamma.length);
        int n2 = random.nextInt(gamma.length);
        this.alpha = gamma[n];
        this.beta = gamma[n2];
        String string = "user-" + gammaS[n] + "-" + gammaS[n2] + ".txt";
        try {
            InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string2 = bufferedReader.readLine();
            int n3 = 1;
            while (string2 != null) {
                String[] stringArray = string2.split("\\s+");
                if (stringArray.length < 2) {
                    DataSimulator.error("BetaUser", "syntax error in input " + string + " at line " + n3);
                }
                double d = Double.parseDouble(stringArray[0]);
                double d2 = Double.parseDouble(stringArray[1]);
                this.pdf.put(new Double(d), new Double(d2));
                string2 = bufferedReader.readLine();
                ++n3;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            logger.log((Priority)Level.ERROR, (Object)("file (jar) " + string + " must be in classpath"));
            System.exit(0);
        }
    }

    public double getUtility(double d) {
        double d2 = (double)Math.round(d * 10.0) / 10.0;
        try {
            Double d3 = (Double)this.pdf.get(new Double(d2));
            double d4 = d3;
            return d4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return d;
        }
    }

    public static Vector generateRandomUsers(int n, int n2) {
        Random random = new Random();
        Vector<BetaUser> vector = new Vector<BetaUser>();
        for (int i = 0; i < n; ++i) {
            BetaUser betaUser = new BetaUser(i, n2, random);
            vector.add(betaUser);
        }
        return vector;
    }

    public static Vector generateRandomUsers(int n, HashMap hashMap) {
        Random random = new Random();
        Vector<BetaUser> vector = new Vector<BetaUser>();
        for (int i = 0; i < n; ++i) {
            BetaUser betaUser = new BetaUser(i, hashMap, random);
            vector.add(betaUser);
        }
        return vector;
    }

    public String getTypeName() {
        return "Beta-" + this.alpha + "-" + this.beta;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

