/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.data;

import cmradar.manager.data.Calendar;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class TimeSlot {
    public String earliestStartTime;
    public String latestFinishTime;
    public String startTime;
    public String finishTime;
    public double priority = 1.0;
    public String location = null;
    String status = "possible";
    public static String _timezoneName = "-0000";
    private static Logger logger = Logger.getLogger((String)(class$cmradar$manager$data$TimeSlot == null ? (class$cmradar$manager$data$TimeSlot = TimeSlot.class$("cmradar.manager.data.TimeSlot")) : class$cmradar$manager$data$TimeSlot).getName());
    public static int DEFAULT_MINUTE = 0;
    public static String _DAY_FORMAT = "yyyy-MM-ddZ";
    public static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd [HH:mm Z]");
    static final String TIME_FORMAT = "yyyy-MM-dd [HH:mm Z]";
    static /* synthetic */ Class class$cmradar$manager$data$TimeSlot;

    public static void setTimezone(String string) {
        _timezoneName = string.substring(3);
        sdf.setTimeZone(TimeZone.getTimeZone(string.substring(0, 3)));
    }

    public TimeSlot() {
        this.earliestStartTime = Calendar.CALENDAR_START;
        this.latestFinishTime = Calendar.CALENDAR_END;
        this.startTime = Calendar.CALENDAR_START;
        this.finishTime = Calendar.CALENDAR_END;
        this.priority = 1.0;
        this.location = "nil";
    }

    public TimeSlot(String string) {
        this(string, 1, 11);
    }

    public TimeSlot(long l) {
        this(sdf.format(new Date(l * 1000L)), 1, 11);
    }

    public TimeSlot(long l, long l2) {
        this.earliestStartTime = sdf.format(new Date(l * 1000L));
        this.startTime = new String(this.earliestStartTime);
        this.latestFinishTime = sdf.format(new Date(l2 * 1000L));
        this.finishTime = new String(this.latestFinishTime);
    }

    public TimeSlot(String string, int n) {
        this(string, n, 11);
    }

    public TimeSlot(String string, int n, int n2) {
        this.startTime = new String(string);
        this.earliestStartTime = new String(string);
        long l = 0L;
        switch (n2) {
            case 10: 
            case 11: {
                l = n * 3600;
                break;
            }
            case 12: {
                l = n * 60;
                break;
            }
            default: {
                l = n * 1;
            }
        }
        long l2 = TimeSlot.parse(this.startTime).getTime() + l * 1000L;
        this.finishTime = sdf.format(new Date(l2));
        this.latestFinishTime = new String(this.finishTime);
        this.priority = 1.0;
        this.location = "nil";
    }

    public TimeSlot(String string, String string2) {
        try {
            this.startTime = string;
            this.finishTime = string2;
            this.earliestStartTime = string;
            this.latestFinishTime = string2;
            this.priority = 1.0;
            this.location = "nil";
        }
        catch (Exception exception) {
            System.out.println("ERROR: failed to construct a timeslot for [" + string + "," + string2 + "]");
        }
    }

    public TimeSlot(TimeSlot timeSlot) {
        this.earliestStartTime = timeSlot.earliestStartTime;
        this.latestFinishTime = timeSlot.latestFinishTime;
        this.startTime = timeSlot.startTime;
        this.finishTime = timeSlot.finishTime;
        this.priority = timeSlot.priority;
        this.location = timeSlot.location;
        this.status = timeSlot.status;
    }

    public void setEST(String string) {
        this.earliestStartTime = string;
    }

    public void setLFT(String string) {
        this.latestFinishTime = string;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public static Date parse(String string) {
        try {
            return sdf.parse(string);
        }
        catch (Exception exception) {
            logger.log((Priority)Level.ERROR, (Object)("can't parse:" + string));
            return null;
        }
    }

    public double getStartTime() {
        return TimeSlot.parse(this.startTime).getTime() / 1000L;
    }

    public double getFinishTime() {
        return TimeSlot.parse(this.finishTime).getTime() / 1000L;
    }

    public String getStartTimeString() {
        return this.startTime;
    }

    public String getFinishTimeString() {
        return this.finishTime;
    }

    public void setStartTime(double d) {
        this.startTime = sdf.format(new Date((long)d * 1000L));
    }

    public void setFinishTime(double d) {
        this.finishTime = sdf.format(new Date((long)d * 1000L));
    }

    public static int parseTimeString(String string, int n) {
        try {
            java.util.Calendar calendar = java.util.Calendar.getInstance();
            Date date = sdf.parse(string);
            calendar.setTime(date);
            return calendar.get(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
            return -1;
        }
    }

    public static Date getDate(String string) {
        try {
            return sdf.parse(string);
        }
        catch (Exception exception) {
            System.out.println("!!parse error: TimeSlot.getDate() " + string);
            return null;
        }
    }

    public int length() {
        return this.ft() - this.st();
    }

    public int est() {
        return TimeSlot.parseTimeString(this.earliestStartTime, 11);
    }

    public int lft() {
        return TimeSlot.parseTimeString(this.latestFinishTime, 11);
    }

    public int st() {
        return TimeSlot.parseTimeString(this.startTime, 11);
    }

    public int ft() {
        return TimeSlot.parseTimeString(this.finishTime, 11);
    }

    public int st_minute() {
        return TimeSlot.parseTimeString(this.startTime, 12);
    }

    public int ft_minute() {
        return TimeSlot.parseTimeString(this.finishTime, 12);
    }

    public int day() {
        return TimeSlot.parseTimeString(this.startTime, 5);
    }

    public int year() {
        return TimeSlot.parseTimeString(this.startTime, 1);
    }

    public int month() {
        return 1 + TimeSlot.parseTimeString(this.startTime, 2);
    }

    public long getDurationSecond() {
        try {
            return (sdf.parse(this.finishTime).getTime() - sdf.parse(this.startTime).getTime()) / 1000L;
        }
        catch (Exception exception) {
            System.err.println("Error in parsing time");
            exception.printStackTrace();
            return 0L;
        }
    }

    public int distance(TimeSlot timeSlot) {
        int n = Calendar.DAY_START_HOUR;
        int n2 = Calendar.DAY_END_HOUR;
        int n3 = n2 - n;
        int n4 = this.day();
        int n5 = timeSlot.day();
        int n6 = this.st();
        int n7 = timeSlot.st();
        if (n4 == n5) {
            return Math.abs(n6 - n7);
        }
        if (n4 > n5) {
            int n8 = n2 - n7;
            n8 += n3 * (n4 - n5 - 1);
            return n8 += n6 - n;
        }
        int n9 = n2 - n6;
        n9 += n3 * (n5 - n4 - 1);
        return n9 += n7 - n;
    }

    public boolean overlaps(TimeSlot timeSlot) {
        return !TimeSlot.before(timeSlot.finishTime, this.startTime) && !TimeSlot.equals(timeSlot.finishTime, this.startTime) && !TimeSlot.before(this.finishTime, timeSlot.startTime) && !TimeSlot.equals(this.finishTime, timeSlot.startTime);
    }

    public boolean equals(Object object) {
        TimeSlot timeSlot = (TimeSlot)object;
        return timeSlot.startTime.equals(this.startTime) && timeSlot.finishTime.equals(this.finishTime) && timeSlot.location.equals(this.location);
    }

    public int hashCode() {
        return this.day() * 1000000 + this.st() * 1000 + this.ft();
    }

    private String twodigit(int n) {
        String string = "" + n;
        if (string.length() == 1) {
            string = "0" + string;
        }
        return string;
    }

    public String toParseString() {
        return this.toParseString(true);
    }

    static String parseTime(String string) {
        String string2 = "";
        try {
            int n = string.indexOf("[") + 1;
            int n2 = n + 5;
            string2 = string.substring(n, n2);
            if (string2.charAt(0) == '0') {
                string2 = string2.substring(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    static String parseDate(String string) {
        String string2 = "";
        try {
            int n = string.indexOf(45);
            int n2 = string.indexOf(45, n + 1);
            int n3 = string.indexOf(32, n2);
            String string3 = string.substring(0, n);
            String string4 = string.substring(n + 1, n2);
            String string5 = string.substring(n2 + 1, n3);
            string2 = string4 + "." + string5 + "." + string3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    public String toParseString(boolean bl) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(TimeSlot.parseDate(this.startTime) + " ");
            stringBuffer.append(TimeSlot.parseTime(this.startTime));
            if (bl) {
                stringBuffer.append(" to ");
            } else {
                stringBuffer.append(" ");
            }
            stringBuffer.append(TimeSlot.parseTime(this.finishTime));
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            System.out.println("Error in quick fix toParseString()... use old parse()...");
            return this.toParseString_DLS(bl);
        }
    }

    public String toString() {
        return this.startTime + " ~ " + this.finishTime;
    }

    public String toParseString_DLS(boolean bl) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("DD.MM.yyyy");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("HH:mm");
        simpleDateFormat.setTimeZone(sdf.getTimeZone());
        simpleDateFormat2.setTimeZone(sdf.getTimeZone());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.twodigit(this.month()));
        stringBuffer.append(".");
        stringBuffer.append(this.twodigit(this.day()));
        stringBuffer.append(".");
        stringBuffer.append(this.year());
        stringBuffer.append(" ");
        stringBuffer.append(this.st());
        stringBuffer.append(":");
        stringBuffer.append(this.twodigit(this.st_minute()));
        if (bl) {
            stringBuffer.append(" to ");
        } else {
            stringBuffer.append(" ");
        }
        stringBuffer.append(this.ft());
        stringBuffer.append(":");
        stringBuffer.append(this.twodigit(this.ft_minute()));
        return stringBuffer.toString();
    }

    public String toPrettyString() {
        return "pretty string!";
    }

    public String toXMLString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\t\t<timeslot>\n");
        stringBuffer.append("\t\t\t<start-time>");
        stringBuffer.append(this.startTime);
        stringBuffer.append("</start-time>\n");
        stringBuffer.append("\t\t\t<finish-time>");
        stringBuffer.append(this.finishTime);
        stringBuffer.append("</finish-time>\n");
        stringBuffer.append("\t\t\t<status>");
        stringBuffer.append(string);
        stringBuffer.append("</status>\n");
        if (this.location != null) {
            stringBuffer.append("\t\t\t<room-id>");
            stringBuffer.append(this.location);
            stringBuffer.append("</room-id>");
        }
        stringBuffer.append("\t\t</timeslot>\n");
        return stringBuffer.toString();
    }

    public boolean before(TimeSlot timeSlot) {
        return TimeSlot.before(this.finishTime, timeSlot.startTime);
    }

    public static boolean before(String string, String string2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(TIME_FORMAT);
        Date date = null;
        Date date2 = null;
        try {
            date = simpleDateFormat.parse(string);
            date2 = simpleDateFormat.parse(string2);
        }
        catch (Exception exception) {
            System.err.println("Error parsing dates in TimeSlot.before");
            exception.printStackTrace();
        }
        return date.before(date2);
    }

    public static boolean equals(String string, String string2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(TIME_FORMAT);
        Date date = null;
        Date date2 = null;
        try {
            date = simpleDateFormat.parse(string);
            date2 = simpleDateFormat.parse(string2);
        }
        catch (Exception exception) {
            System.err.println("Error parsing dates in TimeSlot.before");
            exception.printStackTrace();
        }
        return date.equals(date2);
    }

    public boolean after(TimeSlot timeSlot) {
        return TimeSlot.after(this.startTime, timeSlot.finishTime);
    }

    public static boolean after(String string, String string2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(TIME_FORMAT);
        Date date = null;
        Date date2 = null;
        try {
            date = simpleDateFormat.parse(string);
            date2 = simpleDateFormat.parse(string2);
        }
        catch (Exception exception) {
            System.err.println("Error parsing dates in TimeSlot.after");
            exception.printStackTrace();
        }
        return date.compareTo(date2) >= 0;
    }

    public static boolean strictlyAfter(String string, String string2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(TIME_FORMAT);
        Date date = null;
        Date date2 = null;
        try {
            date = simpleDateFormat.parse(string);
            date2 = simpleDateFormat.parse(string2);
        }
        catch (Exception exception) {
            System.err.println("Error parsing dates in TimeSlot.after");
            exception.printStackTrace();
        }
        return date.after(date2);
    }

    public static long diff(String string, String string2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(TIME_FORMAT);
        Date date = null;
        Date date2 = null;
        try {
            date = simpleDateFormat.parse(string);
            date2 = simpleDateFormat.parse(string2);
        }
        catch (Exception exception) {
            System.err.println("Error parsing dates in TimeSlot.after");
            exception.printStackTrace();
        }
        return (date2.getTime() - date.getTime()) / 1000L;
    }

    public String getDay() {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(_DAY_FORMAT);
            simpleDateFormat.setTimeZone(sdf.getTimeZone());
            return simpleDateFormat.format(sdf.parse(this.startTime));
        }
        catch (Exception exception) {
            logger.log((Priority)Level.ERROR, (Object)("ERROR: getDay() " + this.startTime));
            return null;
        }
    }

    public static String convertTimeFormat(String string, String string2, String string3) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
            SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(string2);
            return simpleDateFormat2.format(simpleDateFormat.parse(string3), new StringBuffer(), new FieldPosition(0)).toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void main(String[] stringArray) {
        String string = "2005-01-01 [10:00 -0500]";
        String string2 = "2005-01-03 [18:00 -0500]";
        TimeSlot timeSlot = new TimeSlot(string);
        TimeSlot timeSlot2 = new TimeSlot(string2);
        System.out.println(timeSlot.distance(timeSlot2));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

