/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.data;

import cmradar.manager.data.CalendarListener;
import cmradar.manager.data.Meeting;
import cmradar.manager.data.Template;
import cmradar.manager.data.TimeSlot;
import cmradar.manager.sim.MeetingInfo;
import cmradar.manager.sim.SimParameters;
import cmradar.manager.sim.TestInfo;
import cmradar.manager.sim.Utility;
import cmradar.manager.sys.RManagerIO;
import cmradar.manager.sys.calendar.Model;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;

public class Calendar {
    public String myUserId;
    public static String MORNING = "SimpleMorning";
    public static String AFTERNOON = "SimpleAfternoon";
    public static String NONE = "None";
    public String PREFERENCE = MORNING;
    public HashMap meetings;
    public static String CALENDAR_START = "2005-01-01 [8:00 -0500]";
    public static String CALENDAR_END = "2005-01-05 [18:00 -0500]";
    public static int DAY_START_HOUR = 8;
    public static int DAY_END_HOUR = 18;
    public static int NUM_DAYS = 1;
    Model model;
    public Vector listeners = new Vector();
    Random r = new Random(123456L);
    int cnt = this.r.nextInt(NUM_DAYS);

    public Calendar(String string, String string2) {
        this.myUserId = string;
        this.meetings = new HashMap();
        if (string2 == null || string2.equals("")) {
            this.PREFERENCE = NONE;
        } else if (string2.equals(MORNING)) {
            this.PREFERENCE = MORNING;
        } else if (string2.equals(AFTERNOON)) {
            this.PREFERENCE = AFTERNOON;
        } else if (string2.equals(NONE)) {
            this.PREFERENCE = NONE;
        } else {
            System.out.println("Calendar.java Error: Unknown preference type -- " + string2);
            System.exit(0);
        }
    }

    public Calendar(String string, String string2, TestInfo testInfo) {
        this(string, string2);
        DAY_START_HOUR = testInfo.getStartHour();
        DAY_END_HOUR = testInfo.getEndHour();
        NUM_DAYS = testInfo.getTestDays();
        CALENDAR_START = Calendar.dayToStartTime(1);
        CALENDAR_END = Calendar.dayToEndTime(NUM_DAYS);
    }

    public void addListener(CalendarListener calendarListener) {
        this.listeners.add(calendarListener);
    }

    public void updated() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            CalendarListener calendarListener = (CalendarListener)iterator.next();
            calendarListener.calendarUpdated(this);
        }
    }

    public void highlightMeeting(Meeting meeting) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            CalendarListener calendarListener = (CalendarListener)iterator.next();
            calendarListener.highlightMeeting(meeting);
        }
    }

    public void unhighlightMeeting(Meeting meeting) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            CalendarListener calendarListener = (CalendarListener)iterator.next();
            calendarListener.unhighlightMeeting(meeting);
        }
    }

    public void highlightTimeSlot(TimeSlot timeSlot) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            CalendarListener calendarListener = (CalendarListener)iterator.next();
            calendarListener.highlightTimeSlot(timeSlot);
        }
    }

    public void unhighlightTimeSlot(TimeSlot timeSlot) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            CalendarListener calendarListener = (CalendarListener)iterator.next();
            calendarListener.unhighlightTimeSlot(timeSlot);
        }
    }

    public boolean isMorningPreference() {
        return this.PREFERENCE.equals(MORNING);
    }

    public boolean isAfternoonPreference() {
        return this.PREFERENCE.equals(AFTERNOON);
    }

    public void addModel(Model model) {
        this.model = model;
    }

    public void update() {
        this.model.updateAll(this.meetings.values().iterator());
    }

    public void printCalendar(RManagerIO rManagerIO) {
        rManagerIO.writeLine("\nCurrent Calendar");
        rManagerIO.writeLine("----------------");
        Iterator iterator = this.meetings.values().iterator();
        while (iterator.hasNext()) {
            Meeting meeting = (Meeting)iterator.next();
            TimeSlot timeSlot = meeting.getConfirmedTimeSlot();
            if (timeSlot != null) {
                rManagerIO.writeLine("Meeting " + meeting.getMeetingId() + " on " + timeSlot.toPrettyString() + " is " + meeting.getTimeSlotStatus(this.myUserId, timeSlot));
            }
            Vector vector = meeting.getPendingTimeSlots();
            for (int i = 0; i < vector.size(); ++i) {
                TimeSlot timeSlot2 = (TimeSlot)vector.elementAt(i);
                rManagerIO.writeLine("Meeting " + meeting.getMeetingId() + " on " + timeSlot2.toPrettyString() + " is " + meeting.getTimeSlotStatus(this.myUserId, timeSlot2));
            }
        }
        rManagerIO.writeLine("\n");
    }

    public int numConfirmedMeetingsInitiator(String string) {
        int n = 0;
        Iterator iterator = this.meetings.values().iterator();
        while (iterator.hasNext()) {
            TimeSlot timeSlot;
            Meeting meeting = (Meeting)iterator.next();
            if (!meeting.getInitiator().equals(string) || (timeSlot = meeting.getConfirmedTimeSlot()) == null) continue;
            ++n;
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("calendar " + this.myUserId + "\n");
        Iterator iterator = this.meetings.values().iterator();
        while (iterator.hasNext()) {
            Meeting meeting = (Meeting)iterator.next();
            TimeSlot timeSlot = meeting.getConfirmedTimeSlot();
            if (timeSlot == null) continue;
            stringBuffer.append(meeting.getMeetingId() + " " + timeSlot.startTime + "\n");
        }
        return stringBuffer.toString();
    }

    public boolean isCurrentMeeting(String string) {
        Meeting meeting = this.getMeeting(string);
        return meeting != null;
    }

    public boolean isPendingMeeting(String string) {
        Meeting meeting = this.getMeeting(string);
        if (meeting == null) {
            return false;
        }
        return meeting.isPending();
    }

    public boolean isConfirmedMeeting(String string) {
        Meeting meeting = this.getMeeting(string);
        if (meeting == null) {
            return false;
        }
        return meeting.isConfirmed();
    }

    public void setStatusPending(String string) {
        Meeting meeting = this.getMeeting(string);
        if (meeting != null) {
            meeting.setStatus("pending");
        }
    }

    public Meeting getMeeting(String string) {
        Meeting meeting = (Meeting)this.meetings.get(string);
        return meeting;
    }

    public Vector getMeetingIds() {
        return new Vector(this.meetings.keySet());
    }

    public String getUserId() {
        return this.myUserId;
    }

    public void addMeeting(Meeting meeting) {
        if (this.getMeeting(meeting.getMeetingId()) == null) {
            this.meetings.put(meeting.getMeetingId(), meeting);
        } else {
            System.out.println("Error in Calendar.addMeeting(): adding duplicate meeting to calendar -- " + meeting.getMeetingId());
        }
    }

    public void deleteMeeting(String string) {
        this.meetings.remove(string);
    }

    public String getMeetingIdFromTimeSlot(TimeSlot timeSlot) {
        Meeting meeting = this.getMeetingFromTimeSlot(timeSlot);
        if (meeting != null) {
            return meeting.getMeetingId();
        }
        return null;
    }

    public Meeting getOverlapMeetingFromTimeSlot(TimeSlot timeSlot) {
        Iterator iterator = this.meetings.values().iterator();
        while (iterator.hasNext()) {
            Meeting meeting = (Meeting)iterator.next();
            TimeSlot timeSlot2 = meeting.getConfirmedTimeSlot();
            if (timeSlot2 != null && timeSlot2.overlaps(timeSlot)) {
                return meeting;
            }
            Vector vector = meeting.getPendingTimeSlots();
            for (int i = 0; i < vector.size(); ++i) {
                TimeSlot timeSlot3 = (TimeSlot)vector.elementAt(i);
                if (!timeSlot3.overlaps(timeSlot)) continue;
                return meeting;
            }
        }
        return null;
    }

    public Meeting getMeetingFromTimeSlot(TimeSlot timeSlot) {
        Iterator iterator = this.meetings.values().iterator();
        while (iterator.hasNext()) {
            Meeting meeting = (Meeting)iterator.next();
            TimeSlot timeSlot2 = meeting.getConfirmedTimeSlot();
            if (timeSlot2 != null && timeSlot2.equals(timeSlot)) {
                return meeting;
            }
            Vector vector = meeting.getPendingTimeSlots();
            for (int i = 0; i < vector.size(); ++i) {
                TimeSlot timeSlot3 = (TimeSlot)vector.elementAt(i);
                if (!timeSlot3.equals(timeSlot)) continue;
                return meeting;
            }
        }
        return null;
    }

    public static TimeSlot getFullRange() {
        TimeSlot timeSlot = new TimeSlot();
        timeSlot.earliestStartTime = CALENDAR_START;
        timeSlot.latestFinishTime = CALENDAR_END;
        timeSlot.startTime = CALENDAR_START;
        timeSlot.finishTime = CALENDAR_END;
        return timeSlot;
    }

    public static String dayToStartTime(int n) {
        return "2005-01-0" + n + " [" + DAY_START_HOUR + ":00 -0500]";
    }

    public static String dayToEndTime(int n) {
        return "2005-01-0" + n + " [" + DAY_END_HOUR + ":00 -0500]";
    }

    public TimeSlot getFullRange2() {
        TimeSlot timeSlot = new TimeSlot();
        timeSlot.earliestStartTime = CALENDAR_START;
        timeSlot.latestFinishTime = CALENDAR_END;
        timeSlot.startTime = Calendar.dayToStartTime(this.cnt + 1);
        timeSlot.finishTime = Calendar.dayToEndTime(this.cnt + 1);
        this.cnt = this.r.nextInt(NUM_DAYS);
        return timeSlot;
    }

    public void checkConsistency(RManagerIO rManagerIO) {
        Vector<TimeSlot> vector = new Vector<TimeSlot>();
        Iterator iterator = this.meetings.values().iterator();
        while (iterator.hasNext()) {
            Meeting meeting = (Meeting)iterator.next();
            TimeSlot timeSlot = meeting.getConfirmedTimeSlot();
            if (timeSlot != null) {
                if (Template.indexOf(vector, timeSlot) < 0) {
                    vector.add(timeSlot);
                } else {
                    rManagerIO.writeLine("checkCalendarConsistency(): timeslot double booked!");
                    System.out.println(this.myUserId + ": checkCalendarConsistency(): timeslot double booked!");
                    rManagerIO.writeLine(timeSlot.toPrettyString());
                    this.printCalendar(rManagerIO);
                    Utility.waitForKey(true);
                }
            }
            Vector vector2 = meeting.getPendingTimeSlots();
            for (int i = 0; i < vector2.size(); ++i) {
                TimeSlot timeSlot2 = (TimeSlot)vector2.get(i);
                if (Template.indexOf(vector, timeSlot2) < 0) {
                    vector.add(timeSlot2);
                    continue;
                }
                rManagerIO.writeLine(timeSlot2.toPrettyString());
                this.printCalendar(rManagerIO);
                rManagerIO.writeLine("checkCalendarConsistency(): timeslot double booked!");
                System.out.println(this.myUserId + ": checkCalendarConsistency(): timeslot double booked!");
                Utility.waitForKey(true);
            }
        }
    }

    public double computeDensity() {
        int n = (DAY_END_HOUR - DAY_START_HOUR) * NUM_DAYS;
        double d = 0.0;
        Iterator iterator = this.meetings.values().iterator();
        while (iterator.hasNext()) {
            Meeting meeting = (Meeting)iterator.next();
            TimeSlot timeSlot = meeting.getConfirmedTimeSlot();
            if (timeSlot == null) continue;
            d += 1.0;
        }
        if (n > 0) {
            return d / (double)n;
        }
        return 0.0;
    }

    public double sumDistanceOfMovedMeetings(Calendar calendar) {
        double d = 0.0;
        Iterator iterator = this.meetings.values().iterator();
        while (iterator.hasNext()) {
            Meeting meeting = (Meeting)iterator.next();
            if (!(meeting.getInitiator().equals(this.myUserId) & calendar.isConfirmedMeeting(meeting.getMeetingId()))) continue;
            TimeSlot timeSlot = meeting.getConfirmedTimeSlot();
            Meeting meeting2 = calendar.getMeeting(meeting.getMeetingId());
            TimeSlot timeSlot2 = meeting2.getConfirmedTimeSlot();
            d += (double)timeSlot.distance(timeSlot2);
        }
        return d;
    }

    public int numMeetingsMissing(Calendar calendar) {
        int n = 0;
        Iterator iterator = this.meetings.values().iterator();
        while (iterator.hasNext()) {
            Meeting meeting = (Meeting)iterator.next();
            if (!meeting.getInitiator().equals(this.myUserId) || calendar.isConfirmedMeeting(meeting.getMeetingId())) continue;
            ++n;
        }
        return n;
    }

    public int numMeetingsMissing(Vector vector) {
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            MeetingInfo meetingInfo = (MeetingInfo)vector.get(i);
            if (!meetingInfo.getInitiator().equals(this.myUserId) || this.isConfirmedMeeting(meetingInfo.getMeetingId())) continue;
            ++n;
        }
        return n;
    }

    public int numMeetingsMoved(Calendar calendar) {
        int n = 0;
        Iterator iterator = this.meetings.values().iterator();
        while (iterator.hasNext()) {
            Meeting meeting;
            TimeSlot timeSlot;
            TimeSlot timeSlot2;
            Meeting meeting2 = (Meeting)iterator.next();
            if (!meeting2.getInitiator().equals(this.myUserId) || !calendar.isConfirmedMeeting(meeting2.getMeetingId()) || (timeSlot2 = meeting2.getConfirmedTimeSlot()).equals(timeSlot = (meeting = calendar.getMeeting(meeting2.getMeetingId())).getConfirmedTimeSlot())) continue;
            ++n;
        }
        return n;
    }

    public static TimeSlot getRandomFreeSlot(Calendar calendar, Vector vector, Random random) {
        Object object;
        int n;
        int n2 = DAY_START_HOUR;
        int n3 = DAY_END_HOUR;
        int n4 = NUM_DAYS;
        int n5 = (n3 - n2) * n4;
        TimeSlot[] timeSlotArray = new TimeSlot[n5];
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd [HH:mm Z]");
        simpleDateFormat.setTimeZone(TimeSlot.sdf.getTimeZone());
        java.util.Calendar calendar2 = java.util.Calendar.getInstance();
        try {
            calendar2.setTime(simpleDateFormat.parse(CALENDAR_START));
        }
        catch (Exception exception) {
            System.err.println("Calendar.getRandomFreeSlot() - Parsing failed");
            System.exit(1);
        }
        calendar2.set(11, n2);
        calendar2.set(12, 0);
        for (int i = 0; i < n5; ++i) {
            TimeSlot timeSlot;
            if (calendar2.get(11) >= n3) {
                calendar2.set(11, n2);
                calendar2.add(6, 1);
            }
            timeSlotArray[i] = timeSlot = new TimeSlot(simpleDateFormat.format(calendar2.getTime()));
            calendar2.add(11, 1);
        }
        int[] nArray = new int[timeSlotArray.length];
        int n6 = 0;
        for (n = 0; n < timeSlotArray.length; ++n) {
            if (vector.contains(timeSlotArray[n]) || (object = calendar.getMeetingIdFromTimeSlot(timeSlotArray[n])) != null) continue;
            nArray[n6++] = n;
        }
        if (n6 > 0) {
            n = Math.abs(random.nextInt()) % n6;
            object = timeSlotArray[nArray[n]];
            return object;
        }
        return null;
    }

    public boolean isTimeSlotEmpty(TimeSlot timeSlot) {
        return this.getMeetingFromTimeSlot(timeSlot) == null;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            System.out.println("Invalid number of args");
            System.out.println(".agents .meetings .calendar");
            System.exit(1);
        }
        SimParameters simParameters = new SimParameters();
        try {
            simParameters.parseAgentsFile(stringArray[0]);
            simParameters.parseOldMeetingsFile(stringArray[1]);
            simParameters.parseCalendarFile(stringArray[2]);
        }
        catch (IOException iOException) {
            System.err.println("Error. Quitting.");
        }
        Vector vector = simParameters.getCalendars();
        Calendar calendar = (Calendar)vector.get(0);
        System.out.println(calendar.toString());
        Random random = new Random(3452L);
        for (int i = 0; i < 100; ++i) {
            Calendar.getRandomFreeSlot(calendar, new Vector(), random);
        }
        System.out.println("--");
    }
}

