package edu.cmu.cs.radar.integ;

public interface ITestRigProvides {
	/**
	 * Sets the state of the test
	 * @param state
	 */
	public void setTestState (TestState state);
	public TestState getTestState ();
	
	/**
	 * Adds a listener that will be notified when the test state changes
	 * @param listener
	 */
	public void addTestStateListener (ITestStateListener listener);
	public void removeTestStateListener (ITestStateListener listener);
	
	/**
	 * 
	 * @return the elapsed time in the test (excluding the time of the break) in milliseconds
	 */
	public long getElapsedTestTime ();
}
