/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.neg;

import cmradar.manager.data.Meeting;
import cmradar.manager.data.Room;
import cmradar.manager.data.RoomTemplate;
import cmradar.manager.data.SharedRoomCalendar;
import cmradar.manager.data.Template;
import cmradar.manager.data.TimeSlot;
import cmradar.manager.neg.AbstractRoomNegotiator;
import cmradar.manager.sched.Scheduler;
import cmradar.manager.sim.MessageCommunicator;
import cmradar.manager.sys.RManagerIO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;

public class RoomOwnerSimpMTypeProb
extends AbstractRoomNegotiator {
    HashMap probabilities;

    public RoomOwnerSimpMTypeProb(RManagerIO rManagerIO, String string, String string2, Scheduler scheduler, MessageCommunicator messageCommunicator, HashMap hashMap) {
        super(rManagerIO, string, string2, scheduler, messageCommunicator);
        this.probabilities = hashMap;
    }

    public RoomOwnerSimpMTypeProb(RManagerIO rManagerIO, String string, String string2, Scheduler scheduler, MessageCommunicator messageCommunicator, SharedRoomCalendar sharedRoomCalendar, HashMap hashMap) {
        super(rManagerIO, string, string2, scheduler, messageCommunicator, sharedRoomCalendar);
        this.probabilities = hashMap;
    }

    public void receive_message(Template template, String string) {
        RoomTemplate roomTemplate = (RoomTemplate)template;
        TimeSlot timeSlot = (TimeSlot)template.getTimeSlotsFromStatus("possible").get(0);
        Room room = this.sharedRCal.getRoomFromId(timeSlot.location);
        this.ioManager.writeLine("\n -> Received request...");
        if (room == null) {
            this.ioManager.writeLine(this.sharedRCal.getNumRooms() + " ts.l=" + timeSlot.location);
        }
        this.ioManager.writeLine("   * room " + room.getRoomId() + " for " + timeSlot.toParseString());
        this.ioManager.writeLine("\n");
        ArrayList arrayList = this.myMeetingsForTime(timeSlot, room);
        if (arrayList.size() > 0) {
            Meeting meeting = (Meeting)arrayList.get(0);
            this.ioManager.writeLine("\n -> Request conflicts with existing reservation...");
            this.ioManager.writeLine("   * meeting " + meeting.getMeetingId() + " is in room " + room.getRoomId() + " at " + timeSlot.toParseString());
            if (this.decide(arrayList)) {
                template.setStatus(timeSlot, "possible");
                this.ioManager.writeLine("   * decided to accept request and bump.");
                this.ioManager.writeLine("\n");
            } else {
                template.setStatus(timeSlot, "impossible");
                this.ioManager.writeLine("   * decided to reject request.");
                this.ioManager.writeLine("\n");
            }
            this.mComm.sendMessage(template.toLispList(), this.myUserId, string);
        }
    }

    protected boolean decide(ArrayList arrayList) {
        Random random = new Random();
        for (int i = 0; i < arrayList.size(); ++i) {
            int n = ((Meeting)arrayList.get((int)i)).type;
            if (this.probabilities.get(new Integer(n)) == null) {
                System.out.println("RoomOwnerSimpMTypeProb: Got a meeting type I don't know about.");
                System.out.println("type i got: " + n);
                System.out.println("types i know about: ");
                Iterator iterator = this.probabilities.keySet().iterator();
                while (iterator.hasNext()) {
                    Integer n2 = (Integer)iterator.next();
                    System.out.println(n2 + ", ");
                }
                return false;
            }
            double d = (Double)this.probabilities.get(new Integer(((Meeting)arrayList.get((int)i)).type));
            double d2 = random.nextDouble();
            this.ioManager.writeLine("if   * [" + d2 + " >? " + d + "], then refuse.");
            if (!(d2 > d)) continue;
            return false;
        }
        return true;
    }

    protected boolean decide2(String string) {
        Random random = new Random();
        if (this.probabilities.get(new Integer(Meeting.typeStringToInt(string))) == null) {
            System.out.println("RoomOwnerSimpMTypeProb: Got a meeting type I don't know about.");
            System.out.println("type i got: " + string);
            System.out.println("types i know about: ");
            Iterator iterator = this.probabilities.keySet().iterator();
            while (iterator.hasNext()) {
                Integer n = (Integer)iterator.next();
                System.out.println(n + ", ");
            }
        }
        double d = (Double)this.probabilities.get(new Integer(Meeting.typeStringToInt(string)));
        double d2 = random.nextDouble();
        this.ioManager.writeLine("   * [" + d2 + " >? " + d + "]");
        return !(d2 > d);
    }
}

