/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.neg;

import cmradar.manager.neg.NegotiationLog;
import cmradar.manager.neg.RoomNegotiationLogEntry;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class AnalyzeTestLogs {
    ArrayList logRecords = new ArrayList();

    public AnalyzeTestLogs(String string) {
        String string2 = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            string2 = bufferedReader.readLine();
            while (string2 != null) {
                String[] stringArray = string2.split("[\t ]+");
                LogRecord logRecord = new LogRecord(stringArray[0], Integer.parseInt(stringArray[1]));
                this.logRecords.add(logRecord);
                string2 = bufferedReader.readLine();
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println(string2);
            numberFormatException.printStackTrace();
        }
        catch (Exception exception) {
            System.out.println(string2);
            System.out.println(string);
            exception.printStackTrace();
        }
    }

    public void analyze() {
        for (int i = 0; i < this.logRecords.size(); ++i) {
            LogRecord logRecord = (LogRecord)this.logRecords.get(i);
            logRecord.processLog();
        }
    }

    public void writeDataFile(String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(string));
            printWriter.println("#x\tavgNumFailedAsks\tnumSuccess\tnumTrials");
            for (int i = 0; i < this.logRecords.size(); ++i) {
                LogRecord logRecord = (LogRecord)this.logRecords.get(i);
                printWriter.println(logRecord.noTrainingExamples + "\t" + logRecord.avgNumFailedAsks + "\t" + logRecord.numSuccess + "\t\t" + logRecord.numTrials);
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.out.println("Usage: input-filename output-filename");
            System.exit(1);
        }
        AnalyzeTestLogs analyzeTestLogs = new AnalyzeTestLogs(stringArray[0]);
        analyzeTestLogs.analyze();
        analyzeTestLogs.writeDataFile(stringArray[1]);
    }

    private class LogRecord {
        String fileName;
        int noTrainingExamples;
        HashMap noMessages;
        double avgNumFailedAsks;
        int numTrials;
        int numSuccess;
        HashMap scheduled;

        LogRecord(String string, int n) {
            this.fileName = string;
            this.noTrainingExamples = n;
            this.noMessages = new HashMap();
            this.scheduled = new HashMap();
            this.avgNumFailedAsks = 0.0;
            this.numSuccess = 0;
        }

        void processLog() {
            try {
                NegotiationLog negotiationLog = new NegotiationLog(new BufferedReader(new FileReader(this.fileName)));
                HashMap hashMap = negotiationLog.getEntryList();
                Iterator iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    RoomNegotiationLogEntry roomNegotiationLogEntry = (RoomNegotiationLogEntry)hashMap.get(string);
                    if (!this.noMessages.containsKey(roomNegotiationLogEntry.getNegId())) {
                        this.noMessages.put(roomNegotiationLogEntry.getNegId(), new Integer(0));
                        this.scheduled.put(roomNegotiationLogEntry.getNegId(), new Boolean(false));
                    }
                    int n = (Integer)this.noMessages.get(roomNegotiationLogEntry.getNegId());
                    this.noMessages.put(roomNegotiationLogEntry.getNegId(), new Integer(n + 1));
                    if (!roomNegotiationLogEntry.getResponse()) continue;
                    this.scheduled.put(roomNegotiationLogEntry.getNegId(), new Boolean(true));
                }
                this.calculateStats();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        void calculateStats() {
            Iterator iterator = this.noMessages.keySet().iterator();
            int n = 0;
            int n2 = 0;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (((Boolean)this.scheduled.get(string)).booleanValue()) {
                    ++this.numSuccess;
                    n = n + (Integer)this.noMessages.get(string) - 1;
                } else {
                    n += ((Integer)this.noMessages.get(string)).intValue();
                }
                n2 += ((Integer)this.noMessages.get(string)).intValue();
            }
            this.avgNumFailedAsks = (double)n / (double)n2;
            this.numTrials = this.noMessages.size();
        }
    }
}

