/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.ext;

import cmradar.manager.data.Room;
import cmradar.manager.ext.BetaUser;
import cmradar.manager.ext.Learner;
import cmradar.manager.ext.RUser;
import cmradar.manager.ext.ValuedObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Random;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class DataSimulator {
    protected Vector rooms;
    protected Vector users;
    static Logger logger = Logger.getLogger((String)(class$cmradar$manager$ext$DataSimulator == null ? (class$cmradar$manager$ext$DataSimulator = DataSimulator.class$("cmradar.manager.ext.DataSimulator")) : class$cmradar$manager$ext$DataSimulator).getName());
    public static final int BETA = -1;
    public static final int LINEAR = -2;
    public static final int MIXED = -3;
    static /* synthetic */ Class class$cmradar$manager$ext$DataSimulator;

    public DataSimulator(int n, int n2, int n3, int n4) {
        int n5;
        this.rooms = Room.generateRandomRooms(n, n3);
        switch (n4) {
            case -2: {
                this.users = RUser.generateRandomUsers(n2, n3);
                break;
            }
            case -1: {
                this.users = BetaUser.generateRandomUsers(n2, n3);
                break;
            }
            case -3: {
                n5 = n2 / 2;
                int n6 = n2 - n5;
                this.users = RUser.generateRandomUsers(n5, n3);
                Vector vector = BetaUser.generateRandomUsers(n6, n3);
                this.users.addAll(vector);
                break;
            }
            default: {
                this.users = BetaUser.generateRandomUsers(n2, n3);
            }
        }
        for (n5 = 0; n5 < this.users.size(); ++n5) {
            RUser rUser = (RUser)this.users.elementAt(n5);
            logger.log((Priority)Level.DEBUG, (Object)("user" + rUser));
            rUser.sortRooms(this.rooms);
        }
    }

    public DataSimulator(Vector vector, int n) {
        HashMap hashMap = null;
        hashMap = vector.size() == 0 ? new HashMap() : ((Room)vector.elementAt(0)).getFeatures();
        this.users = BetaUser.generateRandomUsers(n, hashMap);
        this.rooms = vector;
        for (int i = 0; i < this.users.size(); ++i) {
            RUser rUser = (RUser)this.users.elementAt(i);
            System.out.println("user" + rUser);
            rUser.sortRooms(this.rooms);
        }
    }

    public DataSimulator(Vector vector, String string) {
        this.rooms = vector;
        this.users = new Vector();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                String[] stringArray = string2.split("\\s+");
                int n = Integer.parseInt(stringArray[0]);
                Vector<ValuedObject> vector2 = new Vector<ValuedObject>();
                for (int i = 1; i < stringArray.length; ++i) {
                    int n2 = Integer.parseInt(stringArray[i]);
                    vector2.add(new ValuedObject(n2, i));
                }
                this.users.add(new RUser(n, vector2));
                string2 = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void saveUsers(String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string, false));
            for (int i = 0; i < this.users.size(); ++i) {
                RUser rUser = (RUser)this.users.elementAt(i);
                bufferedWriter.write(String.valueOf(rUser.getId()));
                Vector vector = rUser.getSortedRooms();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    ValuedObject valuedObject = (ValuedObject)enumeration.nextElement();
                    bufferedWriter.write(" " + valuedObject.getId());
                }
                bufferedWriter.write("\n");
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            logger.log((Priority)Level.ERROR, (Object)"Error at saveUsers()");
            exception.printStackTrace();
        }
    }

    public Vector getUsers() {
        return this.users;
    }

    public Vector getRooms() {
        return this.rooms;
    }

    public Vector generateCalendar(double d) {
        return this.generateCalendar(d, 0.0);
    }

    public Vector initializeCalendar() {
        Vector<Double> vector = new Vector<Double>(this.rooms.size());
        for (int i = 0; i < this.rooms.size(); ++i) {
            vector.add(new Double(Learner.FREE));
        }
        return vector;
    }

    public Vector generateCalendar(double d, double d2) {
        int n;
        logger.log((Priority)Level.INFO, (Object)("d=" + d));
        Random random = new Random();
        Vector vector = this.initializeCalendar();
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = this.rooms.size();
        double d6 = d5 * d;
        while (!(d4 > d6)) {
            if (d3 > (double)(this.users.size() * 15)) {
                System.out.println("ok, break" + d4 / d5 + " count=" + d4 + " nf=" + d6 + " r=" + d5 + " d=" + d);
                break;
            }
            n = random.nextInt(this.users.size());
            RUser rUser = (RUser)this.users.elementAt(n);
            Enumeration enumeration = rUser.getSortedRooms().elements();
            while (enumeration.hasMoreElements()) {
                ValuedObject valuedObject = (ValuedObject)enumeration.nextElement();
                if (!vector.elementAt(valuedObject.id).equals(Learner.FREE)) continue;
                vector.setElementAt(new Double(Learner.TAKEN), valuedObject.id);
                d4 += 1.0;
                break;
            }
            d3 += 1.0;
        }
        logger.log((Priority)Level.INFO, (Object)("d=" + d4 / d5));
        for (n = 0; n < vector.size(); ++n) {
            double d7 = random.nextDouble();
            if (!(d7 < d2)) continue;
            vector.setElementAt(Learner.UNKNOWN, n);
        }
        return vector;
    }

    public static Vector addUncertainty(Random random, Vector vector, double d) {
        return DataSimulator.addUncertainty(random, vector, d, false);
    }

    public static Vector addUncertainty(Random random, Vector vector, double d, boolean bl) {
        Vector<Double> vector2 = new Vector<Double>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            double d2 = random.nextDouble();
            if (d2 > d) {
                vector2.add(Learner.UNKNOWN);
                continue;
            }
            Double d3 = (Double)vector.elementAt(i);
            if (bl && !d3.equals(Learner.TAKEN)) {
                vector2.add(Learner.UNKNOWN);
                continue;
            }
            vector2.add(d3);
        }
        return vector2;
    }

    public Vector generateTrainData(int n) {
        return this.generateTrainData(n, null, 0.0);
    }

    public Vector generateTrainData(int n, String string, double d) {
        Vector<Vector> vector = new Vector<Vector>();
        try {
            Random random = new Random();
            BufferedWriter bufferedWriter = null;
            if (string != null) {
                bufferedWriter = new BufferedWriter(new FileWriter(string));
            }
            for (int i = 0; i < n; ++i) {
                double d2 = random.nextDouble();
                Vector vector2 = this.generateCalendar(d2, d);
                vector.add(vector2);
                if (bufferedWriter == null) continue;
                bufferedWriter.write(vector2 + "\n");
            }
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return vector;
    }

    public static void error(String string, String string2) {
        System.out.println("Error:" + string2 + ":" + string);
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        int n;
        if (stringArray.length < 5) {
            DataSimulator.error("DataSimulator.main()", "java DataSimulator numHotels numUsers numVars numData userType[1 for Beta 0 otherwise] savefile");
        }
        int n2 = Integer.parseInt(stringArray[0]);
        int n3 = Integer.parseInt(stringArray[1]);
        int n4 = Integer.parseInt(stringArray[2]);
        int n5 = Integer.parseInt(stringArray[3]);
        int n6 = Integer.parseInt(stringArray[4]);
        String string = null;
        BufferedWriter bufferedWriter = null;
        DataSimulator dataSimulator = null;
        dataSimulator = n6 == 1 ? new DataSimulator(n2, n3, n4, -1) : new DataSimulator(n2, n3, n4, -2);
        if (stringArray.length > 5) {
            string = stringArray[5];
        }
        System.out.println("USERS\n" + dataSimulator.users);
        System.out.println("--------------------");
        for (n = 0; n < n3; ++n) {
            RUser rUser = (RUser)dataSimulator.users.elementAt(n);
            System.out.println("User" + rUser.id + "(" + rUser.getTypeName() + ")" + ":" + rUser.pref);
        }
        System.out.println("--------------------");
        try {
            n = 100;
            for (int i = 0; i < n5; ++i) {
                Vector vector = dataSimulator.generateTrainData(n, string, 0.5);
                if (string == null) continue;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    Vector vector2 = (Vector)enumeration.nextElement();
                }
            }
            if (string != null) {
                bufferedWriter.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            DataSimulator.error("main", "saving training data");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

