/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.demo;

import cmradar.manager.data.Calendar;
import cmradar.manager.data.CalendarListener;
import cmradar.manager.data.Meeting;
import cmradar.manager.data.TimeSlot;
import cmradar.manager.demo.CalendarPanel;
import cmradar.manager.demo.MeetingListPanel;
import java.util.Iterator;

public class MeetingDispatcher
implements CalendarListener {
    private CalendarPanel calPanel;
    private MeetingListPanel mlPanel;

    public MeetingDispatcher(CalendarPanel calendarPanel, MeetingListPanel meetingListPanel) {
        this.calPanel = calendarPanel;
        this.mlPanel = meetingListPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calendarUpdated(Calendar calendar) {
        Iterator iterator = calendar.getMeetingIds().iterator();
        this.mlPanel.clear();
        while (iterator.hasNext()) {
            Meeting meeting;
            String string = (String)iterator.next();
            Meeting meeting2 = meeting = calendar.getMeeting(string);
            synchronized (meeting2) {
                String string2 = meeting.getStatus();
                if (string2.equals("possible")) {
                    this.mlPanel.addMeeting(meeting);
                } else if (string2.equals("pending")) {
                    this.mlPanel.addMeeting(meeting);
                    this.calPanel.processMeeting(meeting);
                } else {
                    this.calPanel.processMeeting(meeting);
                }
            }
        }
        this.mlPanel.endUpdate();
        this.calPanel.endUpdate();
    }

    public void highlightMeeting(Meeting meeting) {
        this.mlPanel.highlightMeeting(meeting);
    }

    public void unhighlightMeeting(Meeting meeting) {
        this.mlPanel.unhighlightMeeting(meeting);
    }

    public void highlightTimeSlot(TimeSlot timeSlot) {
        this.calPanel.highlightTimeSlot(timeSlot);
        this.calPanel.repaint();
    }

    public void unhighlightTimeSlot(TimeSlot timeSlot) {
        this.calPanel.unhighlightTimeSlot(timeSlot);
        this.calPanel.repaint();
    }

    public void setStatusString(String string) {
    }
}

