/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.demo;

import cmradar.manager.data.Calendar;
import cmradar.manager.data.Meeting;
import cmradar.manager.data.Template;
import cmradar.manager.demo.CalendarPanel;
import cmradar.manager.demo.DemoUserImages;
import cmradar.manager.demo.EmailBox;
import cmradar.manager.demo.ImageQueuePanel;
import cmradar.manager.demo.MeetingDispatcher;
import cmradar.manager.demo.MeetingListPanel;
import cmradar.manager.sim.MessageCommunicator;
import cmradar.manager.sim.Simulator;
import cmradar.manager.sys.RManagerIO;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SpringLayout;

public class DemoDisplay
extends JFrame
implements RManagerIO {
    private String userName;
    private String userId;
    private JTextArea textOut;
    private Button email;

    public DemoDisplay(String string, String string2, Rectangle rectangle, MessageCommunicator messageCommunicator, Calendar calendar) {
        super(string + "'s Radar Agent");
        this.userName = string;
        this.userId = string2;
        this.setBounds(rectangle);
        this.setDefaultCloseOperation(3);
        this.addPanels(messageCommunicator, calendar);
        this.setVisible(true);
    }

    private void setupTopPanel(JPanel jPanel, MessageCommunicator messageCommunicator) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd [HH:mm Z]");
        Date date = null;
        try {
            date = simpleDateFormat.parse(Calendar.CALENDAR_START);
        }
        catch (ParseException parseException) {
            System.err.println("Error parsing calendar string");
            parseException.printStackTrace();
            System.exit(0);
        }
        SpringLayout springLayout = new SpringLayout();
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("EEE MMM d, yyyy");
        JLabel jLabel = new JLabel(this.userName);
        JLabel jLabel2 = new JLabel(DemoUserImages.get(this.userId));
        JLabel jLabel3 = new JLabel();
        JSeparator jSeparator = new JSeparator();
        ImageQueuePanel imageQueuePanel = new ImageQueuePanel(this.userId);
        jLabel.setFont(jLabel2.getFont().deriveFont(15.0f));
        jPanel.setLayout(springLayout);
        jLabel2.setBorder(BorderFactory.createEtchedBorder(1));
        imageQueuePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Incoming Messages:"));
        jLabel3.setText(simpleDateFormat2.format(date));
        messageCommunicator.addQueueListener(imageQueuePanel);
        jPanel.add(jLabel);
        jPanel.add(jLabel2);
        jPanel.add(jSeparator);
        jPanel.add(jLabel3);
        jPanel.add(imageQueuePanel);
        springLayout.putConstraint("West", (Component)jLabel2, 10, "West", (Component)jPanel);
        springLayout.putConstraint("North", (Component)jLabel2, 10, "North", (Component)jPanel);
        springLayout.putConstraint("West", (Component)jLabel, 10, "East", (Component)jLabel2);
        springLayout.putConstraint("West", (Component)jLabel3, 10, "East", (Component)jLabel2);
        springLayout.putConstraint("North", (Component)jLabel, 10, "North", (Component)jPanel);
        springLayout.putConstraint("North", (Component)jLabel3, 5, "South", (Component)jLabel);
        springLayout.putConstraint("East", (Component)jSeparator, -5, "East", (Component)jPanel);
        springLayout.putConstraint("West", (Component)jSeparator, 5, "West", (Component)jPanel);
        springLayout.putConstraint("North", (Component)jSeparator, 10, "South", (Component)jLabel2);
        springLayout.putConstraint("South", (Component)jPanel, 0, "South", (Component)jSeparator);
        springLayout.putConstraint("East", (Component)imageQueuePanel, -10, "East", (Component)jPanel);
        springLayout.putConstraint("West", (Component)imageQueuePanel, 15, "East", (Component)jLabel2);
        springLayout.putConstraint("South", (Component)imageQueuePanel, -5, "North", (Component)jSeparator);
        springLayout.putConstraint("North", (Component)imageQueuePanel, 10, "South", (Component)jLabel3);
    }

    private void setupCalPanel(JPanel jPanel, Calendar calendar) {
        JPanel jPanel2 = new JPanel();
        int n = Calendar.DAY_START_HOUR;
        int n2 = Calendar.DAY_END_HOUR;
        CalendarPanel calendarPanel = new CalendarPanel(n, n2, 3, this.userId);
        MeetingListPanel meetingListPanel = new MeetingListPanel(this.userId);
        SpringLayout springLayout = new SpringLayout();
        this.textOut = new JTextArea("Welcome to RADAR.");
        JSeparator jSeparator = new JSeparator();
        JScrollPane jScrollPane = new JScrollPane(this.textOut);
        jSeparator.setVisible(true);
        jPanel.setLayout(springLayout);
        jPanel.add(jSeparator);
        jPanel.add(jPanel2);
        jPanel.add(calendarPanel);
        jPanel.add(meetingListPanel);
        jPanel.add(jScrollPane);
        this.textOut.setEditable(false);
        this.textOut.setLineWrap(true);
        jPanel2.setLayout(new GridLayout(n2 - n + 1, 1));
        for (int i = n; i <= n2; ++i) {
            jPanel2.add(new JLabel(i + ":00", 4));
        }
        calendar.addListener(new MeetingDispatcher(calendarPanel, meetingListPanel));
        meetingListPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Unscheduled Meetings:"));
        springLayout.putConstraint("East", (Component)meetingListPanel, -5, "East", (Component)jPanel);
        springLayout.putConstraint("West", (Component)meetingListPanel, 5, "West", (Component)jPanel);
        springLayout.putConstraint("North", (Component)meetingListPanel, 5, "North", (Component)jPanel);
        springLayout.putConstraint("South", (Component)calendarPanel, -18, "South", (Component)jPanel2);
        springLayout.putConstraint("South", (Component)jPanel2, 0, "North", (Component)jScrollPane);
        springLayout.putConstraint("South", (Component)jScrollPane, -5, "South", (Component)jPanel);
        springLayout.putConstraint("East", (Component)jScrollPane, -5, "East", (Component)jPanel);
        springLayout.putConstraint("West", (Component)jScrollPane, 5, "West", (Component)jPanel);
        springLayout.putConstraint("North", (Component)jPanel2, 8, "South", (Component)meetingListPanel);
        springLayout.putConstraint("North", (Component)calendarPanel, -13, "North", (Component)jPanel2);
        springLayout.putConstraint("East", (Component)calendarPanel, -10, "East", (Component)jPanel);
        springLayout.putConstraint("West", (Component)calendarPanel, 10, "East", (Component)jPanel2);
        springLayout.putConstraint("West", (Component)jPanel2, 5, "West", (Component)jPanel);
        springLayout.putConstraint("East", (Component)jSeparator, -5, "East", (Component)jPanel);
        springLayout.putConstraint("West", (Component)jSeparator, 5, "West", (Component)jPanel);
        springLayout.putConstraint("South", (Component)jSeparator, -2, "North", (Component)jScrollPane);
        jScrollPane.setPreferredSize(new Dimension(100, 65));
    }

    private void addPanels(MessageCommunicator messageCommunicator, Calendar calendar) {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.email = new Button("Email");
        this.email.addActionListener(new ButtonListener());
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel, "North");
        container.add((Component)jPanel2, "Center");
        container.add((Component)this.email, "South");
        this.setupTopPanel(jPanel, messageCommunicator);
        this.setupCalPanel(jPanel2, calendar);
    }

    public void write(String string) {
        this.textOut.append(string);
        this.textOut.setCaretPosition(this.textOut.getText().length());
    }

    public void writeLine(String string) {
        this.textOut.append(string + "\n");
        this.textOut.setCaretPosition(this.textOut.getText().length());
    }

    public String readLine() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            return bufferedReader.readLine();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Error reading input");
            return null;
        }
    }

    private Template getTemplateFromUser() {
        Object object;
        Object object2;
        Object var1_1 = null;
        try {
            object2 = Runtime.getRuntime().exec("rm template.txt\n");
            ((Process)object2).waitFor();
        }
        catch (Exception exception) {
            // empty catch block
        }
        object2 = new EmailBox((Frame)this, this.userId);
        try {
            object = Runtime.getRuntime().exec("perl ../sys/generate_template.pl emailTemp.txt\n");
            ((Process)object).waitFor();
        }
        catch (IOException iOException) {
            System.out.println("ioerror with perl script\n");
        }
        catch (InterruptedException interruptedException) {
            System.out.println("interrupted exception with perl script\n");
        }
        object = Template.FiletoString("template.txt");
        return Template.getTemplateFromString((String)object);
    }

    public static void main(String[] stringArray) {
        new DemoDisplay("Akiva Leffert", "aleffert@cs.cmu.edu", new Rectangle(100, 100, 350, 550), null, null);
    }

    public void closeLogFile() {
    }

    public class ButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == DemoDisplay.this.email) {
                try {
                    Template template = DemoDisplay.this.getTemplateFromUser();
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(Simulator.defaultNewMeetingsFilename));
                    Meeting meeting = new Meeting("MTID", template);
                    String string = meeting.toParseString();
                    bufferedWriter.write(meeting.toParseString());
                    bufferedWriter.close();
                    Simulator.newMeetingsFileExists = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

