/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.data;

import cmradar.manager.data.AgentModel;
import cmradar.manager.data.CalendarViewer;
import cmradar.manager.data.Template;
import cmradar.manager.sim.Utility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class OwnersViewer
extends JFrame
implements Runnable {
    private static final int WIDTH = 800;
    private static final int HEIGHT = 600;
    private static final int ROW_HEIGHT = 50;
    public static final int NAME_COLUMN = 1;
    private static final int PROGRESS_COLUMN = 2;
    private static final int STATUS_COLUMN = 3;
    private static final int TRUE_PROB_COLUMN = 4;
    private static final int LRN_PROB_COLUMN = 5;
    public static final int NONE = 0;
    private static final int LEFT = 1;
    private static final int RIGHT = 2;
    public static final int ASKED = 1;
    public static final int SUCCESS = 2;
    public static final int FAIL = 3;
    public static final int LATE = 4;
    public static final int CUR_REQ_INDEX = 3;
    private Color[] COLORS = new Color[]{Color.white, Color.cyan, Color.green, Color.red, Color.gray};
    private String[] STATUS = new String[]{"", "Asked", "Success", "Fail", "Late"};
    public static boolean DEBUG = false;
    Hashtable agentMap = new Hashtable();
    JPanel myPane;
    JTabbedPane tabPane;
    JTable myTable;
    JTable scTable;
    JTextPane scTextPane;
    JTable rmTable;
    JTextArea curReqArea;
    JTextArea myMemo;
    JButton radarButton;
    SwingCanvas canv;
    RoomOwnerModel tableModel;
    Vector owners = new Vector();
    Color[] msgColors;
    int[] directions;
    static ImageIcon INIT_ICON = new ImageIcon("pics/init.jpg");
    static ImageIcon SUCCESS_ICON = new ImageIcon("pics/success.jpg");

    public OwnersViewer(String string, int n, Object[][] objectArray) {
        super(string);
        this.setDefaultCloseOperation(3);
        this.tabPane = new JTabbedPane();
        this.myPane = new JPanel();
        this.myPane.setLayout(new BoxLayout(this.myPane, 1));
        this.myPane.setOpaque(true);
        this.myTable = new JTable();
        this.myTable.setSelectionMode(2);
        this.myTable.setSelectionBackground(Color.cyan);
        this.setData(objectArray);
        this.myTable.setRowHeight(50);
        this.myTable.setPreferredScrollableViewportSize(new Dimension(800, 50 * objectArray.length));
        JScrollPane jScrollPane = new JScrollPane(this.myTable);
        jScrollPane.setOpaque(true);
        this.myMemo = new JTextArea("CMRadar Room Finder being initiated...", 10, 30);
        JScrollPane jScrollPane2 = new JScrollPane(this.myMemo);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBackground(Color.white);
        jPanel.setOpaque(true);
        this.radarButton = new JButton("cmradar");
        jPanel.add(this.radarButton);
        this.canv = new SwingCanvas();
        this.canv.setPreferredSize(new Dimension(200, 600));
        this.canv.setBackground(Color.white);
        this.canv.setOpaque(true);
        jPanel.add(this.canv);
        jPanel.add(jScrollPane);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 0));
        this.scTextPane = new JTextPane();
        jPanel2.add(new JScrollPane(this.scTextPane));
        JPanel jPanel3 = new JPanel(new GridLayout(1, 0));
        this.rmTable = new JTable();
        this.rmTable.setAutoResizeMode(0);
        JScrollPane jScrollPane3 = new JScrollPane(this.rmTable);
        jPanel3.add(jScrollPane3);
        JPanel jPanel4 = new JPanel(new GridLayout(1, 0));
        this.curReqArea = new JTextArea("", 20, 30);
        this.curReqArea.setLineWrap(true);
        jPanel4.add(this.curReqArea);
        this.tabPane.add("Progress", jPanel);
        this.tabPane.add("Shared Room Calendar", jPanel2);
        this.tabPane.add("All Rooms", jPanel3);
        this.tabPane.add("Current Request", jPanel4);
        this.myPane.add(this.tabPane);
        this.myPane.add(jScrollPane2);
        this.setContentPane(this.myPane);
        this.pack();
        this.setLocation(50, 100);
        this.setVisible(true);
    }

    public OwnersViewer(String string, int n, Object[][] objectArray, boolean bl) {
        super(string);
        this.setDefaultCloseOperation(3);
        this.tabPane = new JTabbedPane();
        this.myPane = new JPanel();
        this.myPane.setLayout(new BoxLayout(this.myPane, 1));
        this.myPane.setOpaque(true);
        this.myTable = new JTable();
        this.myTable.setSelectionMode(2);
        this.myTable.setSelectionBackground(Color.cyan);
        this.setData(objectArray);
        this.myTable.setRowHeight(50);
        this.myTable.setPreferredScrollableViewportSize(new Dimension(800, 600));
        JScrollPane jScrollPane = new JScrollPane(this.myTable);
        jScrollPane.setOpaque(true);
        this.myMemo = new JTextArea("CMRadar Room Finder being initiated...", 10, 30);
        JScrollPane jScrollPane2 = new JScrollPane(this.myMemo);
        JScrollPane jScrollPane3 = new JScrollPane();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBackground(Color.white);
        jPanel.setOpaque(true);
        this.radarButton = new JButton("cmradar");
        jPanel.add(this.radarButton);
        this.canv = new SwingCanvas();
        this.canv.setPreferredSize(new Dimension(200, 600));
        this.canv.setBackground(Color.white);
        this.canv.setOpaque(true);
        jPanel.add(this.canv);
        jPanel.add(jScrollPane);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 0));
        this.scTextPane = new JTextPane();
        jPanel2.add(new JScrollPane(this.scTextPane));
        JPanel jPanel3 = new JPanel(new GridLayout(1, 0));
        this.rmTable = new JTable();
        this.rmTable.setAutoResizeMode(0);
        JScrollPane jScrollPane4 = new JScrollPane(this.rmTable);
        jPanel3.add(jScrollPane4);
        JPanel jPanel4 = new JPanel(new GridLayout(1, 0));
        this.curReqArea = new JTextArea("", 20, 30);
        this.curReqArea.setLineWrap(true);
        JScrollPane jScrollPane5 = new JScrollPane(this.curReqArea);
        jPanel4.add(jScrollPane5);
        this.tabPane.add("Progress", jScrollPane);
        this.tabPane.add("Shared Room Calendar", jPanel2);
        this.tabPane.add("All Rooms", jPanel3);
        this.tabPane.add("Current Request", jPanel4);
        this.myPane.add(this.tabPane);
        this.myPane.add(jScrollPane2);
        this.setContentPane(this.myPane);
        this.pack();
        this.setLocation(50, 100);
        this.setVisible(true);
    }

    public void setData(Object[][] objectArray) {
        this.msgColors = new Color[objectArray.length];
        this.directions = new int[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            ProgressBarObserver progressBarObserver = this.createProgressBar((Integer)objectArray[i][2], this.myTable);
            ObservableOwner observableOwner = new ObservableOwner(1000);
            observableOwner.addObserver(progressBarObserver);
            this.owners.add(observableOwner);
            this.msgColors[i] = Color.white;
            this.directions[i] = 0;
            objectArray[i][2] = progressBarObserver;
            this.agentMap.put(objectArray[i][1], new Integer(i));
        }
        this.tableModel = new RoomOwnerModel(objectArray);
        this.myTable.setModel(this.tableModel);
        this.myTable.getColumnModel().getColumn(2).setCellRenderer(new ProgressBarRenderer());
    }

    public void run() {
    }

    public void setRequestStatus(int n, int n2) {
        this.tableModel.setValueAt(this.STATUS[n2], n, 3);
        this.msgColors[n] = this.COLORS[n2];
        switch (n2) {
            case 1: {
                this.directions[n] = 2;
                ((ObservableOwner)this.owners.elementAt(n)).start();
                break;
            }
            case 3: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                this.directions[n] = 1;
                ((ObservableOwner)this.owners.elementAt(n)).stop();
            }
        }
        this.canv.repaint();
    }

    public void setProbability(String string, float f, float f2) {
        int n = (Integer)this.agentMap.get(string);
        this.tableModel.setValueAt(new Float(f), n, 4);
        this.tableModel.setValueAt(new Float(f2), n, 5);
    }

    public void setRequestStatus(String string, int n) {
        System.out.println("setRequestStatus: " + string + ":" + this.STATUS[n]);
        try {
            int n2 = (Integer)this.agentMap.get(string);
            this.setRequestStatus(n2, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("setRequestStatus: " + string + " error...");
        }
    }

    public static void waitForKey() {
        char[] cArray = new char[64];
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        Object var2_2 = null;
        try {
            System.out.print("Please hit enter to continue>>> ");
            inputStreamReader.read(cArray, 0, 64);
            if (cArray[0] == 'q') {
                System.exit(0);
            }
        }
        catch (IOException iOException) {
            System.out.println("io error");
            System.out.println(iOException);
            System.exit(1);
        }
    }

    private ProgressBarObserver createProgressBar(int n, JTable jTable) {
        ProgressBarObserver progressBarObserver = new ProgressBarObserver();
        progressBarObserver.setMaximum(n);
        progressBarObserver.setBorderPainted(true);
        progressBarObserver.setTable(jTable);
        return progressBarObserver;
    }

    public void setSharedRoomCalendar(String string) {
        try {
            this.scTextPane.setPage(new URL(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setSharedRoomCalendar(Vector vector, Vector vector2) {
        ((DefaultTableModel)this.scTable.getModel()).setDataVector(vector, vector2);
    }

    public void setRooms(Vector vector, Vector vector2) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.rmTable.getModel();
        try {
            defaultTableModel.setColumnIdentifiers(vector);
        }
        catch (Exception exception) {
            System.out.println("label");
            System.exit(0);
        }
        Vector vector3 = null;
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            try {
                vector3 = (Vector)enumeration.nextElement();
                defaultTableModel.addRow(vector3);
            }
            catch (Exception exception) {
                System.out.println("v=" + vector3);
                System.exit(0);
            }
        }
    }

    public void setCurrentRequest(String string) {
        this.curReqArea.setText(string);
        this.appendMsg("A new request received...");
        for (int i = 0; i < this.msgColors.length; ++i) {
            this.msgColors[i] = Color.white;
            this.directions[i] = 0;
            this.setRequestStatus(i, 0);
        }
        this.canv.repaint();
    }

    public void appendMsg(String string) {
        this.myMemo.append("\n");
        this.myMemo.append(Utility.TimeString());
        this.myMemo.append(string);
        this.myMemo.append("\n");
    }

    public void hiliteOwner(String string) {
    }

    public void hiliteOwners(Vector vector) {
    }

    public static void main(String[] stringArray) {
        Object[][] objectArray = new Object[][]{{new ImageIcon("pics/chen.jpg"), "Marie Warren", new Integer(100), "", new Float(0.1), new Float(0.15)}, {new ImageIcon("pics/clay.jpg"), "Robin Tylor", new Integer(50), "", new Float(0.5), new Float(0.45)}, {new ImageIcon("pics/johnson.jpg"), "Galadriel Gustav", new Integer(10), "", new Float(0.9), new Float(0.88)}};
        Object[][] objectArray2 = new Object[][]{};
        if (stringArray.length > 0 && stringArray[0].equals("-debug")) {
            CalendarViewer.DEBUG = true;
        }
        OwnersViewer ownersViewer = new OwnersViewer("CMRadar Room Finder", 0, objectArray2);
        ownersViewer.setCurrentRequest(Template.FiletoString("3.requests"));
        ownersViewer.setData(objectArray);
        ownersViewer.setRequestStatus(0, 1);
        ownersViewer.setRequestStatus(2, 1);
        OwnersViewer.waitForKey();
        ownersViewer.setRequestStatus(0, 2);
    }

    class ProgressBarRenderer
    extends JProgressBar
    implements TableCellRenderer {
        ProgressBarRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof JComponent) {
                return (JComponent)object;
            }
            return null;
        }

        public void setValue(int n) {
            super.setValue(n);
        }
    }

    class ProgressBarObserver
    extends JProgressBar
    implements Observer {
        JTable table;

        ProgressBarObserver() {
        }

        public void setTable(JTable jTable) {
            this.table = jTable;
        }

        public void update(Observable observable, Object object) {
            this.setValue(((ObservableOwner)observable).getCurrentValue());
            ((RoomOwnerModel)this.table.getModel()).fireTableDataChanged();
        }
    }

    class ObservableOwner
    extends Observable
    implements ActionListener {
        Timer timer = new Timer(1000, this);
        int counter = 0;
        int maxValue = 0;

        public ObservableOwner(int n) {
            this.maxValue = n;
            this.timer.setRepeats(true);
        }

        public void start() {
            this.timer.start();
        }

        public void stop() {
            this.timer.stop();
            this.counter = 0;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setChanged();
            this.notifyObservers();
            ++this.counter;
            if (this.counter == this.maxValue) {
                this.timer.stop();
            }
        }

        public int getCurrentValue() {
            return this.counter;
        }
    }

    class SwingCanvas
    extends JPanel {
        SwingCanvas() {
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            RoomOwnerModel roomOwnerModel = (RoomOwnerModel)OwnersViewer.this.myTable.getModel();
            for (int i = 0; i < roomOwnerModel.getRowCount(); ++i) {
                if (OwnersViewer.this.msgColors[i] == Color.white) continue;
                int n = OwnersViewer.this.radarButton.getX() + 2;
                int n2 = OwnersViewer.this.radarButton.getY() + 10;
                int n3 = 200;
                int n4 = 50 * i + 30;
                graphics.setColor(OwnersViewer.this.msgColors[i]);
                graphics.drawLine(n, n2, n3, n4);
            }
        }

        private void drawArrow(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            int n6 = 10;
            double d = Math.atan((n5 - n3) / (n4 - n2));
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            if (n == 2) {
                n7 = n4 - (int)Math.ceil((double)n6 * Math.cos(d + 2.5464790894703255));
                n8 = n4 - (int)Math.ceil((double)n6 * Math.cos(d - 2.5464790894703255));
                n9 = n5 + (int)Math.ceil((double)n6 * Math.sin(d + 2.5464790894703255));
                n10 = n5 + (int)Math.ceil((double)n6 * Math.sin(d - 2.5464790894703255));
                n11 = n4;
                n12 = n5;
            } else if (n == 1) {
                n7 = n2 + (int)Math.ceil((double)n6 * Math.cos(d + 2.5464790894703255));
                n8 = n2 + (int)Math.ceil((double)n6 * Math.cos(d - 2.5464790894703255));
                n9 = n3 + (int)Math.ceil((double)n6 * Math.sin(d + 2.5464790894703255));
                n10 = n3 + (int)Math.ceil((double)n6 * Math.sin(d - 2.5464790894703255));
                n11 = n2;
                n12 = n3;
            }
            int[] nArray = new int[]{n7, n8, n11};
            int[] nArray2 = new int[]{n9, n10, n12};
            graphics.fillPolygon(nArray, nArray2, 3);
            graphics.setColor(Color.blue);
            graphics.fillRect(n7, n9, 2, 2);
            graphics.setColor(Color.red);
            graphics.fillRect(n8, n10, 2, 2);
        }
    }

    class RoomOwnerModel
    extends AgentModel {
        private String[] colNames = new String[]{"Picture", "Name", "Response speed", "Status", "Bumping Probability", ""};

        public RoomOwnerModel(Object[][] objectArray) {
            this.columnNames = this.colNames;
            this.data = objectArray;
        }
    }
}

