/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.calendar;

import edu.cmu.cs.radar.rhai.calendar.Constraint;
import edu.cmu.cs.radar.rhai.calendar.Time;
import edu.cmu.cs.radar.rhai.calendar.TimeView;
import edu.cmu.cs.radar.rhai.spacetime.SwingHelper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class ConstraintView
extends JComponent {
    private static final long serialVersionUID = 1L;
    protected Constraint[] mConstraints;

    public ConstraintView(Constraint[] constraints) {
        if (constraints == null) {
            throw new NullPointerException("argument 'constraints'");
        }
        this.mConstraints = (Constraint[])constraints.clone();
        int i = 0;
        while (i < this.mConstraints.length) {
            if (this.mConstraints[i] == null) {
                throw new NullPointerException("argument 'constraints[" + i + "]'");
            }
            ++i;
        }
    }

    public TimeView getTimeView() {
        return (TimeView)this.getParent();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = SwingHelper.prepareGraphics(g);
        TimeView atv = this.getTimeView();
        int leftEdge = 9;
        int rightEdge = this.getWidth() - 2;
        g2.setPaint(new Color(224, 224, 224));
        g2.drawLine(rightEdge, 0, rightEdge, this.getHeight());
        Constraint[] constraintArray = this.mConstraints;
        int n = this.mConstraints.length;
        int n2 = 0;
        while (n2 < n) {
            Constraint cons = constraintArray[n2];
            Time.Range range = cons.getRange();
            int top = atv.getValueForTimeAsInteger(range.getStart());
            int bottom = atv.getValueForTimeAsInteger(range.getEnd());
            g2.setStroke(new BasicStroke(2.0f, 1, 1));
            g2.setPaint(Color.GRAY);
            g2.drawLine(leftEdge, top, rightEdge, top);
            g2.drawLine(rightEdge, top, rightEdge, bottom);
            g2.drawLine(leftEdge, bottom, rightEdge, bottom);
            this.paintLabel(cons.getLabel(), top, g2);
            Time.Range prefRange = cons.getPreferenceRange();
            if (prefRange != null) {
                top = atv.getValueForTimeAsInteger(prefRange.getStart());
                bottom = atv.getValueForTimeAsInteger(prefRange.getEnd());
                g2.setPaint(Color.GRAY);
                g2.fillRect(rightEdge - 4, top, 4, bottom - top + 1);
            }
            ++n2;
        }
    }

    protected void paintLabel(String label, int top, Graphics2D g2) {
        g2 = (Graphics2D)g2.create();
        g2.setPaint(Color.BLACK);
        FontMetrics fm = g2.getFontMetrics();
        Rectangle2D strLabelBounds = fm.getStringBounds(label, g2);
        AffineTransform trans = AffineTransform.getTranslateInstance(this.getWidth() - 7, (double)top + strLabelBounds.getWidth() + 4.0);
        trans.concatenate(AffineTransform.getRotateInstance(-1.5707963267948966));
        g2.transform(trans);
        g2.drawString(label, 0, 0);
    }
}

