/** class CMRadarProvides (cmradar shims interface for radar integration)
 * jeanoh 2007
 */
//package edu.cmu.cs.radar.integ;
package cmradar;

import java.io.*;
import java.util.Map;
import cmradar.manager.sim.RSimulator;
import cmradar.manager.data.Template;
import cmradar.manager.data.RoomTemplate;
import cmradar.manager.data.TimeSlot;
import org.apache.log4j.*;
import edu.cmu.cs.radar.integ.*;

public class CMRadarShim implements ICMRadarProvides {
    
    RSimulator _cmradar;
    IRadarServices _radar;
    static Logger logger = Logger.getLogger(CMRadarShim.class.getName()); 
    
    public CMRadarShim() {}
 
    // root directory for input files
    public static String CMRADAR_CONFIG = "radar.cmradar.config";
    public static String CMRADAR_CONFIG_DEFAULT = "c:/cmradar";
 
    public boolean initialize(IRadarServices rs) {
	try {
	    String cfg = rs.getProps().getProperty(CMRADAR_CONFIG,
						   CMRADAR_CONFIG_DEFAULT);
	    _cmradar = new RSimulator(cfg);	
	    _radar = rs;
	    _cmradar.setRadarHandle(_radar);
	} catch (Exception ex) { ex.printStackTrace(); return false; }
	return true;
    }

    /* for testing */
    public boolean initialize(IRadarServices rs, String cfg) {
	try {
	    _cmradar = new RSimulator(cfg);	
	    _radar = rs;
	    _cmradar.setRadarHandle(_radar);
	} catch (Exception ex) { ex.printStackTrace(); return false; }
	return true;
    }
    /* returns the total number of requests sent to local room owners */
    //public int numRequestsLocal() { return _cmradar.numRequestsLocal(); }

    /* returns the total number of requests sent to external room owners */
    //public int numRequestsExternal() { return _cmradar.numRequestsExternal(); }

    /* returns the total number of room finding requests in the current session */
    //public int numRequests() { return _cmradar.numRequests(); }

    /* returns the total number of room finding requests failed in the current session */
    //public int numFailedRequests() { return _cmradar.numFailedRequests(); }


    public void printStat() {
	_cmradar.printStat();
    }    

    public void saveStat() {
	_cmradar.saveStat();
    }

    public boolean done() {
	return _cmradar.done();
    }

    public boolean shutdown() {
	saveStat();
	_cmradar.dieGracefully();
	return true;
    }

    // please find a room for the associated spec.
    // return is asynchronous.
    public void requestRoom(EventInformation ei) {

	RoomTemplate t = new RoomTemplate(ei);	
	logger.log(Level.INFO, "CMRadarShims.requestRoom:\n" + t.toLispList() + "\n" + ei);

	_cmradar.writeLog(t.toLispList());
	_cmradar.requestRoom(t);	
    }
}