/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.sys.calendar.CalendarObjects;

import cmradar.manager.data.Meeting;
import cmradar.manager.data.Template;
import java.awt.Color;
import java.util.Vector;
import javax.swing.JLabel;

public class MeetingDataLink {
    private Color c;
    private Meeting m;
    private static JLabel label;

    public MeetingDataLink(Meeting meeting, Color color) {
        this.c = color;
        this.m = meeting;
    }

    public MeetingDataLink() {
        this(null, Color.white);
    }

    public Color getColor() {
        return this.c;
    }

    public String getId() {
        if (this.m == null) {
            return "";
        }
        return " " + this.m.getMeetingId();
    }

    public String getLabelString() {
        if (this.m == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(" " + this.m.getMeetingLabel());
        if (!this.m.getTypeString().equals(":red")) {
            Template template = this.m.toTemplate();
            String string = template.getInitiator();
            stringBuffer.append(" (" + string);
            Vector vector = template.getAttendantIds();
            for (int i = 0; i < vector.size(); ++i) {
                String string2 = (String)vector.elementAt(i);
                if (string2.equals(string)) continue;
                stringBuffer.append("," + string2);
            }
            stringBuffer.append(") ");
        }
        return stringBuffer.toString();
    }

    public JLabel getLabel() {
        if (this.m == null) {
            label = new JLabel();
        } else {
            System.out.println("adding label");
            StringBuffer stringBuffer = new StringBuffer(this.m.getMeetingId() + "(");
            Template template = this.m.toTemplate();
            Vector vector = template.getAttendantIds();
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.elementAt(i);
                stringBuffer.append(string);
                if (i >= vector.size()) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(")");
            label = new JLabel(stringBuffer.toString());
        }
        return label;
    }

    public String toString() {
        if (this.m == null) {
            return "None";
        }
        return "Meeting";
    }

    public void add(Meeting meeting) {
        this.m = meeting;
    }

    public void clear() {
        this.m = null;
    }

    public Meeting getMeeting() {
        return this.m;
    }
}

