/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.sys;

import cmradar.manager.data.Calendar;
import cmradar.manager.data.Meeting;
import cmradar.manager.sim.AgentInfo;
import cmradar.manager.sim.MeetingInfo;
import cmradar.manager.sim.SimParameters;
import cmradar.manager.sys.CalendarDisplayThread;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;

public class CalendarDisplay {
    static int x = 50;
    static int y = 50;

    public static int getType(double d, Random random) {
        double d2 = random.nextDouble();
        if (d2 <= d) {
            return 0;
        }
        return 1;
    }

    public static void putTypesInCalendar(Vector vector, Calendar calendar, int[] nArray) {
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            MeetingInfo meetingInfo = (MeetingInfo)vector.elementAt(i);
            Meeting meeting = calendar.getMeeting(meetingInfo.getMeetingId());
            if (meeting == null) continue;
            meeting.label = n++;
            n %= 3;
        }
    }

    private static void printCLIParams() {
        System.out.println("Usage:\n");
        System.out.println("CalendarDisplay agents meetings calendar [meeting2]\n");
    }

    public static void main(String[] stringArray) {
        int n;
        Object object;
        Vector vector;
        Vector vector2;
        if (stringArray.length == 0) {
            CalendarDisplay.printCLIParams();
            System.exit(1);
        }
        SimParameters simParameters = new SimParameters();
        if (stringArray.length != 3 && stringArray.length != 4) {
            CalendarDisplay.printCLIParams();
            System.exit(1);
        }
        try {
            simParameters.parseAgentsFile(stringArray[0]);
            simParameters.parseOldMeetingsFile(stringArray[1]);
            if (stringArray.length == 4) {
                simParameters.parseNewMeetingsFile(stringArray[3]);
            }
            vector2 = simParameters.getOldMeetings();
            vector = simParameters.getNewMeetings();
            for (int i = 0; i < vector.size(); ++i) {
                object = (MeetingInfo)vector.get(i);
                vector2.add(object);
            }
            simParameters.parseCalendarFile(stringArray[2]);
        }
        catch (IOException iOException) {
            System.err.println("Error starting CalendarDisplay. Quitting.");
            System.exit(0);
        }
        vector2 = simParameters.getOldMeetings();
        vector = simParameters.getCalendars();
        Vector vector3 = simParameters.getAgents();
        object = new int[vector2.size()];
        Random random = new Random(123456L);
        for (n = 0; n < ((int[])object).length; ++n) {
            object[n] = CalendarDisplay.getType(0.5, random);
        }
        for (n = 0; n < vector.size(); ++n) {
            Calendar calendar = (Calendar)vector.elementAt(n);
            CalendarDisplay.putTypesInCalendar(vector2, calendar, object);
        }
        CalendarDisplayThread[] calendarDisplayThreadArray = new CalendarDisplayThread[vector3.size()];
        for (int i = 0; i < vector3.size(); ++i) {
            AgentInfo agentInfo = (AgentInfo)vector3.elementAt(i);
            for (int j = 0; j < vector.size(); ++j) {
                Calendar calendar = (Calendar)vector.get(j);
                if (!calendar.myUserId.equals(agentInfo.getUserId())) continue;
                calendarDisplayThreadArray[i] = new CalendarDisplayThread(agentInfo, calendar);
                calendarDisplayThreadArray[i].start();
            }
        }
        while (true) {
            try {
                while (true) {
                    Thread.sleep(5000L);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }
}

