/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.sim;

import cmradar.manager.data.Meeting;
import cmradar.manager.data.OwnersViewer;
import cmradar.manager.data.Room;
import cmradar.manager.data.RoomTemplate;
import cmradar.manager.data.SharedRoomCalendar;
import cmradar.manager.data.TimeSlot;
import cmradar.manager.ext.Learner;
import cmradar.manager.ext.Matrix2;
import cmradar.manager.ext.MemoryBasedLearner;
import cmradar.manager.neg.RoomNegotiator;
import cmradar.manager.sim.AgentInfo;
import cmradar.manager.sim.AgentThread;
import cmradar.manager.sim.MessageCommunicator;
import cmradar.manager.sim.SimParameters;
import cmradar.manager.sim.Simulator;
import cmradar.manager.sim.TestInfo;
import cmradar.manager.sim.Utility;
import cmradar.manager.sys.SchedulerInvoker;
import edu.cmu.cs.radar.integ.IRadarServices;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;

public class RSimulator
extends Simulator
implements MessageCommunicator {
    Properties config;
    public static boolean debugmode = false;
    public static String REQUEST_DIR = ".";
    private static String SC_TEMPLATES = null;
    public static boolean OV_DEMO = false;
    private OwnersViewer ov;
    private AgentThread cmradarAgent = null;
    private static final String CMRADAR_DELIM = "*^^*";
    private int nRoomRequests;
    private int nFree;
    private int nBump;
    private int nExt;
    private int nFail;
    private int nNoop;
    private int nReqLocal;
    private int nReqExt;
    private int nReqLocalT;
    private int nReqLocalF;
    private int nReqExtT;
    private int nReqExtF;
    static Logger logger = Logger.getLogger((String)(class$cmradar$manager$sim$Simulator == null ? (class$cmradar$manager$sim$Simulator = RSimulator.class$("cmradar.manager.sim.Simulator")) : class$cmradar$manager$sim$Simulator).getName());
    String _root;
    String _configDir = "config/";
    String _configFile;
    BufferedWriter logFile;
    static /* synthetic */ Class class$cmradar$manager$sim$Simulator;

    public RSimulator() {
    }

    public RSimulator(String string) {
        this._root = string;
        if (!this._root.endsWith("/")) {
            this._root = this._root + "/";
        }
        this._configFile = this._root + this._configDir + "cmradar.properties";
        REQUEST_DIR = this._root + this._configDir;
        if (REQUEST_DIR.endsWith("/")) {
            REQUEST_DIR = REQUEST_DIR.substring(0, REQUEST_DIR.length() - 1);
        }
        this.configure();
    }

    public RSimulator(String string, String string2) {
        this._root = string;
        if (!this._root.endsWith("/")) {
            this._root = this._root + "/";
        }
        this._configFile = this._root + string2;
        this._configDir = "";
        this.configure(false);
    }

    public void setRadarHandle(IRadarServices iRadarServices) {
        RoomNegotiator roomNegotiator = (RoomNegotiator)this.cmradarAgent.getNegotiator();
        roomNegotiator.setRadarHandle(iRadarServices);
    }

    public void configure() {
        this.configure(true);
    }

    public void configure(boolean bl) {
        block13: {
            logger.log((Priority)Level.INFO, (Object)"____________CONFIGURE____________");
            this.config = new Properties();
            try {
                Object object;
                FileInputStream fileInputStream = new FileInputStream(this._configFile);
                this.config.load(fileInputStream);
                fileInputStream.close();
                this.params = new SimParameters();
                String string = this._root + this._configDir + this.config.getProperty("cmradar.agents", "cmradar").trim() + ".agents";
                String string2 = this._root + this._configDir + this.config.getProperty("cmradar.rooms", "cmradar").trim() + ".rooms";
                String string3 = this._root + this._configDir + this.config.getProperty("cmradar.penalty", "bumping-penalty.lisp").trim();
                String string4 = this._root + this._configDir + this.config.getProperty("cmradar.trueowners", "cmradar").trim() + ".owners";
                String string5 = this._root + this._configDir + this.config.getProperty("cmradar.learnedowners", "cmradar-learned").trim() + ".owners";
                String string6 = this.config.getProperty("cmradar.hotels", "Flagstaff").trim();
                String string7 = this.config.getProperty("cmradar.schedulerLogLevel", "0");
                String string8 = this.config.getProperty("cmradar.numOptions", "10");
                String string9 = this.config.getProperty("cmradar.SchedulerExe", "scheduler/cmradar-room.exe");
                if (string9.indexOf(":") < 0) {
                    string9 = this._root + string9;
                }
                SchedulerInvoker.SCHED_EXE = string9;
                TimeSlot.setTimezone(this.config.getProperty("cmradar.timezone", "EST-0500").trim());
                String[] stringArray = new String[3];
                int n = 10;
                stringArray[0] = string;
                stringArray[1] = string2;
                stringArray[2] = string5;
                String string10 = this._root + this._configDir + this.config.getProperty("cmradar.sharedcal", "cmradar").trim();
                String string11 = string10 + ".rsim";
                String string12 = string10 + ".meetings";
                string10 = string10 + ".sharedroomcalendar";
                if (string7 != null) {
                    schedulerLogLevel = Integer.parseInt(string7.trim());
                }
                if (string8 != null) {
                    n = Integer.parseInt(string8.trim());
                }
                try {
                    this.params.parseConfigFile(this._configFile);
                    this.params.parseAgentsFile(string);
                    object = this.params.parseExternalBuildings(string6);
                    this.params.parseRoomFile(string2, (Vector)object);
                    this.params.parseOwnersFile(string4);
                    this.params.setOwnersFileName(string5);
                    this.params.parseOldMeetingsFile(string12);
                    this.params.parseSharedRoomCalendarFile(string10, string11);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    logger.log((Priority)Level.ERROR, (Object)"parsing input file");
                    System.exit(0);
                }
                object = null;
                String string13 = this._root + this._configDir + this.config.getProperty("cmradar.rank", "cmradar");
                if (string13 != null && new File(string13 = string13.trim() + ".rank").exists()) {
                    object = new MemoryBasedLearner(new Matrix2(string13));
                }
                if (object == null) {
                    object = new MemoryBasedLearner();
                }
                SharedRoomCalendar sharedRoomCalendar = this.params.getSharedRoomCalendar();
                TestInfo testInfo = this.params.getTestInfo();
                sharedRoomCalendar.setLearner((Learner)object, testInfo);
                Vector vector = this.params.getRooms();
                SharedRoomCalendar sharedRoomCalendar2 = this.params.getSharedRoomCalendar();
                logger.log((Priority)Level.INFO, (Object)("local roomsz=" + vector.size()));
                this.msgQs = new Hashtable(Collections.synchronizedMap(new Hashtable()));
                if (!bl) break block13;
                Vector vector2 = this.params.getAgents();
                this.threads = new AgentThread[vector2.size()];
                logger.log((Priority)Level.INFO, (Object)("AGENTS=" + this.threads.length));
                try {
                    this.logFile = new BufferedWriter(new FileWriter(this._root + this._configDir + "cmradary3.log"));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                for (int i = 0; i < vector2.size(); ++i) {
                    AgentInfo agentInfo = (AgentInfo)vector2.elementAt(i);
                    this.threads[i] = new AgentThread((MessageCommunicator)this, agentInfo, this.logFile);
                    this.threads[i].setOwnersViewer(this.ov);
                    this.threads[i].init(stringArray[0], stringArray[1], stringArray[2], string3);
                    if (i == 0) {
                        port = agentInfo.getPortNumber();
                    }
                    this.addMsgReceiver(agentInfo.getUserId());
                    this.threads[i].set_sharedroomcalendar(sharedRoomCalendar2);
                    if (!agentInfo.getAgentType().startsWith("RoomNegotiator")) continue;
                    this.cmradarAgent = this.threads[i];
                    RoomNegotiator roomNegotiator = (RoomNegotiator)this.cmradarAgent.getNegotiator();
                    roomNegotiator.setNumOptions(n);
                }
                this.timeStart = Utility.TimeMS();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                logger.log((Priority)Level.ERROR, (Object)this._configFile);
                System.exit(0);
            }
        }
        logger.log((Priority)Level.INFO, (Object)"CMRadar configured! -------------------");
    }

    public void requestRoom(RoomTemplate roomTemplate) {
        this.timeStart = Utility.TimeMS();
        int n = 0;
        while (this.cmradarAgent.isRequestActive()) {
            logger.log((Priority)Level.INFO, (Object)"request active!");
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n != 60) continue;
        }
        this.sendMessage(roomTemplate.toLispList(), this.cmradarAgent.getUserId(), this.cmradarAgent.getUserId(), false);
        while (!this.QuiDetected() && !this.timeout()) {
            ++this.cycleCnt;
            for (int i = 0; i < this.threads.length; ++i) {
                this.threads[i].runOneCycle();
            }
        }
    }

    public void incrCount(int n) {
        ++this.nRoomRequests;
        switch (n) {
            case 1: {
                ++this.nBump;
                break;
            }
            case 0: {
                ++this.nFree;
                break;
            }
            case 3: {
                ++this.nExt;
                break;
            }
            case 2: {
                ++this.nFail;
                break;
            }
        }
    }

    public void incrNoop() {
        ++this.nNoop;
    }

    public void incrLocalRequests() {
        ++this.nReqLocal;
    }

    public void incrExternalRequests() {
        ++this.nReqExt;
    }

    public void incrLocalRequests(boolean bl) {
        if (bl) {
            ++this.nReqLocalT;
        } else {
            ++this.nReqLocalF;
        }
    }

    public void incrExternalRequests(boolean bl) {
        if (bl) {
            ++this.nReqExtT;
        } else {
            ++this.nReqExtF;
        }
    }

    public int numRequestsLocal() {
        return this.nReqLocal;
    }

    public int numRequestsLocal(boolean bl) {
        return bl ? this.nReqLocalT : this.nReqLocalF;
    }

    public int numRequestsExternal() {
        return this.nReqExt;
    }

    public int numRequestsExternal(boolean bl) {
        return bl ? this.nReqExtT : this.nReqExtF;
    }

    public int numRequests() {
        return this.nRoomRequests;
    }

    public int numFailedRequests() {
        return this.nFail;
    }

    public int numFree() {
        return this.nFree;
    }

    public int numBump() {
        return this.nBump;
    }

    public int numExt() {
        return this.nExt;
    }

    public int numNoop() {
        return this.nNoop;
    }

    public void printStat() {
        System.out.println("[" + new Date().toString() + "] CMRadar Statistics");
        System.out.println("Total       " + this.numRequests());
        System.out.println("Neg.  Fail  " + (this.numFailedRequests() - this.numNoop()));
        System.out.println("Pref. Fail  " + this.numNoop());
        System.out.println("Success     " + (this.numRequests() - this.numFailedRequests()));
        System.out.println("----------------------------------");
        System.out.println("Rooms obtained:");
        System.out.println("Free        " + this.numFree());
        System.out.println("Bump        " + this.numBump());
        System.out.println("External    " + this.numExt());
        System.out.println("-----------------------------------");
        System.out.println("Local Rooms");
        System.out.println("LocQueried  " + this.numRequestsLocal());
        System.out.println("LocAccepted " + this.numRequestsLocal(true));
        System.out.println("LocRejected " + this.numRequestsLocal(false));
        System.out.println("-----------------------------------");
        System.out.println("External Rooms");
        System.out.println("ExtQueried  " + this.numRequestsExternal());
        System.out.println("ExtAccepted " + this.numRequestsExternal(true));
        System.out.println("ExtRejected " + this.numRequestsExternal(false));
    }

    public void saveStat() {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this._root + this._configDir + "cmradar-stat.log", true));
            bufferedWriter.write("[" + new Date().toString() + "] CMRadar Statistics\n");
            bufferedWriter.write("Total       " + this.numRequests() + "\n");
            bufferedWriter.write("Neg.  Fail  " + (this.numFailedRequests() - this.numNoop()) + "\n");
            bufferedWriter.write("Pref. Fail  " + this.numNoop() + "\n");
            bufferedWriter.write("Success     " + (this.numRequests() - this.numFailedRequests()) + "\n");
            bufferedWriter.write("----------------------------------\n");
            bufferedWriter.write("Rooms obtained:\n");
            bufferedWriter.write("Free        " + this.numFree() + "\n");
            bufferedWriter.write("Bump        " + this.numBump() + "\n");
            bufferedWriter.write("External    " + this.numExt() + "\n");
            bufferedWriter.write("-----------------------------------\n");
            bufferedWriter.write("Local Rooms\n");
            bufferedWriter.write("LocQueried  " + this.numRequestsLocal() + "\n");
            bufferedWriter.write("LocAccepted " + this.numRequestsLocal(true) + "\n");
            bufferedWriter.write("LocRejected " + this.numRequestsLocal(false) + "\n");
            bufferedWriter.write("-----------------------------------\n");
            bufferedWriter.write("External Rooms\n");
            bufferedWriter.write("ExtQueried  " + this.numRequestsExternal() + "\n");
            bufferedWriter.write("ExtAccepted " + this.numRequestsExternal(true) + "\n");
            bufferedWriter.write("ExtRejected " + this.numRequestsExternal(false) + "\n");
            bufferedWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getCMRadarAgentName() {
        return this.cmradarAgent.getAgentName();
    }

    public boolean done() {
        RoomNegotiator roomNegotiator = (RoomNegotiator)this.cmradarAgent.getNegotiator();
        int n = this.getNumMessages(this.cmradarAgent.getUserId());
        return !roomNegotiator.isRequestActive() && n == 0;
    }

    public void dieGracefully() {
        this.closeLogFile();
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i].start();
            this.threads[i].run();
            this.threads[i].finish();
        }
        System.out.println("Done.");
    }

    public void writeLog(String string) {
        if (this.logFile == null) {
            return;
        }
        try {
            this.logFile.write(string + "\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initLogFile(String string) {
        if (string != null) {
            try {
                this.logFile = new BufferedWriter(new FileWriter(string, true));
                this.logFile.write("\n[" + new Date().toString() + "]----BEGINNING NEW RUN----\n");
                System.out.println("using logfile: " + string);
                for (int i = 0; i < this.threads.length; ++i) {
                    this.threads[i].initLogFile(this.logFile);
                }
            }
            catch (IOException iOException) {
                logger.log((Priority)Level.ERROR, (Object)"Unable to open manager log file. Continuing without log.");
            }
        } else {
            System.out.println("initLogFile: logFileName is null!");
        }
    }

    public void closeLogFile() {
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i].closeLogFile();
        }
    }

    private void init_calendars(SimParameters simParameters) {
        long l = Utility.TimeMS();
        System.out.print(" Initializing shared calendars...");
        SharedRoomCalendar sharedRoomCalendar = simParameters.getSharedRoomCalendar();
        if (sharedRoomCalendar == null) {
            logger.log((Priority)Level.ERROR, (Object)"local calendar is null!!!");
        }
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i].set_sharedroomcalendar(sharedRoomCalendar);
        }
        long l2 = Utility.TimeMS();
        System.out.println("done. [Time elapsed: " + (l2 - l) / 1000L + " seconds.]");
    }

    public void requestRoom(String string, String string2, String string3, int n) {
    }

    public void runSynchronousMode() {
        this.elapsed = ((double)Utility.TimeMS() - (double)this.timeStart) / 1000.0;
        Vector vector = this.params.getRequests();
        for (int i = 0; i < vector.size(); ++i) {
            int n;
            RoomTemplate roomTemplate = (RoomTemplate)vector.elementAt(i);
            logger.log((Priority)Level.INFO, (Object)("Sim: Initiate request " + roomTemplate.getMeetingId() + " to " + roomTemplate.getInitiator()));
            for (n = 0; n < this.threads.length; ++n) {
                if (!this.threads[n].getUserId().equals(roomTemplate.getInitiator())) continue;
                int n2 = 0;
                while (this.threads[n].isRequestActive()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (n2 != 60) continue;
                }
                this.sendMessage(roomTemplate.toLispList(), this.threads[n].getUserId(), this.threads[n].getUserId(), false);
                break;
            }
            while (!this.QuiDetected() && !this.timeout()) {
                ++this.cycleCnt;
                for (n = 0; n < this.threads.length; ++n) {
                    this.threads[n].runOneCycle();
                }
            }
        }
    }

    public void printExecutionStatus() {
        if (this.mode.isSync()) {
            String string = "  cycles elapsed";
            System.out.println(string + Utility.fillerString(string) + this.cycleCnt);
            String string2 = "  total msgs communicated";
            System.out.println(string2 + Utility.fillerString(string2) + this.msgCnt);
            for (int i = 0; i < this.threads.length; ++i) {
                String string3 = this.threads[i].getUserId();
                LinkedList linkedList = (LinkedList)this.msgQs.get(string3);
            }
        }
    }

    public static void copyFile(String string, String string2) {
        try {
            int n;
            File file = new File(string);
            File file2 = new File(string2);
            FileReader fileReader = new FileReader(file);
            FileWriter fileWriter = new FileWriter(file2);
            while ((n = fileReader.read()) != -1) {
                fileWriter.write(n);
            }
            fileReader.close();
            fileWriter.close();
        }
        catch (Exception exception) {
            logger.log((Priority)Level.ERROR, (Object)("Error.RSimulator.copyFile() " + exception.toString()));
        }
    }

    public static Vector timeList(String[] stringArray) {
        Vector<TimeSlot> vector = new Vector<TimeSlot>();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("~");
            TimeSlot timeSlot = new TimeSlot(stringArray2[0], stringArray2[1]);
            vector.add(timeSlot);
        }
        return vector;
    }

    public void loadCrisis(String string) {
        int n;
        String[] stringArray;
        SharedRoomCalendar sharedRoomCalendar = this.params.getSharedRoomCalendar();
        logger.log((Priority)Level.INFO, (Object)("Loading crisis from " + string + " src=" + sharedRoomCalendar));
        Properties properties = new Properties();
        try {
            stringArray = new FileInputStream(string);
            properties.load((InputStream)stringArray);
            stringArray.close();
        }
        catch (Exception exception) {
            logger.log((Priority)Level.ERROR, (Object)(string + ": file not found."));
            System.exit(0);
        }
        stringArray = properties.getProperty("cmradar.conference", "").split(",");
        String[] stringArray2 = properties.getProperty("cmradar.crisis", "").split(",");
        String[] stringArray3 = properties.getProperty("cmradar.conferenceRoom", "").split(",");
        String[] stringArray4 = properties.getProperty("cmradar.crisisBuilding", "UC").trim().split(",");
        Vector vector = RSimulator.timeList(stringArray);
        Vector vector2 = RSimulator.timeList(stringArray2);
        Vector<String> vector3 = new Vector<String>();
        for (n = 0; n < stringArray4.length; ++n) {
            vector3.add(stringArray4[n]);
        }
        n = -1;
        Vector<String> vector4 = new Vector<String>();
        vector4.add("Randal");
        for (int i = 0; i < stringArray3.length; ++i) {
            Room room = sharedRoomCalendar.getRoomFromId(stringArray3[i]);
            logger.log((Priority)Level.INFO, (Object)("R" + room.getRoomId()));
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                TimeSlot timeSlot = (TimeSlot)iterator.next();
                LinkedList linkedList = sharedRoomCalendar.getMeetings(room, timeSlot);
                Object object = linkedList.iterator();
                while (object.hasNext()) {
                    Meeting meeting = (Meeting)object.next();
                    sharedRoomCalendar.removeMeeting(room, meeting);
                }
                object = new Meeting("Randal", "__conf__" + ++n, "Randal", 6, vector4);
                ((Meeting)object).setDuration(timeSlot.getDurationSecond());
                ((Meeting)object).setTimeSlotStatus("Randal", timeSlot, "confirmed");
                sharedRoomCalendar.confirmMeeting(room, (Meeting)object, timeSlot, true);
                logger.log((Priority)Level.INFO, (Object)("  TS=" + timeSlot.toParseString() + " conf=" + ((Meeting)object).getMeetingId()));
            }
        }
        sharedRoomCalendar.addCrisis(vector2, vector3, "Randal", "__crisis__");
        sharedRoomCalendar.saveFile("crisis");
        logger.log((Priority)Level.INFO, (Object)"generation done. saving into html. may take a few seconds.");
        sharedRoomCalendar.quickHtml("crisis.html", this.config);
    }

    private static void printCLIParams() {
        System.out.println("Usage:\n");
        System.out.println("RSimulator\n\t\t| -rsched configFile requestFile\n OR \n\t\t| -crisis rootDir configFile\n");
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            RSimulator.printCLIParams();
            System.exit(1);
        }
        PropertyConfigurator.configure((String)"radar.properties");
        Properties properties = new Properties();
        RSimulator rSimulator = null;
        SimParameters simParameters = new SimParameters();
        if (stringArray[0].indexOf("debug") >= 0) {
            debugmode = true;
        }
        if (stringArray[0].indexOf("-rsched") >= 0) {
            logger.log((Priority)Level.INFO, (Object)("conf=" + stringArray[1]));
            rSimulator = new RSimulator(stringArray[1]);
            rSimulator.params.parseRequestFile(stringArray[2]);
            rSimulator.runSynchronousMode();
            rSimulator.dieGracefully();
        } else if (stringArray[0].indexOf("-crisis") >= 0) {
            rSimulator = new RSimulator(stringArray[1], stringArray[2]);
            String string = "crisis.properties";
            rSimulator.loadCrisis(string);
        } else {
            RSimulator.printCLIParams();
            System.exit(1);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

