/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.sim;

import cmradar.manager.data.Calendar;
import cmradar.manager.data.Meeting;
import cmradar.manager.data.TimeSlot;
import cmradar.manager.sim.AgentInfo;
import cmradar.manager.sim.MeetingInfo;
import cmradar.manager.sim.SimParameters;
import cmradar.manager.sys.RManagerIOSystem;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class CalendarReader {
    public static Vector parseCalendarFile(String string, SimParameters simParameters) {
        String string2;
        Vector<Calendar> vector = new Vector<Calendar>();
        Vector vector2 = simParameters.getOldMeetings();
        BufferedReader bufferedReader = null;
        boolean bl = false;
        String string3 = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (Exception exception) {
            System.out.println(exception);
            System.out.println("Could not open " + string);
            System.exit(0);
        }
        try {
            string3 = bufferedReader.readLine();
        }
        catch (Exception exception) {
            System.out.println(exception);
            return vector;
        }
        while (string3 != null) {
            try {
                string2 = bufferedReader.readLine();
            }
            catch (Exception exception) {
                System.out.println(exception);
                break;
            }
            if (string3.startsWith("#Final Calendars")) break;
            string3 = string2;
        }
        while (!bl) {
            try {
                string3 = bufferedReader.readLine();
            }
            catch (Exception exception) {
                System.out.println(exception);
                bl = true;
            }
            if (bl || string3 == null) {
                bl = true;
                break;
            }
            if (!string3.startsWith("calendar")) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string3);
            stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            String string4 = "null";
            Vector vector3 = simParameters.getAgents();
            for (int i = 0; i < vector3.size(); ++i) {
                AgentInfo agentInfo = (AgentInfo)vector3.get(i);
                if (!agentInfo.getUserId().equals(string2)) continue;
                string4 = agentInfo.getUserPrefs();
            }
            if (string4.equals("null")) {
                System.out.println(string + " Error: No preference type for " + string2);
                System.exit(0);
            }
            Calendar calendar = new Calendar(string2, string4, simParameters.getTestInfo());
            boolean bl2 = false;
            block13: while (!bl2) {
                try {
                    string3 = bufferedReader.readLine();
                }
                catch (Exception exception) {
                    System.out.println(exception);
                    bl = true;
                }
                if (string3 == null || string3.length() == 0) {
                    bl2 = true;
                    continue;
                }
                if (string3.startsWith("#")) continue;
                stringTokenizer = new StringTokenizer(string3);
                String string5 = stringTokenizer.nextToken();
                StringBuffer stringBuffer = new StringBuffer();
                while (stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(stringTokenizer.nextToken());
                    if (!stringTokenizer.hasMoreTokens()) continue;
                    stringBuffer.append(" ");
                }
                for (int i = 0; i < vector2.size(); ++i) {
                    MeetingInfo meetingInfo = (MeetingInfo)vector2.elementAt(i);
                    if (!meetingInfo.getMeetingId().equals(string5)) continue;
                    TimeSlot timeSlot = new TimeSlot(stringBuffer.toString());
                    Meeting meeting = new Meeting(string2, meetingInfo.toTemplate());
                    meeting.setTimeSlotStatus(string2, timeSlot, "confirmed");
                    meeting.setConfirmed();
                    HashMap hashMap = meetingInfo.getAttendants();
                    Iterator iterator = hashMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        String string6 = (String)iterator.next();
                        meeting.addAttendant(string6);
                        meeting.initiator = meetingInfo.getInitiator();
                        if (meetingInfo.getType() == null) continue;
                        meeting.type = Meeting.typeStringToInt(meetingInfo.getType());
                    }
                    calendar.addMeeting(meeting);
                    continue block13;
                }
            }
            calendar.checkConsistency(new RManagerIOSystem(""));
            vector.add(calendar);
        }
        return vector;
    }

    public static void putAttendantsInCalendar(Vector vector, Calendar calendar, int[] nArray) {
        for (int i = 0; i < vector.size(); ++i) {
            MeetingInfo meetingInfo = (MeetingInfo)vector.elementAt(i);
            Meeting meeting = calendar.getMeeting(meetingInfo.getMeetingId());
            if (meeting == null) continue;
            HashMap hashMap = meetingInfo.getAttendants();
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                meeting.addAttendant(string);
                meeting.initiator = meetingInfo.getInitiator();
                meeting.type = nArray[i];
            }
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 5) {
            System.out.println("Invalid number of args");
            System.out.println(".agents .meetings .calendar .meetings2 .calendar2");
            System.exit(1);
        }
        SimParameters simParameters = new SimParameters();
        try {
            simParameters.parseSimFiles(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4]);
        }
        catch (IOException iOException) {
            System.err.println("Error. Quitting.");
        }
        System.out.println("\n#CalendarDisruption");
        System.out.println("#id\tMisses\tMoves\tDistance");
        System.out.println("--------------------------------");
        Vector vector = CalendarReader.parseCalendarFile(stringArray[2], simParameters);
        Vector vector2 = simParameters.getOldMeetings();
        Vector vector3 = simParameters.getNewMeetings();
        for (int i = 0; i < vector3.size(); ++i) {
            MeetingInfo meetingInfo = (MeetingInfo)vector3.get(i);
            vector2.add(meetingInfo);
        }
        Vector vector4 = CalendarReader.parseCalendarFile(stringArray[4], simParameters);
        for (int i = 0; i < vector.size(); ++i) {
            Calendar calendar = (Calendar)vector.get(i);
            for (int j = 0; j < vector4.size(); ++j) {
                Calendar calendar2 = (Calendar)vector4.get(j);
                if (!calendar.getUserId().equals(calendar2.getUserId())) continue;
                int n = calendar.numMeetingsMissing(calendar2) + calendar2.numMeetingsMissing(simParameters.getNewMeetings());
                int n2 = calendar.numMeetingsMoved(calendar2);
                double d = calendar.sumDistanceOfMovedMeetings(calendar2);
                System.out.println(calendar.getUserId() + "\t" + n + "\t" + n2 + "\t" + d);
            }
        }
    }
}

