/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.sim;

import cmradar.manager.data.Meeting;
import java.util.HashMap;
import java.util.Iterator;

public class AgentInfo {
    private String userName;
    private String userId;
    private String agentName;
    private String agentType;
    private String[] children;
    private double scheduleDensity;
    private String userPrefs;
    private int portNumber;
    private int responseTime;
    private String subName;
    private double roomYesProb;
    private HashMap roomYesMTypeProb;
    private HashMap roomYesMTypeSizeProb;
    private double roomYesProbLearned;
    private HashMap roomYesMTypeProbLearned;
    private HashMap roomYesMTypeSizeProbLearned;

    public AgentInfo() {
    }

    public AgentInfo(HashMap hashMap, HashMap hashMap2, int n) {
        this.roomYesProb = -1.0;
        this.roomYesMTypeProb = null;
        this.roomYesMTypeSizeProb = null;
        String string = (String)hashMap2.get("UserName");
        if (string == null) {
            string = (String)hashMap.get("UserName");
        }
        this.userName = string;
        string = (String)hashMap2.get("UserId");
        if (string == null) {
            string = (String)hashMap.get("UserId");
        }
        this.userId = string;
        string = (String)hashMap2.get("AgentName");
        if (string == null) {
            string = (String)hashMap.get("AgentName");
        }
        this.agentName = string;
        string = (String)hashMap2.get("AgentType");
        if (string == null) {
            string = (String)hashMap.get("AgentType");
        }
        this.agentType = string;
        string = (String)hashMap2.get("UserPrefs");
        if (string == null) {
            string = (String)hashMap.get("UserPrefs");
        }
        this.userPrefs = string;
        string = (String)hashMap2.get("SubFor");
        if (string == null) {
            string = (String)hashMap.get("SubFor");
        }
        this.subName = string;
        string = (String)hashMap2.get("Children");
        this.children = string == null ? ((string = (String)hashMap.get("Children")) == null ? new String[0] : string.split(",")) : string.split(",");
        string = (String)hashMap2.get("ScheduleDensity");
        if (string == null) {
            string = (String)hashMap.get("ScheduleDensity");
        }
        try {
            this.scheduleDensity = Double.parseDouble(string);
        }
        catch (Exception exception) {
            this.scheduleDensity = -1.0;
        }
        string = (String)hashMap2.get("PortNumber");
        if (string == null) {
            string = (String)hashMap.get("PortNumber");
            try {
                this.portNumber = Integer.parseInt(string) + n;
            }
            catch (Exception exception) {
                System.out.println("Missing port number in config file");
                System.exit(0);
            }
        } else {
            this.portNumber = Integer.parseInt(string);
        }
    }

    public void parseProbString(String string) {
        this.roomYesMTypeProb = new HashMap();
        String[] stringArray = string.split("[\t ]");
        this.roomYesProb = Double.parseDouble(stringArray[1]);
        if (stringArray.length == 2) {
            return;
        }
        String string2 = stringArray[2];
        string2 = string2.substring(1, string2.length() - 1);
        String[] stringArray2 = string2.split(",");
        for (int i = 0; i < stringArray2.length; ++i) {
            String string3 = stringArray2[i];
            String[] stringArray3 = string3.split(":");
            this.roomYesMTypeProb.put(new Integer(Meeting.typeStringToInt(stringArray3[0])), new Double(stringArray3[1]));
        }
    }

    public String getProbStr() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.roomYesMTypeProb == null || this.roomYesMTypeProb.values() == null) {
            return "";
        }
        Iterator iterator = this.roomYesMTypeProb.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            String string = ((Double)this.roomYesMTypeProb.get(n)).toString();
            String string2 = "";
            Object v = this.roomYesMTypeProbLearned.get(n);
            if (v != null) {
                string2 = ((Double)v).toString();
            }
            stringBuffer.append(string + "(" + string2 + ") ");
        }
        return stringBuffer.toString();
    }

    public void parseProbString2(String string) {
        String[] stringArray = string.split("[\t ]+");
        this.roomYesProb = Double.parseDouble(stringArray[1]);
        if (stringArray.length == 2) {
            return;
        }
        if (stringArray[2].indexOf("-") == -1) {
            this.roomYesMTypeProb = new HashMap();
            this.roomYesMTypeSizeProb = null;
            String string2 = stringArray[2];
            string2 = string2.substring(1, string2.length() - 1);
            String[] stringArray2 = string2.split(",");
            for (int i = 0; i < stringArray2.length; ++i) {
                String string3 = stringArray2[i];
                String[] stringArray3 = string3.split(":");
                this.roomYesMTypeProb.put(new Integer(Meeting.typeStringToInt(stringArray3[0])), new Double(stringArray3[1]));
            }
        } else {
            this.roomYesMTypeSizeProb = new HashMap();
            this.roomYesMTypeProb = null;
            String string4 = stringArray[2];
            string4 = string4.substring(1, string4.length() - 1);
            String[] stringArray4 = string4.split(",");
            for (int i = 0; i < stringArray4.length; ++i) {
                String[] stringArray5 = stringArray4[i].split(":");
                String[] stringArray6 = stringArray5[0].split("-");
                HashMap<String, Double> hashMap = new HashMap<String, Double>();
                hashMap.put(stringArray6[1], new Double(stringArray5[1]));
                this.roomYesMTypeSizeProb.put(new Integer(Meeting.typeStringToInt(stringArray6[0])), hashMap);
            }
        }
    }

    public void parseLearnedProbString2(String string) {
        String[] stringArray = string.split("[\t ]+");
        this.roomYesProbLearned = Double.parseDouble(stringArray[1]);
        if (stringArray.length == 2) {
            return;
        }
        if (stringArray[2].indexOf("-") == -1) {
            this.roomYesMTypeProbLearned = new HashMap();
            this.roomYesMTypeSizeProbLearned = null;
            String string2 = stringArray[2];
            string2 = string2.substring(1, string2.length() - 1);
            String[] stringArray2 = string2.split(",");
            for (int i = 0; i < stringArray2.length; ++i) {
                String string3 = stringArray2[i];
                String[] stringArray3 = string3.split(":");
                this.roomYesMTypeProbLearned.put(new Integer(Meeting.typeStringToInt(stringArray3[0])), new Double(stringArray3[1]));
            }
        } else {
            this.roomYesMTypeSizeProbLearned = new HashMap();
            this.roomYesMTypeProbLearned = null;
            String string4 = stringArray[2];
            string4 = string4.substring(1, string4.length() - 1);
            String[] stringArray4 = string4.split(",");
            for (int i = 0; i < stringArray4.length; ++i) {
                String[] stringArray5 = stringArray4[i].split(":");
                String[] stringArray6 = stringArray5[0].split("-");
                HashMap<String, Double> hashMap = new HashMap<String, Double>();
                hashMap.put(stringArray6[1], new Double(stringArray5[1]));
                this.roomYesMTypeSizeProbLearned.put(new Integer(Meeting.typeStringToInt(stringArray6[0])), hashMap);
            }
        }
    }

    public boolean isRoomYesMType() {
        return this.roomYesMTypeProb != null;
    }

    public boolean isRoomYesMTypeSize() {
        return this.roomYesMTypeSizeProb != null;
    }

    public double getRoomYesProb() {
        return this.roomYesProb;
    }

    public HashMap getRoomYesMTypeProb() {
        return this.roomYesMTypeProb;
    }

    public HashMap getRoomYesMTypeSizeProb() {
        return this.roomYesMTypeSizeProb;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public String getAgentType() {
        return this.agentType;
    }

    public String getUserPrefs() {
        return this.userPrefs;
    }

    public double getScheduleDensity() {
        return this.scheduleDensity;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getSubName() {
        return this.subName;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public int getResponseTime() {
        return this.responseTime;
    }

    public String[] getChildren() {
        return this.children;
    }

    public String toString() {
        String string = "";
        string = string + "UserID: " + this.userId + "\n";
        string = string + "UserName: " + this.userName + "\n";
        string = string + "UserPrefs: " + this.userPrefs + "\n";
        string = string + "AgentName: " + this.agentName + "\n";
        string = string + "SubFor: " + this.subName + "\n";
        string = string + "AgentType: " + this.agentType + "\n";
        string = string + "ScheduleDensity: " + this.scheduleDensity + "\n";
        string = string + "PortNumber: " + this.portNumber + "\n";
        return string;
    }

    public void fillInTestData1() {
        this.userId = "pmodi@cs.cmu.edu";
        this.userName = "Jay Modi";
        this.userPrefs = "SimpleMorning";
        this.agentName = "Jay Modi's Agent";
        this.agentType = "BumpingNeg";
        this.scheduleDensity = 0.8;
        this.portNumber = 40001;
    }

    public static void main(String[] stringArray) {
        AgentInfo agentInfo = new AgentInfo();
        agentInfo.parseProbString2("agent\t0.3\t[CLASS:0.3,CLASS:0.3,CLASS:0.3]");
        agentInfo.parseProbString2("agent\t0.3");
        agentInfo.parseProbString2("USER4\t0.3\t[class-small:0.1,class-medium:0.1,class-large:0.1,conference-small:0.1,conference-medium:0.1,conference-large:0.1,seminar-small:0.1,seminar-medium:0.1,seminar-large:0.2]");
    }
}

