/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.sched;

import cmradar.manager.data.Meeting;
import cmradar.manager.data.Room;
import cmradar.manager.data.RoomTemplate;
import cmradar.manager.data.SharedRoomCalendar;
import cmradar.manager.data.Template;
import cmradar.manager.data.TimeSlot;
import cmradar.manager.sched.Scheduler;
import cmradar.manager.sim.AgentInfo;
import cmradar.manager.sim.SimParameters;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public class SimpleRoomScheduler
implements Scheduler {
    private static int DEFAULT_RETURN_SLOTS = 1;
    private SharedRoomCalendar cal = null;
    String myUserId;
    SimParameters params = new SimParameters();

    public void startScheduler(String string, String string2) {
        this.cal = new SharedRoomCalendar();
        this.myUserId = string;
    }

    public boolean set_calendar(SharedRoomCalendar sharedRoomCalendar) {
        this.cal = new SharedRoomCalendar(sharedRoomCalendar);
        return true;
    }

    public void resetRoomSchedulerFiles(String string, String string2, String string3) {
        try {
            this.params.parseAgentsFile(string);
            this.params.parseRoomFile(string2);
            if (string3.length() > 0) {
                this.params.parseOwnersFile(string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String processRoomRequest(String string, int n) {
        return null;
    }

    private double getOwnerProb(Meeting meeting) {
        String string = meeting.getInitiator();
        Vector vector = this.params.getAgents();
        for (int i = 0; i < vector.size(); ++i) {
            AgentInfo agentInfo = (AgentInfo)vector.elementAt(i);
            if (!string.equals(agentInfo.getUserId())) continue;
            HashMap hashMap = agentInfo.getRoomYesMTypeProb();
            int n = meeting.type;
            if (hashMap == null || hashMap.get(new Integer(n)) == null) {
                return 0.5;
            }
            double d = (Double)hashMap.get(new Integer(n));
            return d;
        }
        return 0.0;
    }

    private Vector processConfirmedRequest(RoomTemplate roomTemplate, int n, TimeSlot timeSlot) {
        Vector<RoomTemplate> vector = new Vector<RoomTemplate>();
        Room room = this.cal.getRoomFromId(timeSlot.location);
        LinkedList linkedList = this.cal.getMeetings(room, timeSlot);
        if (linkedList.size() == 0) {
            Meeting meeting = new Meeting(this.myUserId, roomTemplate);
            this.cal.addMeeting(room, meeting, timeSlot, true);
        } else {
            roomTemplate.setStatus(timeSlot, "impossible");
        }
        vector.add(roomTemplate);
        return vector;
    }

    public Vector processRoomRequest(RoomTemplate roomTemplate, int n) {
        System.out.println("commented out. STILL IN USE?");
        return null;
    }

    public Vector processRoomRequestList(Vector vector) {
        Vector<Vector> vector2 = new Vector<Vector>();
        for (int i = 0; i < vector.size(); ++i) {
            RoomTemplate roomTemplate = (RoomTemplate)vector.get(i);
            vector2.add(this.processRoomRequest(roomTemplate, 1));
        }
        return vector2;
    }

    public String processRoomRequestList(String string) {
        return "nil";
    }

    public Vector processRequest(Template template, int n) {
        System.out.println("SimpleRoomScheduler.processRequest does nothing.");
        return new Vector();
    }

    public Vector processRequest(Template template) {
        return this.processRequest(template, DEFAULT_RETURN_SLOTS);
    }

    public Vector processRequestList(Vector vector) {
        Iterator iterator = vector.iterator();
        Vector<Vector> vector2 = new Vector<Vector>();
        while (iterator.hasNext()) {
            Template template = (Template)iterator.next();
            vector2.add(this.processRequest(template, DEFAULT_RETURN_SLOTS));
        }
        return vector2;
    }

    public void setBumping(boolean bl) {
    }

    public void saveModel() {
    }

    public void setPending(boolean bl) {
    }

    public void setBumpingStrategy(int n) {
    }

    public double evaluateSchedule() {
        return 0.0;
    }

    public static void main(String[] stringArray) {
        Template template;
        int n;
        System.out.println("I am SimpleRoomScheduler");
        SimpleRoomScheduler simpleRoomScheduler = new SimpleRoomScheduler();
        simpleRoomScheduler.startScheduler("A", "SimpleMorning");
        simpleRoomScheduler.setBumping(false);
        simpleRoomScheduler.setBumpingStrategy(1);
        Template template2 = new Template();
        template2.meetingId = "10001";
        template2.initiator = "A";
        template2.addAttendant("A", 1.0);
        template2.addAttendant("B", 1.0);
        TimeSlot timeSlot = new TimeSlot();
        timeSlot.earliestStartTime = "2004-06-25 [8:00 -0500]";
        timeSlot.latestFinishTime = "2004-06-25 [18:00 -0500]";
        timeSlot.startTime = "2004-06-25 [9:00 -0500]";
        timeSlot.finishTime = "2004-06-25 [10:00 -0500]";
        template2.addTimeSlot(timeSlot, "confirmed");
        template2.addPurpose("13", "nil", "nil");
        Vector<Template> vector = new Vector<Template>();
        vector.add(template2);
        simpleRoomScheduler.processRequest(template2);
        template2 = new Template();
        template2.meetingId = "41";
        template2.initiator = "A";
        template2.addAttendant("A", 1.0);
        template2.addAttendant("B", 1.0);
        template2.addAttendant("C", 1.0);
        timeSlot = new TimeSlot();
        timeSlot.earliestStartTime = "2004-06-25 [8:00 -0500]";
        timeSlot.latestFinishTime = "2004-06-25 [18:00 -0500]";
        timeSlot.startTime = "2004-06-25 [9:00 -0500]";
        timeSlot.finishTime = "2004-06-25 [10:00 -0500]";
        template2.addTimeSlot(timeSlot, "possible");
        template2.addPurpose("14", "nil", "nil");
        vector.add(template2);
        Vector vector2 = simpleRoomScheduler.processRequest(template2, 5);
        for (n = 0; n < vector2.size(); ++n) {
            template = (Template)vector2.elementAt(n);
            System.out.println(n + " " + template.toString());
        }
        vector2 = simpleRoomScheduler.processRequest(template2, 5);
        for (n = 0; n < vector2.size(); ++n) {
            template = (Template)vector2.elementAt(n);
            System.out.println(n + " " + template.toString());
        }
    }
}

