/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.neg;

import cmradar.manager.data.Calendar;
import cmradar.manager.data.Meeting;
import cmradar.manager.data.OwnersViewer;
import cmradar.manager.data.Template;
import cmradar.manager.data.TimeSlot;
import cmradar.manager.neg.MutableNegotiationLog;
import cmradar.manager.sched.Scheduler;
import cmradar.manager.sim.MessageCommunicator;
import cmradar.manager.sim.RadarLogger;
import cmradar.manager.sim.Utility;
import cmradar.manager.sys.RManagerIO;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class AbstractNegotiator {
    static Logger logger = Logger.getLogger((String)(class$cmradar$manager$neg$AbstractNegotiator == null ? (class$cmradar$manager$neg$AbstractNegotiator = AbstractNegotiator.class$("cmradar.manager.neg.AbstractNegotiator")) : class$cmradar$manager$neg$AbstractNegotiator).getName());
    String myUserId;
    public Calendar calendar;
    Scheduler ozone;
    RManagerIO ioManager;
    public Vector openMeetings = new Vector();
    public RadarLogger nLog = null;
    protected MutableNegotiationLog negLogger;
    protected boolean iWantToLog = false;
    MessageCommunicator mComm;
    public boolean calendarIsSet = false;
    public int numBumps = 0;
    int responseTime = 1000;
    public double initQ = 0.0;
    OwnersViewer ov;
    public static final String tabspace = "                 ";
    static /* synthetic */ Class class$cmradar$manager$neg$AbstractNegotiator;

    public AbstractNegotiator(RManagerIO rManagerIO, String string, String string2, Scheduler scheduler, MessageCommunicator messageCommunicator) {
        this.set_owner_id(string);
        this.calendar = new Calendar(string, string2);
        this.ioManager = rManagerIO;
        this.ozone = scheduler;
        this.mComm = messageCommunicator;
    }

    public AbstractNegotiator() {
    }

    public abstract void receive_message(Template var1, String var2);

    public void setResponseTime(int n) {
        this.responseTime = n;
    }

    public void setOptions(String string) {
    }

    public void setIOManager(RManagerIO rManagerIO) {
        this.ioManager = rManagerIO;
    }

    public void setOwnersViewer(OwnersViewer ownersViewer) {
        this.ov = ownersViewer;
    }

    public void set_calendar(Calendar calendar) {
        this.calendar = calendar;
        this.initializeScheduler();
        this.calendarIsSet = true;
    }

    public void initializeScheduler() {
        Vector<Template> vector = new Vector<Template>();
        Iterator iterator = this.calendar.meetings.values().iterator();
        while (iterator.hasNext()) {
            Meeting meeting = (Meeting)iterator.next();
            TimeSlot timeSlot = meeting.getConfirmedTimeSlot();
            if (timeSlot == null) continue;
            Template template = new Template(meeting.toTemplate());
            template.clearTimeSlots();
            template.addTimeSlot(timeSlot, "confirmed");
            vector.add(template);
        }
        this.ozone.processRequestList(vector);
        this.printStatus("All initial meetings  successfully scheduled.\n", 0);
        this.initQ = this.ozone.evaluateSchedule();
    }

    public void set_owner_id(String string) {
        this.myUserId = string;
    }

    public String getUserId() {
        return this.myUserId;
    }

    public boolean inQuiescence() {
        return this.openMeetings.size() == 0;
    }

    public int getNumOpenMeetings() {
        return this.openMeetings.size();
    }

    public boolean success(String string) {
        return this.calendar.isConfirmedMeeting(string);
    }

    public int numSuccess() {
        return this.negLogger.getTotalSuccess();
    }

    public int numFailure() {
        return this.negLogger.getTotalFailure();
    }

    public int numRounds() {
        return this.negLogger.getTotalRoundCount();
    }

    public int rounds(String string) {
        return this.negLogger.getRoundCount(string);
    }

    public int numMeetings() {
        return this.calendar.numConfirmedMeetingsInitiator(this.myUserId);
    }

    public double evaluateSchedule() {
        return this.ozone.evaluateSchedule();
    }

    public void resetRoomScheduler(String string, String string2, String string3) {
        this.ozone.resetRoomSchedulerFiles(string, string2, string3);
    }

    public double initialQuality() {
        return this.initQ;
    }

    public Scheduler getScheduler() {
        return this.ozone;
    }

    public void printStatus(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        stringBuffer.append(">> " + string);
    }

    public void finish() {
        if (this.iWantToLog) {
            try {
                this.negLogger.writeLog();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("Error writing log file...");
            }
        }
    }

    public void set_logger(RadarLogger radarLogger) {
        this.nLog = radarLogger;
    }

    public void logStatusChange(Meeting meeting, TimeSlot timeSlot) {
        if (this.nLog != null) {
            String string = meeting.getMeetingId();
            String string2 = this.myUserId;
            String string3 = "null                 ";
            String string4 = "new";
            if (timeSlot != null) {
                string3 = timeSlot.toPrettyString();
                string4 = meeting.getTimeSlotStatus(this.myUserId, timeSlot);
            }
            if (string4.equals("impossible")) {
                Meeting meeting2 = this.calendar.getMeetingFromTimeSlot(timeSlot);
                if (meeting2 != null) {
                    this.nLog.printToLogln(Utility.TimeString() + "\t" + string + "\t" + string2 + "\t" + string3 + "\t" + string4 + "\t" + meeting.getNumAttendants() + " " + meeting2.getNumAttendants() + "\t" + meeting.getTypeString() + " " + meeting2.getTypeString());
                }
            } else {
                this.nLog.printToLogln(Utility.TimeString() + "\t" + string + "\t" + string2 + "\t" + string3 + "\t" + string4 + "\t" + meeting.bumpedBy);
            }
        }
    }

    public void logReschedule(Meeting meeting) {
        if (this.nLog != null) {
            String string = meeting.getMeetingId();
            String string2 = this.myUserId;
            String string3 = "null                 ";
            String string4 = "reschedule";
            Meeting meeting2 = this.calendar.getMeeting(meeting.bumpedBy);
            this.nLog.printToLogln(Utility.TimeString() + "\t" + string + "\t" + string2 + "\t" + string3 + "\t" + string4 + "\t" + meeting.bumpedBy + "\t" + meeting.getNumAttendants() + " " + (meeting2 == null ? -1 : meeting2.getNumAttendants()) + "\t" + meeting.getTypeString() + " " + (meeting2 == null ? "-1" : meeting2.getTypeString()));
        }
    }

    public void logFailure(Meeting meeting) {
        if (this.nLog != null) {
            String string = meeting.getMeetingId();
            String string2 = this.myUserId;
            String string3 = "null                 ";
            String string4 = "failure";
            Meeting meeting2 = this.calendar.getMeeting(meeting.bumpedBy);
            this.nLog.printToLogln(Utility.TimeString() + "\t" + string + "\t" + string2 + "\t" + string3 + "\t" + string4);
        }
    }

    public void logTaboo(Meeting meeting, TimeSlot timeSlot) {
        if (this.nLog != null) {
            String string = meeting.getMeetingId();
            String string2 = this.myUserId;
            String string3 = "null                 ";
            String string4 = "taboo";
            if (timeSlot != null) {
                string3 = timeSlot.toPrettyString();
            }
            this.nLog.printToLogln(Utility.TimeString() + "\t" + string + "\t" + string2 + "\t" + string3 + "\t" + string4);
        }
    }

    public void logStolen(Meeting meeting, TimeSlot timeSlot) {
        if (this.nLog != null) {
            String string = meeting.getMeetingId();
            String string2 = this.myUserId;
            String string3 = "null                 ";
            String string4 = "stolen";
            if (timeSlot != null) {
                string3 = timeSlot.toPrettyString();
            }
            this.nLog.printToLogln(Utility.TimeString() + "\t" + string + "\t" + string2 + "\t" + string3 + "\t" + string4);
        }
    }

    public void logEvent(Meeting meeting, String string, TimeSlot timeSlot) {
        String string2 = meeting.getMeetingId();
        String string3 = this.myUserId;
        String string4 = timeSlot.toPrettyString();
        logger.log((Priority)Level.INFO, (Object)(string3 + "\t" + string + "\t" + "time  " + string4 + "\t" + "for meeting " + string2));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

