/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.demo;

import cmradar.manager.data.Meeting;
import cmradar.manager.demo.CalendarCell;
import cmradar.manager.demo.ListPanel;
import cmradar.manager.demo.MeetingRenderer;
import java.awt.Dimension;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;

public class MeetingListPanel
extends ListPanel {
    private String owner;

    public MeetingListPanel(String string) {
        this.data = Collections.synchronizedList(new LinkedList());
        this.rend = new MeetingRenderer();
        ((MeetingRenderer)this.rend).isInMeetingListPanel = true;
        this.owner = string;
    }

    public void clear() {
        this.data.clear();
    }

    public void addMeeting(Object object) {
        CalendarCell calendarCell = new CalendarCell(this.owner);
        calendarCell.useMeeting((Meeting)object);
        this.data.add(calendarCell);
    }

    public void endUpdate() {
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return new Dimension(1000, 50);
    }

    public void highlightMeeting(Meeting meeting) {
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            CalendarCell calendarCell = (CalendarCell)iterator.next();
            Meeting meeting2 = calendarCell.getCurMeeting();
            if (!meeting2.equals(meeting)) continue;
            calendarCell.setHighlighted(true);
            return;
        }
    }

    public void unhighlightMeeting(Meeting meeting) {
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            CalendarCell calendarCell = (CalendarCell)iterator.next();
            Meeting meeting2 = calendarCell.getCurMeeting();
            if (!meeting2.equals(meeting)) continue;
            calendarCell.setHighlighted(false);
            return;
        }
    }
}

