/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.demo;

import cmradar.manager.data.Calendar;
import cmradar.manager.data.Meeting;
import cmradar.manager.data.TimeSlot;
import cmradar.manager.demo.CalendarCell;
import java.awt.Color;
import java.awt.GridLayout;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class CalendarPanel
extends JComponent {
    private int start;
    private int end;
    private int days;
    private java.util.Calendar startCal;
    private CalendarCell[][] cells;
    private String[] names = new String[]{"MON", "TUE", "WED", "THU", "FRI", "SAT", "SUN"};

    public CalendarPanel(int n, int n2, int n3, String string) {
        int n4;
        this.start = n;
        this.end = n2;
        this.days = n3;
        GridLayout gridLayout = new GridLayout(this.end - this.start + 1, this.days);
        this.cells = new CalendarCell[this.end - this.start][this.days];
        this.startCal = java.util.Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd [HH:mm Z]");
        Date date = null;
        try {
            date = simpleDateFormat.parse(Calendar.CALENDAR_START);
        }
        catch (ParseException parseException) {
            System.err.println("Error parsing calendar start date");
            parseException.printStackTrace();
            System.exit(0);
        }
        this.startCal.setTime(date);
        this.setLayout(gridLayout);
        int n5 = this.startCal.get(7);
        for (n4 = 0; n4 < this.days; ++n4) {
            JLabel jLabel = new JLabel(this.names[(n5 + n4) % 7], 0);
            jLabel.setBackground(Color.WHITE);
            this.add(jLabel);
        }
        for (n4 = 0; n4 < this.end - this.start; ++n4) {
            for (int i = 0; i < this.days; ++i) {
                this.cells[n4][i] = new CalendarCell(string);
                this.cells[n4][i].setBorder(BorderFactory.createEmptyBorder(3, 2, 2, 2));
                this.add(this.cells[n4][i]);
            }
        }
    }

    private void processTime(Meeting meeting, TimeSlot timeSlot) {
        java.util.Calendar calendar = (java.util.Calendar)this.startCal.clone();
        int n = timeSlot.year();
        int n2 = timeSlot.month();
        int n3 = timeSlot.day();
        int n4 = timeSlot.st();
        for (int i = 0; i < this.days; ++i) {
            int n5 = calendar.get(1);
            int n6 = calendar.get(2);
            int n7 = calendar.get(5);
            int n8 = calendar.get(11);
            if (n == n5 && n2 == n6 && n3 == n7 && n4 >= this.start && n4 < this.end) {
                this.cells[n4 - this.start][i].useMeeting(meeting);
            }
            calendar.add(6, 1);
        }
    }

    public void processMeeting(Meeting meeting) {
        TimeSlot timeSlot;
        Iterator iterator = meeting.getPendingTimeSlots().iterator();
        while (iterator.hasNext()) {
            timeSlot = (TimeSlot)iterator.next();
            this.processTime(meeting, timeSlot);
        }
        timeSlot = meeting.getBumpedTimeSlot();
        if (timeSlot != null) {
            this.processTime(meeting, timeSlot);
        }
        if ((timeSlot = meeting.getConfirmedTimeSlot()) != null) {
            this.processTime(meeting, timeSlot);
        }
    }

    public void endUpdate() {
        for (int i = 0; i < this.days; ++i) {
            for (int j = this.start; j < this.end; ++j) {
                this.cells[j - this.start][i].cleanup();
            }
        }
        this.repaint();
    }

    public void highlightTimeSlot(TimeSlot timeSlot) {
        java.util.Calendar calendar = (java.util.Calendar)this.startCal.clone();
        int n = timeSlot.year();
        int n2 = timeSlot.month();
        int n3 = timeSlot.day();
        int n4 = timeSlot.st();
        for (int i = 0; i < this.days; ++i) {
            int n5 = calendar.get(1);
            int n6 = calendar.get(2);
            int n7 = calendar.get(5);
            int n8 = calendar.get(11);
            if (n == n5 && n2 == n6 && n3 == n7 && n4 >= this.start && n4 < this.end) {
                this.cells[n4 - this.start][i].setHighlighted(true);
            }
            calendar.add(6, 1);
        }
    }

    public void unhighlightTimeSlot(TimeSlot timeSlot) {
        java.util.Calendar calendar = (java.util.Calendar)this.startCal.clone();
        int n = timeSlot.year();
        int n2 = timeSlot.month();
        int n3 = timeSlot.day();
        int n4 = timeSlot.st();
        for (int i = 0; i < this.days; ++i) {
            int n5 = calendar.get(1);
            int n6 = calendar.get(2);
            int n7 = calendar.get(5);
            int n8 = calendar.get(11);
            if (n == n5 && n2 == n6 && n3 == n7 && n4 >= this.start && n4 < this.end) {
                this.cells[n4 - this.start][i].setHighlighted(false);
            }
            calendar.add(6, 1);
        }
    }
}

