/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.data;

import cmradar.manager.data.RoomTemplate;
import cmradar.manager.sim.SimParameters;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Room
implements Comparable {
    public static final String AUDITORIUM = "AUDITORIUM";
    public static final String CLASSROOM = "CLASSROOM";
    public static final String CONFERENCE = "CONFERENCE";
    public static final String RECEPTION = "RECEPTION";
    public static final String[] roomTypes = new String[]{"AUDITORIUM", "CLASSROOM", "CONFERENCE", "RECEPTION"};
    private static Logger logger = Logger.getLogger((String)(class$cmradar$manager$data$Room == null ? (class$cmradar$manager$data$Room = Room.class$("cmradar.manager.data.Room")) : class$cmradar$manager$data$Room).getName());
    static HashMap mins;
    static HashMap maxs;
    public static final String STATIONARY_PROJECTOR = "STATIONARY";
    public static final String MOVABLE_PROJECTOR = "MOVABLE";
    public static final String NO_PROJECTOR = "NONE";
    public static final String[] projTypes;
    public static final String NONE = "NONE";
    public static final String AVAILABLE = "AVAILABLE";
    public static final String IN_ROOM = "IN_ROOM";
    public static final String[] availTypes;
    public static final String idLabel = "id:";
    protected int id = -1;
    protected String roomId;
    protected String desc;
    protected String type;
    protected String building;
    protected HashMap nVars;
    protected boolean hotel = false;
    protected String agentName;
    protected double density = 0.5;
    Random rgen = new Random();
    public static double lambda;
    private int count = -1;
    static /* synthetic */ Class class$cmradar$manager$data$Room;

    public Room() {
        this.nVars = new HashMap();
    }

    public boolean equals(Object object) {
        Room room = (Room)object;
        return room.roomId.equals(this.roomId);
    }

    public Room(int n, int n2, Random random) {
        this.id = n;
        this.roomId = String.valueOf(n);
        this.nVars = new HashMap();
        for (int i = 0; i < n2; ++i) {
            this.nVars.put(String.valueOf(i), new Double(random.nextDouble()));
        }
    }

    public static Vector generateRandomRooms(int n, int n2) {
        Random random = new Random();
        Vector<Room> vector = new Vector<Room>();
        for (int i = 0; i < n; ++i) {
            Room room = new Room(i, n2, random);
            vector.add(room);
        }
        Room.collectStat(vector);
        return vector;
    }

    public boolean isHotel() {
        return this.hotel;
    }

    private void addFeature(String string, String string2) {
        if (string.equalsIgnoreCase("id")) {
            this.roomId = string2;
        } else if (string.equalsIgnoreCase("description")) {
            this.desc = string2;
        } else if (string.equalsIgnoreCase("building")) {
            this.building = string2;
        } else if (string.equalsIgnoreCase("room-type")) {
            this.type = string2;
        } else {
            try {
                this.nVars.put(string, new Double(string2));
            }
            catch (Exception exception) {
                System.out.println("f=" + string);
                System.exit(0);
            }
        }
        if (string.equals("id")) {
            this.roomId = string2;
        }
    }

    public double getFeature(String string) {
        return Room.getDouble(this.roomId, this.nVars, string);
    }

    private static double getDouble(String string, HashMap hashMap, String string2) {
        Double d = (Double)hashMap.get(string2);
        if (d == null) {
            logger.log((Priority)Level.ERROR, (Object)("feature " + string2 + " not found in room " + string));
            return 0.0;
        }
        return d;
    }

    public HashMap getFeatures() {
        return this.nVars;
    }

    public int getId() {
        return this.id;
    }

    public String getRoomId() {
        return this.roomId;
    }

    public String getBuilding() {
        return this.building;
    }

    public int getMinCapacity() {
        return (int)this.getFeature("min-capacity");
    }

    public int getMaxCapacity() {
        return (int)this.getFeature("max-capacity");
    }

    private static void syntaxError(String string, int n, boolean bl) {
        String string2 = "expected";
        if (!bl) {
            string2 = "not " + string2;
        }
        System.exit(0);
    }

    private static void collectStat(Vector vector) {
        if (vector.size() == 0) {
            return;
        }
        Room room = (Room)vector.elementAt(0);
        mins = new HashMap(room.nVars);
        maxs = new HashMap(room.nVars);
        Iterator iterator = room.nVars.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Room room2 = (Room)enumeration.nextElement();
                double d = room2.getFeature(string);
                double d2 = Room.getDouble("", mins, string);
                double d3 = Room.getDouble("", maxs, string);
                if (d < d2) {
                    mins.put(string, new Double(d));
                    continue;
                }
                if (!(d > d3)) continue;
                maxs.put(string, new Double(d));
            }
        }
    }

    public static int getFeatureSize() {
        return mins.size();
    }

    public double normalizeFeature(String string) {
        return SimParameters.normalize(this.getFeature(string), Room.getDouble("", mins, string), Room.getDouble("", maxs, string), 0.0, 1.0);
    }

    public static Vector parseRoomList(String string, HashMap hashMap) {
        Vector vector = new Vector();
        return Room.parseRoomList(string, vector, null, new Vector(), hashMap, null);
    }

    public static Vector parseRoomList(String string, Vector vector, Vector vector2, Vector vector3, HashMap hashMap, Vector vector4) {
        Integer n = new Integer(1);
        try {
            Room room;
            StreamTokenizer streamTokenizer = new StreamTokenizer(new BufferedReader(new FileReader(string)));
            streamTokenizer.slashSlashComments(true);
            streamTokenizer.slashStarComments(true);
            streamTokenizer.eolIsSignificant(true);
            streamTokenizer.quoteChar(34);
            streamTokenizer.ordinaryChar(47);
            int n2 = -1;
            while ((room = Room.parseRoom(streamTokenizer, n)) != null) {
                if (vector3.contains(room.building)) {
                    room.id = ++n2;
                    room.agentName = room.building;
                    room.hotel = true;
                    vector2.add(room);
                    vector4.add(room.getRoomId());
                } else {
                    vector.add(room);
                }
                hashMap.put(room.getRoomId(), room);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Room.collectStat(vector2);
        return vector;
    }

    private static Room parseRoom(StreamTokenizer streamTokenizer, Integer n) {
        int n2 = 0;
        int n3 = n;
        Room room = new Room();
        String string = "";
        try {
            block11: while (streamTokenizer.nextToken() != -1) {
                switch (streamTokenizer.ttype) {
                    case 60: {
                        if (n2 != 0 && n2 != 3) {
                            logger.log((Priority)Level.ERROR, (Object)("expects TAGNAME or '>' lev=" + n2 + " @L" + n3));
                            System.exit(0);
                        }
                        n2 = 1;
                        continue block11;
                    }
                    case 62: {
                        if (n2 == 1) {
                            n2 = 3;
                            continue block11;
                        }
                        if (n2 == 2) {
                            n = new Integer(n3);
                            return room;
                        }
                        logger.log((Priority)Level.ERROR, (Object)("unexpected > @L" + n3));
                        System.exit(0);
                        continue block11;
                    }
                    case 47: {
                        if (n2 != true) continue block11;
                        n2 = 2;
                        continue block11;
                    }
                    case 10: {
                        if (n2 == 5) {
                            n2 = 3;
                        }
                        ++n3;
                        continue block11;
                    }
                    case -3: 
                    case 34: {
                        if (n2 == 1 || n2 == 2) continue block11;
                        if (n2 == 3) {
                            string = streamTokenizer.sval;
                            n2 = 4;
                            continue block11;
                        }
                        if (n2 == 4) {
                            room.addFeature(string, streamTokenizer.sval);
                            n2 = 5;
                            continue block11;
                        }
                        logger.log((Priority)Level.ERROR, (Object)("unexpected " + streamTokenizer.sval + ", lev=" + n2 + "@L" + n3));
                        System.exit(0);
                        continue block11;
                    }
                    case -2: {
                        if (n2 == 4) {
                            room.addFeature(string, String.valueOf(streamTokenizer.nval));
                            n2 = 5;
                            continue block11;
                        }
                        logger.log((Priority)Level.ERROR, (Object)("unexpected " + String.valueOf(streamTokenizer.nval) + "@L" + n3));
                        System.exit(0);
                        continue block11;
                    }
                    case 58: {
                        if (n2 == 4) continue block11;
                        logger.log((Priority)Level.ERROR, (Object)("unexpected : lev=" + n2 + " @L" + n3));
                        System.exit(0);
                        continue block11;
                    }
                }
                logger.log((Priority)Level.INFO, (Object)("ignoring " + streamTokenizer.ttype));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    protected String outField(String string, String string2) {
        return "\t\n" + string + " \n" + string2 + "\n";
    }

    public String toParseString() {
        StringBuffer stringBuffer = new StringBuffer("<room>\n");
        Iterator iterator = this.nVars.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append(this.outField(string, String.valueOf((Double)this.nVars.get(string))));
        }
        stringBuffer.append("</room>");
        return stringBuffer.toString();
    }

    public Vector toTableLabel() {
        Vector vector = new Vector();
        return vector;
    }

    public Vector toTableData() {
        Vector vector = new Vector();
        return vector;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public void setDensity(double d) {
        this.density = d;
    }

    public double getDensity() {
        return this.density;
    }

    public int compareTo(Object object) {
        Room room = (Room)object;
        return Double.compare(room.density, this.density);
    }

    public boolean isAvailable() {
        ++this.count;
        return this.isAvailable(this.count);
    }

    public boolean isAvailable(int n) {
        double d = this.rgen.nextDouble();
        return !(d > Math.pow(lambda, n) * this.density);
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        String string = stringArray[0];
        String string2 = stringArray[1];
        Vector vector = Room.parseRoomList(string, new HashMap());
        StringBuffer stringBuffer = new StringBuffer();
        try {
            object2 = new BufferedReader(new FileReader(stringArray[1]));
            while ((object = ((BufferedReader)object2).readLine()) != null) {
                stringBuffer.append((String)object);
                stringBuffer.append("\n");
            }
        }
        catch (IOException iOException) {
            System.out.println("Unable to open rooms file " + string);
            iOException.printStackTrace();
            System.exit(1);
        }
        object2 = new LinkedList(RoomTemplate.getTemplatesFromString(stringBuffer.toString()));
        object = ((AbstractSequentialList)object2).iterator();
        int n = 0;
        while (object.hasNext()) {
            System.out.println("Result rooms for request " + n + ":");
            ArrayList arrayList = ((RoomTemplate)object.next()).getRequirements();
            Iterator iterator = vector.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                Room room = (Room)iterator.next();
            }
            System.out.println("Request " + n + " found " + n2 + " matches.");
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        projTypes = new String[]{STATIONARY_PROJECTOR, MOVABLE_PROJECTOR, "NONE"};
        availTypes = new String[]{"NONE", AVAILABLE, IN_ROOM};
        lambda = 0.7;
    }
}

