/*
 * Decompiled with CFR 0.152.
 */
package cmradar;

import cmradar.manager.data.RoomTemplate;
import cmradar.manager.sim.RSimulator;
import edu.cmu.cs.radar.integ.ICMRadarProvides;
import edu.cmu.cs.radar.integ.IRadarServices;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class CMRadarShim
implements ICMRadarProvides {
    RSimulator _cmradar;
    IRadarServices _radar;
    static Logger logger = Logger.getLogger((String)(class$cmradar$CMRadarShim == null ? (class$cmradar$CMRadarShim = CMRadarShim.class$("cmradar.CMRadarShim")) : class$cmradar$CMRadarShim).getName());
    public static String CMRADAR_CONFIG = "radar.cmradar.config";
    public static String CMRADAR_CONFIG_DEFAULT = "c:/cmradar";
    static /* synthetic */ Class class$cmradar$CMRadarShim;

    public boolean initialize(IRadarServices iRadarServices) {
        try {
            String string = iRadarServices.getProps().getProperty(CMRADAR_CONFIG, CMRADAR_CONFIG_DEFAULT);
            this._cmradar = new RSimulator(string);
            this._radar = iRadarServices;
            this._cmradar.setRadarHandle(this._radar);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean initialize(IRadarServices iRadarServices, String string) {
        try {
            this._cmradar = new RSimulator(string);
            this._radar = iRadarServices;
            this._cmradar.setRadarHandle(this._radar);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public void printStat() {
        this._cmradar.printStat();
    }

    public void saveStat() {
        this._cmradar.saveStat();
    }

    public boolean done() {
        return this._cmradar.done();
    }

    public boolean shutdown() {
        this.saveStat();
        this._cmradar.dieGracefully();
        return true;
    }

    public void requestRoom(ICMRadarProvides.EventInformation eventInformation) {
        RoomTemplate roomTemplate = new RoomTemplate(eventInformation);
        logger.log((Priority)Level.INFO, (Object)("CMRadarShims.requestRoom:\n" + roomTemplate.toLispList() + "\n" + eventInformation));
        this._cmradar.writeLog(roomTemplate.toLispList());
        this._cmradar.requestRoom(roomTemplate);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

