/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeDate;
import edu.cmu.cs.radar.stp.cachingdatamodel.LinearFunctionData;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeNode;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class SpaceTimeTimeIntervals
implements Cloneable,
Iterable<Interval> {
    private List<Interval> _intervalList = new ArrayList<Interval>();

    public SpaceTimeTimeIntervals(SpaceTimeNode node) {
        SpaceTimeProperty availabilityProperty = node.getProperty("resourceLimit");
        if (availabilityProperty == null) {
            return;
        }
        LinearFunctionData data = availabilityProperty.getFunctionData();
        if (data == null) {
            return;
        }
        int dataSize = data.size();
        boolean available = false;
        double startTime = 0.0;
        int i = 0;
        while (i < dataSize) {
            double x = data.getX(i);
            double y = data.getY(i);
            if (y > 0.0) {
                if (!available) {
                    available = true;
                    startTime = x;
                }
            } else if (available) {
                available = false;
                this._intervalList.add(new Interval(new SpaceTimeDate((long)startTime), new SpaceTimeDate((long)x)));
            }
            ++i;
        }
        if (available) {
            this._intervalList.add(new Interval(new SpaceTimeDate((long)startTime), new SpaceTimeDate(node.getAdapter().getScenarioStop())));
        }
        this.intersect(new SpaceTimeDate(node.getAdapter().getScenarioStart()), new SpaceTimeDate(node.getAdapter().getScenarioStop()));
    }

    public void debug_Print() {
        for (Interval interval : this._intervalList) {
            System.out.println("Start: " + interval._start.toString() + " Stop: " + interval._stop.toString());
        }
    }

    public SpaceTimeTimeIntervals(SpaceTimeTimeIntervals intervals) {
        for (Interval interval : intervals._intervalList) {
            this._intervalList.add(new Interval(interval._start, interval._stop));
        }
    }

    public Object clone() {
        return new SpaceTimeTimeIntervals(this);
    }

    public void intersect(Date start, Date stop) {
        ArrayList<Interval> intersectionList = new ArrayList<Interval>();
        for (Interval interval : this._intervalList) {
            if (interval._stop.before(start) || interval._start.after(stop)) continue;
            if (interval._start.before(start) && interval._stop.after(start)) {
                interval._start = start;
            } else if (interval._start.before(stop) && interval._stop.after(stop)) {
                interval._stop = stop;
            }
            intersectionList.add(interval);
        }
        this._intervalList = intersectionList;
    }

    public void complement(Date start, Date stop) {
        ArrayList<Interval> complementlist = new ArrayList<Interval>();
        if (this._intervalList.size() == 0) {
            this._intervalList.add(new Interval(start, stop));
            return;
        }
        Interval firstInterval = this._intervalList.get(0);
        Interval lastInterval = this._intervalList.get(this._intervalList.size() - 1);
        if (firstInterval._start.after(start)) {
            complementlist.add(new Interval(start, firstInterval._start));
        }
        int i = 0;
        while (i < this._intervalList.size() - 1) {
            Interval interval = this._intervalList.get(i);
            Interval nextInterval = this._intervalList.get(i + 1);
            complementlist.add(new Interval(interval._stop, nextInterval._start));
            ++i;
        }
        if (lastInterval._stop.before(stop)) {
            complementlist.add(new Interval(lastInterval._stop, stop));
        }
        this._intervalList = complementlist;
    }

    public int size() {
        return this._intervalList.size();
    }

    public Interval get(int index) {
        return this._intervalList.get(index);
    }

    @Override
    public Iterator<Interval> iterator() {
        return this._intervalList.iterator();
    }

    public static class Interval {
        public Date _start;
        public Date _stop;

        public Interval(Date start, Date stop) {
            this._start = start;
            this._stop = stop;
        }

        public String toString() {
            return this._start + "\u2013" + this._stop;
        }
    }
}

